Feature Navigator - Plugin for QGIS

Feature Navigator is a QGIS plugin that facilitates navigation between features in an active layer. It allows you to move from one feature to another, view information about the selected feature, and zoom to the feature on the map. The current state of the plugin is also saved to allow easy resumption of navigation.

Features
Navigation between features in an active layer (Next, Previous, First, Last).
View information about the current feature (current feature index and total number of features).
Option to zoom to the selected feature on the map.
Integrated toolbar with buttons to open the plugin.
Interactive dock widget displaying feature information and navigation buttons.
The navigation state is automatically saved to allow easy resumption.
Requirements
QGIS 3.x (it is recommended to use the latest version of QGIS).
Python (to run the plugin).
Installation
Download the plugin from the GitHub repository.
Copy the plugin to the QGIS plugins directory:
On Windows: C:\Users\<YourUsername>\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins
On Linux: ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/
Open QGIS and navigate to Plugins -> Manage and Install Plugins.
Click on the Install from file tab and select the folder where you downloaded the plugin.
Enable the Feature Navigator plugin from the list of installed plugins.
Usage
Open the Feature Navigator
Once installed and enabled, you will see a button in the QGIS toolbar called "Feature Navigator".
Click this button to open the Dock Widget for navigation.
Navigating Between Features
Next: Move to the next feature.
Previous: Move to the previous feature.
First: Jump to the first feature.
Last: Jump to the last feature.
Feature Information
The Dock Widget displays the following information:

Feature X of Y: The index of the current feature and the total number of features.
Zoom to the Selected Feature
Every time you select a feature, the plugin will zoom in on it on the map to facilitate viewing.

Configuration
The plugin saves its current state in a JSON file (state.json), allowing you to resume navigation from where you left off the next time you open QGIS.

Issues and Support
If you encounter any issues with the plugin, please open an issue on GitHub or contact the author for support.

Contributions
Contributions are welcome. If you want to contribute to the development of the plugin, you can fork this repository, make your changes, and submit a pull request.

License
This plugin is licensed under the MIT License.