# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MultipleLayersTools
                                 A QGIS plugin
 Add buttons to add tools to turn on edit mode, commit, undo, filter selected 
 layers and groups.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-12-05
        git sha              : $Format:%H$
        copyright            : (C) 2020 by djes
        email                : djes@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import (  QSettings, 
                            QTranslator, 
                            qVersion, 
                            QCoreApplication,
                            QVariant)
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QMessageBox
from qgis.core import QgsProject, QgsLayerTreeLayer, QgsVectorLayer
from qgis.PyQt.QtXml import QDomDocument
from qgis.utils import iface
from qgis.gui import QgsQueryBuilder

# Initialize Qt resources from file resources.py
from .resources import *
import os.path

class MultipleLayersTools:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale', 'en')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MultipleLayersTools_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Multiple Layers Tools')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MultipleLayersTools', message)

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/multiple_layers_tools/'

        # will be set False in run()
        self.first_start = True

        # own toolbar init
        self.toolbar = self.iface.addToolBar(self.tr(u'Multiple layers tools toolbar'))
        self.toolbar.setObjectName("Multiple layers tools toolbar")

        self.action_edit        = QAction(QIcon(icon_path + 'multiple_layers_edit.png'), self.tr(u'Set edit mode for selected layers and groups'), self.iface.mainWindow())
        self.action_commit      = QAction(QIcon(icon_path + 'multiple_layers_commit.png'), self.tr(u'Commit selected layers and groups'), self.iface.mainWindow())
        self.action_undo        = QAction(QIcon(icon_path + 'multiple_layers_undo.png'), self.tr(u'Undo selected layers and groups'), self.iface.mainWindow())
        self.action_filter      = QAction(QIcon(icon_path + 'multiple_layers_filter.png'), self.tr(u'Filter selected layers and groups'), self.iface.mainWindow())
        self.action_clearfilter = QAction(QIcon(icon_path + 'multiple_layers_clearfilter.png'), self.tr(u'Clear selected layers and groups filters'), self.iface.mainWindow())
        self.action_loadstyles  = QAction(QIcon(icon_path + 'multiple_layers_loadstyles.png'), self.tr(u'Load selected layers styles from DB'), self.iface.mainWindow())

        self.action_edit.triggered.connect(self.run_edit)
        self.action_commit.triggered.connect(self.run_commit)
        self.action_undo.triggered.connect(self.run_undo)        
        self.action_filter.triggered.connect(self.run_filter)
        self.action_clearfilter.triggered.connect(self.run_clearfilter)
        self.action_loadstyles.triggered.connect(self.run_loadstyles)

        self.toolbar.addActions([self.action_edit, self.action_commit, self.action_undo, self.action_filter, self.action_clearfilter, self.action_loadstyles])

    def unload(self):
        del self.toolbar

    def run_edit(self):
        """Run method that performs the edit"""
          
        selectedLayers = iface.layerTreeView().selectedLayersRecursive()
        for layer in selectedLayers:
            layer.startEditing()
            layer.triggerRepaint()

    def run_commit(self):
        """Run method that performs the commit"""
          
        selectedLayers = iface.layerTreeView().selectedLayersRecursive()
        for layer in selectedLayers:
            layer.commitChanges()
            layer.triggerRepaint()

    def run_undo(self):
        """Run method that performs the undo"""
          
        selectedLayers = iface.layerTreeView().selectedLayersRecursive()
        for layer in selectedLayers:
            layer.rollBack()
            layer.triggerRepaint()

    def run_filter(self):
        """Run method that performs the filter"""
        
        #Retrieve selected layers (or group members)
        selectedLayers = iface.layerTreeView().selectedLayersRecursive()
        #Sadly, the layer order is not good, so will sort it by name
        sortedSelectedLayers = sorted(selectedLayers, key=lambda x: x.name())

        # To creates layer
        # layer = QgsVectorLayer("Point?crs=epsg:4326&index=yes",
        #                     "temporary_points", "memory")
        # QgsProject.instance().addMapLayer(layer)

        # Look up for the first valid layer
        for layer in sortedSelectedLayers:

            if layer and layer.isValid():
            
                #Fire up the query builder based on the first layer
                query_builder = QgsQueryBuilder(layer)
                #query_builder.setSql(u'"age" > 30')
                query_builder.accept()
                
                if query_builder.exec_(): #exec_ waits, show not
                
                    expression = query_builder.sql()

                    #Set filter for all selected layers
                    for layer in sortedSelectedLayers:
                        layer.setSubsetString(expression)
                        layer.triggerRepaint()
                        #print(layer)
                        #print(layer.id())
                    
                del(query_builder)
                del(layer)
                
                #exit loop
                break
        
        #No valid layer selected, quits
              
    def run_clearfilter(self):
        """Run method that performs the clear filter"""

        selectedLayers = iface.layerTreeView().selectedLayersRecursive()
        for layer in selectedLayers:
            layer.setSubsetString('')
            layer.triggerRepaint()
            
    def run_loadstyles(self):
        """Run method that performs loading layers styles from DB"""
        selectedLayers = iface.layerTreeView().selectedLayersRecursive()
        message = self.tr(u'Styles trouvés :\n\n')
        for layer in selectedLayers:
            if isinstance(layer, QgsVectorLayer):
                listedStyles = layer.listStylesInDatabase()
                numberOfStyles = listedStyles[0]
                if numberOfStyles > 0:
                    message = message + layer.name() + '\n'
                    defaultStyleId = listedStyles[1][0]
                    # defaultStyleName = listedStyles[2][0]
                    # defaultStyleDate = listedStyles[3][0]
                    styledoc = QDomDocument()
                    styleTuple = layer.getStyleFromDatabase(defaultStyleId)
                    styleqml = styleTuple[0]
                    styledoc.setContent(styleqml)
                    layer.importNamedStyle(styledoc)
                    layer.triggerRepaint()
                    
        if message == '':
            message = self.tr(u'No style found.')
        
        QMessageBox.information(None, self.tr(u'Information'), message)
