# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MultiEncodeVectorConverterDockWidget
                                 A QGIS plugin
 Multi-Encode Vector Converter
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2026-02-15
        git sha              : $Format:%H$
        copyright            : (C) 2026 by Hideharu Masai
        email                : hideharumasai@void.mints.ne.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import csv

from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import QCoreApplication, Qt, QVariant, pyqtSignal, QSettings, QTranslator
from qgis.PyQt.QtWidgets import (
    QWidget,
    QGroupBox,
    QVBoxLayout,
    QHBoxLayout,
    QRadioButton,
    QLabel,
    QComboBox,
    QPushButton,
    QLineEdit,
    QFileDialog,
    QFrame,
    QStackedWidget,
    QSizePolicy,
    QMessageBox,
)
from qgis.core import (
    QgsProject,
    QgsVectorLayer,
    QgsFeatureRequest,
    QgsVectorFileWriter,
    QgsCoordinateTransformContext,
    QgsField,
    QgsFeature,
    QgsWkbTypes,
)


class MultiEncodeVectorConverterDockWidget(QtWidgets.QDockWidget):

    closingPlugin = pyqtSignal()

    # Language selector: (locale_code, display_name)
    _LANGUAGES = [
        ("en", "English"),
        ("es", "Español"),
        ("pt", "Português"),
        ("ja", "日本語"),
    ]

    # Display name → Python codec string (None = auto)
    _ENCODING_CODEC = {
        "Auto Detect": None,
        "CP932 (Windows Japanese)": "cp932",
        "Shift_JIS": "cp932",  # CP932 is a superset; handles NEC special chars (Ⅰ-Ⅹ etc.)
        "EUC-JP": "euc_jp",
        "UTF-8": "utf-8",
        "UTF-8-sig (BOM)": "utf-8-sig",
        "CP1250 (Windows Central European)": "cp1250",
        "ISO-8859-2 (Central European)": "iso-8859-2",
        "CP1252 (Windows Western European)": "cp1252",
        "ISO-8859-1 (Latin-1)": "iso-8859-1",
        "CP1251 (Windows Cyrillic)": "cp1251",
        "EUC-KR (Korean)": "euc_kr",
        "GBK (Chinese Simplified)": "gbk",
        "Big5 (Chinese Traditional)": "big5",
    }

    @staticmethod
    def tr(message):
        """Translate UI strings for multilingual support."""
        return QCoreApplication.translate("MultiEncodeVectorConverterDockWidget", message)

    def __init__(self, parent=None):
        """Constructor."""
        super(MultiEncodeVectorConverterDockWidget, self).__init__(parent)

        self._plugin_dir = os.path.dirname(__file__)
        self._translator = None

        self.setWindowTitle(self.tr("Multi-Encode Vector Converter"))

        main_widget = QWidget()
        layout = QVBoxLayout()

        # ── A: Input Source ──────────────────────────────────────────
        self.group_a = QGroupBox(self.tr("A: Input Source"))
        group_a = self.group_a
        layout_a = QVBoxLayout()

        rb_row = QHBoxLayout()
        self.rb_layer = QRadioButton(self.tr("QGIS Layer"))
        self.rb_layer_csv = QRadioButton(self.tr("QGIS Layer + CSV"))
        self.rb_shp = QRadioButton(self.tr("Shapefile"))
        self.rb_layer.setChecked(True)
        rb_row.addWidget(self.rb_layer)
        rb_row.addWidget(self.rb_layer_csv)
        rb_row.addWidget(self.rb_shp)
        layout_a.addLayout(rb_row)

        # Stacked input detail controls
        self.input_stack = QStackedWidget()
        self.input_stack.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)

        # Page 0: QGIS Layer only
        page_layer = QWidget()
        pl_layout = QHBoxLayout()
        pl_layout.setContentsMargins(0, 0, 0, 0)
        pl_layout.setSpacing(6)
        pl_layout.setAlignment(Qt.AlignTop)
        pl_layout.addWidget(QLabel(self.tr("Layer")))
        self.cb_layer = QComboBox()
        pl_layout.addWidget(self.cb_layer)
        page_layer.setLayout(pl_layout)
        self.input_stack.addWidget(page_layer)

        # Page 1: QGIS Layer + CSV (new join)
        page_layer_csv = QWidget()
        plc_layout = QVBoxLayout()
        plc_layout.setContentsMargins(0, 0, 0, 0)
        plc_layout.setSpacing(4)

        row_lc_layer = QHBoxLayout()
        row_lc_layer.setContentsMargins(0, 0, 0, 0)
        row_lc_layer.setSpacing(6)
        row_lc_layer.addWidget(QLabel(self.tr("Layer")))
        self.cb_layer_csv = QComboBox()
        row_lc_layer.addWidget(self.cb_layer_csv)

        row_lc_csv = QHBoxLayout()
        row_lc_csv.setContentsMargins(0, 0, 0, 0)
        row_lc_csv.setSpacing(6)
        row_lc_csv.addWidget(QLabel(self.tr("CSV")))
        self.btn_browse_csv = QPushButton(self.tr("Browse"))
        self.btn_browse_csv.clicked.connect(self._on_browse_csv)
        self.le_csv_path = QLineEdit()
        self.le_csv_path.setPlaceholderText(self.tr("Select a .csv file"))
        row_lc_csv.addWidget(self.btn_browse_csv)
        row_lc_csv.addWidget(self.le_csv_path)

        row_lc_join = QHBoxLayout()
        row_lc_join.setContentsMargins(0, 0, 0, 0)
        row_lc_join.setSpacing(4)
        row_lc_join.addWidget(QLabel(self.tr("Join key")))
        self.cb_layer_field = QComboBox()
        row_lc_join.addWidget(self.cb_layer_field)
        row_lc_join.addWidget(QLabel("="))
        self.cb_csv_field = QComboBox()
        row_lc_join.addWidget(self.cb_csv_field)

        plc_layout.addLayout(row_lc_layer)
        plc_layout.addLayout(row_lc_csv)
        plc_layout.addLayout(row_lc_join)
        plc_layout.addStretch()
        page_layer_csv.setLayout(plc_layout)
        self.input_stack.addWidget(page_layer_csv)

        # Page 2: Shapefile (direct file import)
        page_shp = QWidget()
        ps_layout = QHBoxLayout()
        ps_layout.setContentsMargins(0, 0, 0, 0)
        ps_layout.setSpacing(6)
        ps_layout.setAlignment(Qt.AlignTop)
        ps_layout.addWidget(QLabel(self.tr("Shapefile")))
        self.le_shp_path = QLineEdit()
        self.le_shp_path.setPlaceholderText(self.tr("Select a .shp file"))
        self.btn_browse_shp = QPushButton(self.tr("Browse"))
        self.btn_browse_shp.clicked.connect(self._on_browse_shp)
        ps_layout.addWidget(self.le_shp_path)
        ps_layout.addWidget(self.btn_browse_shp)
        page_shp.setLayout(ps_layout)
        self.input_stack.addWidget(page_shp)

        # Lock input_stack to the tallest page so panel height stays stable on mode switch
        max_h = 0
        for i in range(self.input_stack.count()):
            page = self.input_stack.widget(i)
            if page.layout() is not None:
                page.layout().activate()
            max_h = max(max_h, page.sizeHint().height())
        if max_h > 0:
            self.input_stack.setFixedHeight(max_h)

        self.lbl_input_description = QLabel()
        self.lbl_input_description.setWordWrap(True)
        layout_a.addWidget(self.input_stack)
        layout_a.addWidget(self.lbl_input_description)
        group_a.setLayout(layout_a)
        layout.addWidget(group_a)

        # ── Info labels (outside group_a) ─────────────────────────────
        # Detected join info — shown in Layer mode when joins exist
        self.lbl_join_info = QLabel()
        self.lbl_join_info.setWordWrap(True)
        self.lbl_join_info.setAlignment(Qt.AlignCenter)
        self.lbl_join_info.setVisible(False)
        layout.addWidget(self.lbl_join_info)

        # GPKG source check / layer status
        self.lbl_layer_check = QLabel()
        self.lbl_layer_check.setWordWrap(True)
        self.lbl_layer_check.setAlignment(Qt.AlignCenter)
        layout.addWidget(self.lbl_layer_check)

        # ── B: Encoding ───────────────────────────────────────────────
        self.group_b = QGroupBox(self.tr("B: Encoding"))
        group_b = self.group_b
        layout_b = QHBoxLayout()

        enc_items = list(self._ENCODING_CODEC.keys())

        # Left column: Layer encoding
        widget_layer_enc = QWidget()
        layout_layer_enc = QVBoxLayout()
        layout_layer_enc.setContentsMargins(0, 0, 4, 0)
        layout_layer_enc.setSpacing(4)
        self.lbl_layer_enc_title = QLabel(self.tr("Layer Encoding"))
        self.lbl_layer_enc_title.setAlignment(Qt.AlignCenter)
        layout_layer_enc.addWidget(self.lbl_layer_enc_title)
        self.cb_encoding = QComboBox()
        self.cb_encoding.addItems(enc_items)
        layout_layer_enc.addWidget(self.cb_encoding)
        self.lbl_enc_preview = QLabel(self.tr("Preview: (select a source)"))
        self.lbl_enc_preview.setWordWrap(True)
        self.lbl_enc_preview.setAlignment(Qt.AlignCenter)
        layout_layer_enc.addWidget(self.lbl_enc_preview)
        layout_layer_enc.addStretch()
        widget_layer_enc.setLayout(layout_layer_enc)

        # Vertical separator
        separator = QFrame()
        separator.setFrameShape(QFrame.VLine)
        separator.setFrameShadow(QFrame.Sunken)

        # Right column: CSV encoding (grayed out when no CSV)
        self.widget_csv_enc = QWidget()
        layout_csv_enc = QVBoxLayout()
        layout_csv_enc.setContentsMargins(4, 0, 0, 0)
        layout_csv_enc.setSpacing(4)
        self.lbl_csv_enc_title = QLabel(self.tr("CSV Encoding"))
        self.lbl_csv_enc_title.setAlignment(Qt.AlignCenter)
        layout_csv_enc.addWidget(self.lbl_csv_enc_title)
        self.cb_csv_encoding = QComboBox()
        self.cb_csv_encoding.addItems(enc_items)
        layout_csv_enc.addWidget(self.cb_csv_encoding)
        self.lbl_csv_enc_preview = QLabel(self.tr("Preview: (no CSV source)"))
        self.lbl_csv_enc_preview.setWordWrap(True)
        self.lbl_csv_enc_preview.setAlignment(Qt.AlignCenter)
        layout_csv_enc.addWidget(self.lbl_csv_enc_preview)
        layout_csv_enc.addStretch()
        self.widget_csv_enc.setLayout(layout_csv_enc)
        self.widget_csv_enc.setEnabled(False)

        layout_b.addWidget(widget_layer_enc)
        layout_b.addWidget(separator)
        layout_b.addWidget(self.widget_csv_enc)

        group_b.setLayout(layout_b)
        layout.addWidget(group_b)

        # ── C: Output Format ──────────────────────────────────────────
        self.group_c = QGroupBox(self.tr("C: Output Format"))
        group_c = self.group_c
        layout_c = QVBoxLayout()
        self.lbl_gpkg = QLabel(self.tr("GeoPackage (GPKG, Recommended)"))
        layout_c.addWidget(self.lbl_gpkg)
        self.lbl_output_hint = QLabel(self.tr("Output path will be selected when Execute is clicked."))
        layout_c.addWidget(self.lbl_output_hint)
        self.btn_execute = QPushButton(self.tr("Execute"))
        self.btn_execute.clicked.connect(self._on_execute_clicked)
        layout_c.addWidget(self.btn_execute)
        group_c.setLayout(layout_c)
        layout.addWidget(group_c)

        self.lbl_result_summary = QLabel(self.tr("Result: No execution yet."))
        self.lbl_result_summary.setWordWrap(True)
        self.lbl_result_summary.setAlignment(Qt.AlignCenter)
        layout.addWidget(self.lbl_result_summary)

        # ── Important Note ────────────────────────────────────────────
        self.group_note = QGroupBox(self.tr("Important Note"))
        group_note = self.group_note
        layout_note = QVBoxLayout()
        self.lbl_note = QLabel(self.tr(
            "This is a temporary remediation for GPKG workflows.\n"
            "GPKG handling in this plugin is a temporary relief measure.\n"
            "It improves normalization and integration issues, but cannot fully restore\n"
            "information already lost by legacy format limits or irreversible conversions."
        ))
        self.lbl_note.setWordWrap(True)
        layout_note.addWidget(self.lbl_note)
        group_note.setLayout(layout_note)
        layout.addWidget(group_note)

        # ── Language Switcher (bottom-left) ───────────────────────────
        lang_row = QHBoxLayout()
        lang_row.addWidget(QLabel("Language:"))
        self.cb_language = QComboBox()
        for _, display in self._LANGUAGES:
            self.cb_language.addItem(display)
        lang_row.addWidget(self.cb_language)
        lang_row.addStretch()
        layout.addLayout(lang_row)

        main_widget.setLayout(layout)
        self.setWidget(main_widget)

        # Connections
        self.rb_layer.toggled.connect(self._update_input_mode)
        self.rb_layer_csv.toggled.connect(self._update_input_mode)
        self.rb_shp.toggled.connect(self._update_input_mode)
        self.cb_layer.currentIndexChanged.connect(self._on_layer_changed)
        self.cb_layer_csv.currentIndexChanged.connect(self._on_layer_csv_changed)
        self.cb_encoding.currentIndexChanged.connect(self._update_enc_preview)
        self.cb_csv_encoding.currentIndexChanged.connect(self._update_csv_enc_preview)
        QgsProject.instance().layersAdded.connect(self._refresh_layer_list)
        QgsProject.instance().layersRemoved.connect(self._refresh_layer_list)

        self.cb_language.currentIndexChanged.connect(self._on_language_changed)

        self._refresh_layer_list()
        self._update_input_mode()
        self._apply_language(self._detect_initial_locale())

    # ── Language management ────────────────────────────────────────────

    def _detect_initial_locale(self):
        saved = QSettings("MultiEncodeVectorConverter", "prefs").value("language", "")
        if saved and any(code == saved for code, _ in self._LANGUAGES):
            return saved
        system_locale = QSettings().value("locale/userLocale", "en")[:2]
        if any(code == system_locale for code, _ in self._LANGUAGES):
            return system_locale
        return "en"

    def _apply_language(self, locale):
        if self._translator:
            QCoreApplication.removeTranslator(self._translator)
            self._translator = None
        if locale != "en":
            qm_path = os.path.join(
                self._plugin_dir, "i18n",
                "multi_encode_vector_converter_{}.qm".format(locale)
            )
            if os.path.exists(qm_path):
                self._translator = QTranslator()
                self._translator.load(qm_path)
                QCoreApplication.installTranslator(self._translator)
        QSettings("MultiEncodeVectorConverter", "prefs").setValue("language", locale)
        self.cb_language.blockSignals(True)
        for i, (code, _) in enumerate(self._LANGUAGES):
            if code == locale:
                self.cb_language.setCurrentIndex(i)
                break
        self.cb_language.blockSignals(False)
        self._retranslate_ui()

    def _on_language_changed(self, index):
        locale = self._LANGUAGES[index][0]
        self._apply_language(locale)

    def _retranslate_ui(self):
        self.setWindowTitle(self.tr("Multi-Encode Vector Converter"))
        self.group_a.setTitle(self.tr("A: Input Source"))
        self.rb_layer.setText(self.tr("QGIS Layer"))
        self.rb_layer_csv.setText(self.tr("QGIS Layer + CSV"))
        self.rb_shp.setText(self.tr("Shapefile"))
        self.btn_browse_csv.setText(self.tr("Browse"))
        self.le_csv_path.setPlaceholderText(self.tr("Select a .csv file"))
        self.le_shp_path.setPlaceholderText(self.tr("Select a .shp file"))
        self.btn_browse_shp.setText(self.tr("Browse"))
        self.group_b.setTitle(self.tr("B: Encoding"))
        self.lbl_layer_enc_title.setText(self.tr("Layer Encoding"))
        self.lbl_csv_enc_title.setText(self.tr("CSV Encoding"))
        self.group_c.setTitle(self.tr("C: Output Format"))
        self.lbl_gpkg.setText(self.tr("GeoPackage (GPKG, Recommended)"))
        self.lbl_output_hint.setText(self.tr("Output path will be selected when Execute is clicked."))
        self.btn_execute.setText(self.tr("Execute"))
        self.group_note.setTitle(self.tr("Important Note"))
        self.lbl_note.setText(self.tr(
            "This is a temporary remediation for GPKG workflows.\n"
            "GPKG handling in this plugin is a temporary relief measure.\n"
            "It improves normalization and integration issues, but cannot fully restore\n"
            "information already lost by legacy format limits or irreversible conversions."
        ))

    # ── Layer list management ──────────────────────────────────────────

    def _refresh_layer_list(self):
        """Reload layer names from current QGIS project into both layer combos."""
        placeholder = self.tr("Please select a QGIS layer")
        for cb in (self.cb_layer, self.cb_layer_csv):
            cb.clear()
            cb.addItem(placeholder, "")

        layers = list(QgsProject.instance().mapLayers().values())
        if not layers:
            no_layers = self.tr("(No layers loaded)")
            for cb in (self.cb_layer, self.cb_layer_csv):
                cb.addItem(no_layers, "")
            return

        for layer in layers:
            if not isinstance(layer, QgsVectorLayer):
                continue
            if layer.providerType() == "delimitedtext":
                continue
            src = layer.source().lower().split("|")[0].split("?")[0].strip()
            if src.endswith(".csv") or src.endswith(".tsv") or src.endswith(".txt"):
                continue
            for cb in (self.cb_layer, self.cb_layer_csv):
                cb.addItem(layer.name(), layer.id())

    def _get_selected_layer(self):
        """Return layer object selected in Layer-only combo, or None."""
        layer_id = self.cb_layer.currentData()
        if not layer_id:
            return None
        return QgsProject.instance().mapLayer(layer_id)

    def _get_selected_layer_csv(self):
        """Return layer object selected in Layer+CSV combo, or None."""
        layer_id = self.cb_layer_csv.currentData()
        if not layer_id:
            return None
        return QgsProject.instance().mapLayer(layer_id)

    @staticmethod
    def _is_layer_source_gpkg(layer):
        """Lightweight check whether selected layer source is GPKG."""
        return ".gpkg" in (layer.source() or "").lower()

    # ── Join detection ────────────────────────────────────────────────

    def _detect_layer_joins(self, layer):
        """Return list of join info dicts for the given layer."""
        if layer is None or not isinstance(layer, QgsVectorLayer):
            return []
        joins = []
        for join_info in layer.vectorJoins():
            join_layer = QgsProject.instance().mapLayer(join_info.joinLayerId())
            name = join_layer.name() if join_layer else join_info.joinLayerId()
            joins.append({
                "name": name,
                "join_field": join_info.joinFieldName(),
                "target_field": join_info.targetFieldName(),
            })
        return joins

    # ── Input mode switch ─────────────────────────────────────────────

    def _update_input_mode(self):
        """Switch input controls and update info labels by selected source option."""
        if self.rb_layer.isChecked():
            self.input_stack.setCurrentIndex(0)
            self.lbl_input_description.setText(
                self.tr("Select a loaded QGIS layer. Existing joins will be detected automatically.")
            )
        elif self.rb_layer_csv.isChecked():
            self.input_stack.setCurrentIndex(1)
            self.lbl_input_description.setText(
                self.tr("Select a layer and specify a CSV to join. Join key fields must be set.")
            )
        else:
            self.input_stack.setCurrentIndex(2)
            self.lbl_input_description.setText(
                self.tr(
                    "Select a Shapefile to import directly. "
                    "Load into QGIS first if you also need a CSV join."
                )
            )

        self._update_layer_conversion_hint()
        self._update_join_info()
        self._update_csv_enc_visibility()

    # ── Layer change handlers ─────────────────────────────────────────

    def _on_layer_changed(self):
        """Handle layer selection change in Layer-only mode."""
        self._update_layer_conversion_hint()
        self._update_join_info()
        self._update_csv_enc_visibility()
        self._auto_detect_and_update_encoding()

    def _on_layer_csv_changed(self):
        """Handle layer selection change in Layer+CSV mode."""
        layer = self._get_selected_layer_csv()
        self._populate_layer_fields(layer)
        self._update_layer_conversion_hint()
        self._update_join_info()
        self._auto_detect_and_update_encoding()

    # ── Info label updates ────────────────────────────────────────────

    def _update_layer_conversion_hint(self):
        """Show GPKG source check message (hidden in SHP mode)."""
        if self.rb_shp.isChecked():
            self.lbl_layer_check.setStyleSheet("")
            self.lbl_layer_check.clear()
            return

        layer = self._get_selected_layer() if self.rb_layer.isChecked() else self._get_selected_layer_csv()

        if layer is None:
            self.lbl_layer_check.setStyleSheet("")
            self.lbl_layer_check.setText(
                self.tr("Please select a QGIS layer to check whether conversion is required.")
            )
            return

        if self._is_layer_source_gpkg(layer):
            self.lbl_layer_check.setStyleSheet("color: #c62828;")
            self.lbl_layer_check.setText(
                self.tr(
                    "This layer is already GPKG. "
                    "If encoding normalization is unnecessary, conversion is not required."
                )
            )
        else:
            self.lbl_layer_check.setStyleSheet("")
            self.lbl_layer_check.setText(
                self.tr("This layer is not GPKG. Conversion to recommended GPKG will be applied.")
            )

    def _update_join_info(self):
        """Show detected join info outside group_a (Layer mode only)."""
        if not self.rb_layer.isChecked():
            self.lbl_join_info.setVisible(False)
            return

        joins = self._detect_layer_joins(self._get_selected_layer())
        if not joins:
            self.lbl_join_info.setVisible(False)
            return

        lines = [
            self.tr('Join "{name}" detected. Join state will be reproduced in GPKG.').format(
                name=j["name"]
            )
            for j in joins
        ]
        self.lbl_join_info.setText("\n".join(lines))
        self.lbl_join_info.setVisible(True)

    # ── File browse handlers ──────────────────────────────────────────

    def _on_browse_shp(self):
        """Open file dialog to select Shapefile."""
        path, _ = QFileDialog.getOpenFileName(
            self, self.tr("Select Shapefile"), "", "Shapefile (*.shp)"
        )
        if path:
            self.le_shp_path.setText(path)
            self._auto_detect_and_update_encoding()

    def _on_browse_csv(self):
        """Open file dialog to select CSV and populate field combo."""
        path, _ = QFileDialog.getOpenFileName(
            self, self.tr("Select CSV"), "", "CSV (*.csv)"
        )
        if path:
            self.le_csv_path.setText(path)
            self._populate_csv_fields(path)
            self._auto_detect_and_update_encoding()

    # ── Encoding detection & preview ─────────────────────────────────

    def _get_encoding_codec(self):
        """Return Python codec string for current cb_encoding selection, or None."""
        return self._ENCODING_CODEC.get(self.cb_encoding.currentText())

    def _set_encoding_combo(self, codec):
        """Set cb_encoding to the item whose codec matches. Falls back to Auto Detect."""
        if not codec:
            self.cb_encoding.setCurrentIndex(0)
            return
        norm = codec.lower().replace("-", "").replace("_", "")
        for i in range(self.cb_encoding.count()):
            enc = self._ENCODING_CODEC.get(self.cb_encoding.itemText(i))
            if enc and enc.lower().replace("-", "").replace("_", "") == norm:
                self.cb_encoding.setCurrentIndex(i)
                return
        self.cb_encoding.setCurrentIndex(0)

    @staticmethod
    def _auto_detect_encoding_from_file(shp_path):
        """Return encoding string from .cpg sidecar, or None if absent/unreadable."""
        cpg_path = os.path.splitext(shp_path)[0] + ".cpg"
        if os.path.isfile(cpg_path):
            try:
                with open(cpg_path, "r", errors="ignore") as f:
                    return f.read().strip() or None
            except OSError:
                pass
        return None

    @staticmethod
    def _auto_detect_encoding_from_layer(layer):
        """Return provider encoding from layer, or None when SYSTEM/unknown/raster."""
        if layer is None or not isinstance(layer, QgsVectorLayer):
            return None
        enc = layer.dataProvider().encoding()
        return enc if enc and enc.upper() not in ("SYSTEM", "") else None

    def _auto_detect_and_update_encoding(self):
        """Auto-detect source encoding and refresh the preview."""
        if self.rb_shp.isChecked():
            shp_path = self.le_shp_path.text().strip()
            codec = self._auto_detect_encoding_from_file(shp_path) if shp_path else None
        else:
            layer = (
                self._get_selected_layer()
                if self.rb_layer.isChecked()
                else self._get_selected_layer_csv()
            )
            codec = self._auto_detect_encoding_from_layer(layer)
        self._set_encoding_combo(codec)
        self._update_enc_preview()

        # CSV encoding — only when the CSV column is enabled
        if self.widget_csv_enc.isEnabled():
            csv_codec = self._auto_detect_csv_encoding()
            self._set_csv_encoding_combo(csv_codec)
            self._update_csv_enc_preview()

    # CSV encoding helpers ─────────────────────────────────────────────

    def _update_csv_enc_visibility(self):
        """Enable/disable CSV encoding column based on mode and join detection."""
        if self.rb_layer_csv.isChecked():
            self.widget_csv_enc.setEnabled(True)
            return
        if self.rb_layer.isChecked():
            joins = self._detect_layer_joins(self._get_selected_layer())
            self.widget_csv_enc.setEnabled(bool(joins))
            return
        self.widget_csv_enc.setEnabled(False)

    def _get_csv_encoding_codec(self):
        """Return Python codec string for current cb_csv_encoding selection, or None."""
        return self._ENCODING_CODEC.get(self.cb_csv_encoding.currentText())

    def _set_csv_encoding_combo(self, codec):
        """Set cb_csv_encoding to the item whose codec matches. Falls back to Auto Detect."""
        if not codec:
            self.cb_csv_encoding.setCurrentIndex(0)
            return
        norm = codec.lower().replace("-", "").replace("_", "")
        for i in range(self.cb_csv_encoding.count()):
            enc = self._ENCODING_CODEC.get(self.cb_csv_encoding.itemText(i))
            if enc and enc.lower().replace("-", "").replace("_", "") == norm:
                self.cb_csv_encoding.setCurrentIndex(i)
                return
        self.cb_csv_encoding.setCurrentIndex(0)

    @staticmethod
    def _detect_csv_file_encoding(path):
        """Heuristic CSV encoding detection: try UTF-8-BOM, CP932, UTF-8."""
        for codec in ("utf-8-sig", "cp932", "utf-8"):
            try:
                with open(path, "r", encoding=codec, errors="strict") as f:
                    f.read(4096)
                return codec
            except (UnicodeDecodeError, OSError):
                continue
        return None

    def _auto_detect_csv_encoding(self):
        """Detect encoding of the CSV source (file in Layer+CSV mode, or join layer source)."""
        if self.rb_layer_csv.isChecked():
            csv_path = self.le_csv_path.text().strip()
            if csv_path and os.path.isfile(csv_path):
                return self._detect_csv_file_encoding(csv_path)
            return None
        if self.rb_layer.isChecked():
            layer = self._get_selected_layer()
            if layer is None or not isinstance(layer, QgsVectorLayer):
                return None
            for join_info in layer.vectorJoins():
                join_layer = QgsProject.instance().mapLayer(join_info.joinLayerId())
                if join_layer is None:
                    continue
                enc = self._auto_detect_encoding_from_layer(join_layer)
                if enc:
                    return enc
                join_path = self._extract_join_source_path(join_layer.source())
                if join_path:
                    return self._detect_csv_file_encoding(join_path)
        return None

    def _update_csv_enc_preview(self):
        """Update lbl_csv_enc_preview with sample values from the CSV source."""
        codec = self._get_csv_encoding_codec()
        values = self._get_csv_preview_values(codec)
        if values:
            self.lbl_csv_enc_preview.setText(
                self.tr("Preview: {}").format("  /  ".join(values))
            )
        elif values is None:
            self.lbl_csv_enc_preview.setText(
                self.tr("Preview: (no CSV sample available)")
            )
        else:
            self.lbl_csv_enc_preview.setText(
                self.tr("Preview: (ASCII only — encoding not critical)")
            )

    def _get_csv_preview_values(self, codec):
        """Return up to 3 non-ASCII string values, [] if all-ASCII, None if no data."""
        if self.rb_layer_csv.isChecked():
            csv_path = self.le_csv_path.text().strip()
            if csv_path and os.path.isfile(csv_path):
                return self._read_csv_sample(csv_path, codec)
            return None
        if self.rb_layer.isChecked():
            layer = self._get_selected_layer()
            if layer is None or not isinstance(layer, QgsVectorLayer):
                return None
            for join_info in layer.vectorJoins():
                join_layer = QgsProject.instance().mapLayer(join_info.joinLayerId())
                if join_layer is None:
                    continue
                join_path = self._extract_join_source_path(join_layer.source())
                if join_path:
                    return self._read_csv_sample(join_path, codec)
        return None

    @classmethod
    def _read_csv_sample(cls, csv_path, codec):
        """Read CSV headers and first rows, return up to 3 non-ASCII string values.

        Returns:
            list of non-ASCII values  — non-ASCII content found
            []                        — data exists but all ASCII-only
            None                      — no readable string data
        """
        enc = codec or "utf-8"
        try:
            with open(csv_path, "r", encoding=enc, errors="replace") as f:
                reader = csv.reader(f)
                headers = next(reader, [])
                rows = []
                for _ in range(5):
                    row = next(reader, None)
                    if row is None:
                        break
                    rows.append(row)
            values = []
            seen = set()
            has_any_string = False
            for h in headers:
                h = h.strip()
                if not h:
                    continue
                has_any_string = True
                if cls._is_ascii_only(h) or h in seen:
                    continue
                seen.add(h)
                values.append(h)
                if len(values) >= 3:
                    return values
            for row in rows:
                for val in row:
                    val = val.strip()
                    if not val:
                        continue
                    has_any_string = True
                    if cls._is_ascii_only(val) or val in seen:
                        continue
                    seen.add(val)
                    values.append(val)
                    if len(values) >= 3:
                        return values
            if values:
                return values
            return [] if has_any_string else None
        except Exception:
            return None

    # ── Layer encoding preview ─────────────────────────────────────────

    def _update_enc_preview(self):
        """Update lbl_enc_preview with sample attribute values."""
        codec = self._get_encoding_codec()
        values = self._get_preview_values(codec)
        if values:
            self.lbl_enc_preview.setText(
                self.tr("Preview: {}").format("  /  ".join(values))
            )
        elif values is None:
            self.lbl_enc_preview.setText(
                self.tr("Preview: (no sample available)")
            )
        else:
            self.lbl_enc_preview.setText(
                self.tr("Preview: (ASCII only — encoding not critical)")
            )

    def _get_preview_values(self, codec):
        """Return up to 3 non-ASCII string values, [] if all-ASCII, None if no data."""
        if self.rb_shp.isChecked():
            shp_path = self.le_shp_path.text().strip()
            if not shp_path or not os.path.isfile(shp_path):
                return None
            return self._read_shp_sample(shp_path, codec)
        layer = (
            self._get_selected_layer()
            if self.rb_layer.isChecked()
            else self._get_selected_layer_csv()
        )
        if layer is None or not isinstance(layer, QgsVectorLayer):
            return None
        # For SHP-backed layers, re-read raw file so encoding selection takes effect
        source_path = layer.source().split("|")[0].strip()
        if source_path.lower().endswith(".shp") and os.path.isfile(source_path):
            return self._read_shp_sample(source_path, codec)
        # GPKG and other formats are always UTF-8 — show as loaded
        return self._read_layer_sample(layer)

    @staticmethod
    def _is_ascii_only(s):
        """Return True if s contains only ASCII characters (uninformative for encoding detection)."""
        return all(ord(c) < 128 for c in s)

    @classmethod
    def _read_shp_sample(cls, shp_path, codec):
        """Read DBF sidecar directly and decode string values with the specified codec.

        Returns:
            list of non-ASCII values  — non-ASCII content found
            []                        — data exists but all ASCII-only
            None                      — no readable string data
        """
        dbf_path = os.path.splitext(shp_path)[0] + ".dbf"
        if not os.path.isfile(dbf_path):
            return None
        try:
            with open(dbf_path, "rb") as f:
                hdr = f.read(32)
                if len(hdr) < 32:
                    return None
                record_count = int.from_bytes(hdr[4:8], "little")
                header_size = int.from_bytes(hdr[8:10], "little")
                record_size = int.from_bytes(hdr[10:12], "little")
                n_fields = (header_size - 33) // 32

                enc = codec or "utf-8"

                # Collect string (type "C") field positions/lengths and field names
                string_fields = []
                has_any_string = False
                rec_offset = 1  # byte 0 is deletion flag
                f.seek(32)
                values = []
                seen = set()
                for _ in range(n_fields):
                    desc = f.read(32)
                    if len(desc) < 32 or desc[0] == 0x0D:
                        break
                    name_raw = desc[0:11].split(b"\x00")[0]
                    ftype = chr(desc[11])
                    flen = desc[16]
                    try:
                        name = name_raw.decode(enc, errors="replace").strip()
                    except LookupError:
                        name = name_raw.decode("utf-8", errors="replace").strip()
                    if name:
                        has_any_string = True
                        if not cls._is_ascii_only(name) and name not in seen:
                            seen.add(name)
                            values.append(name)
                            if len(values) >= 3:
                                return values
                    if ftype == "C":
                        string_fields.append((rec_offset, flen))
                    rec_offset += flen

                if not string_fields:
                    if values:
                        return values
                    return [] if has_any_string else None

                f.seek(header_size)
                for _ in range(min(record_count, 20)):
                    record = f.read(record_size)
                    if len(record) < record_size:
                        break
                    if record[0] == 0x2A:  # deleted record
                        continue
                    for foffset, flen in string_fields:
                        raw = record[foffset: foffset + flen]
                        try:
                            val = raw.decode(enc, errors="replace").strip()
                        except LookupError:
                            val = raw.decode("utf-8", errors="replace").strip()
                        if not val:
                            continue
                        has_any_string = True
                        if cls._is_ascii_only(val) or val in seen:
                            continue
                        seen.add(val)
                        values.append(val)
                        if len(values) >= 3:
                            return values
            if values:
                return values
            return [] if has_any_string else None
        except Exception:
            return None

    @classmethod
    def _read_layer_sample(cls, layer):
        """Scan field names then up to 20 features for 3 non-ASCII string values.

        Returns:
            list of non-ASCII values  — non-ASCII content found
            []                        — data exists but all ASCII-only
            None                      — no readable string data
        """
        try:
            values = []
            seen = set()
            has_any_string = False
            # Seed with field names first
            for field in layer.fields():
                name = field.name().strip()
                if not name:
                    continue
                has_any_string = True
                if cls._is_ascii_only(name) or name in seen:
                    continue
                seen.add(name)
                values.append(name)
                if len(values) >= 3:
                    return values
            # Then scan feature values
            for feat in layer.getFeatures(QgsFeatureRequest().setLimit(20)):
                for field in layer.fields():
                    val = feat[field.name()]
                    if not (isinstance(val, str) and val.strip()):
                        continue
                    stripped = val.strip()
                    has_any_string = True
                    if cls._is_ascii_only(stripped) or stripped in seen:
                        continue
                    seen.add(stripped)
                    values.append(stripped)
                    if len(values) >= 3:
                        return values
            if values:
                return values
            return [] if has_any_string else None
        except Exception:
            return None

    # ── Field population ──────────────────────────────────────────────

    def _populate_layer_fields(self, layer):
        """Populate layer field combo from layer schema."""
        self.cb_layer_field.clear()
        if layer is None:
            return
        for field in layer.fields():
            self.cb_layer_field.addItem(field.name())

    def _populate_csv_fields(self, path):
        """Populate CSV field combo by reading the header row (encoding-aware)."""
        self.cb_csv_field.clear()
        if not path or not os.path.isfile(path):
            return
        for enc in ("utf-8-sig", "cp932", "utf-8"):
            try:
                with open(path, "r", encoding=enc, errors="strict") as f:
                    headers = next(csv.reader(f), [])
                for h in headers:
                    self.cb_csv_field.addItem(h)
                return
            except (UnicodeDecodeError, StopIteration):
                continue

    # ── Output path selection ─────────────────────────────────────────

    def _select_output_file(self):
        """Open save dialog for output GeoPackage path and return selected path."""
        path, _ = QFileDialog.getSaveFileName(
            self, self.tr("Select Output GeoPackage"), "", "GeoPackage (*.gpkg)"
        )
        if not path:
            return ""
        if not path.lower().endswith(".gpkg"):
            path = "{}.gpkg".format(path)
        return path

    # ── Validation ────────────────────────────────────────────────────

    def _validate_inputs(self):
        """Validate required input selections before execute."""
        if self.rb_layer.isChecked():
            if self._get_selected_layer() is None:
                QMessageBox.warning(
                    self, self.tr("Validation Error"), self.tr("Please select a QGIS layer.")
                )
                return False

        elif self.rb_layer_csv.isChecked():
            if self._get_selected_layer_csv() is None:
                QMessageBox.warning(
                    self, self.tr("Validation Error"), self.tr("Please select a QGIS layer.")
                )
                return False
            csv_path = self.le_csv_path.text().strip()
            if not csv_path:
                QMessageBox.warning(
                    self, self.tr("Validation Error"), self.tr("Please select a CSV file.")
                )
                return False
            if not os.path.isfile(csv_path):
                QMessageBox.warning(
                    self, self.tr("Validation Error"), self.tr("Selected CSV file does not exist.")
                )
                return False
            if not self.cb_layer_field.currentText() or not self.cb_csv_field.currentText():
                QMessageBox.warning(
                    self, self.tr("Validation Error"), self.tr("Please select join key fields.")
                )
                return False

        else:  # SHP
            shp_path = self.le_shp_path.text().strip()
            if not shp_path:
                QMessageBox.warning(
                    self, self.tr("Validation Error"), self.tr("Please select a Shapefile.")
                )
                return False
            if not shp_path.lower().endswith(".shp"):
                QMessageBox.warning(
                    self, self.tr("Validation Error"), self.tr("File must have .shp extension.")
                )
                return False
            if not os.path.isfile(shp_path):
                QMessageBox.warning(
                    self, self.tr("Validation Error"), self.tr("Selected Shapefile does not exist.")
                )
                return False

        return True

    # ── Execute ───────────────────────────────────────────────────────

    def _on_execute_clicked(self):
        """Validate, confirm, convert, and load result into QGIS."""
        if not self._validate_inputs():
            return

        output_path = self._select_output_file()
        if not output_path:
            self.lbl_result_summary.setText(
                self.tr("Result: Execution canceled (no output selected).")
            )
            return

        if os.path.exists(output_path):
            answer = QMessageBox.question(
                self,
                self.tr("Overwrite Confirmation"),
                self.tr("Output file already exists. Overwrite?"),
                QMessageBox.Yes | QMessageBox.No,
                QMessageBox.No,
            )
            if answer != QMessageBox.Yes:
                self.lbl_result_summary.setText(self.tr("Result: Execution canceled by user."))
                return

        if self.rb_layer.isChecked():
            layer = self._get_selected_layer()
            if layer and self._is_layer_source_gpkg(layer) and not self._detect_layer_joins(layer):
                self.lbl_result_summary.setText(
                    self.tr("Result: Layer is already GPKG with no joins. Skipping.")
                )
                QMessageBox.information(
                    self,
                    self.tr("Skip"),
                    self.tr(
                        "This layer is already GPKG and has no joins to reproduce. Skipping."
                    ),
                )
                return

        ok, msg = self._do_convert(output_path)
        self.lbl_result_summary.setText(self.tr("Result: {}").format(msg))
        if ok:
            layer_name = os.path.splitext(os.path.basename(output_path))[0]
            result_layer = QgsVectorLayer(
                "{}|layername={}".format(output_path, layer_name), layer_name, "ogr"
            )
            if result_layer.isValid():
                QgsProject.instance().addMapLayer(result_layer)
            QMessageBox.information(self, self.tr("Success"), msg)
        else:
            QMessageBox.critical(self, self.tr("Error"), msg)

    # ── Conversion dispatch ───────────────────────────────────────────

    def _do_convert(self, output_path):
        """Dispatch to the appropriate conversion method. Returns (ok, message)."""
        if self.rb_shp.isChecked():
            return self._convert_shp(output_path)
        if self.rb_layer_csv.isChecked():
            return self._convert_layer_csv(output_path)
        return self._convert_layer(output_path)

    def _convert_shp(self, output_path):
        """Convert SHP directly to GPKG using the selected layer encoding."""
        shp_path = self.le_shp_path.text().strip()
        codec = self._get_encoding_codec() or "utf-8"
        layer_name = os.path.splitext(os.path.basename(shp_path))[0]

        fields, records = self._read_dbf_full(shp_path, codec)
        geo_layer = QgsVectorLayer(shp_path, "temp_geom", "ogr")
        if not geo_layer.isValid():
            return False, self.tr("Failed to open Shapefile.")

        mem = self._build_memory_layer(geo_layer, fields, records)
        if mem is None:
            return False, self.tr("Failed to build output layer.")
        return self._write_to_gpkg(mem, output_path, layer_name)

    def _convert_layer(self, output_path):
        """Convert QGIS layer (SHP re-read or flatten with joins) to GPKG."""
        layer = self._get_selected_layer()
        codec = self._get_encoding_codec()
        csv_codec = self._get_csv_encoding_codec()
        layer_name = layer.name()
        source_path = layer.source().split("|")[0].strip()

        if source_path.lower().endswith(".shp") and os.path.isfile(source_path):
            # Re-read SHP with the correct encoding
            fields, records = self._read_dbf_full(source_path, codec or "utf-8")
            geo_layer = QgsVectorLayer(source_path, "temp_geom", "ogr")
            if not geo_layer.isValid():
                return False, self.tr("Failed to open Shapefile source.")
            mem = self._build_memory_layer(geo_layer, fields, records)
            if mem is None:
                return False, self.tr("Failed to build output layer.")

            # Reproduce QGIS-configured joins (e.g., SHP joined to a CSV layer)
            for join_info in layer.vectorJoins():
                join_layer = QgsProject.instance().mapLayer(join_info.joinLayerId())
                if join_layer is None:
                    continue
                join_path = self._extract_join_source_path(join_layer.source())
                if not join_path:
                    continue
                # Field index in original layer → same index in mem (same DBF order)
                target_idx = layer.fields().indexFromName(join_info.targetFieldName())

                # Get the subset of fields selected in the join properties.
                # If this list is empty, it means all fields are joined.
                join_fields_subset = join_info.joinFieldNamesSubset()

                csv_dict, all_csv_extra_fields = self._read_csv_full(
                    join_path, csv_codec or "utf-8", join_info.joinFieldName()
                )

                # Filter the fields to be merged based on the join subset.
                # joinFieldNamesSubset() returns the original CSV column names (no prefix).
                # None means all fields are joined.
                if join_fields_subset is not None:
                    subset_set = set(join_fields_subset)
                    fields_to_merge = [f for f in all_csv_extra_fields if f in subset_set]
                else:
                    fields_to_merge = all_csv_extra_fields

                if csv_dict is not None:
                    # Pass the correctly filtered list of fields to the merge function.
                    mem = self._merge_csv_to_layer(mem, csv_dict, fields_to_merge, target_idx)
                    if mem is None:
                        return False, self.tr("Failed to merge join data.")
        else:
            # GPKG and other formats: iterate features directly (QGIS joins included)
            mem = self._flatten_to_memory(layer)

        if mem is None:
            return False, self.tr("Failed to build output layer.")
        return self._write_to_gpkg(mem, output_path, layer_name)

    def _convert_layer_csv(self, output_path):
        """Join layer with external CSV (separate encodings) and write to GPKG."""
        layer = self._get_selected_layer_csv()
        codec = self._get_encoding_codec()
        csv_codec = self._get_csv_encoding_codec()
        csv_path = self.le_csv_path.text().strip()
        layer_field_name = self.cb_layer_field.currentText()
        csv_field_name = self.cb_csv_field.currentText()

        # Field index is reliable even when the field name is garbled in QGIS
        layer_field_idx = layer.fields().indexFromName(layer_field_name)

        csv_dict, csv_extra_fields = self._read_csv_full(csv_path, csv_codec, csv_field_name)
        if csv_dict is None:
            return False, self.tr("Failed to read CSV file.")

        source_path = layer.source().split("|")[0].strip()
        if source_path.lower().endswith(".shp") and os.path.isfile(source_path):
            fields, records = self._read_dbf_full(source_path, codec or "utf-8")
            geo_layer = QgsVectorLayer(source_path, "temp_geom", "ogr")
            if not geo_layer.isValid():
                return False, self.tr("Failed to open layer source.")
            base_mem = self._build_memory_layer(geo_layer, fields, records)
        else:
            base_mem = self._flatten_to_memory(layer)

        if base_mem is None:
            return False, self.tr("Failed to build base layer.")

        merged = self._merge_csv_to_layer(base_mem, csv_dict, csv_extra_fields, layer_field_idx)
        if merged is None:
            return False, self.tr("Failed to merge CSV data.")
        return self._write_to_gpkg(merged, output_path, layer.name())

    # ── Conversion helpers ────────────────────────────────────────────

    @staticmethod
    def _extract_join_source_path(source):
        """Return filesystem path from a QGIS layer source string, or None.

        Handles:
          - Plain file paths:           "/path/to/file.csv"
          - OGR pipe format:            "/path/to/file.shp|layername=..."
          - Delimited text URI:         "file:///path/to/file.csv?delimiter=..."
        """
        if not source:
            return None
        if source.lower().startswith("file:"):
            try:
                from urllib.parse import urlparse, unquote
                parsed = urlparse(source)
                path = unquote(parsed.path)
                # Windows: /C:/path → C:/path
                if path.startswith("/") and len(path) > 2 and path[2] == ":":
                    path = path[1:]
                return path if os.path.isfile(path) else None
            except Exception:
                pass
        base = source.split("|")[0].strip()
        return base if os.path.isfile(base) else None

    @classmethod
    def _read_dbf_full(cls, shp_path, codec):
        """Read entire DBF with the given codec.

        Returns (fields, records) where:
          fields  = [(name, ftype, flen, dec_count), ...]
          records = [[val, ...], ...] – deleted records are skipped
        """
        dbf_path = os.path.splitext(shp_path)[0] + ".dbf"
        if not os.path.isfile(dbf_path):
            return [], []
        try:
            with open(dbf_path, "rb") as f:
                hdr = f.read(32)
                if len(hdr) < 32:
                    return [], []
                record_count = int.from_bytes(hdr[4:8], "little")
                header_size = int.from_bytes(hdr[8:10], "little")
                record_size = int.from_bytes(hdr[10:12], "little")
                n_fields = (header_size - 33) // 32

                enc = codec or "utf-8"
                fields = []
                offsets = []
                rec_offset = 1  # byte 0 is deletion flag
                f.seek(32)
                for _ in range(n_fields):
                    desc = f.read(32)
                    if len(desc) < 32 or desc[0] == 0x0D:
                        break
                    name_raw = desc[0:11].split(b"\x00")[0]
                    ftype = chr(desc[11])
                    flen = desc[16]
                    dec_count = desc[17]
                    try:
                        name = name_raw.decode(enc, errors="replace").strip()
                    except LookupError:
                        name = name_raw.decode("utf-8", errors="replace").strip()
                    fields.append((name, ftype, flen, dec_count))
                    offsets.append((rec_offset, flen, ftype, dec_count))
                    rec_offset += flen

                records = []
                f.seek(header_size)
                for _ in range(record_count):
                    record = f.read(record_size)
                    if len(record) < record_size:
                        break
                    if record[0] == 0x2A:  # deleted record — skip (OGR also skips these)
                        continue
                    row = []
                    for foffset, flen, ftype, dec_count in offsets:
                        raw = record[foffset: foffset + flen]
                        try:
                            val = raw.decode(enc, errors="replace").strip()
                        except LookupError:
                            val = raw.decode("utf-8", errors="replace").strip()
                        if ftype in ("N", "F"):
                            if val:
                                try:
                                    val = float(val) if dec_count > 0 else int(float(val))
                                except (ValueError, OverflowError):
                                    pass
                            else:
                                val = None
                        elif ftype == "L":
                            val = (
                                True if val.upper() in ("T", "Y")
                                else (False if val.upper() in ("F", "N") else None)
                            )
                        row.append(val)
                    records.append(row)
            return fields, records
        except Exception:
            return [], []

    # GPKG uses "fid" as the primary key column and "geom"/"geometry" for geometry.
    # Fields with these names must be renamed to avoid silent data loss or misalignment.
    _GPKG_RESERVED = frozenset({"fid", "geom", "geometry"})
    
    # Suffixes for resolving duplicate field names, per user suggestion for readability.
    _DUPLICATE_SUFFIXES = [
        '_α', '_β', '_γ', '_δ', '_ε', '_ζ', '_η', '_θ', '_ι', '_κ', '_λ', '_μ',
        '_ν', '_ξ', '_ο', '_π', '_ρ', '_σ', '_τ', '_υ', '_φ', '_χ', '_ψ', '_ω'
    ]
    
    @classmethod
    def _safe_gpkg_name(cls, name, used):
        """Return name safe for GPKG; append suffixes for reserved names or duplicates."""
        # 1. Handle reserved words first by setting the base name
        base_name = (name + "_") if name.lower() in cls._GPKG_RESERVED else name

        # 2. Check if the base name itself is unique
        if base_name.lower() not in used:
            used.add(base_name.lower())
            return base_name

        # 3. If not, try appending Greek letter suffixes
        for suffix in cls._DUPLICATE_SUFFIXES:
            candidate = base_name + suffix
            if candidate.lower() not in used:
                used.add(candidate.lower())
                return candidate

        # 4. Fallback: if all Greek letters are used, append numbers
        i = 1
        while True:
            candidate = "{}_{}".format(base_name, i)
            if candidate.lower() not in used:
                used.add(candidate.lower())
                return candidate
            i += 1

    @classmethod
    def _build_memory_layer(cls, geo_layer, fields, records):
        """Create a memory QgsVectorLayer from geometry + decoded DBF fields/records."""
        geom_str = QgsWkbTypes.displayString(geo_layer.wkbType())
        crs = geo_layer.crs().authid()
        mem = QgsVectorLayer("{}?crs={}".format(geom_str, crs), "output", "memory")
        if not mem.isValid():
            return None

        used_names = set()
        qgs_fields = []
        for name, ftype, flen, dec_count in fields:
            safe = cls._safe_gpkg_name(name, used_names)
            if ftype in ("N", "F"):
                if dec_count > 0:
                    qgs_fields.append(QgsField(safe, QVariant.Double, '', flen, dec_count))
                else:
                    qgs_fields.append(QgsField(safe, QVariant.LongLong))
            elif ftype == "L":
                qgs_fields.append(QgsField(safe, QVariant.Bool))
            else:
                qgs_fields.append(QgsField(safe, QVariant.String, '', flen))

        pr = mem.dataProvider()
        pr.addAttributes(qgs_fields)
        mem.updateFields()

        new_feats = []
        for i, geo_feat in enumerate(geo_layer.getFeatures()):
            feat = QgsFeature(mem.fields())
            feat.setGeometry(geo_feat.geometry())
            if i < len(records):
                for j, val in enumerate(records[i]):
                    feat.setAttribute(j, val)
            new_feats.append(feat)
        pr.addFeatures(new_feats)
        mem.updateExtents()
        return mem

    @staticmethod
    def _flatten_to_memory(layer):
        """Copy layer (including virtual join fields) to a memory layer."""
        geom_str = QgsWkbTypes.displayString(layer.wkbType())
        crs = layer.crs().authid()
        mem = QgsVectorLayer("{}?crs={}".format(geom_str, crs), "output", "memory")
        if not mem.isValid():
            return None

        pr = mem.dataProvider()
        pr.addAttributes(list(layer.fields()))
        mem.updateFields()

        new_feats = []
        for src_feat in layer.getFeatures():
            feat = QgsFeature(mem.fields())
            feat.setGeometry(src_feat.geometry())
            feat.setAttributes(src_feat.attributes())
            new_feats.append(feat)
        pr.addFeatures(new_feats)
        mem.updateExtents()
        return mem

    @staticmethod
    def _read_csv_full(csv_path, codec, key_field):
        """Read CSV into a lookup dict keyed by key_field values.

        Returns (csv_dict, extra_field_names) or (None, None) on error.
        """
        enc = codec or "utf-8"
        try:
            with open(csv_path, "r", encoding=enc, errors="replace") as f:
                reader = csv.DictReader(f)
                headers = list(reader.fieldnames or [])
                csv_dict = {}
                for row in reader:
                    key = str(row.get(key_field, "") or "").strip()
                    csv_dict[key] = dict(row)
            # Deduplicate while preserving order; duplicate CSV columns cause _α suffixes.
            seen = {key_field}
            extra_fields = []
            for h in headers:
                if h not in seen:
                    seen.add(h)
                    extra_fields.append(h)
            return csv_dict, extra_fields
        except Exception:
            return None, None

    @classmethod
    def _merge_csv_to_layer(cls, base_layer, csv_dict, csv_extra_fields, field_idx):
        """Add CSV columns to base_layer joined on the attribute at field_idx."""
        geom_str = QgsWkbTypes.displayString(base_layer.wkbType())
        crs = base_layer.crs().authid()
        mem = QgsVectorLayer("{}?crs={}".format(geom_str, crs), "output", "memory")
        if not mem.isValid():
            return None

        pr = mem.dataProvider()
        # Deduplicate CSV field names against base fields (and GPKG reserved names).
        # Memory provider silently skips duplicate names, which would shift all
        # subsequent CSV columns to wrong positions.
        used_names = {f.name().lower() for f in base_layer.fields()}
        safe_csv_names = [cls._safe_gpkg_name(fname, used_names) for fname in csv_extra_fields]

        new_attrs = list(base_layer.fields())
        for safe_name in safe_csv_names:
            new_attrs.append(QgsField(safe_name, QVariant.String))
        pr.addAttributes(new_attrs)
        mem.updateFields()

        # Number of base attributes to copy (trim any extras from virtual join fields).
        n_base = len(base_layer.fields())

        new_feats = []
        for src_feat in base_layer.getFeatures():
            feat = QgsFeature(mem.fields())
            feat.setGeometry(src_feat.geometry())
            # Limit to exactly base-field count so QGIS virtual-join values don't
            # occupy the CSV column slots.
            attrs = list(src_feat.attributes())[:n_base]
            raw_key = src_feat.attribute(field_idx) if field_idx >= 0 else None
            if raw_key is None:
                join_key = ""
            elif isinstance(raw_key, float) and raw_key == int(raw_key):
                join_key = str(int(raw_key))  # 1.0 → "1" not "1.0"
            else:
                join_key = str(raw_key).strip()
            csv_row = csv_dict.get(join_key, {})
            for fname in csv_extra_fields:  # original names for dict lookup
                attrs.append(csv_row.get(fname))
            feat.setAttributes(attrs)
            new_feats.append(feat)
        pr.addFeatures(new_feats)
        mem.updateExtents()
        return mem

    @staticmethod
    def _write_to_gpkg(layer, output_path, layer_name):
        """Write layer to GPKG as UTF-8. Returns (ok, message)."""
        options = QgsVectorFileWriter.SaveVectorOptions()
        options.driverName = "GPKG"
        options.fileEncoding = "UTF-8"
        options.layerName = layer_name or "layer"
        options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteFile

        result, msg, _, _ = QgsVectorFileWriter.writeAsVectorFormatV3(
            layer, output_path, QgsCoordinateTransformContext(), options
        )
        if result == QgsVectorFileWriter.NoError:
            return True, QCoreApplication.translate(
                "MultiEncodeVectorConverterDockWidget",
                "Conversion complete: {}"
            ).format(output_path)
        return False, QCoreApplication.translate(
            "MultiEncodeVectorConverterDockWidget",
            "Write error (code {}): {}"
        ).format(result, msg)

    # ── Utility ───────────────────────────────────────────────────────

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()
