# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MoveFeature
                                 A QGIS plugin
 This plugin moves the features fro one location to another.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-10-06
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Murat ÇALIŞKAN
        email                : caliskan.murat.20@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.utils import iface
from qgis.core import Qgis, QgsPointXY, QgsGeometry, QgsVectorFileWriter, QgsFields, QgsField, QgsWkbTypes, QgsFeature, QgsCoordinateReferenceSystem, QgsVectorLayer
from qgis.gui import QgsMapToolEmitPoint, QgsMapMouseEvent

from qgis.core import QgsProject

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .moving_feature_dialog import MoveFeatureDialog
import os.path

from osgeo import ogr, osr
import os, json

class MoveFeature():
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MoveFeature_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Move Features')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MoveFeature', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/moving_feature/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Move Features'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Move Features'),
                action)
            self.iface.removeToolBarIcon(action)
            
    
    def getLayers(self):
        self.dlg.comboBox.clear()
        self.dlg.comboBox_2.clear()
        self.dlg.comboBox_3.clear()
        
        self.dlg.comboBox_3.addItems(self.layers.keys())
        self.dlg.comboBox_2.addItems([k for k,v in self.layers.items() if v.wkbType() == 1])
        self.dlg.comboBox.addItems([k for k,v in self.layers.items() if v.wkbType() == 1])
            
    def select_output(self):
        self.dlg.lineEdit.setText("")
        self.shpPath, self._filter = QFileDialog.getSaveFileName(self.dlg, "Select input shp file", "", '*.shp')
        self.dlg.lineEdit.setText(self.shpPath)
            
    def convertFeatToJson(self, feat):
        self.fjson = {'type': 'Feature'}
        self.fjson["id"] = feat.id()
        self.fjson["geometry"] = feat.geometry()
        self.fjson["properties"] = [(field.type(),field.name(),attr) if attr else (field.type(),field.name(),"") for field, attr in zip(feat.fields(), feat.attributes())]
        return self.fjson
    
    def display_point(self, pointTool, pnt):
        try:
            self.coorx = round(pointTool.x(),3)
            self.coory = round(pointTool.y(),3)
            if pnt == "start":
                self.dlg.label_13.setText(str(self.coorx))
                self.dlg.label_14.setText(str(self.coory))
            elif pnt == "end":
                self.dlg.label_15.setText(str(self.coorx))
                self.dlg.label_16.setText(str(self.coory))   
        except AttributeError:
            pass
        self.unset()
        self.dlg.showNormal()
        
    
    def getClickedCoor(self, pnt):
        self.dlg.showMinimized()
        global pointTool
        pointTool = QgsMapToolEmitPoint(self.canvas)
        pointTool.canvasClicked.connect(lambda x: self.display_point(x,pnt))        
        self.canvas.setMapTool(pointTool)
        
    def unset(self):
        self.canvas.unsetMapTool(pointTool)
    
    def move_feature(self, feat, dx, dy):
        self.new_feat = feat.copy()
        self.geometry = feat["geometry"]
        
        if self.geometry.wkbType() == 1: # Point
            self.geom = self.geometry.asPoint()
            self.newGeom = QgsPointXY(self.geom[0]+dx, self.geom[1]+dy)
            self.newGeometry = QgsGeometry.fromPointXY(self.newGeom)
            self.new_feat["geometry"] = self.newGeometry
        
        elif self.geometry.wkbType() == 2: # LineString
            self.geom = self.geometry.asPolyline()
            self.newGeom = [QgsPointXY(i[0]+dx, i[1]+dy) for i in self.geom]
            self.newGeometry = QgsGeometry.fromPolylineXY(self.newGeom)
            self.new_feat["geometry"] = self.newGeometry
        
        elif self.geometry.wkbType() == 3: # Polygon
            self.geom = self.geometry.asPolygon()
            self.newGeom=[]
            for g in self.geom:
                self.g1=[]
                for gg in g:
                    self.new_gg = QgsPointXY(gg[0]+dx, gg[1]+dy)
                    self.g1.append(self.new_gg)
                self.newGeom.append(self.g1)
                
            self.newGeometry = QgsGeometry.fromPolygonXY(self.newGeom)
            self.new_feat["geometry"] = self.newGeometry
        
        elif self.geometry.wkbType() == 4: # MultiPoint
            self.geom = self.geometry.asMultiPoint()
            self.newGeom = [QgsPointXY(i[0]+dx, i[1]+dy) for i in self.geom]
            self.newGeometry = QgsGeometry.fromMultiPointXY(self.newGeom)
            self.new_feat["geometry"] = self.newGeometry
        
        elif self.geometry.wkbType() == 5: # MultiLineString
            self.geom = self.geometry.asMultiPolyline()
            self.newGeom=[]
            for g in self.geom:
                self.g1=[]
                for gg in g:
                    self.new_gg = QgsPointXY(gg[0]+dx, gg[1]+dy)
                    self.g1.append(self.new_gg)
                self.newGeom.append(self.g1)
                
            self.newGeometry = QgsGeometry.fromMultiPolylineXY(self.newGeom)
            self.new_feat["geometry"] = self.newGeometry
        
        elif self.geometry.wkbType() == 6: # MultiPolygon
            self.geom = self.geometry.asMultiPolygon()
            self.newGeom=[]
            for g in self.geom:
                self.g1=[]
                for gg in g:
                    self.g2=[]
                    for ggg in gg:
                        self.new_ggg = QgsPointXY(ggg[0]+dx, ggg[1]+dy)
                        self.g2.append(self.new_ggg)
                    self.g1.append(self.g2)
                self.newGeom.append(self.g1)
    
            self.newGeometry = QgsGeometry.fromMultiPolygonXY(self.newGeom)
            self.new_feat["geometry"] = self.newGeometry
            
        return self.new_feat

    def createShp(self, out_shp, features, inLayer, sr, out_type=None):
        self.new_name = inLayer.name()+"_new"
        self.geomType = QgsWkbTypes.displayString(inLayer.wkbType()) 
        if out_type == "m":
            self.new_shp = QgsVectorLayer(self.geomType, self.new_name, "memory")
            self.pr = self.new_shp.dataProvider()
            
            self.fields = [QgsField(n,t) for t,n,_ in features[0]["properties"]]
            self.pr.addAttributes(self.fields)
            self.new_shp.updateFields()
            
            
            for f in features:
                self.feat = QgsFeature()
                self.feat.setGeometry(f["geometry"])
                self.feat.setAttributes([k for i,j,k in f["properties"]])
                self.pr.addFeature(self.feat)
                self.new_shp.updateExtents() 
            QgsProject.instance().addMapLayer(self.new_shp)
            self.new_shp.setCrs(QgsCoordinateReferenceSystem.fromWkt(sr))
        else:
            self.fields = QgsFields()
            for t,n,_ in features[0]["properties"]:
                self.fields.append(QgsField(n,t))
            
            self.writer = QgsVectorFileWriter(out_shp, 'UTF-8', self.fields, inLayer.wkbType(), QgsCoordinateReferenceSystem.fromWkt(sr), 'ESRI Shapefile')
            for f in features:
                self.feat = QgsFeature()
                self.feat.setGeometry(f["geometry"])
                self.feat.setAttributes([k for i,j,k in f["properties"]])
                self.writer.addFeature(self.feat)
                
            self.layer=iface.addVectorLayer(out_shp, '', 'ogr')
            self.layer.setExtent(inLayer.extent())
            del(self.writer)
    
    def run(self):
        """Run method that performs all the real work"""
        
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.dlg = MoveFeatureDialog()
            self.layers = {layer.name():layer for layer in QgsProject.instance().mapLayers().values() if layer.type()== 0}
            self.getLayers()
            
            self.dlg.pushButton_input_shp_5.clicked.connect(lambda x:self.getClickedCoor("start"))
            self.dlg.pushButton_input_shp_4.clicked.connect(lambda x:self.getClickedCoor("end"))
            
            self.dlg.toolButton.clicked.connect(self.select_output)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            
            self.method = self.dlg.tabWidget.currentIndex()            
            if self.method == 0:
                self.startName = self.dlg.comboBox.currentText()
                self.startLayer = self.layers[self.startName]
                self.geomStart = next(self.startLayer.getFeatures()).geometry()
                
                self.endName = self.dlg.comboBox_2.currentText()
                self.endLayer = self.layers[self.endName]
                self.geomEnd = next(self.endLayer.getFeatures()).geometry()
                
                self.sx, self.sy = self.geomStart.asPoint()
                self.ex, self.ey = self.geomEnd.asPoint()
                
                self.dx = self.ex-self.sx
                self.dy = self.ey-self.sy
            
            elif self.method == 1:
                self.sx = float(self.dlg.doubleSpinBox.text().replace(",","."))
                self.sy = float(self.dlg.doubleSpinBox_2.text().replace(",","."))             
                self.ex = float(self.dlg.doubleSpinBox_3.text().replace(",","."))
                self.ey = float(self.dlg.doubleSpinBox_4.text().replace(",","."))             
                self.dx = self.ex - self.sx
                self.dy = self.ey - self.sy
            
            elif self.method == 2:
                self.dx = float(self.dlg.doubleSpinBox_5.text().replace(",","."))
                self.dy = float(self.dlg.doubleSpinBox_6.text().replace(",","."))
                
            elif self.method == 3:
                self.sx = float(self.dlg.label_13.text().replace(",","."))
                self.sy = float(self.dlg.label_14.text().replace(",","."))             
                self.ex = float(self.dlg.label_15.text().replace(",","."))
                self.ey = float(self.dlg.label_16.text().replace(",","."))             
                self.dx = self.ex - self.sx
                self.dy = self.ey - self.sy
            
            
            self.out_shp = self.dlg.lineEdit.text()         
            self.shpLayer = self.layers[self.dlg.comboBox_3.currentText()]
            self.shpJson = [self.convertFeatToJson(feat) for feat in self.shpLayer.getFeatures()]
            self.sr = self.shpLayer.crs().toWkt()
            self.jsonList = [self.move_feature(feat, self.dx, self.dy) for feat in self.shpJson]
                        
            if self.out_shp:
                try:
                    self.createShp(self.out_shp, self.jsonList, self.shpLayer, self.sr)
                    self.iface.messageBar().pushMessage("Success", "Features moved successfully!" , level=Qgis.Success, duration=5)
                except Exception as e:
                    self.iface.messageBar().pushMessage("Error", "An error occured! Check the python console." , level=Qgis.Critical, duration=5)
                    print(e)
            else:
                try:
                    self.createShp(self.out_shp, self.jsonList, self.shpLayer, self.sr, "m")
                    self.iface.messageBar().pushMessage("Success", "Features moved successfully!" , level=Qgis.Success, duration=5)
                except Exception as e:
                    self.iface.messageBar().pushMessage("Error", "An error occured! Check the python console." , level=Qgis.Critical, duration=5)
                    print(e)
