# -*- coding: utf-8 -*-
"""
Created on Thu Jul 10 10:02:44 2025

@author: zocuckov
"""

# -*- coding: utf-8 -*-

"""
/***************************************************************************
 MovementAnalysis
                                 A QGIS plugin
 Toolbox for raster based movement analysis: least-cost path, cost surface, accessibility.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-05-17
        copyright            : (C) 2024 by Zoran Čučković
        email                : cuckovic.zoran@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Zoran Čučković'
__date__ = '2024-05-17'
__copyright__ = '(C) 2024 by Zoran Čučković'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication

from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterRasterDestination,
                        QgsProcessingParameterBoolean,
                      QgsProcessingParameterNumber,
                       QgsProcessingParameterEnum)


from osgeo import gdal
import numpy as np


from .modules import Raster as rst 


# Constants for methods
TOBLER = 0
HERZOG_METABOLIC = 1
CONOLLY_LAKE = 2
HERZOG_WHEELED = 3

# Modes
COST = 0
SPEED = 1


def slope (dem, xres, yres, tangent=False, geographic_north = True):
    
    # north-up rasters have negative yres (!!)
    if geographic_north : yres = -yres  
    
    # Pad edges to allow gradient computation
    padded = np.pad(dem, 1, mode='edge')

    # Horn's method: approximate dz/dx and dz/dy
    dzdx = (
        (padded[1:-1, 2:] + 2*padded[1:-1, 1:-1] + padded[1:-1, :-2]) -
        (padded[:-2, 2:] + 2*padded[:-2, 1:-1] + padded[:-2, :-2])
    ) / (8 * xres)

    dzdy = (
        (padded[2:, 1:-1] + 2*padded[1:-1, 1:-1] + padded[:-2, 1:-1]) -
        (padded[2:, :-2] + 2*padded[1:-1, :-2] + padded[:-2, :-2])
    ) / (8 * yres)

    # Tangent of slope (gives rise/run)
    slope_tangent = np.hypot(dzdx, dzdy)  # same as sqrt(dx² + dy²)
    
    return slope_tangent if tangent else np.degrees(np.arctan(slope_tangent))
        


class SlopeCost(QgsProcessingAlgorithm):
        # Constants used to refer to parameters and outputs. They will be
       # used when calling the algorithm from another algorithm, or when
       # calling from the QGIS console.
    
    DEM = 'DEM'

    OUTPUT = 'OUTPUT'
    
    MODE = 'MODE'
    
    METHOD = 'METHOD'
       
    SPEED = 'SPEED'
    
    HERZOG_SLOPE = 'HERZOG_SLOPE'
    
    MODES = [ 'cost (time)', 'speed'] 
    METHODS = [ "Tobler's hiking function",
        "Herzog metabolic cost",
        "Conolly & Lake relative cost",
        "Herzog wheeled vehicle model"] 
    

    def initAlgorithm(self, config=None):
    
        self.addParameter(
            QgsProcessingParameterRasterLayer(
                self.DEM,
                self.tr('Digital elevation model')
            ) )
              
        # self.addParameter(QgsProcessingParameterBoolean(
        #     self.SPEED,
        #     self.tr('Use speed (instead of cost)')))
        
        self.addParameter(QgsProcessingParameterEnum (
            self.METHOD,
            self.tr('Slope function'),
            self.METHODS,
            defaultValue=0))
            
        self.addParameter(QgsProcessingParameterEnum (
            self.MODE,
            self.tr('Output type'),
            self.MODES,
            defaultValue=0))
        
        self.addParameter(QgsProcessingParameterNumber (
            self.HERZOG_SLOPE,
            self.tr("Critical slope degree (Herzog's vehicule function)"),
            QgsProcessingParameterNumber.Double,
            defaultValue=12))
        
        self.addParameter(
            QgsProcessingParameterRasterDestination(
                self.OUTPUT,
            self.tr("Output file")))

    def processAlgorithm(self, parameters, context, feedback):
        
     
        dem = self.parameterAsRasterLayer(parameters,self.DEM, context)
        method = self.parameterAsInt(parameters,self.METHOD,context) 
                      
        mode = self.parameterAsInt(parameters,self.MODE,context) 
        
        critical_slope = self.parameterAsInt(parameters,self.HERZOG_SLOPE,context) 
        
        output_path = self.parameterAsOutputLayer(parameters,self.OUTPUT,context)
        
        if mode != COST and method >=2 : 
            raise Exception ( "Speed cannot be derived from this formula !" )
    
        # Open the DEM raster
        
        dem = rst.Raster(dem.source(), output_path)
         
        use_tangent = method in [0,1,3] 
        
        z = dem.open_raster()
        
        z = np.where(z>0,z,np.nan)
          
        s = slope(z, dem.pix_x, dem.pix_y, use_tangent)
        
        if method == TOBLER: #speed as main output
            
            out = 6 * np.exp(-3.5 * np.abs(s + 0.05))  # km/h
            if mode == COST : #cost in hours, where pixels in meters are converted in km"
                out = (dem.pix_x / 1000) / out
            # pace tombler = 1 /out
        elif method == HERZOG_METABOLIC:
            den = (1337.8*s**6 + 278.19*s**5 - 517.39*s**4 -
                   78.199*s**3 + 93.419*s**2 + 19.825*s + 1.64)
            out = 1000 / den if mode == COST else 1 / den

        elif method == CONOLLY_LAKE: # slope in degrees 
            out = 1 / (np.tan(np.radians(s)) / np.tan(np.radians(1)))

        elif method == HERZOG_WHEELED:
            # slope in percent : s *100
            out = 1 / (1 + (s * 100 / critical_slope)**2)
            
        dem.result = out
      
        dem.write_output()
    
        return {self.OUTPUT:output_path} 


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Slope cost'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Helpers'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return SlopeCost()
