# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MOVECOSTDialog
                                 A QGIS plugin
 Rscipt for QGIS for Calculation of Slope-Dependant Accumulated Cost Surface, Least-Cost Paths, and Least-Cost Corridors Related to Human
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-09-14
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Enzo Cocca; Gianmarco Alberti
        email                : enzo.ccc@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import shutil

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QApplication, QDialog, QMessageBox, QFileDialog,QLineEdit,QWidget,QCheckBox
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtCore import *


from qgis.core import *
from distutils.dir_util import copy_tree
from processing.tools.system import mkdir, userFolder
import processing
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'movecost_dialog_base.ui'))


class MOVECOSTDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(MOVECOSTDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
    
        self.test()
    def test(self):
        profile_home = QgsApplication.qgisSettingsDirPath()
        path= os.path.exists(os.path.join(profile_home,'python', 'plugins','processing_r'))
        if path==False:
            QMessageBox.warning(self, "Warning",
                                     "You need to install and set R provider before",
                                     QMessageBox.Ok)
    def on_pushButton_movecost_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movecost')
        
    def on_pushButton_movecost_p_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movecostbypolygon')
        
    def on_pushButton_movebound_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movebound')
    
    def on_pushButton_movebound_p_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:moveboundbypolygon')
    
    def on_pushButton_movecorr_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movecorr')
    
    def on_pushButton_movecorr_p_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movecorrbypolygon')
    
    def on_pushButton_movealloc_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movealloc')
    
    def on_pushButton_movealloc_p_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:moveallocbypolygon')
    
    def on_pushButton_movecomp_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movecomp')
    
    def on_pushButton_movecomp_p_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movecompbypolygon')
    
    def on_pushButton_movenetw_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movenetw')
    
    def on_pushButton_movenetw_p_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:movenetwbypolygon')
    
    def on_pushButton_moverank_p_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:moverank')
    
    def on_pushButton_moverank_polygon_pressed(self):#####modifiche apportate per il calcolo statistico con R
        processing.execAlgorithmDialog('r:moverankbypolygon')
    def defaultScriptsFolder():
        folder = str(os.path.join(userFolder(), "rscripts"))
        mkdir(folder)
        return os.path.abspath(folder)

    def on_pushButton_add_script_pressed(self):
        # Paths to source files and QGIS profile directory
        profile_home = QgsApplication.qgisSettingsDirPath()
        source_profile = os.path.join(profile_home, 'python', 'plugins', 'movecost', 'rscripts')
        rs = os.path.join(profile_home, 'processing', 'rscripts')

        # Check if the destination directory exists, create it if not
        if not os.path.exists(rs):
            os.makedirs(rs)

        # Copy each file individually to allow overwriting
        for filename in os.listdir(source_profile):
            source_file = os.path.join(source_profile, filename)
            dest_file = os.path.join(rs, filename)

            # Copy and overwrite the file
            shutil.copy2(source_file, dest_file)

        # Alternatively, using copy_tree from distutils.dir_util
        # This will also overwrite files
        copy_tree(source_profile, rs)