from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os
from .mosaic_algorithm import MosaicAlgorithm
# Import other algorithms here when you add them
# from .other_algorithm import OtherAlgorithm

class MosaicProvider(QgsProcessingProvider):
    """
    Processing Provider for MAS Geospatial Tools
    This class manages all algorithms under the MAS Geospatial Tools provider
    """
    
    def __init__(self):
        super().__init__()

    def loadAlgorithms(self):
        """
        Load all algorithms for this provider
        Add new algorithms here by calling self.addAlgorithm()
        """
        # Current algorithm
        self.addAlgorithm(MosaicAlgorithm())
        
        # Future algorithms - uncomment when you add them
        # self.addAlgorithm(OtherRasterAlgorithm())
        # self.addAlgorithm(AnotherRasterAlgorithm())

    def id(self):
        """
        Unique provider ID - used internally by QGIS
        Keep this consistent and unique across QGIS
        """
        return 'mas_geospatial_tools'

    def name(self):
        """
        Provider name shown in Processing Toolbox
        This is what users see as the main provider name
        """
        return 'MAS Geospatial Tools'

    def longName(self):
        """
        Detailed provider description
        """
        return 'MAS Geospatial Tools - Advanced Raster and Vector Processing'

    def icon(self):
        """
        Provider icon (toolbox.png) shown in Processing Toolbox
        """
        icon_path = os.path.join(os.path.dirname(__file__), 'toolbox.png')
        if os.path.exists(icon_path):
            return QIcon(icon_path)
        # Fallback to default QGIS icon if toolbox.png not found
        return QgsProcessingProvider.icon(self)

    def load(self):
        """
        Called when provider is first loaded
        """
        self.refreshAlgorithms()
        return True

    def unload(self):
        """
        Called when provider is unloaded
        """
        pass

    def supportedOutputTableExtensions(self):
        """
        Define supported output table formats if needed
        """
        return ['csv', 'xlsx']

    def supportedOutputRasterLayerExtensions(self):
        """
        Define supported output raster formats
        """
        return ['tif', 'tiff', 'img']
