# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MosaicBuilderDialog
                                 A QGIS plugin
 Copy a selected feature (without characteristics) to a scratch layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-06-30
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Dorset Council
        email                : gis@dorsetcouncil.gov.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject, QgsSettings, QgsMessageLog, QgsMapLayerProxyModel, Qgis

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'mosaic_builder_dialog_base.ui'))


class MosaicBuilderDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(MosaicBuilderDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # We can only work with polygon vector layers so we filter the list
        self.layerSelectionCombo.setFilters(QgsMapLayerProxyModel.PolygonLayer)

        self.layerSelectionCombo.layerChanged.connect(self.updateLabelText)

        #Ensure the currently selected layer is shown
        GlobalSettings = QgsSettings()
        keywordValue = GlobalSettings.value("mosaicBuilder/searchLayer", None)

        # Resolve the keyword default layer ID using name instead of just ID
        layerID = keywordValue
        if len(QgsProject.instance().mapLayersByName(keywordValue))>0:
            layerID = QgsProject.instance().mapLayersByName(keywordValue)[0].id() 

        if layerID is not None:
            selectedLayers = QgsProject.instance().mapLayer(layerID)
            #QgsMessageLog.logMessage(str(len(selectedLayers)), "Mosaic Builder", level=Qgis.Info)
            if selectedLayers is not None:
                self.layerSelectionCombo.setLayer(QgsProject.instance().mapLayer(layerID))
            else:
                self.layerSelectionCombo.setLayer(None)
        else:
            self.layerSelectionCombo.setLayer(None)

        self.updateLabelText()

    def unload(self):
        self.layerSelectionCombo.layerChanged.disconnect(self.updateLabelText)

    def updateLabelText(self):
        if self.layerSelectionCombo.currentLayer() is not None:
            self.ActiveText.setText("")
        else:
            self.ActiveText.setText("Using active (selected) layer unless default is set")

