from qgis.core import QgsProcessingProvider, QgsApplication
from qgis.PyQt.QtGui import QIcon
import os

class MORPHINTProvider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'morphint_morphology_intensity_analyzer'

    def name(self):
        return self.tr('MORPHINT (Urban Morphology and Intensity Analyzer)')

    def icon(self):
        path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(path)

    def loadAlgorithms(self):
        from .algorithms.morphint_morphology_intensity_analyzer import MORPHINT
        self.addAlgorithm(MORPHINT())

