# -*- coding: utf-8 -*-

"""
***************************************************************************
    MorpheoAlgorithmProvider.py
    ---------------------
    Date                 : August 2016
    Copyright            : (C) 2016 3Liz
    Email                : rldhont at 3liz dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""
from __future__ import print_function
from __future__ import absolute_import


__author__ = 'René-Luc DHONT'
__date__ = 'August 2016'
__copyright__ = '(C) 2016, 3Liz'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import time
import logging
from PyQt5.QtGui import *
from qgis.core import QgsProcessingProvider
#from plugins.processing.core.ProcessingConfig import ProcessingConfig, Setting
 
from qgis.gui import QgsGui
from .MorpheoAlgorithm import \
        MorpheoBuildAlgorithm, \
        MorpheoWayAttributesAlgorithm, \
        MorpheoEdgeAttributesAlgorithm, \
        MorpheoEdgesGraphAlgorithm, \
        MorpheoWaysGraphAlgorithm, \
        MorpheoStructuralDiffAlgorithm, \
        MorpheoMeshAlgorithm, \
        MorpheoHorizonAlgorithm

class MorpheoAlgorithmProvider(QgsProcessingProvider):

    def __init__(self):
        QgsProcessingProvider.__init__(self)
        self.activate = True

    def name(self):
        return 'Morpheo (Graph metrics)'

    def id(self):
        return 'morpheo'

    def icon(self):
        return QIcon(os.path.join(os.path.dirname(__file__), '..', 'morpheo.png'))

    def unload(self):

        pass
    
    def loadAlgorithms(self):
        try:
            self.addAlgorithm(MorpheoBuildAlgorithm())
            self.addAlgorithm(MorpheoWayAttributesAlgorithm())
            self.addAlgorithm(MorpheoEdgeAttributesAlgorithm())
            self.addAlgorithm(MorpheoEdgesGraphAlgorithm())
            self.addAlgorithm(MorpheoWaysGraphAlgorithm())
            self.addAlgorithm(MorpheoStructuralDiffAlgorithm())
            self.addAlgorithm(MorpheoMeshAlgorithm())
            self.addAlgorithm(MorpheoHorizonAlgorithm())
        except Exception as e:
            # fix_print_with_import
            print("error: unable to load morpheo algo because ", e)
            
            # the following line replace the old ProcessingLog. log DB path can be found using: QgsGui.historyProviderRegistry().userHistoryDbPath()
            QgsGui.historyProviderRegistry().addEntry("ALGORITHM", {'ERROR': 'Could not create Morpheo algorithm', 'algorithm_id': self.id()})
            raise e

