# -*- coding: utf-8 -*-

# reimplementation of the following removed functions from previous QGIS versions : getTempDiInTempFolder, _mkdir

import uuid
import os
from qgis.core import QgsProcessingUtils 


def _mkdir(newdir):
    os.makedirs(newdir.strip('\n\r '), exist_ok=True)


def getTempDirInTempFolder() -> str:
    """Returns a temporary directory, putting it into a temp folder.
    """

    path = QgsProcessingUtils.tempFolder()
    path = os.path.join(path, uuid.uuid4().hex)
    _mkdir(path)
    return path
