# -*- coding: utf-8 -*-
"""
/***************************************************************************
    MorphAL: PTM plugin for QGIS
    --------------
    Start date           : January 2021
    Copyright            : (C) 2021, Eric Grosso, PTM
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.core import QgsProcessingProvider

from morphal.core.geometry_to_medians import MorphALGeometryToMedians
from morphal.core.morphal_geometry_to_segments import MorphALGeometryToSegments
from morphal.core.morphal_polygon_perimeter_area import MorphALPolygonPerimeterArea
from morphal.core.morphal_rectangular_characterisation import (
    MorphALRectangularCharacterisation,
)
from morphal.core.morphal_segment_orientation import MorphALSegmentOrientation
from morphal.core.polygon_indicators import MorphALPolygonIndicators


class PTM4QgisProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

        self.algorithms_list = [
            MorphALPolygonPerimeterArea(),
            MorphALGeometryToSegments(),
            MorphALGeometryToMedians(),
            MorphALSegmentOrientation(),
            MorphALPolygonIndicators(),
            MorphALRectangularCharacterisation(),
        ]

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        for alg in self.algorithms_list:
            self.addAlgorithm(alg)

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return "morphal"

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr("PTM-MorphAL")

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
