# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MonitaskDockWidget
                                 A QGIS plugin
 遥感监测作业插件
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-04-23
        git sha              : $Format:%H$
        copyright            : (C) 2022 by zhouxu/NGCC
        email                : zhouxu@ngcc.cn
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt.QtCore import QSettings,QUrl,QStringListModel,QVariant,QObject
from qgis.PyQt import QtGui, QtWidgets, uic,QtNetwork
from qgis.PyQt.QtCore import pyqtSignal
from qgis.core import (QgsProject,QgsRasterLayer,QgsVectorLayer,QgsFields,QgsField,
                       QgsWkbTypes,QgsVectorFileWriter,QgsCoordinateReferenceSystem,
                       QgsCoordinateTransformContext,QgsVectorDataProvider,QgsFeature,
                       QgsGeometry, QgsSimpleFillSymbolLayer,QgsSymbol,QgsSingleSymbolRenderer,
                       QgsHashedLineSymbolLayer,QgsLineSymbol,QgsInvertedPolygonRenderer,
                       QgsSimpleLineSymbolLayer,QgsCategorizedSymbolRenderer,QgsRendererCategory,
                       QgsPalLayerSettings,QgsVectorLayerSimpleLabeling,QgsDefaultValue,
                       QgsEditorWidgetSetup,QgsTextFormat)
import json
import processing
from osgeo import gdal, osr, ogr
import sqlite3
#from random import randrange

FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'task_dialog.ui'))

class TaskDialog(QtWidgets.QDialog, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(TaskDialog, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.parent=parent
        self.currentTaskType = -1
        self.settings = QSettings()

        self.setupUi(self)
        self.connectBtn.clicked.connect(self.getTaskListOnline)
        self.listView.clicked.connect(self.onTaskSelected)
        self.applyTaskBtn.clicked.connect(self.applyTask)
        self.testTaskBtn.clicked.connect(self.createTaskProject)
#        self.taskType.currentIndexChanged.connect(self.checkApplyBtnState)
        self.taskSrvUrlEdit.setText(self.settings.value("MoniTask/task_service_url", ''))


#    def checkApplyBtnState(self,currentIndex):
#        self.applyTaskBtn.setEnabled(currentIndex==0)

    def setContext(self,iface):
        self.iface=iface

    def createTaskProject(self):
        taskDb=self.create_empty_taskpackage()
        self.fill_taskpackage(taskDb)

        project = QgsProject.instance()
        treeroot=project.layerTreeRoot()
        parcelGroup=treeroot.addGroup("工作图层")
        helperGroup=treeroot.addGroup("辅助图层")

        changelayer = QgsVectorLayer(taskDb+'|layername=change_parcels','采集结果')
        self.configChangeParceLayerSymbol(changelayer)
        self.configChangeParcelLayerAttributes(changelayer)
        project.addMapLayer(changelayer, False)  # 注册该图层到全局图层表中，但不在图例列表中显示
        parcelGroup.addLayer(changelayer)

        domGroup=treeroot.addGroup("DOM")
        nextgroup=domGroup.addGroup("后时相影像")
        pregroup =domGroup.addGroup("前时相影像")
        for block in self.task_blocks:
            if len(project.mapLayersByName(block['preimg'].strip()))==0:
                prelayer=QgsRasterLayer('/vsicurl/'+block['preurl'].strip()+'/'+block['preimg'].strip(),block['preimg'].strip())
                project.addMapLayer(prelayer,False) #注册该图层到全局图层表中，但不在图例列表中显示
                pregroup.addLayer(prelayer)
            if len(project.mapLayersByName(block['nextimg'].strip()))==0:
                nextlayer=QgsRasterLayer('/vsicurl/'+block['nexturl'].strip()+'/'+block['nextimg'].strip(),block['nextimg'].strip())
                project.addMapLayer(nextlayer,False) #注册该图层到全局图层表中，但不在图例列表中显示
                nextgroup.addLayer(nextlayer)

        task_block_layer = QgsVectorLayer(taskDb+'|layername=task_blocks','作业区块')
        self.configTaskBlockLayerSymbol(task_block_layer)
        project.addMapLayer(task_block_layer, False)  # 注册该图层到全局图层表中，但不在图例列表中显示

        task_cover_layer = QgsVectorLayer(taskDb+'|layername=tasks_details','作业整体范围')
        self.configTaskCoverLayerSymbol(task_cover_layer)
        project.addMapLayer(task_cover_layer, False)  # 注册该图层到全局图层表中，但不在图例列表中显示

        taskgrid_name='task_grid'
        taskgrid_layer=self.create_taskgrid(taskDb,taskgrid_name,task_block_layer)
        self.configTaskGridLayerSymbol(taskgrid_layer)
        project.addMapLayer(taskgrid_layer, False)  # 注册该图层到全局图层表中，但不在图例列表中显示

        helperGroup.addLayer(task_block_layer)
        helperGroup.addLayer(taskgrid_layer)
        helperGroup.addLayer(task_cover_layer)


        project.write(os.path.join(self.settings.value("MoniTask/workingdir", ''),self.task_blocks[0]['task_no'].strip()+'.qgs'))

        self.showLayersInOverviewWindow([taskgrid_layer,task_block_layer])
        self.layers=[changelayer,task_block_layer,taskgrid_layer,task_cover_layer]
        self.accept()

    def showLayersInOverviewWindow(self,layers=[]):
        self.iface.mainWindow().findChild(QObject, "Overview").setWindowTitle('概视图')
        self.iface.mainWindow().findChild(QObject, "Overview").setVisible(True)
        for layer in layers:
            self.iface.setActiveLayer(layer)
            self.iface.mainWindow().findChild(QObject, "mActionAddToOverview").trigger()

    def configChangeParcelLayerAttributes(self,changelayer):
        aliases=["fid","地物类型代码","地物类型名称","地物标注","生产标记","采集所用分辨率","采集是窗口比例尺","任务包编号",
        "采集所用前时相影像","采集所用后时相影像" ,"前时相影像URL","后时相影像URL","采集人员姓名","采集单位名称",
        "首次采集时间","检查人员姓名","检查单位名称","检查日期","最后更新时间"]
        ccDict={"农作物":"0101","林木":"0301","其他待添加......":"0909"} #应考虑从projects表中读取相关信息

        fieldDefault=[['',False],['',False],['',False],['',False],['1',False],['',False],['',False],['',False]
                ,['',False],['',False],['',False],['',False],['',False],['',False],['now()',False],['',False]
                ,['',False],['',False],['now()',True]]
        fieldReadOnly=[True,False,True,False,False,True,True,True,True,True,True,True,True,True,True,True,True,True,True]
        editWidgetType=["Hidden","ValueMap","Hidden","TextEdit","ValueMap","Hidden","Hidden","Hidden","Hidden","Hidden",
                        "Hidden","Hidden","Hidden","Hidden","DateTime","Hidden","Hidden","Hidden","DateTime"]
        editWidgetConfig=[{},{"map": ccDict},{},
                          {"IsMultiline":"false","UseHtml":"false"},
                          {"map": {"基本确认":"1","有疑问":"2","已核查":"3"}},
                          {},{},{},{},{},{},{},{},{},
                          {"allow_null":"false","calendar_popup":"true","display_format":"yyyy/M/d HH:mm:ss","field_format":"yyyy/M/d HH:mm:ss","field_iso_format":"false"},
                          {},{},{"allow_null":"false","calendar_popup":"true","display_format":"yyyy/M/d HH:mm:ss","field_format":"yyyy/M/d HH:mm:ss","field_iso_format":"false"},
                          {"allow_null":"false","calendar_popup":"true","display_format":"yyyy/M/d HH:mm:ss","field_format":"yyyy/M/d HH:mm:ss","field_iso_format":"false"}]
        editFormConfig = changelayer.editFormConfig()
        for i in changelayer.attributeList():
            changelayer.setFieldAlias(i,aliases[i])
            changelayer.setDefaultValueDefinition(i,QgsDefaultValue(fieldDefault[i][0],fieldDefault[i][1]))
            changelayer.setEditorWidgetSetup(i,QgsEditorWidgetSetup(editWidgetType[i],editWidgetConfig[i]))
            editFormConfig.setReadOnly(i,fieldReadOnly[i])
            editFormConfig.setReuseLastValue(i,False)

        changelayer.setEditFormConfig(editFormConfig)

    def configChangeParceLayerSymbol(self,changelayer):
        # create from a defaultsymbol:
        symbol = QgsSymbol.defaultSymbol(changelayer.geometryType())
        # Create all style layers
        symL1 = QgsSimpleFillSymbolLayer.create({
            "outline_color": "170,107,12,255",
            "outline_width": "0.26",
            "style": "no"
        })
        symL2 = QgsSimpleLineSymbolLayer .create({
              "dash_pattern_offset":"0.8",
              "draw_inside_polygon":"1",
              "line_color":"243,227,9,255",
              "line_style":"dot",
              "line_width":"0.26",
              "offset":"1.2"
        })
        # Add them
        symbol.changeSymbolLayer(0,symL1)
        symbol.appendSymbolLayer(symL2)
        # Create a renderer with the symbol as first parameter
        renderer = QgsSingleSymbolRenderer(symbol)
        # Define the renderer
        changelayer.setRenderer(renderer)

        label_settings = QgsPalLayerSettings()
        label_settings.fieldName = 'cc'
        text_format = QgsTextFormat()
        text_format.setColor(QtGui.QColor(238,174,174,255))
        label_settings.setFormat(text_format)

        changelayer.setLabeling(QgsVectorLayerSimpleLabeling(label_settings))
        changelayer.setLabelsEnabled(True)

    def configTaskCoverLayerSymbol(self,task_cover_layer):
        # create from a defaultsymbol:
        symbol = QgsSymbol.defaultSymbol(task_cover_layer.geometryType())
        # Create all style layers
        symL1 = QgsSimpleFillSymbolLayer.create({
            "outline_color": "71,138,68,255",
            "outline_width": "0.46",
            "style": "no"
        })
        symL2 = QgsHashedLineSymbolLayer.create({
            "hash_angle":"45",
            "hash_length":"2.4",
            "interval":"2.4",
            "offset":"1.2",
            "place_on_every_part": "true",
            "placements":"Interval",
            "ring_filter":"0",
            "rotate":"1"
        })
        symL2_subSym = QgsLineSymbol.createSimple({
            "line_color":"246,227,14,154",
            "line_style":"solid",
            "line_width":"0.26"
        })
        symL2.setSubSymbol(symL2_subSym)
        # Add them
        symbol.changeSymbolLayer(0,symL1)
        symbol.appendSymbolLayer(symL2)
        # Create a renderer with the symbol as first parameter
        renderer = QgsSingleSymbolRenderer(symbol)
        # Define the renderer
        task_cover_layer.setRenderer(renderer)

    def configTaskBlockLayerSymbol(self, task_block_layer):
        # create from a defaultsymbol:
        symbol = QgsSymbol.defaultSymbol(task_block_layer.geometryType())
        # Create all style layers
        symL1 = QgsSimpleFillSymbolLayer.create({
            "outline_color": "35,35,35,100",
            "outline_width": "0.26",
            "outline_style":"solid",
            "color":"35,35,35,50",
            "style": "solid"
        })
        # Add them
        symbol.changeSymbolLayer(0,symL1)
        # Create a renderer with the symbol as first parameter
        renderer = QgsInvertedPolygonRenderer(QgsSingleSymbolRenderer(symbol))
        # Define the renderer
        task_block_layer.setRenderer(renderer)


    def configTaskGridLayerSymbol(self,taskgrid_layer):
        cats=[]
        # create from a defaultsymbol:
        symbol0 = QgsSymbol.defaultSymbol(taskgrid_layer.geometryType())
        # Create all style layers
        symL0 = QgsSimpleFillSymbolLayer.create({
            "outline_color": "200,200,255,200",
            "outline_width": "0.26",
            "line_style":"dot",
            "style": "no"
        })
        # replace the symbol layer  in the default symbol
        symbol0.changeSymbolLayer(0,symL0)
        cats.append(QgsRendererCategory('',symbol0,'to do'))

        symbol1 = QgsSymbol.defaultSymbol(taskgrid_layer.geometryType())
        # Create all style layers
        symL11 = QgsSimpleLineSymbolLayer .create({
              "dash_pattern_offset":"0.8",
              "draw_inside_polygon":"1",
              "line_color":"243,235,8,170",
              "line_style":"solid",
              "line_width":"0.2",
              "offset":"1"
        })
        symL12 = QgsSimpleFillSymbolLayer.create({
            "outline_color": "200,200,255,200",
            "outline_width": "0.26",
            "style": "no"
        })

        symbol1.changeSymbolLayer(0,symL11)
        symbol1.appendSymbolLayer(symL12)
        cats.append(QgsRendererCategory('1',symbol1,'doing'))

        symbol2 = QgsSymbol.defaultSymbol(taskgrid_layer.geometryType())
        # Create all style layers
        symL2 = QgsSimpleFillSymbolLayer.create({
            "color": "31,158,61,51",
            "outline_width": "0",
            "outline_style":"no",
            "style": "solid"
        })
        # replace the symbol layer  in the default symbol
        symbol2.changeSymbolLayer(0,symL2)
        cats.append(QgsRendererCategory('2',symbol2,'done'))

        renderer = QgsCategorizedSymbolRenderer('status',cats)
        taskgrid_layer.setRenderer(renderer)

    def create_taskgrid(self,taskDb,taskgrid_name,task_block_layer):
        algorithm_id='native:creategrid'
        parameter_dic = {}
        parameter_dic['TYPE']=2
        ext = task_block_layer.extent()
        extstr = str(ext.xMinimum()) + ',' + str(ext.xMaximum()) + ',' + str(ext.yMinimum()) + ',' + str(
            ext.yMaximum()) + '[EPSG:4480]'
        parameter_dic['EXTENT']= extstr
        parameter_dic['HSPACING']= 0.5
        parameter_dic['VSPACING']= 0.5
        parameter_dic['HOVERLAY']= 0
        parameter_dic['VOVERLAY']= 0
        parameter_dic['CRS']= QgsCoordinateReferenceSystem('EPSG:4480')
        parameter_dic['OUTPUT']= 'TEMPORARY_OUTPUT'

        parameter_dic['OUTPUT'] = 'ogr:dbname="'+taskDb+'" table="'+taskgrid_name+'" (geom)'
        res = processing.run(algorithm_id, parameter_dic)

        gridlayer = QgsVectorLayer(res['OUTPUT'],'索引网格')
        gridlayer.startEditing()
        processing.run("native:selectbylocation",
                       {'INPUT': gridlayer, 'PREDICATE': [0], 'INTERSECT': task_block_layer, 'METHOD': 0})
        gridlayer.invertSelection()
        gridlayer.deleteSelectedFeatures()
        gridlayer.deleteAttributes([1,2,3,4,5])
        gridlayer.addAttribute(QgsField("gridno", QVariant.Int))
        gridlayer.addAttribute(QgsField("status", QVariant.Int))
        gridlayer.addAttribute(QgsField("taskarea", QVariant.Double))
        gridlayer.addAttribute(QgsField("updated", QVariant.DateTime,'DATETIME'))
        gridlayer.commitChanges()
        gridlayer.endEditCommand()
        return gridlayer

    def create_empty_taskpackage(self):
        dbfile = os.path.join(self.settings.value("MoniTask/workingdir", ''),
                              self.task_blocks[0]['task_no'].strip() + '.gpkg')
        self.create_taskpackagedb_by_qgis(dbfile)
        return dbfile
    def fill_taskpackage(self,taskDb):
        tasks_details_layer = QgsVectorLayer(taskDb+'|layername=tasks_details','tasks_details')
        caps = tasks_details_layer.dataProvider().capabilities()
        if caps & QgsVectorDataProvider.AddFeatures:
            tasks_details_layer.startEditing()
            for item in self.tasks_details:
                feat = QgsFeature(tasks_details_layer.fields())
                # feat.setAttribute(1, item["born"])
                # feat.setAttribute(2, item["projectid"])
                # feat.setAttribute(3, item["status"])
                # feat.setAttribute(4, item["apply2capture"])
                # feat.setAttribute(5, item["capture_personid"])
                # feat.setAttribute(6, item["capture_plan_date"])
                # feat.setAttribute(7, item["capture_finish_date"])
                # feat.setAttribute(8, item["apply2check"])
                # feat.setAttribute(9, item["check_personid"])
                # feat.setAttribute(10, item["check_plan_date"])
                # feat.setAttribute(11, item["check_finish_date"])
                # feat.setAttribute(12, item["latest_update"])
                # feat.setAttribute(13, item["task_no"])

                feat["born"] = item["born"]
                feat["projectid"] = item["projectid"]
                feat["status"] = item["status"]
                feat["apply2capture"] = item["apply2capture"]
                feat["capture_personid"] = item["capture_personid"]
                feat["capture_plan_date"] = item["capture_plan_date"]
                feat["capture_finish_date"] = item["capture_finish_date"]
                feat["apply2check"] = item["apply2check"]
                feat["check_personid"] = item["check_personid"]
                feat["check_plan_date"] = item["check_plan_date"]
                feat["check_finish_date"] = item["check_finish_date"]
                feat["latest_update"] = item["latest_update"]
                feat["task_no"] = item["task_no"]
                feat.setGeometry(QgsGeometry.fromWkt(item["wkt"]))
#                QtWidgets.QMessageBox.about(self, '信息', item["wkt"])
                (res, outFeats) = tasks_details_layer.dataProvider().addFeatures([feat])
            tasks_details_layer.commitChanges()
#            QtWidgets.QMessageBox.about(self, '信息', str(tasks_details_layer.commitErrors()))
            tasks_details_layer.endEditCommand()

        task_blocks_layer = QgsVectorLayer(taskDb + '|layername=task_blocks', 'task_blocks')
        caps = task_blocks_layer.dataProvider().capabilities()
        if caps & QgsVectorDataProvider.AddFeatures:
            task_blocks_layer.startEditing()
            for item in self.task_blocks:
                feat = QgsFeature(task_blocks_layer.fields())
                # feat.setAttribute(1, item["preimg"])
                # feat.setAttribute(2, item["nextimg"])
                # feat.setAttribute(3, item["preurl"])
                # feat.setAttribute(4, item["nexturl"])
                # feat.setAttribute(5, item["task_no"])

                feat["preimg"] = item["preimg"]
                feat["nextimg"] = item["nextimg"]
                feat["preurl"] = item["preurl"]
                feat["nexturl"] = item["nexturl"]
                feat["task_no"] = item["task_no"]
                feat.setGeometry(QgsGeometry.fromWkt(item["wkt"]))
                (res, outFeats) = task_blocks_layer.dataProvider().addFeatures([feat])
            task_blocks_layer.commitChanges()
            task_blocks_layer.endEditCommand()
#            QtWidgets.QMessageBox.about(self, '信息', str(task_blocks_layer.commitErrors()))

    def applyTask(self):
        #1. update the status of the task in the server database

        #2. create task project in user's working folder
        self.createTaskProject()




    def startTasklistRequest(self, url):
        self.networkmanager = QtNetwork.QNetworkAccessManager()
        request = QtNetwork.QNetworkRequest(url)
        self.reply = self.networkmanager.get(request)
        self.networkmanager.finished.connect(self.showTaskList)

    def getTaskListOnline(self):
        self.listView.setModel(None)
        self.applyTaskBtn.setEnabled(False)
        self.testTaskBtn.setEnabled(False)

        self.taskTable.clearContents()
        self.currentTaskType = self.taskType.currentIndex()
        url=QUrl(self.taskSrvUrlEdit.text()+'tasks_details_wkt?status=eq.'+str(self.currentTaskType))
        self.startTasklistRequest(url)

    def showTaskList(self,reply):
        self.tasks_details = json.loads(str(reply.readAll(),'utf-8'))
#        QtWidgets.QMessageBox.about(self, '信息', str(items))
        textList = list()
        for item in self.tasks_details:
            textList.append(item["task_no"].strip())

        model = QStringListModel()
        model.setStringList(textList)
        self.listView.setModel(model)

    def onTaskSelected(self,selected):
        self.sel_taskno=str(selected.data())
#        QtWidgets.QMessageBox.about(self, '信息',taskno)

        url=QUrl(self.taskSrvUrlEdit.text()+'task_blocks_wkt?task_no=eq.'+self.sel_taskno)

        self.networkmanager = QtNetwork.QNetworkAccessManager()
        request = QtNetwork.QNetworkRequest(url)
        self.reply = self.networkmanager.get(request)
        self.networkmanager.finished.connect(self.showTaskInfo)

        self.applyTaskBtn.setEnabled(self.currentTaskType==0)
        self.testTaskBtn.setEnabled(True)


    def showTaskInfo(self,reply):
        result= str(reply.readAll(),'utf-8')
        self.task_blocks = json.loads(result)

#       QtWidgets.QMessageBox.about(self, '信息', str(items))
        self.taskTable.setRowCount(len(self.task_blocks))
        self.taskTable.setColumnCount(len(self.task_blocks[0]))
        self.taskTable.setHorizontalHeaderLabels(self.task_blocks[0].keys())
        row=0
        for item in self.task_blocks:
            values=item.values()
            col=0
            for value in values:
                self.taskTable.setItem(row,col,QtWidgets.QTableWidgetItem(str(value)))
                col+=1
            row+=1

    def create_taskpackagedb_by_qgis(self,gpkg_path):
        def create_blank_gpkg_layer(gpkg_path: str, layer_name: str, geometry: int,crs: str, schema: QgsFields, append: bool = False) -> bool:
            # To add a layer to an existing GPKG file, pass 'append' as True
            options = QgsVectorFileWriter.SaveVectorOptions()
            options.driverName = "GPKG"
            options.layerName = layer_name
            if append:
                options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer

            writer = QgsVectorFileWriter.create(
                gpkg_path,
                schema,
                geometry,
                QgsCoordinateReferenceSystem(crs),
                QgsCoordinateTransformContext(),
                options)
            del writer
            return True

        # Create layer change_parcels
        crs = 'epsg:4480'
        layer_name = "change_parcels"
        geom = QgsWkbTypes.Polygon
        schema = QgsFields()
        schema.append(QgsField("cc", QVariant.String,'char',8))
        schema.append(QgsField("cn", QVariant.String, 'char',16))
        schema.append(QgsField("feature", QVariant.String, 'char',32))
        schema.append(QgsField("tag", QVariant.Int))
        schema.append(QgsField("used_res", QVariant.Double))
        schema.append(QgsField("used_scale", QVariant.Double))
        schema.append(QgsField("task_no", QVariant.String, 'char',52))
        schema.append(QgsField("preimg", QVariant.String,'char',72))
        schema.append(QgsField("nextimg", QVariant.String, 'char',72))
        schema.append(QgsField("pre_url", QVariant.String, 'char',32))
        schema.append(QgsField("next_url", QVariant.String, 'char',32))
        schema.append(QgsField("capture_person", QVariant.String,'char',8))
        schema.append(QgsField("capture_org", QVariant.String, 'char',32))
        schema.append(QgsField("born", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("check_person", QVariant.String, 'char',8))
        schema.append(QgsField("check_org", QVariant.String, 'char' ,32))
        schema.append(QgsField("checked", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("updated", QVariant.DateTime, 'DATETIME'))
        create_blank_gpkg_layer(gpkg_path, layer_name, geom, crs, schema)

        # Create table tasks_details
        layer_name = "tasks_details"
        geom = QgsWkbTypes.Polygon
        #        geom = QgsWkbTypes.NoGeometry
        #        crs = ''
        schema = QgsFields()
        schema.append(QgsField("born", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("projectid", QVariant.Int))
        schema.append(QgsField("status", QVariant.Int))
        schema.append(QgsField("apply2capture", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("capture_personid", QVariant.Int))
        schema.append(QgsField("capture_plan_date", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("capture_finish_date", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("apply2check", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("check_personid", QVariant.Int))
        schema.append(QgsField("check_plan_date", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("check_finish_date", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("latest_update", QVariant.DateTime, 'DATETIME'))
        schema.append(QgsField("task_no", QVariant.String, 'char', 52))
        create_blank_gpkg_layer(gpkg_path, layer_name, geom, crs, schema, True)

        # Create layer tasks_blocks
        layer_name = "task_blocks"
        geom = QgsWkbTypes.Polygon
        schema = QgsFields()
        schema.append(QgsField("preimg", QVariant.String,'char',72))
        schema.append(QgsField("nextimg", QVariant.String, 'char',72))
        schema.append(QgsField("preurl", QVariant.String, 'char',32))
        schema.append(QgsField("nexturl", QVariant.String, 'char',32))
        schema.append(QgsField("task_no", QVariant.String, 'char',52))
        create_blank_gpkg_layer(gpkg_path, layer_name, geom, crs, schema, True)


    # if Create non-spatial table ,just let geom = QgsWkbTypes.NoGeometry and crs = '', like
    #   layer_name = "xxx"
    #   geom = QgsWkbTypes.NoGeometry
    #   crs = ''

    def samplecode_create_taskpackagedb_by_sqlite3(gpkg_path):
        connection = sqlite3.connect(gpkg_path)
        cursor = connection.cursor()
        cursor.execute('''CREATE TABLE tasks_details(
                            tid bigint NOT NULL,
                            born date,
                            projectid bigint,
                            status smallint,
                            apply2capture date,
                            capture_personid bigint,
                            capture_plan_date date,
                            capture_finish_date date,
                            apply2check date,
                            check_personid bigint,
                            check_plan_date date,
                            check_finish_date date,
                            latest_update date,
                            task_no character varying(52)
                        )''')
        connection.commit()
        cursor.execute('''CREATE TABLE tasks_blocks(
                        bid integer NOT NULL,
                        task_no character varying(52) NOT NULL,
                        preimg character(96),
                        nextimg character(96),
                        preurl character(64),
                        nexturl character(64),
                        geom Polygon
                    )''')
        connection.commit()
        cursor.execute('''CREATE TABLE change_parcels(
                        fid integer NOT NULL,
                        cc character(8) NOT NULL,
                        cn character varying(16) NOT NULL,
                        feature character varying(32)  NOT NULL,
                        tag smallint NOT NULL,
                        used_res real NOT NULL DEFAULT '-1',
                        used_scale real NOT NULL DEFAULT '-1',
                        task_no character(52)  NOT NULL,
                        preimg character(72)  NOT NULL,
                        nextimg character(72)  NOT NULL,
                        pre_url character varying(32)  NOT NULL,
                        next_url character varying(32)  NOT NULL,
                        capture_person character varying(8)  NOT NULL,
                        geom Polygon NOT NULL,
                        capture_org character varying(32)  NOT NULL,
                        born date NOT NULL,
                        check_person character varying(8) ,
                        check_org character varying(32) ,
                        checked date,
                        updated date NOT NULL
                    )''')
        connection.commit()
        connection.close()
        return gpkg_path

    def samplecode_create_taskpackagedb_by_ogr(gpkg_path):
        driver = ogr.GetDriverByName('GPKG')
        if os.path.exists(gpkg_path):
            driver.DeleteDataSource(gpkg_path)
        data_source = driver.CreateDataSource(gpkg_path)

        # 创建空间参考 WGS84
        srs = osr.SpatialReference()
        srs.ImportFromEPSG(4480)

        # 创建图层
        layer = data_source.CreateLayer("image_index", srs, ogr.wkbPolygon)
        # 添加字段
        # 下一行不需要，会自动生成fid字段
        # layer.CreateField(ogr.FieldDefn("id", ogr.OFTInteger))

        field_name = ogr.FieldDefn("filename", ogr.OFTString)
        field_name.SetWidth(96)
        layer.CreateField(field_name)

        field_name = ogr.FieldDefn("platform", ogr.OFTString)
        field_name.SetWidth(6)
        layer.CreateField(field_name)
        layer.CreateField(ogr.FieldDefn("imgdate", ogr.OFTDate))

        field_name = ogr.FieldDefn("filesrs", ogr.OFTString)
        field_name.SetWidth(16)
        layer.CreateField(field_name)

        layer.CreateField(ogr.FieldDefn("resolution", ogr.OFTReal))
        layer.CreateField(ogr.FieldDefn("bandnum", ogr.OFTInteger))
        layer.CreateField(ogr.FieldDefn("updated", ogr.OFTDateTime))
        layer.CreateField(ogr.FieldDefn("fromsite_id", ogr.OFTInteger))
        field_name = ogr.FieldDefn("fromsite_ip", ogr.OFTString)
        field_name.SetWidth(15)
        layer.CreateField(field_name)

        data_source.Destroy()
        return gpkg_path

    def samplecode_create_map_theme(self):
        root = QgsProject.instance().layerTreeRoot()

        mapThemesCollection = QgsProject.instance().mapThemeCollection()
        mapThemes = mapThemesCollection.mapThemes()
        # Where you need to set your images names
        # Could be retrieve if only raster names wanted with
        # [layer.name() for layer in QgsProject.instance().mapLayers().values() if isinstance(layer, QgsRasterLayer)]
        # If you want all layers names and filter them manually
        # [layer.name() for layer in QgsProject.instance().mapLayers().values()]
        layersToChanges = ['CartoDB Light', 'OpenStreetMap','OpenTransports']  # Replace with your list of raster layers instead

        for layer in layersToChanges:
            for child in root.children():
                if isinstance(child, QgsLayerTreeGroup):
                    print_log("- group: " + child.name())
                elif isinstance(child, QgsLayerTreeLayer):
                    print_log("- layer: " + child.name() + "  ID: " + child.layerId())
                    # Layer you want to tick
                    if (child.name() == layer):
                        child.setItemVisibilityChecked(True)
                        print_log("Check only once")
                    elif child.name() in layersToChanges:
                        child.setItemVisibilityChecked(False)
                        print_log("Check the others you want to hide")
            mapThemeRecord = QgsMapThemeCollection.createThemeFromCurrentState(
                QgsProject.instance().layerTreeRoot(),
                iface.layerTreeView().model()
                # For QGIS 3.18+, instead of above line, use iface.layerTreeView().layerTreeModel()
            )
            mapThemesCollection.insert(layer, mapThemeRecord)

