# -*- coding: utf-8 -*-

def samplecode_create_taskpackagedb_by_sqlite3(gpkg_path):
    connection = sqlite3.connect(gpkg_path)
    cursor = connection.cursor()
    cursor.execute('''CREATE TABLE tasks_details(
                        tid bigint NOT NULL,
                        born date,
                        projectid bigint,
                        status smallint,
                        apply2capture date,
                        capture_personid bigint,
                        capture_plan_date date,
                        capture_finish_date date,
                        apply2check date,
                        check_personid bigint,
                        check_plan_date date,
                        check_finish_date date,
                        latest_update date,
                        task_no character varying(52)
                    )''')
    connection.commit()
    cursor.execute('''CREATE TABLE tasks_blocks(
                    bid integer NOT NULL,
                    task_no character varying(52) NOT NULL,
                    preimg character(96),
                    nextimg character(96),
                    preurl character(64),
                    nexturl character(64),
                    geom Polygon
                )''')
    connection.commit()
    cursor.execute('''CREATE TABLE change_parcels(
                    fid integer NOT NULL,
                    cc character(8) NOT NULL,
                    cn character varying(16) NOT NULL,
                    feature character varying(32)  NOT NULL,
                    tag smallint NOT NULL,
                    used_res real NOT NULL DEFAULT '-1',
                    used_scale real NOT NULL DEFAULT '-1',
                    task_no character(52)  NOT NULL,
                    preimg character(72)  NOT NULL,
                    nextimg character(72)  NOT NULL,
                    pre_url character varying(32)  NOT NULL,
                    next_url character varying(32)  NOT NULL,
                    capture_person character varying(8)  NOT NULL,
                    geom Polygon NOT NULL,
                    capture_org character varying(32)  NOT NULL,
                    born date NOT NULL,
                    check_person character varying(8) ,
                    check_org character varying(32) ,
                    checked date,
                    updated date NOT NULL
                )''')
    connection.commit()
    connection.close()
    return gpkg_path

def samplecode_create_taskpackagedb_by_ogr(gpkg_path):
    driver = ogr.GetDriverByName('GPKG')
    if os.path.exists(gpkg_path):
        driver.DeleteDataSource(gpkg_path)
    data_source = driver.CreateDataSource(gpkg_path)

    # 创建空间参考 WGS84
    srs = osr.SpatialReference()
    srs.ImportFromEPSG(4480)

    # 创建图层
    layer = data_source.CreateLayer("image_index", srs, ogr.wkbPolygon)
    # 添加字段
    # 下一行不需要，会自动生成fid字段
    # layer.CreateField(ogr.FieldDefn("id", ogr.OFTInteger))

    field_name = ogr.FieldDefn("filename", ogr.OFTString)
    field_name.SetWidth(96)
    layer.CreateField(field_name)

    field_name = ogr.FieldDefn("platform", ogr.OFTString)
    field_name.SetWidth(6)
    layer.CreateField(field_name)
    layer.CreateField(ogr.FieldDefn("imgdate", ogr.OFTDate))

    field_name = ogr.FieldDefn("filesrs", ogr.OFTString)
    field_name.SetWidth(16)
    layer.CreateField(field_name)

    layer.CreateField(ogr.FieldDefn("resolution", ogr.OFTReal))
    layer.CreateField(ogr.FieldDefn("bandnum", ogr.OFTInteger))
    layer.CreateField(ogr.FieldDefn("updated", ogr.OFTDateTime))
    layer.CreateField(ogr.FieldDefn("fromsite_id", ogr.OFTInteger))
    field_name = ogr.FieldDefn("fromsite_ip", ogr.OFTString)
    field_name.SetWidth(15)
    layer.CreateField(field_name)

    data_source.Destroy()
    return gpkg_path

def samplecode_create_map_theme(self):
    root = QgsProject.instance().layerTreeRoot()

    mapThemesCollection = QgsProject.instance().mapThemeCollection()
    mapThemes = mapThemesCollection.mapThemes()
    # Where you need to set your images names
    # Could be retrieve if only raster names wanted with
    # [layer.name() for layer in QgsProject.instance().mapLayers().values() if isinstance(layer, QgsRasterLayer)]
    # If you want all layers names and filter them manually
    # [layer.name() for layer in QgsProject.instance().mapLayers().values()]
    layersToChanges = ['CartoDB Light', 'OpenStreetMap','OpenTransports']  # Replace with your list of raster layers instead

    for layer in layersToChanges:
        for child in root.children():
            if isinstance(child, QgsLayerTreeGroup):
                print_log("- group: " + child.name())
            elif isinstance(child, QgsLayerTreeLayer):
                print_log("- layer: " + child.name() + "  ID: " + child.layerId())
                # Layer you want to tick
                if (child.name() == layer):
                    child.setItemVisibilityChecked(True)
                    print_log("Check only once")
                elif child.name() in layersToChanges:
                    child.setItemVisibilityChecked(False)
                    print_log("Check the others you want to hide")
        mapThemeRecord = QgsMapThemeCollection.createThemeFromCurrentState(
            QgsProject.instance().layerTreeRoot(),
            iface.layerTreeView().model()
            # For QGIS 3.18+, instead of above line, use iface.layerTreeView().layerTreeModel()
        )
        mapThemesCollection.insert(layer, mapThemeRecord)

def samplecode_create_multi_mapviews():
    #通过激活view菜单中的功能创建新的map view（默认为View菜单项下的第一个菜单项）
    iface.viewMenu().actions()[0].trigger()
    #下面的语句通过新建mapview菜单项的objectName获取，结果等效，更可靠
    iface.mainWindow().findChild(QAction,'mActionNewMapCanvas').trigger()
    #QGIS主地图窗口的mapcanvas的objectName为theMapCanvas：
    iface.mapCanvases()[0].objectName()
    # 输出：'theMapCanvas'
    iface.viewMenu().actions()[0].trigger()
    # 新建一个地图窗口，其objectName为Map 1
    iface.mapCanvases()[1].objectName()
    # 输出：'Map 1'
    # 修改对象名称：
    iface.mapCanvases()[1].setObjectName(‘MyMapWindow’)
    # 可以通过对象名称搜索找到目标对象
    Mc = iface.mainWindow().findChild(QWidget, name='MyMapWindow')
    # 修改地图窗口的标题，需要上溯三级才能指向窗口
    iface.mapCanvases()[1].parent().parent().parent().setWindowTitle(‘My
    Map
    Window’)
    # 通过修改mapcanvas的属性，设置不同窗口显示的theme，实现各个窗口的同步等。
    # 关闭或隐藏地图窗口（关闭后还可以打开，窗口并未消除）
    iface.mainWindow().findChild(QWidget, name='pre').parent().parent().parent().show() / hide()
    或close()
    # 如果手动关闭地图窗口，则会物理消除该窗口，再引用就不存在了

def samplecode_listall_QGIS_mainwindowChild_objectNames():
    for item in iface.maiWindow().children():item.objectName()
    #查找一个对象类型不确定（用QObject代替）、对象名称确定对象的方法
    iface.mainWindow().findChild(QObject, 'dbManager').trigger()
    #列出View菜单下Decoration子菜单下的所有菜单项的对象名称
    for action in iface.viewMenu().findChild(QObject, 'mMenuDecorations').actions():
        action.objectName()
    '''#输出如下：
    'mActionDecorationGrid'
    'mActionDecorationScaleBar'
    'mActionDecorationImage'
    'mActionDecorationNorthArrow'
    'mActionDecorationTitle'
    'mActionDecorationCopyright'
    'mActionDecorationLayoutExtent'
    '''
    #获得对象名称后，可以直接全局查找获得该对象的引用
    iface.mainWindow().findChild(QObject,'mActionDecorationGrid',Qt.FindChildrenRecursively).trigger()
    #其中第三个参数可以不填写，默认为Qt.FindChildrenRecursively，即在子孙中递归查找，即：
    iface.mainWindow().findChild(QObject,'mActionDecorationGrid').trigger()


