# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MoniQueDialog
                                 A QGIS plugin
 Monoplotting oblique images.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-02-07
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Sebastian Mikolka-Flöry
        email                : s.floery@gmx.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import open3d as o3d
import numpy as np

from qgis.PyQt import QtWidgets, QtCore, QtGui
from qgis.gui import QgsProjectionSelectionWidget
from qgis.core import (
    Qgis,
    QgsProject,
    QgsVectorLayer,
    QgsFeature,
    QgsField,
    QgsGeometry,
    QgsPointXY,
    QgsVectorFileWriter,
)

from ..terramesh import MeshGrid

class ConvertDialog(QtWidgets.QDialog):
    
    # created_signal = QtCore.pyqtSignal(object)

    def __init__(self, parent=None, icon_dir=None):
        """Constructor."""
        super(ConvertDialog, self).__init__()
        
        self.icon_dir = icon_dir

        self.setWindowTitle("Convert DTM to mesh...")
        self.resize(500, 150)
        self.setMinimumSize(QtCore.QSize(500, 150))
        self.setMaximumSize(QtCore.QSize(500, 150))
        
        main_layout = QtWidgets.QVBoxLayout()
        
        dtm_layout = QtWidgets.QHBoxLayout()
        dtm_label = QtWidgets.QLabel("DTM Path:")
        dtm_label.setMinimumWidth(100)
        self.dtm_line = QtWidgets.QLineEdit()
        self.dtm_line.setEnabled(False)
        self.dtm_btn = QtWidgets.QPushButton()
        self.dtm_btn.setIcon(QtGui.QIcon(os.path.join(self.icon_dir, "mActionFileOpen.png")))
        self.dtm_btn.clicked.connect(self.set_dtm_path)
        
        dtm_layout.addWidget(dtm_label)
        dtm_layout.addWidget(self.dtm_line)
        dtm_layout.addWidget(self.dtm_btn)

        mesh_layout = QtWidgets.QHBoxLayout()
        mesh_label = QtWidgets.QLabel("Mesh Path:")
        mesh_label.setMinimumWidth(100)
        self.mesh_line = QtWidgets.QLineEdit()
        self.mesh_line.setEnabled(False)
        self.mesh_btn = QtWidgets.QPushButton()
        self.mesh_btn.setIcon(QtGui.QIcon(os.path.join(self.icon_dir, "mActionFileOpen.png")))
        self.mesh_btn.clicked.connect(self.set_mesh_path)

        mesh_layout.addWidget(mesh_label)
        mesh_layout.addWidget(self.mesh_line)
        mesh_layout.addWidget(self.mesh_btn)
        
        error_layout = QtWidgets.QHBoxLayout()
        error_label = QtWidgets.QLabel("Maximum error [m]:")
        error_label.setToolTip('Maximum difference in meters between inital DTM and simplified mesh. 1 m is a good tradeoff between performance and accuracy.')
        error_label.setMinimumWidth(100)
        self.error_line = QtWidgets.QLineEdit()
        self.error_line.setEnabled(True)
        self.error_line.setText("1")
        
        line_validator = QtGui.QDoubleValidator()
        line_validator.setRange(0, 100, 2)
        self.error_line.setValidator(line_validator)
        
        error_layout.addWidget(error_label)
        error_layout.addWidget(self.error_line)
        
        btn_layout = QtWidgets.QHBoxLayout()
        self.pbar_label = QtWidgets.QLabel("")
        self.pbar_label.setMinimumWidth(250)
        self.convert_btn = QtWidgets.QPushButton("Convert")
        self.convert_btn.setEnabled(False)
        self.convert_btn.clicked.connect(self.convert_dtm)
        
        # btn_layout.addStretch(1)
        btn_layout.addWidget(self.pbar_label)
        btn_layout.addStretch(1)
        btn_layout.addWidget(self.convert_btn)
        
        self.pbar = QtWidgets.QProgressBar()
        self.pbar.setMaximum(10)
        
        main_layout.addLayout(dtm_layout)
        main_layout.addLayout(mesh_layout)
        main_layout.addLayout(error_layout)
        main_layout.addLayout(btn_layout)
        main_layout.addWidget(self.pbar)
        main_layout.addStretch(1)
        self.setLayout(main_layout)
    
    def set_dtm_path(self):
        dtm_path = QtWidgets.QFileDialog.getOpenFileName(None, "DTM path", "", ("DTM (*.tif)"))[0]
        if dtm_path:
            self.dtm_line.setText(dtm_path)

            if self.mesh_line.text() is not "":
                self.convert_btn.setEnabled(True)
                
    def set_mesh_path(self):
        mesh_path = QtWidgets.QFileDialog.getSaveFileName(None, "Open mesh", "", ("Mesh (*.ply)"))[0]   
        if mesh_path:
            self.mesh_line.setText(mesh_path)

            if  self.dtm_line.text() is not "":
                self.convert_btn.setEnabled(True)

    def convert_dtm(self):
        
        dtm_path = self.dtm_line.text()
        mesh_path = self.mesh_line.text()
        max_error = float(self.error_line.text())
        
        QtWidgets.QApplication.setOverrideCursor(QtCore.Qt.WaitCursor)
        
        #TODO updates of text not properly working; processing might need to be transferred
        #TODO to individual QThread; appaers to be blocking updates
        self.pbar_label.setText("Reading %s..." % (dtm_path))
        self.pbar.setValue(1)
        
        self.pbar_label.setText("Simplifying tiles...")
        tile_grid = MeshGrid(path=dtm_path, tile_size=512, max_error=max_error)
        self.pbar.setValue(4)
        
        self.pbar_label.setText("Snapping boundary vertices...")
        tile_grid.snap_boundaries()
        self.pbar.setValue(7)
        
        self.pbar_label.setText("Merging tiles...")
        tile_grid.merge_tiles(opath=mesh_path)
        self.pbar.setValue(10)
        
        self.pbar_label.setText("Saved mesh to %s." % (mesh_path))
        QtWidgets.QApplication.restoreOverrideCursor()

    # def set_crs(self):
    #     if (self.gpkg_line.text() is not "") & (self.mesh_line.text() is not "") & (self.crs_widget.crs().isValid()):
    #         self.create_btn.setEnabled(True)
    
    # def create_project(self):
    #     gpkg_path = self.gpkg_line.text()
    #     mesh_path = self.mesh_line.text()
    #     crs = self.crs_widget.crs().authid()
        
    #     QtWidgets.QApplication.instance().setOverrideCursor(QtCore.Qt.WaitCursor)
    #     transform_context = QgsProject.instance().transformContext() #necessary for writing
                
    #     mesh = o3d.io.read_triangle_mesh(mesh_path)
        
    #     verts = np.asarray(mesh.vertices)
        
    #     nr_verts = int(verts.shape[0])
    #     nr_faces = int(np.asarray(mesh.triangles).shape[0])
        
    #     minx, miny, minz = np.min(verts, axis=0)
    #     maxx, maxy, maxz = np.max(verts, axis=0)

    #     mesh_bbox = [QgsPointXY(minx, maxy),
    #                  QgsPointXY(maxx, maxy),
    #                  QgsPointXY(maxx, miny),
    #                  QgsPointXY(minx, miny),
    #                  QgsPointXY(minx, maxy)]
            
    #     reg_lyr = QgsVectorLayer("Polygon?crs=%s" % (crs), "region", "memory")
    #     pr = reg_lyr.dataProvider()
    #     pr.addAttributes([QgsField("name", QtCore.QVariant.String), 
    #                       QgsField("path", QtCore.QVariant.String),
    #                       QgsField("op_path", QtCore.QVariant.String), 
    #                       QgsField("nr_verts", QtCore.QVariant.Int), 
    #                       QgsField("nr_faces", QtCore.QVariant.Int), 
    #                       QgsField("minx", QtCore.QVariant.Double, "double", 10, 3), 
    #                       QgsField("miny", QtCore.QVariant.Double, "double", 10, 3),
    #                       QgsField("minz", QtCore.QVariant.Double, "double", 10, 3),
    #                       QgsField("maxx", QtCore.QVariant.Double, "double", 10, 3), 
    #                       QgsField("maxy", QtCore.QVariant.Double, "double", 10, 3),
    #                       QgsField("maxz", QtCore.QVariant.Double, "double", 10, 3)])
    #     reg_lyr.updateFields() 
            
    #     # add a feature
    #     feat = QgsFeature()
    #     feat.setGeometry(QgsGeometry.fromPolygonXY([mesh_bbox]))
    #     feat.setAttributes([os.path.basename(mesh_path), 
    #                         mesh_path,
    #                         "",
    #                         nr_verts,
    #                         nr_faces, 
    #                         float(minx), 
    #                         float(miny), 
    #                         float(minz), 
    #                         float(maxx),
    #                         float(maxy),
    #                         float(maxz)])
    #     pr.addFeatures([feat])

    #     # update layer's extent when new features have been added
    #     # because change of extent in provider is not propagated to the layer
    #     reg_lyr.updateExtents()
        
    #     #write region layer to geopackage
    #     lyr_options = QgsVectorFileWriter.SaveVectorOptions()
    #     lyr_options.layerName = reg_lyr.name()
    #     lyr_options.driverName = "GPKG"
        
    #     if hasattr(QgsVectorFileWriter, 'writeAsVectorFormatV3'): #for QGIS Version >3.20
    #         use_v3 = True
    #         _writer = QgsVectorFileWriter.writeAsVectorFormatV3(reg_lyr, gpkg_path, transform_context, lyr_options)
    #     elif hasattr(QgsVectorFileWriter, 'writeAsVectorFormatV2'): #for QGIS Version <3.20
    #         use_v3 = False
    #         _writer = QgsVectorFileWriter.writeAsVectorFormatV2(reg_lyr, gpkg_path, transform_context, lyr_options)
            
    #     if _writer[0] == QgsVectorFileWriter.NoError:
    #         pass
    #     else:
    #         self.msg_bar.pushMessage("Error", "Could not create project.", level=Qgis.Critical, duration=3)
    #         raise ValueError("Could not create project!")
                            
    #     #create additionally needed layers and add them to the geopackage as well
    #     cam_lyr = QgsVectorLayer("Point?crs=%s" % (crs), "cameras", "memory")
    #     cam_pr = cam_lyr.dataProvider()
    #     cam_pr.addAttributes([QgsField("iid", QtCore.QVariant.String),
    #                           QgsField("path", QtCore.QVariant.String),
    #                           QgsField("ext", QtCore.QVariant.String),
    #                           QgsField("is_oriented", QtCore.QVariant.Int),
    #                           QgsField("obj_x0", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_y0", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_z0", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_x0_std", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_y0_std", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_z0_std", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("alpha", QtCore.QVariant.Double, "double", 10, 5),
    #                           QgsField("zeta", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("kappa", QtCore.QVariant.Double, "double", 10, 5),
    #                           QgsField("alpha_std", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("zeta_std", QtCore.QVariant.Double, "double", 10, 5),
    #                           QgsField("kappa_std", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("s0", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("img_x0", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("img_y0", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("f", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("f_std", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("img_w", QtCore.QVariant.Int),
    #                           QgsField("img_h", QtCore.QVariant.Int),
    #                           QgsField("hfov", QtCore.QVariant.Double, "double", 6, 3),
    #                           QgsField("vfov", QtCore.QVariant.Double, "double", 6, 3)])
    #     cam_lyr.updateFields() 
                
    #     gcps_lyr = QgsVectorLayer("Point?crs=%s" % (crs), "gcps", "memory")
    #     gcps_pr = gcps_lyr.dataProvider()
    #     gcps_pr.addAttributes([QgsField("iid", QtCore.QVariant.String),
    #                           QgsField("gid", QtCore.QVariant.String),
    #                           QgsField("desc", QtCore.QVariant.String),
    #                           QgsField("obj_x", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_y", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_z", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_x_std", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_y_std", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("obj_z_std", QtCore.QVariant.Double, "double", 10, 3),
    #                           QgsField("active", QtCore.QVariant.String)])
    #     gcps_lyr.updateFields() 
        
    #     gcps_img_lyr = QgsVectorLayer("Point?crs=%s" % (crs), "gcps_img", "memory")
    #     gcps_img_pr = gcps_img_lyr.dataProvider()
    #     gcps_img_pr.addAttributes([QgsField("iid", QtCore.QVariant.String),
    #                           QgsField("gid", QtCore.QVariant.String),
    #                           QgsField("desc", QtCore.QVariant.String),
    #                           QgsField("img_x", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("img_y", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("img_dx", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("img_dy", QtCore.QVariant.Double, "double", 10, 1),
    #                           QgsField("active", QtCore.QVariant.String)])
    #     gcps_img_lyr.updateFields()
        
    #     # cam_hfov_lyr = QgsVectorLayer("Polygon?crs=%s" % (crs), "cameras_hfov", "memory")
    #     # cam_hfov_pr = cam_hfov_lyr.dataProvider()
    #     # cam_hfov_pr.addAttributes([QgsField("iid", QtCore.QVariant.String),
    #     #                            QgsField("is_oriented", QtCore.QVariant.Int),
    #     #                             QgsField("path", QtCore.QVariant.String),
    #     #                             QgsField("ext", QtCore.QVariant.String),
    #     #                             QgsField("w", QtCore.QVariant.Int),
    #     #                             QgsField("h", QtCore.QVariant.Int),
    #     #                             QgsField("hfov", QtCore.QVariant.Double, "double", 6, 3),
    #     #                             QgsField("vfov", QtCore.QVariant.Double, "double", 6, 3)])
    #     # cam_hfov_lyr.updateFields() 
        
    #     map_line_lyr = QgsVectorLayer("LineString?crs=%s" % (crs), "lines", "memory")
    #     map_line_pr = map_line_lyr.dataProvider()
    #     map_line_pr.addAttributes([QgsField("iid", QtCore.QVariant.String), 
    #                                QgsField("type", QtCore.QVariant.String), 
    #                                QgsField("comment", QtCore.QVariant.String)]);
    #     map_line_lyr.updateFields() 
        
    #     map_line_pnts_lyr = QgsVectorLayer("Point?crs=%s" % (crs), "lines_vx", "memory")
        
    #     img_line_lyr = QgsVectorLayer("LineString", "lines_img", "memory")
    #     img_line_pr = img_line_lyr.dataProvider()
    #     img_line_pr.addAttributes([QgsField("iid", QtCore.QVariant.String), 
    #                                QgsField("type", QtCore.QVariant.String), 
    #                                QgsField("comment", QtCore.QVariant.String)]);
    #     img_line_lyr.updateFields() 
        
    #     img_line_pnts_lyr = QgsVectorLayer("Point", "lines_img_vx", "memory")
        
    #     lyrs = [map_line_lyr, cam_lyr, map_line_pnts_lyr, img_line_lyr, img_line_pnts_lyr, gcps_lyr, gcps_img_lyr]              
        
    #     for lyr in lyrs:
    #         options = QgsVectorFileWriter.SaveVectorOptions()
    #         options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer    
    #         options.layerName = lyr.name()
    #         options.driverName = "GPKG"
            
    #         if use_v3: #QGIS < 3.20
    #             _writer = QgsVectorFileWriter.writeAsVectorFormatV3(lyr, gpkg_path, transform_context, options)
    #         else:
    #             _writer = QgsVectorFileWriter.writeAsVectorFormatV2(lyr, gpkg_path, transform_context, options)
            
    #         if _writer[0] == QgsVectorFileWriter.NoError:
    #             pass
    #         else:
    #             #! does not work; no message bar in the create dialog; necessary to send signal to main_dialog
    #             #! with error message as parameter
    #             # self.msg_bar.pushMessage("Error", "Could not create project.", level=Qgis.Critical, duration=3)
    #             # raise ValueError("Could not create project!")
    #             pass
        
    #     QtWidgets.QApplication.instance().restoreOverrideCursor()

    #     self.created_signal.emit({"gpkg_path":gpkg_path})
    #     self.close()