# -*- coding: utf-8 -*-
"""
/***************************************************************************
 mon_parcellairep_dockwidget
                                 A QGIS plugin
 Manage your parcels
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-02-12
        git sha              : $Format:%H$
        copyright            : (C) 2020 by jhemmi.eu
        email                : jean@jhemmi.eu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from .initialisation_var_exception import *
from .terroir_consolidateur import *
#from .mes_rangs_centipede import ( chercherDernierPosCentipede, creerTamponsParcelles, filtreQualitesCentipede,  \
#    projectionPourJointureSpatiale, choisirGeoJSONsInterieurExterieur, creerPointsLignesBrises) 

from qgis.core import ( 
   QgsSettings, QgsProject, QgsVectorLayer, QgsVectorLayerJoinInfo, QgsLayerTreeGroup,QgsCoordinateReferenceSystem, \
   QgsProcessingFeatureSourceDefinition, QgsFeatureRequest)
  #QgsApplication, QgsWkbTypes, QgsVectorFileWriter, QgsFeature, QgsFields, QgsField,

from qgis.PyQt.QtCore import ( Qt, QUrl, pyqtSignal) #, QFileInfo)
from qgis.PyQt.QtGui import ( QDesktopServices)
from qgis.PyQt.QtWidgets import ( QDialogButtonBox, QFileDialog, QSizePolicy) # QGridLayout QDialog 
from qgis.PyQt import ( QtWidgets, uic) # QtGui
from qgis.gui import ( QgsMessageBar)

try:
    import processing
    if MonParcellaire_TRACE=="YES": dir( processing)
    from processing import ( QgsProcessingException) # algorithmHelp
    if MonParcellaire_TRACE=="YES": 
        print("Processing : {0} ".format( dir( QgsProcessingException.__traceback__)))
except:
    erreurImport("Processing")
    
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'mon_parcellaire_dockwidget_base.ui'))
    
""" TRAITEMENTS ou PROCESSING"""
def traitementSelectionnerVignes(source, champ_selection = 'code_culture', libelle='VRC'):
    """ Selection dans Mes Parcelles"""
    algo_name, algo_simplifie ="qgis:selectbyattribute",  "Filtrer vignes..."
    resultat_selection = processing.run(algo_name, 
        {'INPUT': source, 'FIELD': champ_selection, 'OPERATOR':0,'VALUE':libelle,'METHOD':0})
    if resultat_selection == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    monPrint( "Sélection dans {0}".format( resultat_selection))

def traitementSauverEcraser(source, sortie):
    """ Sauver en ecrasant fichier"""
    algo_name, algo_simplifie ="native:savefeatures",  "Sauver vignes..."
    result = processing.run(algo_name, 
        {'INPUT': source , 'OUTPUT': sortie,'LAYER_NAME':'', \
		 'DATASOURCE_OPTIONS':'', 'LAYER_OPTIONS':'','ACTION_ON_EXISTING_FILE':0})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    monPrint( "Sauver en {0}".format( result))
    return result

def traitementSauverGPKGEcraserCouche(source, sortie_gpkg, couche):
    """ Sauver en ecrasant couche uniquement"""
    algo_name, algo_simplifie ="native:savefeatures",  "Sauver couche des vignes..."
    result = processing.run(algo_name, 
        {'INPUT': source , 'OUTPUT': sortie_gpkg,'LAYER_NAME':couche, \
			'DATASOURCE_OPTIONS':'','LAYER_OPTIONS':'','ACTION_ON_EXISTING_FILE':1})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    monPrint( "Sauver en {0}".format( result))
    return result

def traitementGarderChamps(source, sortie, \
	ne_pas_detruire = [ "code_culture", "surf_parcelle", \
			"nom_parcelle", "raisonsociale"]):
    """ Champs à conserver de "Mes Parcelles à conserver"""
    algo_name, algo_simplifie ="native:retainfields",  "Garder champs utiles"
    result = processing.run(algo_name, 
        {'INPUT': source , 'OUTPUT': sortie, \
		'FIELDS':ne_pas_detruire})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    return result

def traitementCalculerAffectationSimplifiee(source, sortie):
    algo_name, algo_simplifie ="native:fieldcalculator",  "Calculer affectation simplifiée..."
    result = processing.run(algo_name, 
        {'INPUT': source , 'OUTPUT': sortie, \
	 	 'FIELD_NAME':'Affectation simplifiee','FIELD_TYPE':2,'FIELD_LENGTH':5,'FIELD_PRECISION':0,
		 'FORMULA':' left(  "Code validation" ,3)'})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    return result

def traitementCalculerSuperficie(source, sortie, champ_superficie='superficie'):
    algo_name, algo_simplifie ="native:fieldcalculator",  "Calculer superficie..."
    if (champ_superficie == 'surface_ut_dans_parcelle'):
        CHEMIN=os.path.dirname( sortie)
        CIBLE=os.path.basename( sortie)
        la_sortie = os.path.join(CHEMIN, 'TMP_'+CIBLE)
    else:
        la_sortie = sortie
    result = processing.run(algo_name, 
        {'INPUT': source , 'OUTPUT': la_sortie, \
	 	'FIELD_NAME':champ_superficie,'FIELD_TYPE':1,'FIELD_LENGTH':10,'FIELD_PRECISION':0,\
		'FORMULA':'to_int( $area)'})
    if (champ_superficie == 'surface_ut_dans_parcelle'):
        result = processing.run(algo_name, 
         {'INPUT': la_sortie , 'OUTPUT': sortie, \
			 'FIELD_NAME':'pourcent_ut_dans_parcelle','FIELD_TYPE':1,'FIELD_LENGTH':10,'FIELD_PRECISION':0,\
			 'FORMULA':'"surface_ut_dans_parcelle"/"superficie"*100'})

    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    return result

def traitementIntersection(source, intersection, sortie):
    algo_name, algo_simplifie ="native:intersection",  "Intersecter terroir par parcelles..."
    result = processing.run(algo_name, 
        {'INPUT': source , 'OVERLAY': intersection,'OUTPUT': sortie, \
			'INPUT_FIELDS':[],'OVERLAY_FIELDS':[],'OVERLAY_FIELDS_PREFIX':''})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    return result

def traitementDupliquer_nom_parcelle(source, sortie):
    algo_name, algo_simplifie ="native:fieldcalculator",  "Dupliquer nom_parcelles..."
    result = processing.run(algo_name, 
        {'INPUT': source , 'OUTPUT': sortie, \
			'FIELD_NAME':MonParcellaireNomAttribut,'FIELD_TYPE':2,'FIELD_LENGTH':25,'FIELD_PRECISION':0,
			'FORMULA':' "nom_parcelle" '})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    return result

def traitementExempleCalculerChamp(source, sortie):
    algo_name, algo_simplifie ="native:fieldcalculator",  "Calculer affectation simplifiée..."
    result = processing.run(algo_name, 
        {'INPUT': source , 'OUTPUT': sortie, \
	 	 'FIELD_NAME':'orientation','FIELD_TYPE':1,'FIELD_LENGTH':5,'FIELD_PRECISION':0,
		 'FORMULA':' 360-"orientatio"'})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreurTraitement(algo_name)
    return result

def traitementJointureOrientation(source, jointure, sortie, libelle=""):
    algo_name,  algo_simplifie ="qgis:joinattributesbylocation",  "Jointure par localisation ..."

    result = processing.run(algo_name, 
        {'INPUT': source, 'JOIN':jointure, 'PREDICATE':[1],
		 'JOIN_FIELDS':['orientation'],'METHOD':1,'DISCARD_NONMATCHING':False,
		 'PREFIX':'', 'OUTPUT': sortie})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreur_traitement(algo_name)
    return result

def traitementJointureAttributs(source, jointure, sortie, non_terroir, libelle=""):
    algo_name,  algo_simplifie ="native:joinattributestable",  "Jointure de tous les attributs ..."
    result = processing.run(algo_name, 
        {'INPUT': source, 'FIELD':'nom', 'INPUT_2':jointure, 'FIELD_2':'nom', 'FIELDS_TO_COPY':[], \
        'METHOD':1,'DISCARD_NONMATCHING':False,'PREFIX':'', \
		 'NON_MATCHING':non_terroir,'OUTPUT': sortie})
    if result == None:
        monPrint( "Erreur bloquante durant processing {0}".format( algo_simplifie), T_ERR)
        erreur_traitement(algo_name)
    return result

def quel_chemin_synchro( REPERTOIRE_base, REP_suite):
    CHEMIN_base = os.path.join( REPERTOIRE_base, REP_suite)   
    if not os.path.isdir( CHEMIN_base):
        os.mkdir(CHEMIN_base)
    dateMaintenant = datetime.now()
    dateFormatee=dateMaintenant.strftime("%Y%m%d%H%M")
    CHEMIN_COMPLET = os.path.join( CHEMIN_base, REP_suite+SEP_U+dateFormatee)
    if not os.path.isdir( CHEMIN_COMPLET):
        os.mkdir(CHEMIN_COMPLET)
    return CHEMIN_COMPLET

def dump_df( df, NOM="un_df", lignes=3):
    #my_print("{2} Type de {0} {1}".format (NOM, type(df),  E_PANDAS),"Info-entete")
    print("{1} Nom de {0}".format ( df.__class__.__name__,  E_PANDAS),"Info-entete")
    #my_print("{0} a pour index {1}".format( NOM, df.index))
    print("{0} a pour shape {1}".format( NOM, df.shape))
    print("{0} {1} a pour colums {2}".format( E_PANDAS, NOM, df.columns))
    #Tester le type
    if isinstance( df, pd.DataFrame):
        print("{0} {1} a pour {3} premieres valeurs {2}".format( E_PANDAS, NOM, df.head( lignes),  lignes), "Info-pied")
    else:
        min_lignes=min( lignes,  len(df))
        print("{0} a pour {2} premieres valeurs {1}".format( NOM, df[0:min_lignes], min_lignes), "Info-pied")
    return

class MonParcellaireDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(MonParcellaireDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        # Barre de comm
        self.bar = QgsMessageBar()
        self.bar.setSizePolicy( QSizePolicy.Minimum, QSizePolicy.Fixed )

        self.plugin_dir = os.path.dirname(__file__) 
        
        #print( "** Démarrage de MonParcellaire {0}".format(APPLI_VERSION))
        CHOIX_TOUT_VOIR, CHOIX_MES_PARCELLES, NOM_CSV_MES_PARCELLES, CHOIX_ORIENTATION, NOM_ORIENTATION, \
		    CHOIX_SUITE, CHOIX_JOINTURE, \
		    REPERTOIRE_GPKG, FREQUENCE_SAUVEGARDE, \
            ATTRIBUT_JOINTURE, LISTE_ATTRIBUTS_A_JOINDRE, \
		    LISTE_NOMS_IMPRIMABLES, LISTE_NOMS_IMPRIMES, DERNIER_ATLAS_CHOISI = self.lireSettings()
        # Slot boutons 
        self.Prepare_buttonBox.button( QDialogButtonBox.Ok ).pressed.connect(self.slotTraiterRepertoireGPKGJointure)
        self.Prepare_buttonBox.button( QDialogButtonBox.Save ).pressed.connect(self.ecrireSettings)
        self.TestButton.pressed.connect(self.traiterCentipedePos)
        # pour test: self.SuiteButton.pressed.connect(self.affecterVignesSuites)
        self.TerroirButton.pressed.connect(self.consoliderTerroir)
        self.ImprimerSelectionButton.pressed.connect(self.imprimerSelection)
        self.ImprimerTousButton.pressed.connect(self.imprimerTous)
        # Slot toolbouton 
        self.Repertoire_toolButton.pressed.connect( self.slotLectureRepertoireGPKG)
        self.Jointure_checkBox.stateChanged.connect( self.slotBasculeJointure)
        self.Mes_Parcelles_toolButton.pressed.connect( self.slotLectureMesParcelles)
        self.Mes_Parcelles_checkBox.stateChanged.connect( self.slotBasculeMesParcelles)

        # Cas des combo
        self.initialiserCombo( self.FrequenceSauvegarde_comboBox, LISTE_FREQUENCE_SAUVEGARDE, FREQUENCE_SAUVEGARDE,  "des fréquences de sauvegarde")
        CHEMIN_JOINTURE = None
        if CHOIX_JOINTURE == "YES":
            # Déterminer le nom de la jointure
            CHEMIN_JOINTURE = self.rechercherExtensionEncodage( REPERTOIRE_GPKG)
        if CHEMIN_JOINTURE != None:
            nomColonnes, nomColonnesUniques = self.lireAttributsJointure( CHEMIN_JOINTURE)
        else:
            nomColonnes=['Pas de jointure']
            nomColonnesUniques=['Pas de jointure']
        # Attributs pour la joindre
        self.initialiserCombo( self.AttributJointure_comboBox, nomColonnesUniques, ATTRIBUT_JOINTURE, "des attributs disponibles pour jointure")
        # Liste AttributsAJoindre
        self.initialiserListeMultiple( self.AttributsAJoindre_listWidget, nomColonnes, LISTE_ATTRIBUTS_A_JOINDRE,  "des attributs à joindre")
        # Cas où jointure est attendu mais n'existe pas (ou plus)
        if CHOIX_JOINTURE == "YES" and CHEMIN_JOINTURE == None:
            self.Jointure_checkBox.setChecked( Qt.Unchecked)
            CHOIX_JOINTURE == "NO"
        else:
            self.Jointure_checkBox.setChecked( Qt.Checked)
        self.slotBasculeJointure

        # Les noms imprimables dans NomsImprimables_listWidget
        self.initialiserListeMultiple( self.NomsImprimables_listWidget, LISTE_NOMS_IMPRIMABLES, LISTE_NOMS_IMPRIMES, "de noms imprimables")
        self.NomsImprimables_listWidget.setEnabled( True)
        self.label_AttributsAImprimer.setEnabled( True)
        # Appel à aide ou contrib
        self.Aide_bouton.pressed.connect(self.slotDemanderAide)
        self.Contribuer_bouton.pressed.connect(self.slotDemanderContribution)
        
        project = QgsProject.instance()                                  
        manager = project.layoutManager()
        malayouts_list = manager.printLayouts()
        LISTE_ATLAS=[]
        for layout in malayouts_list:
            un_atlas=layout.atlas()
            if un_atlas.enabled():
                LISTE_ATLAS.append( layout.name())
        if LISTE_ATLAS == []:
            LISTE_ATLAS=["Aucun atlas disponible"]
        self.initialiserCombo( self.Atlas_comboBox, LISTE_ATLAS, DERNIER_ATLAS_CHOISI, "des atlas disponibles dans le projet")
        self.ecrireSettings()
        return

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()
        return

    def slotDemanderContribution( self):
        """ Pointer vers page paiement pour QGIS""" 
        help_url = QUrl("https://qgis.org/funding/donate/")
        QDesktopServices.openUrl(help_url)
        return

    def slotDemanderAide(self):
        """ Help html qui pointe vers gitHub""" 
        help_url = QUrl("https://github.com/jhemmi/MonParcellaire/wiki")
        QDesktopServices.openUrl(help_url)
        return

    def ecrireSettings(self):
        """On écrit dans settings les saisies"""
        s = QgsSettings( APPLI_NOM)
        choixToutVoir = "YES" #if self.Voir_checkBox.isChecked() else "NO"
        s.setValue("MonParcellaire/Tout_voir", choixToutVoir)
        s.setValue("MonParcellaire/repertoireGPKG", self.Repertoire_lineEdit.text())
        s.setValue("MonParcellaire/FrequenceSauvegarde", self.FrequenceSauvegarde_comboBox.currentText())
        choixMesParcelles= "YES" if self.Mes_Parcelles_checkBox.isChecked() else "NO"
        s.setValue("MonParcellaire/ImportMesParcelles", choixMesParcelles)
        s.setValue("MonParcellaire/nomMesParcelles", self.Mes_Parcelles_lineEdit.text())
        choixOrientation= "YES" if self.Orientation_checkBox.isChecked() else "NO"
        s.setValue("MonParcellaire/Orientation", choixOrientation)
        choixSuite= "YES" if self.Suite_checkBox.isChecked() else "NO"
        s.setValue("MonParcellaire/VigneSuite", choixSuite)
        s.setValue("MonParcellaire/nomOrientation",  "modele parcelles orientées")
        choixJointure = "YES" if self.Jointure_checkBox.isChecked() else "NO"
        s.setValue("MonParcellaire/PresenceJointure", choixJointure)
        s.setValue("MonParcellaire/AttributJointure", self.AttributJointure_comboBox.currentText())
        s.setValue("MonParcellaire/AtlasChoisi", self.Atlas_comboBox.currentText())
        # Multivalues
        items=self.AttributsAJoindre_listWidget.selectedItems()
        listeAJoindre = ""
        for item in range(len(items)):
            nomItem=str(self.AttributsAJoindre_listWidget.selectedItems()[item].text())
            if nomItem != MonParcellaireNomAttribut:
                if item == 0:
                    listeAJoindre=nomItem
                else:
                    listeAJoindre=listeAJoindre + SEP_CONFIG + nomItem
        s.setValue("MonParcellaire/AttributsAJoindre", listeAJoindre)
        # Liste noms imprimables
        items=self.NomsImprimables_listWidget.selectedItems()
        listeNoms_imprimes = ""
        for item in range(len(items)):
            nomItem=str(self.NomsImprimables_listWidget.selectedItems()[item].text())
            if item == 0:
                listeNoms_imprimes=nomItem
            else:
                listeNoms_imprimes=listeNoms_imprimes + SEP_CONFIG + nomItem
        s.setValue("MonParcellaire/NomsImprimes", listeNoms_imprimes)

        #monPrint( "Settings sauvegardées")
        return

    def lireSettings( self):
        s = QgsSettings( APPLI_NOM)
        CHOIX_TOUT_VOIR = s.value("MonParcellaire/Tout_voir", "NO")
        CHOIX_MES_PARCELLES = s.value("MonParcellaire/ImportMesParcelles", "NO")
        self.Mes_Parcelles_checkBox.setChecked( Qt.Checked) if CHOIX_MES_PARCELLES == "YES" else self.Mes_Parcelles_checkBox.setChecked( Qt.Unchecked)
        NOM_CSV_MES_PARCELLES = s.value("MonParcellaire/nomMesParcelles", "Export geometries parcelles2025_Fronton.csv")
        self.Mes_Parcelles_lineEdit.setText( NOM_CSV_MES_PARCELLES )
        CHOIX_ORIENTATION = s.value("MonParcellaire/Orientation", "NO")
        self.Orientation_checkBox.setChecked( Qt.Checked) if CHOIX_ORIENTATION == "YES" else self.Orientation_checkBox.setChecked( Qt.Unchecked)
        NOM_ORIENTATION = s.value("MonParcellaire/nomOrientation", "modele parcelles orientées")
        self.Orientation_lineEdit.setText( NOM_ORIENTATION )
        CHOIX_SUITE = s.value("MonParcellaire/VigneSuite", "NO")
        self.Suite_checkBox.setChecked( Qt.Checked) if CHOIX_SUITE == "YES" else self.Suite_checkBox.setChecked( Qt.Unchecked)
        CHOIX_JOINTURE = s.value("MonParcellaire/PresenceJointure", "NO")
        self.Jointure_checkBox.setChecked( Qt.Checked) if CHOIX_JOINTURE == "YES" else self.Jointure_checkBox.setChecked( Qt.Unchecked)
        referentiel_plugin=os.path.join( self.plugin_dir, "data")
        REPERTOIRE_GPKG = s.value( "MonParcellaire/repertoireGPKG", referentiel_plugin)
        if not os.path.isdir( REPERTOIRE_GPKG): # n'existe plus
            monPrint( "Répertoire {0} n'existant plus, retour au choix du référentiel du plugin {1}".\
                format( REPERTOIRE_GPKG, referentiel_plugin), T_WAR)
            REPERTOIRE_GPKG = referentiel_plugin
        self.Repertoire_lineEdit.setText( REPERTOIRE_GPKG )
        FREQUENCE_SAUVEGARDE = s.value("MonParcellaire/FrequenceSauvegarde", LISTE_FREQUENCE_SAUVEGARDE[0])
        ATTRIBUT_JOINTURE = s.value("MonParcellaire/AttributJointure", "Pas de jointure")
        PreparelisteAttributAJoindre = s.value("MonParcellaire/AttributsAJoindre", "Pas de jointure")
        LISTE_ATTRIBUTS_A_JOINDRE=PreparelisteAttributAJoindre.split( SEP_CONFIG)
        #monPrint( "Settings lus jointure {} pour attributs {}".format( CHOIX_JOINTURE, LISTE_ATTRIBUTS_A_JOINDRE))
        # Noms imprimables dans une liste de noms exporter en csv ou bien TODO: dans la couche Emprise
        liste="les_noms"+EXT_csv
        nom_liste_noms = os.path.join( REPERTOIRE_GPKG, liste)
        if os.path.isfile( nom_liste_noms):
            df_les_noms = pd.read_csv( nom_liste_noms, sep=",")   # TODO: envisager usage de rechercherDelimiteurJointure
            available_noms=df_les_noms["Code Exploitant"].sort_values().unique()
            LISTE_NOMS_IMPRIMABLES=available_noms.tolist()
        else:
            LISTE_NOMS_IMPRIMABLES=["Pas de noms imprimables"]
			
        # Noms à imprimer
        PreparelisteNomsImprimes= s.value("MonParcellaire/NomsImprimes", "Pas de noms imprimables")
        LISTE_NOMS_IMPRIMES=PreparelisteNomsImprimes.split( SEP_CONFIG)
        #monPrint( "Settings lus pour noms à imprimer {}".format( LISTE_NOMS_IMPRIMES))
        # Atlas choisi
        DERNIER_ATLAS_CHOISI = s.value("MonParcellaire/AtlasChoisi", "Aucun atlas disponible")

        self.ecrireSettings()
        return CHOIX_TOUT_VOIR, CHOIX_MES_PARCELLES, NOM_CSV_MES_PARCELLES, \
           CHOIX_ORIENTATION, NOM_ORIENTATION, CHOIX_SUITE, CHOIX_JOINTURE, \
           REPERTOIRE_GPKG, FREQUENCE_SAUVEGARDE, ATTRIBUT_JOINTURE, LISTE_ATTRIBUTS_A_JOINDRE, \
           LISTE_NOMS_IMPRIMABLES, LISTE_NOMS_IMPRIMES, DERNIER_ATLAS_CHOISI

    def sauvergardeSelonFrequence(self, repertoireASauver, nomCourt, frequence, suiteSauvegarde, presenceAttendue=False, nomTable="xxx"):
        """ Fichier (y compris GPKG) est sauvés selon la fréquence et si nécessaire
            nommage detaillé selon la fréquence"""
        REPERTOIRE_SAUVEGARDE = os.path.join( repertoireASauver, suiteSauvegarde)
        creerRepertoireOptionTemporaire( REPERTOIRE_SAUVEGARDE)
        # Déterminer les noms des gpkg pour les copier
        CHEMIN_GPKG, _, cheminCompletTable = nommagesGPKG( repertoireASauver, nomTable, nomCourt, presenceAttendue)  
        if CHEMIN_GPKG == None:
            monPrint( "Pas de sauvegarde pour {0}".format( nomCourt), T_WAR)            
            return None, None
        dateMaintenant = datetime.now()
        if frequence == LISTE_FREQUENCE_SAUVEGARDE[0]: # prochain run
            dateFormatee=dateMaintenant.strftime("%Y%m%d%H%M")
        elif frequence == LISTE_FREQUENCE_SAUVEGARDE[1]: # par jour
            dateFormatee=dateMaintenant.strftime("%Y%m%d")
        elif frequence == LISTE_FREQUENCE_SAUVEGARDE[2]: # par semaine
            dateFormatee=dateMaintenant.strftime("%Y%mSemaine%U")
        else: # par mois
            assert( frequence == LISTE_FREQUENCE_SAUVEGARDE[3])
            dateFormatee=dateMaintenant.strftime("%Y%m")
        CHEMIN_GPKG_SAVE = os.path.join( REPERTOIRE_SAUVEGARDE,  nomCourt) + "_SAUVEGARDE_" + dateFormatee
        if not os.path.isfile( CHEMIN_GPKG_SAVE):
            shutil.copy( CHEMIN_GPKG, CHEMIN_GPKG_SAVE)
        return CHEMIN_GPKG, cheminCompletTable

    def slotBasculeMesParcelles( self):
        """ 
        Bascule le choix Mes Parcelles
        """
        CHEMIN_JOINTURE=None
        if self.Mes_Parcelles_checkBox.isChecked():
            self.Mes_Parcelles_lineEdit.setEnabled( True)
            self.Mes_Parcelles_toolButton.setEnabled( True)
            self.Orientation_checkBox.setEnabled( True)
            self.Orientation_lineEdit.setEnabled( True)
            self.Suite_checkBox.setEnabled( True)
            self.label_chemin_orientation.setEnabled(True)
            self.label_chemin_Mes_Parcelles.setEnabled(True)
        else:
            self.Mes_Parcelles_lineEdit.setEnabled( False)
            self.Mes_Parcelles_toolButton.setEnabled( False)
            self.Orientation_checkBox.setEnabled( False)
            self.Orientation_lineEdit.setEnabled( False)
            self.Suite_checkBox.setEnabled( False)
            self.label_chemin_orientation.setEnabled(False)
            self.label_chemin_Mes_Parcelles.setEnabled(False)
        return

    def slotBasculeJointure( self):
        """ 
        Bascule le choix jointure et acces aux listes d'attribut à joindre
        """
        CHEMIN_JOINTURE=None
        self.ecrireSettings()
        if self.Jointure_checkBox.isChecked():
            _, _, _, _, _, _, _,REPERTOIRE_GPKG, _, \
            ATTRIBUT_JOINTURE, LISTE_ATTRIBUTS_A_JOINDRE, _, _, _ = self.lireSettings()
            CHEMIN_JOINTURE = self.rechercherExtensionEncodage( REPERTOIRE_GPKG)
        if CHEMIN_JOINTURE != None and self.Jointure_checkBox.isChecked():
            self.AttributJointure_comboBox.setEnabled( True)
            self.AttributsAJoindre_listWidget.setEnabled( True)
            self.label_Jointure.setEnabled( True)
            self.label_AttributJointure.setEnabled( True)
            self.label_AttributsAJoindre.setEnabled( True)
            nomColonnes, nomColonnesUniques = self.lireAttributsJointure( CHEMIN_JOINTURE)
            # Attributs pour la joindre
            self.initialiserCombo( self.AttributJointure_comboBox, nomColonnesUniques, ATTRIBUT_JOINTURE)
            # Liste AttributsAJoindre
            self.initialiserListeMultiple( self.AttributsAJoindre_listWidget, nomColonnes, LISTE_ATTRIBUTS_A_JOINDRE,  "attributs à joindre")
        else:
            self.Jointure_checkBox.setChecked( Qt.Unchecked)
            self.AttributJointure_comboBox.setEnabled( False)
            self.AttributsAJoindre_listWidget.setEnabled( False)
            self.label_Jointure.setEnabled( False)
            self.label_AttributJointure.setEnabled( False)
            self.label_AttributsAJoindre.setEnabled( False)
            self.initialiserCombo( self.AttributJointure_comboBox, ["Pas de jointure"], "Pas de jointure")
            self.initialiserListeMultiple( self.AttributsAJoindre_listWidget, ["Pas de jointure"], ["Pas de jointure"], "attributs à joindre")

    def initialiserCombo( self, comboAInitialiser, LISTE_VALEURS, UNE_VALEUR,  libelleErreur=None):
        """Initialise un combo avec une liste de valeur et avec la position de la valeur correspondante trouvé dans Settings
        """
        comboAInitialiser.setCurrentIndex( 0)
        if len( LISTE_VALEURS) == 0:
            comboAInitialiser.clear()
            if libelleErreur != None:
                monPrint( self.tr("Pas de liste {0} pré défini".format( libelleErreur)), T_WAR,  "BAR", self)
        else:
            comboAInitialiser.clear( )
            comboAInitialiser.addItems( LISTE_VALEURS )
            # Retrouver le mode de trace dans  settings
            for idx, valeur in enumerate( LISTE_VALEURS):
                if ( valeur == UNE_VALEUR):
                    comboAInitialiser.setCurrentIndex( idx)
                    break

    def initialiserListeMultiple( self, listWidget, LISTE_VALEURS_POSSIBLE, LISTE_VALEURS,  libelleErreur):
        """Initialise unne liste de valeur et avec la liste des valeurs correspondantes trouvés dans Settings
        """
        if len( LISTE_VALEURS_POSSIBLE) == 0:
            #listeAInitialiser.clear( )
            monPrint( self.tr("Pas de liste {0} pré défini".format( libelleErreur)), T_WAR,  "BAR", self)
            return
        if len( LISTE_VALEURS) == 0:
            monPrint( self.tr("Pas de liste {0} à sélectionner".format( libelleErreur)), T_WAR,  "BAR", self)
        else:
            listWidget.clear()
            listWidget.addItems( LISTE_VALEURS_POSSIBLE)

            for i in LISTE_VALEURS:
                matching_items = listWidget.findItems(i, Qt.MatchExactly)
                for item in matching_items:
                    item.setSelected(True)

    def slotLectureMesParcelles(self):
        # Choisir le CSV exporté de Mes Parcelles
        s = QgsSettings( APPLI_NOM)
        REPERTOIRE_GPKG = s.value( "MonParcellaire/repertoireGPKG", os.path.join( self.plugin_dir, "data"))
        nomMesParcelles = s.value( "MonParcellaire/nomMesParcelles", "Export geometries parcelles2025_Fronton.csv")
        nomCompletMesParcelles, _ = QFileDialog.getOpenFileName( self, self.tr("Choisir le CSV exporté de Mes Parcelles"),
                     REPERTOIRE_GPKG, "CSV (*.csv)");

        if len( nomCompletMesParcelles) == 0:
            return
        if not os.path.isfile( nomCompletMesParcelles):
            return
        self.Mes_Parcelles_lineEdit.setText( nomCompletMesParcelles)
        self.ecrireSettings()
        return

    def slotLectureRepertoireGPKG(self):
        # Choisir le répertoire
        s = QgsSettings( APPLI_NOM)
        REPERTOIRE_GPKG = s.value( "MonParcellaire/repertoireGPKG", os.path.join( self.plugin_dir, "data"))
        nomRepertoire = QFileDialog.getExistingDirectory( self, self.tr("Choisir le répertoire de votre GPKG"),
                     REPERTOIRE_GPKG, QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks);
        if len( nomRepertoire) == 0:
            return
        if not os.path.isdir( nomRepertoire):
            return
        self.Repertoire_lineEdit.setText( nomRepertoire )
        self.ecrireSettings()
        self.slotBasculeJointure()       
        return
        
    def ouvrirProjetETGroupe(self, nomDuGroupe):
        """ Ouvrir projet et un groupe"""

        # Vérification du projet ouverte
        monProjet = QgsProject.instance()
        if monProjet.fileName() == None or monProjet.fileName() == "":
            monPrint( "Projet en cours de création",  T_WAR)
        else:
            monPrint( "Projet ouvert {}".format(monProjet.fileName()))

        root = monProjet.layerTreeRoot()
        # Création du groupe jointure_date
        dateMaintenant = datetime.now()
        nomGroupe=nomDuGroupe + " du " + dateMaintenant.strftime("%d %b à %Hh%M:%S")
        temporaireGroupe = QgsLayerTreeGroup( nomGroupe)
        # Positionner en haut de root
        root.addChildNode(temporaireGroupe)
        nouveauGroupe = temporaireGroupe.clone()
        root.insertChildNode(0, nouveauGroupe)
        root.removeChildNode(temporaireGroupe)
        return monProjet, nouveauGroupe

    def fusionnerJointure(self, cheminCompletParcelle, jointureChoisie):
        """ Selon les tables déja ouverte dans le projet : ouverture si necessaire des différents cas de délimiteurs
            Jointure par QGIS """
        REPERTOIRE_GPKG = self.Repertoire_lineEdit.text()
        CHEMIN_SYNCHRONISATION = quel_chemin_synchro(REPERTOIRE_GPKG, REP_SYN)

        # Vérification du projet ouverte
        monProjet, nouveauGroupeJointure = self.ouvrirProjetETGroupe( MonParcellaire_JOI)
        # Ouverture du vecteur parcelle
        parcelle = QgsVectorLayer(cheminCompletParcelle, MonParcellaire_PAR+SEP_U+MonParcellaire_JOI, 'ogr')
        monProjet.addMapLayer(parcelle, False)
        nouveauGroupeJointure.addLayer( parcelle)
        
        # Recherche delimiteur
        delimiteur, csv, nomCsv = self.rechercherDelimiteurJointure( jointureChoisie, "No Pandas")
        nomCourtJointure = os.path.basename( jointureChoisie)

        monPrint( "Délimiteur identifié {0} pour {1}".format( delimiteur, nomCourtJointure), T_OK)
        monProjet.addMapLayer(csv, False)
        nouveauGroupeJointure.addLayer( csv)

        # Jointure
        attributsSelectionnes=self.AttributsAJoindre_listWidget.selectedItems()
        attributsAJoindre = []
        for positionAttribut in range(len(attributsSelectionnes)):
            attributsAJoindre.append( str(self.AttributsAJoindre_listWidget.selectedItems()[positionAttribut].text()))
        #monPrint( "Attributs à joindre {}".format( attributsAJoindre))
        # Liste des champs dans csv
        nomColonnes, _ = self.lireAttributsJointure( jointureChoisie)
        attributsAJoindreOrdonne = []
        for col in nomColonnes:
            if col in attributsAJoindre:
                if col != MonParcellaireNomAttribut:
                    attributsAJoindreOrdonne.append(col)
        #monPrint( "Attributs à joindre ordonné {}".format( attributsAJoindreOrdonne))

        champVecteur=MonParcellaireNomAttribut
        maJointure=QgsVectorLayerJoinInfo()
        champCsv=self.AttributJointure_comboBox.currentText()
        maJointure.setJoinFieldName( champCsv)
        maJointure.setTargetFieldName( champVecteur)
        maJointure.setUsingMemoryCache( True)
        maJointure.setPrefix( "")
        maJointure.setJoinLayer( csv)
        # Récupérer les champs de jointure
        maJointure.setJoinFieldNamesSubset( attributsAJoindreOrdonne)
        parcelle.addJoin( maJointure)
        affectation_sans_suite = os.path.join( CHEMIN_SYNCHRONISATION, MonParcellaire_AFF_SANS_SUITE+EXT_geojson)
        traitementSauverEcraser( parcelle, affectation_sans_suite)
        return jointureChoisie, attributsAJoindreOrdonne

    def rechercherExtensionEncodage( self, repertoireGPKG, nom_jointure = MonParcellaire_JOI):
        """ Traite les différents cas d'extensions
            Rend la première jointure disponbile et la transforme en UTF-8 si necessaire
            ou None si il n'est existe aucune"""
        if not os.path.isdir (repertoireGPKG):
            erreurRepertoire( repertoireGPKG)
        for extension in EXTENSIONS_CONNUES:
            #monPrint( "Extension {0} pour repertoire {1}".format( extension, repertoireGPKG))
            CHEMIN_JOINTURE = nommageVecteur( repertoireGPKG, nom_jointure, extension,  "Ne doit pas preexister")
            if os.path.isfile( CHEMIN_JOINTURE):
                break
        if not os.path.isfile( CHEMIN_JOINTURE):
            monWarning = "Aucune jointure disponible parmi {0}. Déposez la jointure dans votre référentiel : répertoire {1}".\
                format( EXTENSIONS_CONNUES, repertoireGPKG)
            monPrint( monWarning , T_WAR,  "BAR", self)
            monPrint( monWarning , T_WAR)
            return None
        # Détection encodage
        monFile = open(CHEMIN_JOINTURE, "rb")
        rawdata = monFile.read()
        detection = chardet.detect(rawdata)
        monFile.close()
        if detection['encoding'] == 'utf-8':
            CHEMIN_JOINTURE_UTF=CHEMIN_JOINTURE
        else:
            CHEMIN_JOINTURE_UTF= os.path.join( repertoireGPKG, nom_jointure + "_UTF-8" + extension)
            monFile_UTF=open(CHEMIN_JOINTURE_UTF, "wb")
            monPrint( "Encodage {0} pour cette jointure pris en charge par Mon Parcellaire".format( detection['encoding']), T_OK)
            dataUTF=rawdata.decode(detection['encoding']).encode("utf-8")
            monFile_UTF.write( dataUTF)
            monFile_UTF.close()
        return CHEMIN_JOINTURE_UTF

    def rechercherDelimiteurJointure( self, CHEMIN_JOINTURE, mode="Pandas"):
        """ Traite les différents cas de délimiteurs avec pandas ou QGIS"""
        if VERSION_PANDAS != None and mode == "Pandas":
            lesDelimiteurs=" "
            for delimiteur in DELIMITEURS_CONNUS:
                if delimiteur !='\t':
                    lesDelimiteurs=lesDelimiteurs+delimiteur+ " "
                else:
                    lesDelimiteurs=lesDelimiteurs+"TABULATION "
                try:
                    dfJointure = pd.read_csv( CHEMIN_JOINTURE,  sep="{}".format(delimiteur)) #, encoding=detection['encoding'])
                except:
                    monPrint( 'Délimiteur "{0}" ne convient pas au csv {1}'.format( delimiteur, CHEMIN_JOINTURE))
                    continue
                break           
            if dfJointure.empty:
                erreurJointureDelimeteurs( CHEMIN_JOINTURE, lesDelimiteurs)
                return None, None, None
            return delimiteur, dfJointure, None 
        else:
            for delimiteur in DELIMITEURS_CONNUS:
                nomCsv="file:///{1}?delimiter={0}".format( delimiteur, CHEMIN_JOINTURE)
                try:
                    csv = QgsVectorLayer(nomCsv, MonParcellaire_JOI, 'delimitedtext')               
                except:
                    monPrint( "Délimiteur {0} ne convient pas au csv {1}".format( delimiteur, nomCsv))
                    continue
                break
            #TODO Vx: attraper erreur ?    
            return delimiteur, csv, nomCsv
            
    def lireAttributsJointure(self, CHEMIN_JOINTURE):
        """ Lecture de la jointure dans Pandas, pour trouver attributs unique et avec doubles"""
        nomColonnes=[]
        nomColonnesUniques=[]
        if VERSION_PANDAS != None:
            _, dfJointure, _ = self.rechercherDelimiteurJointure( CHEMIN_JOINTURE)
            if dfJointure.empty:
                return nomColonnes, nomColonnesUniques
            #monPrint("Liste des colonnes {}".format( listeColonnes))        
            for col in dfJointure.columns:                
                if col != MonParcellaireNomAttribut:
                    nomColonnes.append( col)
                listeJointureBrute=dfJointure[col].sort_values()
                listeJointureUnique=dfJointure[col].sort_values().unique()
                unique = True if len(listeJointureBrute) == len(listeJointureUnique) else False
                if unique:
                    nomColonnesUniques.append( col)
                    #monPrint("Colonne {0} est unique".format(col))
        else:
            _, layer, _ = self.rechercherDelimiteurJointure( CHEMIN_JOINTURE)
            #TEST: à vérifier
            if layer == None:
                return nomColonnes, nomColonnesUniques
            for field in layer.fields():
                #monPrint("Pas de {2} : champ du vecteur {0} a pour type {1}".format( field.name(), field.typeName(), E_PANDASS))
                nomColonnes.append( field.name())
            # Sans Pandas : mode dégradé pas de recherche des uniques
            nomColonnesUniques = nomColonnes
        if nomColonnesUniques == []:
            monPrint("Aucun attribut de cette jointure n'est unique: jointure impossible", T_ERR)
            monPrint("Aucun attribut de cette jointure n'est unique: jointure impossible", T_ERR,  T_BAR,  self)
            # Décocher le choix de jointure
            self.Jointure_checkBox.setChecked( Qt.Unchecked)
        return nomColonnes, nomColonnesUniques
        
    def extraireVignesMesParcelles(self):
        """ Ouvrir CSV Mes Parcelles
        Dupliquer dans nom le champ nom_parcelle
        Selectionnées les vignes
        """

        REPERTOIRE_GPKG = self.Repertoire_lineEdit.text()
        CHEMIN_SYNCHRONISATION = quel_chemin_synchro(REPERTOIRE_GPKG, REP_SYN)
        monProjet, nouveauGroupeMP = self.ouvrirProjetETGroupe( MonParcellaire_MP)
        cheminCompletMesParcelle = self.Mes_Parcelles_lineEdit.text()
        uri="file:///"+cheminCompletMesParcelle+"?delimiter={}&wktField={}".format(",","geom")
        mes_parcelles = QgsVectorLayer(uri, \
              MonParcellaire_MP, 'delimitedtext')
        monProjet.addMapLayer(mes_parcelles, False)
        nouveauGroupeMP.addLayer( mes_parcelles)
        # Forcer EPSG 2154 QgsCoordinateReferenceSystem constructor deprecated
        mes_parcelles.setCrs(QgsCoordinateReferenceSystem('EPSG:'+str(ID_DESTINATION_CRS)))
        monProjet.addMapLayer(mes_parcelles, False)
        nouveauGroupeMP.addLayer( mes_parcelles)
		
        # Sauver en geojson
        try:
              nom_toutes_parcelles = os.path.join( CHEMIN_SYNCHRONISATION, "MES_PARCELLES_TOUTES"+EXT_geojson)
              traitementSauverEcraser( uri, nom_toutes_parcelles)
              toutes_parcelles = QgsVectorLayer(nom_toutes_parcelles, \
              		MesParcelles_GJ, "ogr")
              monProjet.addMapLayer(toutes_parcelles, False)
        except:
              erreurGeojsonOuvert( nom_toutes_parcelles)
        # Filtrer les seules vignes
        try:
              traitementSelectionnerVignes( nom_toutes_parcelles)
              selection_input=QgsProcessingFeatureSourceDefinition( nom_toutes_parcelles, \
				selectedFeaturesOnly=True, \
				featureLimit=-1, geometryCheck=QgsFeatureRequest.GeometryAbortOnInvalid)
              nom_vignes_tous_attributs = os.path.join( CHEMIN_SYNCHRONISATION, "MES_PARCELLES_TOUS_ATTRIBUTS"+EXT_geojson)
              traitementSauverEcraser( selection_input, nom_vignes_tous_attributs)
              toutes_attr_vignes = QgsVectorLayer( nom_vignes_tous_attributs, \
              		MonParcellaireFiltre_GJ, "ogr")
              monProjet.addMapLayer(toutes_attr_vignes, False)
              #nouveauGroupeMP.addLayer( toutes_attr_vignes)
        except:
              monPrint( "Vecteur {0} ne convient pas pour la sélection des vignes".format( nom_toutes_parcelles), T_ERR)
              erreurTraitement("Sélection vignes")
        try:
              # Garder les colonnes utiles de Mes Parcelles pour Mon Parcellaire
              nom_vignes_mini_attributs = os.path.join( CHEMIN_SYNCHRONISATION, \
				"MES_PARCELLES_MINI_ATTRIBUTS"+EXT_geojson)
              traitementGarderChamps( nom_vignes_tous_attributs, nom_vignes_mini_attributs)
              nom_vignes = os.path.join( CHEMIN_SYNCHRONISATION, "MES_PARCELLES_VIGNES"+EXT_geojson)
              traitementDupliquer_nom_parcelle( nom_vignes_mini_attributs, nom_vignes)
              toutes_vignes = QgsVectorLayer(nom_vignes, \
              		MonParcellaire_attr_MP, "ogr")
              monProjet.addMapLayer(toutes_vignes, False)
              nouveauGroupeMP.addLayer( toutes_vignes)
        except:
              monPrint( "Vecteur {0} ne convient pas pour gerer attribut pour Mon Parcellaire la sélection des vignes".format( nom_vignes_tous_attributs), T_ERR)
              erreurTraitement("Gestion des attributs de vignes")
        try:
              # Si demandé, retrouver les orientations
              CHOIX_ORIENTATION = "YES" if self.Orientation_checkBox.isChecked() else "NO"
              if CHOIX_ORIENTATION == "YES":
                _, _, nom_vignes_orientees_modele = nommagesGPKG( REPERTOIRE_GPKG, MonParcellaire_ORIENTE_MODELE_DANS_GPKG)
                #nom_vignes_orientees_modele = os.path.join( CHEMIN_SYNCHRONISATION, MonParcellaire_ORIENTE_MODELE+EXT_geojson)
                nom_vignes_orientees = os.path.join( CHEMIN_SYNCHRONISATION, \
					MonParcellaire_ORIENTE+EXT_geojson)
                traitementJointureOrientation( nom_vignes, \
					nom_vignes_orientees_modele, nom_vignes_orientees)
                vignes_orientees = QgsVectorLayer(nom_vignes_orientees, \
              		MonParcellaire_ORIENTE, "ogr")
                monProjet.addMapLayer(vignes_orientees, False)
                nouveauGroupeMP.addLayer( vignes_orientees)
                return nom_vignes_orientees
        except:
              monPrint( "Vecteur {0} ne convient pas pour joindre les orientations".format( nom_vignes_orientees_modele), T_ERR)
              erreurTraitement("Orientation vignes")
        return nom_vignes

    def slotTraiterRepertoireGPKGJointure( self):
        """ Gestion la sauvegarde du GPKG : trois cas de frequences de sauvegarde, 
            Gestion des synchronisation Mes Parcelles Orientation    
            Gestion de la jointure    
        """
        monPrint( self.tr("Contrôle répertoire, sauvegarde GPKGs et jointure ... Version {0}".format(APPLI_VERSION)))
        
        # Utiliser les dernières saisies
        REPERTOIRE_GPKG = self.Repertoire_lineEdit.text()
        FREQUENCE_SAUVEGARDE = self.FrequenceSauvegarde_comboBox.currentText()
        CHOIX_JOINTURE = "YES" if self.Jointure_checkBox.isChecked() else "NO"
        CHOIX_MES_PARCELLES = "YES" if self.Mes_Parcelles_checkBox.isChecked() else "NO"
        CHOIX_SUITE = "YES" if self.Suite_checkBox.isChecked() else "NO"
        self.ecrireSettings()        
        ###############
        # Sauvegardes 
        ###############
        presenceObligatoire= True
        CHEMIN_VECTEUR_GPKG, cheminCompletParcelle = self.sauvergardeSelonFrequence( REPERTOIRE_GPKG, MonParcellaire_GPKG, \
            FREQUENCE_SAUVEGARDE, MonParcellaire_SAV, presenceObligatoire, MonParcellaire_PAR)
        CHEMIN_RASTER_GPKG, _ = self.sauvergardeSelonFrequence( REPERTOIRE_GPKG, MesFondsDePlan_GPKG, \
            LISTE_FREQUENCE_SAUVEGARDE[3], MonParcellaire_SAV)
        CHEMIN_IEA_GPKG, _ = self.sauvergardeSelonFrequence( REPERTOIRE_GPKG, MesIAE_GPKG, \
            FREQUENCE_SAUVEGARDE, MonParcellaire_SAV)
        # Sauver tous les projets
        nomProjetRecherches = os.path.join( REPERTOIRE_GPKG, '*'+EXT_qgz)
        listeProjetTriee = sorted(glob.glob( nomProjetRecherches))
        #monPrint( self.tr("Liste des projets QGIS {0}".format(listeProjetTriee)))
        for monProjet in listeProjetTriee:
            nomCourtprojet = os.path.basename( monProjet)
            _, _ = self.sauvergardeSelonFrequence( REPERTOIRE_GPKG, nomCourtprojet, \
                FREQUENCE_SAUVEGARDE, MonParcellaire_SAV)
        ###############
        # Jointure 
        ###############                   
        if CHOIX_JOINTURE == "YES":
            # Déterminer le nom de la jointure (plusieurs extensions)
            jointureChoisie = self.rechercherExtensionEncodage( REPERTOIRE_GPKG)
            if jointureChoisie != None:
                if CHOIX_MES_PARCELLES == "YES":
                    cheminCompletImporteMesParcelle = self.extraireVignesMesParcelles()
                    traitementSauverGPKGEcraserCouche( cheminCompletImporteMesParcelle, CHEMIN_VECTEUR_GPKG, MonParcellaire_PAR)

                CHEMIN_JOINTURE,  attributsAJoindreOrdonne = \
                    self.fusionnerJointure( cheminCompletParcelle, jointureChoisie)
                nomCourtJointure = os.path.basename( CHEMIN_JOINTURE)
                REPERTOIRE_JOINTURE= os.path.dirname( CHEMIN_JOINTURE)
                _, _ = self.sauvergardeSelonFrequence( REPERTOIRE_JOINTURE, nomCourtJointure, \
                    LISTE_FREQUENCE_SAUVEGARDE[0], MonParcellaire_SAV,  presenceObligatoire)
                if CHOIX_SUITE == "YES":
                    self.affecterVignesSuites( MonParcellaire_AFF_SANS_SUITE+EXT_geojson)
                monPrint( self.tr("Fin : vérification répertoire, sauvegarde GPKGs et jointure {0} pour des attributs {1}".\
                    format(nomCourtJointure, attributsAJoindreOrdonne)), T_OK)
            else:
                monPrint( self.tr("Fin : vérification répertoire - pas de jointure et sauvegarde GPKGs"), T_OK)
        else:
            monPrint( self.tr("Fin : vérification répertoire et sauvegarde GPKGs"), T_OK)

    def affecterVignesSuites( self, source=MonParcellaire_AFF_SANS_SUITE+EXT_geojson, cible = MonParcellaire_SUI+ SEP_U +'SANS_superficie'+EXT_geojson):
        """ Deviner les affectations pour les vignes suites (mais aussi cepage et orientation
        """
        REPERTOIRE_GPKG = self.Repertoire_lineEdit.text()
        CHEMIN_SYNCHRONISATION = quel_chemin_synchro(REPERTOIRE_GPKG, REP_SYN)

        if not os.path.isfile( source):
            source=os.path.join(CHEMIN_SYNCHRONISATION,source)
        if not os.path.isfile( cible):
            cible=os.path.join(CHEMIN_SYNCHRONISATION,cible)
        monProjet, nouveauGroupeSUITE = self.ouvrirProjetETGroupe( MonParcellaire_SUI)
        monPrint( "Traitement vignes suites ... Version {} module {}".format(APPLI_VERSION, __name__))
        import geopandas as gpd
        dfAffectation = gpd.read_file( source)
        dfAffectation[ "suite"]="Non"
        #dump_df( dfAffectation, "Affect")

        available_parcelles=dfAffectation['nom'].sort_values().unique()
        print("= Info = Nombre de parcelles uniques {}.".format( len( available_parcelles)))
        nb_double=0
        derniere_liste_a_ecrire=[]
        inconsistants=[]
        for pos, une_parcelle in enumerate( available_parcelles):
            # Trappe pour debug
            #if pos > 30:
            #   break
            #if une_parcelle != "F0001CO24":
            #    continue
            df_une_parcelle=dfAffectation[ (dfAffectation['nom'] == une_parcelle)]
            if len(df_une_parcelle) > 1:
                nb_double=nb_double+1
                monPrint( "{} {}ème DOUBLE entité pour la parcelle {} dans Mes Parcelles qui doit être corrigé".format(E_WARNING, nb_double, une_parcelle))
                continue
            affectation_coopviti= df_une_parcelle['Code validation'].values[0]
            cepage= df_une_parcelle['Cépage'].values[0]
            pre_orientation= df_une_parcelle['orientation'].values[0]
            try:
                orientation=int( pre_orientation)
            except ValueError:
                orientation=9999
            #print( "Pour la parcelle {} a pour affectation {} et orientation {}".format(une_parcelle, affectation_coopviti, orientation))
            # Rapprochement des vignes suites (A B C D) avec sa vigne principale
            suite="Non"
            if affectation_coopviti is None or affectation_coopviti == "nan" or len(affectation_coopviti) <= 0:
                if une_parcelle[-1] in ["A", "B", "C", "D", "E", "F"]:
                    if une_parcelle[0:-1] == derniere_liste_a_ecrire[0]:
                        #print("== Parcelle suite {} est rapprochée de {}".format( une_parcelle, derniere_liste_a_ecrire[0] ))
                        affectation_coopviti= derniere_liste_a_ecrire[1]
                        cepage=derniere_liste_a_ecrire[2]
                        if orientation==9999:
                            orientation=int( derniere_liste_a_ecrire[3])
                        suite="Oui"
                    else:
                        print("{} == Parcelle suite {} ne peut pas être rapprochée de la précedente parcelle {}".\
							  format( E_WARNING, une_parcelle, derniere_liste_a_ecrire[0] ))
                        affectation_coopviti="Inconnue"
                        cepage="Inconnu"
                        if orientation==9999:
                            orientation=0
                        suite="Non rapprochée"

                    # Mémoriser Affectation 
                    #print("= Info = Vignes suite {} récupere Affectation {} Cépage {} Orientation {}.".\
                    #	 format( une_parcelle, affectation_coopviti, cepage,orientation))
                    dfAffectation.loc[dfAffectation["nom"] == une_parcelle, "Code validation"] = affectation_coopviti
                    dfAffectation.loc[dfAffectation["nom"] == une_parcelle, "Cépage"] = cepage
                    dfAffectation.loc[dfAffectation["nom"] == une_parcelle, "orientation"] = orientation
                    dfAffectation.loc[dfAffectation["nom"] == une_parcelle, "suite"] = suite
                else:
                    print("{} BASES INCONSISTANTES == Parcelle {} (non A B C OU D) sans affectation, cépage et orientation n'est pas conservé".format( E_WARNING, une_parcelle ))
                    dfAffectation.drop(dfAffectation.loc[dfAffectation["nom"] == une_parcelle].index, inplace=True)
                    # Ecrire une liste sans affectations
                    inconsistants.append( une_parcelle)
            if une_parcelle[-1] not in ["A", "B", "C", "D", "E"]:
                derniere_liste_a_ecrire = [une_parcelle, affectation_coopviti, cepage, str(orientation)]
        dfAffectation.to_file( cible, driver="GeoJSON")
        if len(inconsistants)>0:
            monPrint( "{} parcelles provenant de Mes Parcelles non affectable et non suite : {}".format(len(inconsistants), inconsistants), T_WAR)
		# Calculer superficie des vignes
        cible_finale = os.path.join(CHEMIN_SYNCHRONISATION, MonParcellaire_AFF+EXT_geojson)
        traitementCalculerSuperficie( cible, cible_finale)
		# kml en GPS et GPKG en 2154
        cible_kml = os.path.join(CHEMIN_SYNCHRONISATION, MonParcellaire_AFF+EXT_kml)
        traitementGarderChamps( cible_finale, cible_kml, ["nom", "Code validation"])
        CHEMIN_VECTEUR_GPKG = os.path.join(REPERTOIRE_GPKG, MonParcellaire_GPKG)
        traitementSauverGPKGEcraserCouche( cible_finale, CHEMIN_VECTEUR_GPKG, MonParcellaire_AFF)
        affectation_suite = QgsVectorLayer(cible_finale, \
              		MonParcellaire_SUI.upper(), "ogr")
        monProjet.addMapLayer(affectation_suite, False)
        nouveauGroupeSUITE.addLayer( affectation_suite)

    def filterAtOnce(self, fieldName, operator, fieldValue):
        #Très fortement inspiré de l'extension FilterAtOnce (id 1968, https://github.com/muratkendir/FilterLayersAtOnce) Thanks muratkendir
        #Inutile de faire un clear avant
        layers = QgsProject.instance().layerTreeRoot().children()
        #fieldName = self.dlg.lineEdit_fieldName.text()
        #operator = self.dlg.comboBox.currentText()
        #fieldValue = self.dlg.lineEdit_value.text()
        if fieldName == '' or fieldValue == '':
            monPrint( "{} Attention, il manque field name or value.".format(E_WARNING))
        else:
            for katman in layers:
                # Eviter de filtrer "tree layer group"
                try:
                    layer_name = katman.layer().name()
                    #monPrint( katman.type() + ' is layer ?')
                    try:
                        katman.layer().setSubsetString(str(fieldName)+' '+str(operator)+' '+"'"+str(fieldValue)+"'")
                        #print(layer_name + ' layer is filtered with given expression.')
                    except:
                         print(layer_name + " n'est pas filtrée.")
                except:
                    print("Une couche n'est pas filtrée.")
            #monPrint( "Toutes les couches filtrées avec l'expression: {} {} {}".format( fieldName,operator, fieldValue))
        return

    def imprimerSelection( self, selection=[]):
        """ Filtrer les couches sur le nom présents dans selection (inspiration de Filter at once)
           Imprimer l'atlas de chaque selection
        """
        self.ecrireSettings()
        _, _, _, _, _, _, _,REPERTOIRE_GPKG, _, _, _, _, _, DERNIER_ATLAS_CHOISI = self.lireSettings()
        if selection == []:
            impressionSelectionnes=self.NomsImprimables_listWidget.selectedItems()
            impressionListe = []
            for position in range(len(impressionSelectionnes)):
                impressionListe.append( str(self.NomsImprimables_listWidget.selectedItems()[position].text()))
            if impressionListe != []:
                selection = impressionListe
        #monPrint("Début impression de atlas {} pour la sélection : {}".format( self.Imprimer_lineEdit_Nom.text(), selection))
        REPERTOIRE_GPKG = self.Repertoire_lineEdit.text()
        repertoire_print = os.path.join( REPERTOIRE_GPKG, "PRINT")
        if not os.path.isdir( repertoire_print):
            os.mkdir(repertoire_print)

        for nom in selection:
            #monPrint("Filtrer sur le nom : {}".format( nom))
            # Filtrer les couches du projet ? en batch
            self.filterAtOnce( "nom", "like", nom+"%")
            pdf_print = os.path.join( repertoire_print, nom + " " + DERNIER_ATLAS_CHOISI+ EXT_pdf)
            monPrint("Imprimer atlas du nom : {} dans le pdf {}".format( nom, pdf_print))
            processing.run("native:atlaslayouttopdf", {'LAYOUT':DERNIER_ATLAS_CHOISI,'COVERAGE_LAYER':None, \
               'FILTER_EXPRESSION':'','SORTBY_EXPRESSION':'','SORTBY_REVERSE':False,'LAYERS':None,'DPI':None,'FORCE_VECTOR':False,\
               'FORCE_RASTER':False,'GEOREFERENCE':True,'INCLUDE_METADATA':True,'DISABLE_TILED':False,'SIMPLIFY':True,'TEXT_FORMAT':1, \
               'IMAGE_COMPRESSION':0,'OUTPUT':pdf_print})
        monPrint("Fin des impression de la liste : {}".format( selection))
        return

    def imprimerTous( self):
        """ Retrouver tous les noms imprimables et appeler imprimerSelection
        """
        self.ecrireSettings()
        _, _, _, _, _, _, _,REPERTOIRE_GPKG, _, _, _, LISTE_TOUS_IMPRIMABLES, _, _ = self.lireSettings()
        #monPrint("Début impression de tous retrouver dans : {}".format( LISTE_TOUS_IMPRIMABLES))
        if LISTE_TOUS_IMPRIMABLES != ["Pas de noms imprimables"]:
            self.imprimerSelection( LISTE_TOUS_IMPRIMABLES)
            #monPrint("Fin impression de tous : {}".format( LISTE_TOUS_IMPRIMABLES))
        else:
            monPrint("{} dans le répertoire {} : aucune impression".format( "Pas de noms imprimables", REPERTOIRE_GPKG))
        return

    def consoliderTerroir( self, terroir_gpkg="IFV_sols_terroir"+EXT_gpkg, couche_terroir_gpkg="sols terroirs", \
				affectation_gpkg = MonParcellaire_GPKG, couche_affectation_gpkg = MonParcellaire_AFF, \
				cible ="CONSOLIDE"+SEP_U+MonParcellaire_PAR+SEP_U+MonParcellaire_TER+EXT_geojson):
        """ La sauvergarde du shp en gpkg n'est pas automatisé 
           Créer une intersection de "sols terroirs" par "affectatioins"
           Rechercher surface des terroir dans parcelle et leur % pour classer et pondérer les informtions terroirs
           Lancer la consolidation finale
        """
        REPERTOIRE_GPKG = self.Repertoire_lineEdit.text()
        CHEMIN_SYNCHRONISATION = quel_chemin_synchro(REPERTOIRE_GPKG, REP_SYN)
        REPERTOIRE_COMMUN= os.path.dirname( REPERTOIRE_GPKG)
        REPERTOIRE_TERROIR=os.path.join(REPERTOIRE_COMMUN, NOM_REPERTOIRE_TERROIR)
        # Nommage et sauvegarde terroir
        _, _, intersection = nommagesGPKG( REPERTOIRE_GPKG, couche_affectation_gpkg, affectation_gpkg, True)
		# Assert Terroir existe pour vérouiller seul cas FRONTON et exception explicite
        _, _, terroirs = nommagesGPKG( REPERTOIRE_TERROIR, couche_terroir_gpkg, terroir_gpkg, True)
		# TODO: verifier le bon encodage UTF-8

        if not os.path.isfile( cible):
            cible_complet=os.path.join( REPERTOIRE_TERROIR, cible)
        monProjet, nouveauGroupeTERROIR = self.ouvrirProjetETGroupe( MonParcellaire_TER)
        traitementIntersection(terroirs, intersection, cible_complet)

        # Champs superfie de chaque UT dans chaque parcelle et % des morceaux 
        consolide_surface=os.path.join( REPERTOIRE_TERROIR, "SURFACE_"+cible)
        traitementCalculerSuperficie( cible_complet, consolide_surface, 'surface_ut_dans_parcelle')
		# Ajout du champ affectation simplifiée
        #consolide_affectation=os.path.join( REPERTOIRE_TERROIR, "AFFECTATION_"+cible)
        #traitementCalculerAffectationSimplifiee( consolide_surface, consolide_affectation)
		# Afficher consolidation 
        consolide_terroir = QgsVectorLayer(consolide_surface, \
              		MonParcellaire_TER.upper(), "ogr")
        monProjet.addMapLayer(consolide_terroir, False)
        nouveauGroupeTERROIR.addLayer( consolide_terroir)
        # PB Lire geojson dans Pandas (export CSV dans DEV/CONSOLIDATION_TERROIR
        df_T_P = gpd.read_file( consolide_surface)

        #cible_csv=os.path.join(REPERTOIRE_TERROIR,"UTs_par_parcelles.csv")
        #traitementSauverEcraser( consolide_surface, cible_csv)
		# Verifier presence et passage eventuel en UTF
        #csvChoisie = self.rechercherExtensionEncodage( REPERTOIRE_TERROIR,"UTs_par_parcelles")
        #df_T_P = pd.read_csv( csvChoisie,  sep="{}".format(",")) #, encoding="utf-8")
        # Creer la synthese
        NOM_COURT_SYNTHESE = "Parcelle Coopviti Mes Parcelles Orientation" + SEP_U  + 'SUP'+ SEP_U  + str( LE_POURCENTAGE_IGNORE) + EXT_csv
        CSV_SYNTHESE = os.path.join( CHEMIN_SYNCHRONISATION, NOM_COURT_SYNTHESE)
        mon_csv_synthese,  writer=initaliser_synthese_csv( CSV_SYNTHESE)
        #dump_df( df_T_P, cible)
        #monPrint("Les types des colonnes sont : {}".format( df_T_P.dtypes))
        available_parcelles=df_T_P['nom'].sort_values().unique()
        monPrint("= Info = Nombre de parcelles uniques {}.".format( len( available_parcelles)))
        un_seul=plusieurs=sans_terroir=0
        max_sous_parcelle=0
        for pos, une_parcelle in enumerate(available_parcelles):
        # Trappe pour debug
        #if une_parcelle != "F0001CO24":
        #    continue
            df_une_parcelle=df_T_P[ (df_T_P['nom'] == une_parcelle) & (df_T_P['pourcent_ut_dans_parcelle'] > LE_POURCENTAGE_IGNORE)]
            info_terroir=df_une_parcelle[['pourcent_ut_dans_parcelle',  'CODE_UT', 'N_REG_SOL',  'NOMENCLATU', 'RUM', 'DRAINAGE', 'VIGUEUR', 'Surface Encepagée',  
                                  'Code validation', 'Cépage', 'Porte Greffe', 'orientation']].sort_values(ascending=False, by = 'pourcent_ut_dans_parcelle').values.tolist()
            if len(df_une_parcelle) > 1:
        #available_pourcentage_parcelles=df_une_parcelle['pourcent_ut_dans_parcelle'].sort_values(ascending=False)
                plusieurs=plusieurs+1 
                if len(df_une_parcelle) > max_sous_parcelle:
                    max_sous_parcelle = len(df_une_parcelle)
###        if plusieurs in [ 100, 800]:
#            print( "Parcelle {} a plusieurs cas de terroirs {} et les pourcentages sont {}".\
#                format( une_parcelle, len(df_une_parcelle),  list(available_pourcentage_parcelles)))
#            print( "Parcelle {} et info terroirs {}".\
#                format( une_parcelle, info_terroir))
            elif len(df_une_parcelle) == 1:
                un_seul=un_seul+1
            else:
                # Cas bizarre
                sans_terroir=sans_terroir+1
                monPrint( "{} Attention TERROIR == Parcelle {} n'a aucune information terroir.".format( U_TERROIR, une_parcelle))
                continue
            # Ecrire dans synthese
            ajoute_une_consolidation( writer, une_parcelle, info_terroir)

        monPrint("== RESUME {} parcelles avec un seul terroir, {} avec plusieurs (max vaut {}) et {} sans information terroir.".\
                format( un_seul,  plusieurs, max_sous_parcelle, sans_terroir))
        mon_csv_synthese.close()
        # Jointure des affectations et de la synthese terroir
        cible_terroir_court="TERROIR_AFFECTES"+EXT_geojson
        cible_terroir = os.path.join( REPERTOIRE_TERROIR, cible_terroir_court)
        sans_terroir = os.path.join( REPERTOIRE_TERROIR, "PARCELLE_SANS_TERROIR"+EXT_geojson)
        traitementJointureAttributs(intersection, CSV_SYNTHESE,cible_terroir, sans_terroir)
        consolide_terroir = QgsVectorLayer(cible_terroir, \
              		cible_terroir_court, "ogr")
        monProjet.addMapLayer(consolide_terroir, False)
        nouveauGroupeTERROIR.addLayer( consolide_terroir)

        monPrint("== Fin la consolidation terroir {} est créée, tu as les parcelles sans terroir dans {}.".\
                format( cible_terroir, sans_terroir), T_OK)
        return

    def traiterCentipedePos( self):
        """ Traiter les traces Centipede pos
            Creer des rangs ou interrangs dans le parcellaire
        """
        monPrint( self.tr("BOUTON en chantier : Traitement des traces centipedes ... Version {} module {}".format(APPLI_VERSION, __name__)))
        return

#        monProjet = QgsProject.instance()
#        root = monProjet.layerTreeRoot()
#        REPERTOIRE_GPKG = self.Repertoire_lineEdit.text()
#        CHEMIN_GPKG, _, cheminCompletTable = nommagesGPKG( REPERTOIRE_GPKG, MonParcellaire_PAR, MonParcellaire_GPKG, True)  
#        _, nomPosChoisi = chercherDernierPosCentipede( CHEMIN_GPKG)     
#        monPrint( "Dernière trace est choisie {0}. Si vous voulez un autre traitement, renommer vos fichier bruts *.pos".format(nomPosChoisi))
#
#        NomRepertoireCentipede = os.path.join( REPERTOIRE_GPKG, REPERTOIRE_CENTIPEDE_W)
#        NomTamponInterieur, NomTamponExterieur = creerTamponsParcelles( baseGPKG, cheminCompletTable, NomRepertoireCentipede)
#        nomQ1_GeoJSON, nomQ2_GeoJSON = filtreQualitesCentipede( nomPosChoisi, NomRepertoireCentipede)
#        nomPointsCentipedeQ1INT, nomPointsCentipedeQ1EXT,  nomPointsCentipedeQ2EXT= projectionPourJointureSpatiale(nomQ1_GeoJSON, nomQ2_GeoJSON)
#        dfPointBrut, quelRendu = choisirGeoJSONsInterieurExterieur( nomPointsCentipedeQ1INT, nomPointsCentipedeQ1EXT, nomPointsCentipedeQ2EXT)
#
#        repertoireDesParcelles = os.path.join( NomRepertoireCentipede, REPERTOIRE_CENTIPEDE_PARCELLES)
#        creerRepertoireOptionTemporaire( repertoireDesParcelles)#

#        # PASSE1 : Passer en revu tous les points par parcelle et trouver les ruptures de temps (2 Secondes) ou de distance (2m) (< écartement rang ou de passage

#        creerPointsLignesBrises( dfPointBrut,  quelRendu)
#        monPrint( "{} Fin extraction des Points & Lignes brisées à partir de {}".format( E_CLAP, quelRendu),  T_OK)


#    def lireSignets(self):
#        import xml.etree.ElementTree as ET
#        
#        referentielPlugin=os.path.join( self.plugin_dir, "data")
#        mesSignets=os.path.join( referentielPlugin, "signets"+EXT_xml)
#        mesSignetsCSV=os.path.join( referentielPlugin, "signets"+EXT_csv)
#        if not os.path.isfile( mesSignets):
#            print("Pas de signets {}".format(mesSignets))
#            return
#
#        root = ET.parse(mesSignets).getroot()
#        if root.tag != "qgis_bookmarks":
#            print("Signets non QGIS")
#            return
#
#        tags = {"tags":[]}
#        for bookmark in root.iter('bookmark'):
##            name = bookmark.find('name').text
##            xmin = bookmark.find('xmin').text
##            monPrint( "Name et xmin : {0} {0} ".format( name,  xmin))
#            tag = {}
#            tag["name"] = bookmark.find('name').text
#            xmin = bookmark.find('xmin').text
#            ymin = bookmark.find('ymin').text
#            xmax = bookmark.find('xmax').text
#            ymax = bookmark.find('ymax').text
#            WKT = "MultiPolygon ((({0} {1}, {2} {1}, {2} {3}, {0} {3}, {0} {1})))".\
#                format( xmin, ymin, xmax, ymax)
#            tag["WKT"] = WKT
#
#            tags["tags"]. append(tag)
#        df_signets = pd.DataFrame(tags["tags"])
#        monPrint( "Signet : {}".format( df_signets.head()))
#        print( df_signets.head())        
#        df_signets.to_csv( mesSignetsCSV, sep=';')
#                