# -*- coding: utf-8 -*-

# Dictionary for mapping ALK values to Building USE (Residential Buildings (RB) or
# Non Residential Buildings (NRB)) and TYPE (Wohngebaeude, Buerogebaeude, etc.)

# Inputvalue (*xin)
def get(*xin):

    from PyQt4.QtCore import QVariant

    # dictionary from ALKIS®- Grunddatenbestand und länderspezifische Inhalte
    ALKNAME = {
    "1000":"Wohngebaeude",
    "1010":"Wohnhaus",
    "1020":"Wohnheim",
    "1021":"Kinderheim",
    "1022":"Seniorenheim",
    "1023":"Schwesternwohnheim",
    "1024":"Studenten-, Schuelerwohnheim",
    "1025":"Schullandheim",
    "1100":"Gemischt genutztes Gebaeude mit Wohnen",
    "1110":"Wohngebaeude mit Gemeinbedarf",
    "1120":"Wohngebaeude mit Handel und Dienstleistungen",
    "1121":"Wohn- und Verwaltungsgebaeude",
    "1122":"Wohn- und Buerogebaeude",
    "1123":"Wohn- und Geschaeftsgebaeude",
    "1130":"Wohngebaeude mit Gewerbe und Industrie",
    "1131":"Wohn- und Betriebsgebaeude",
    "1210":"Land- und forstwirtschaftliches Wohngebaeude",
    "1220":"Land- und forstwirtschaftliches Wohn- und Betriebsgebaeude",
    "1221":"Bauernhaus",
    "1222":"Wohn- und Wirtschaftsgebaeude",
    "1223":"Forsthaus",
    "1310":"Gebaeude zur Freizeitgestaltung",
    "1311":"Ferienhaus",
    "1312":"Wochenendhaus",
    "1313":"Gartenhaus",
    "2000":"Gebaeude fuer Wirtschaft oder Gewerbe",
    "2010":"Gebaeude fuer Handel und Dienstleistungen",
    "2020":"Buerogebaeude",
    "2030":"Kreditinstitut",
    "2040":"Versicherung",
    "2050":"Geschaeftsgebaeude",
    "2051":"Kaufhaus",
    "2052":"Einkaufszentrum",
    "2053":"Markthalle",
    "2054":"Laden",
    "2055":"Kiosk",
    "2056":"Apotheke",
    "2060":"Messehalle",
    "2070":"Gebaeude fuer Beherbergung",
    "2071":"Hotel, Motel, Pension",
    "2072":"Jugendherberge",
    "2073":"Huette (mit uebernachtungsmoeglichkeit)",
    "2074":"Campingplatzgebaeude",
    "2080":"Gebaeude fuer Bewirtung",
    "2081":"Gaststaette, Restaurant",
    "2082":"Huette (ohne uebernachtungsmoeglichkeit)",
    "2083":"Kantine",
    "2090":"Frezeit- und Vergnuegungsstaette",
    "2091":"Festsaal",
    "2092":"Kino",
    "2093":"Kegel-, Bowlinghalle",
    "2094":"Spielkasino",
    "2100":"Gebaeude fuer Gewerbe und Industrie",
    "2110":"Produktionsgebaeude",
    "2111":"Fabrik",
    "2112":"Betriebsgebaeude",
    "2113":"Brauerei",
    "2114":"Brennerei",
    "2120":"Werkstatt",
    "2121":"Saegewerk",
    "2130":"Tankstelle",
    "2131":"Waschstrasse, Waschanlage, Waschhalle",
    "2140":"Gebaeude der Vorratshaltung",
    "2141":"Kuehlhaus",
    "2142":"Speichergebaeude",
    "2143":"Lagerhalle, Lagerschuppen, Lagerhaus",
    "2150":"Speditionsgebaeude",
    "2160":"Gebaeude fuer Forschungszwecke",
    "2170":"Gebaeude fuer Grundstoffgewinnung",
    "2171":"Bergwerk",
    "2172":"Saline",
    "2180":"Gebaeude fuer betriebliche Sozialeinrichtung",
    "2200":"Sonstiges Gebaeude fuer Gewerbe und Industrie",
    "2210":"Muehle",
    "2211":"Windmuehle",
    "2212":"Wassermuehle",
    "2213":"Schoepfwerk",
    "2220":"Wetterstation",
    "2310":"Gebaeude fuer Handel und Dienstleistungen mit Wohnen",
    "2320":"Gebaeude fuer Gewerbe und Industrie mit Wohnen",
    "2400":"Betriebsgebaeude zu Verkehrsanlagen (allgemein)",
    "2410":"Betriebsgebaeude fuer Strassenverkehr",
    "2411":"Strassenmeisterei",
    "2412":"Wartehalle",
    "2420":"Betriebsgebaeude fuer Schienenverkehr",
    "2421":"Bahnwaerterhaus",
    "2422":"Lokschuppen, Wagenhalle",
    "2423":"Stellwerk, Blockstelle",
    "2424":"Betriebsgebaeude des Gueterbahnhofs",
    "2430":"Betriebsgebaeude fuer Flugverkehr",
    "2431":"Flugzeughalle",
    "2440":"Betriebsgebaeude fuer Schiffsverkehr",
    "2441":"Werft (Halle)",
    "2442":"Dock (Halle)",
    "2443":"Betriebsgebaeude zur Schleuse",
    "2444":"Bootshaus",
    "2450":"Betriebsgebaeude zur Seilbahn",
    "2451":"Spannwerk zur Drahtseilbahn",
    "2460":"Gebaeude zum Parken",
    "2461":"Parkhaus",
    "2462":"Parkdeck",
    "2463":"Garage",
    "2464":"Fahrzeughalle",
    "2465":"Tiefgarage",
    "2500":"Gebaeude zur Versorgung",
    "2501":"Gebaeude zur Energieversorgung",
    "2510":"Gebaeude zur Wasserversorgung",
    "2511":"Wasserwerk",
    "2512":"Pumpstation",
    "2513":"Wasserbehaelter",
    "2520":"Gebaeude zur Elektrizitaetsversorgung",
    "2521":"Elektrizitaetswerk",
    "2522":"Umspannwerk",
    "2523":"Umformer",
    "2527":"Reaktorgebaeude",
    "2528":"Turbinenhaus",
    "2529":"Kesselhaus",
    "2540":"Gebaeude fuer Fernmeldewesen",
    "2560":"Gebaeude an unterirdischen Leitungen",
    "2570":"Gebaeude zur Gasversorgung",
    "2571":"Gaswerk",
    "2580":"Heizwerk",
    "2590":"Gebaeude zur Versorgungsanlage",
    "2591":"Pumpwerk (nicht fuer Wasserversorgung)",
    "2600":"Gebaeude zur Entsorgung",
    "2610":"Gebaeude zur Abwasserbeseitigung",
    "2611":"Gebaeude der Klaeranlage",
    "2612":"Toilette",
    "2620":"Gebaeude zur Abfallbehandlung",
    "2621":"Muellbunker",
    "2622":"Gebaeude der Muellverbrennung",
    "2623":"Gebaeude der Abfalldeponie",
    "2700":"Gebaeude fuer Land- und Forstwirtschaft",
    "2720":"Land- und forstwirtschaftliches Betribesgebaeude",
    "2721":"Scheune",
    "2723":"Schuppen",
    "2724":"Stall",
    "2726":"Scheune und Stall",
    "2727":"Stall fuer Tiergrosshaltung",
    "2728":"Reithalle",
    "2729":"Wirtschaftsgebaeude",
    "2732":"Almhuette",
    "2735":"Jagdhaus, Jagdhuette",
    "2740":"Treibhaus, Gewaechshaus",
    "2741":"Treibhaus",
    "2742":"Gewaechshaus, verschiebbar",
    "3000":"Gebaeude fuer oeffentliche Zwecke",
    "3010":"Verwaltungsgebaeude",
    "3011":"Parlament",
    "3012":"Rathaus",
    "3013":"Post",
    "3014":"Zollamt",
    "3015":"Gericht",
    "3016":"Botschaft, Konsulat",
    "3017":"Kreisverwaltung",
    "3018":"Bezirksregierung",
    "3019":"Finanzamt",
    "3020":"Gebaeude fuer Bildung und Forschung",
    "3021":"Allgemein bildende Schule",
    "3022":"Berufsbildende Schule",
    "3023":"Hochschulgebaeude (Fachhochschule, Universitaet)",
    "3024":"Forschungsinstitut",
    "3030":"Gebaeude fuer kulturelle Zwecke",
    "3031":"Schloss",
    "3032":"Theater, Oper",
    "3033":"Konzertgebaeude",
    "3034":"Museum",
    "3035":"Rundfunk, Fehrsehen",
    "3036":"Veranstaltungsgebaeude",
    "3037":"Bibliothek, Buecherei",
    "3038":"Burg, Festung",
    "3040":"Gebaeude fuer religioese Zwecke",
    "3041":"Kirche",
    "3042":"Synagoge",
    "3043":"Kapelle",
    "3044":"Gemeindehaus",
    "3045":"Gotteshaus",
    "3046":"Moschee",
    "3047":"Tempel",
    "3048":"Kloster",
    "3050":"Gebaeude fuer Gesundheitswesen",
    "3051":"Krankenhaus",
    "3052":"Heilanstalt, Pflegeanstalt, Pflegestation",
    "3053":"aerztehaus, Poliklinik",
    "3060":"Gebaeude fuer soziale Zwecke",
    "3061":"Jugendfreizeitheim",
    "3062":"Freizeit-, Vereinsheim, Dorfgemeinschafts-, Buergerhaus",
    "3063":"Seniorenfreizeitstaette",
    "3064":"Obdachlosenheim",
    "3065":"Kindergrippe, Kindergarten, Kindertagesstaette",
    "3066":"Asylbewerberheim",
    "3070":"Gebaeude fuer Sicherheit und Ordnung",
    "3071":"Polizei",
    "3072":"Feuerwehr",
    "3073":"Kaserne",
    "3074":"Schutzbunker",
    "3075":"Justizvollzugsanstalt",
    "3080":"Friedhofsgebaeude",
    "3081":"Trauerhalle",
    "3082":"Krematorium",
    "3090":"Empfangsgebaeude",
    "3091":"Bahnhofsgebaeude",
    "3092":"Flughafengebaeude",
    "3094":"Gebaeude zum U-Bahnhof",
    "3095":"Gebaeude zum S-Bahnhof",
    "3097":"Gebaeude zum Busbahnhof",
    "3098":"Empfangsgebaeude Schifffahrt",
    "3100":"Gebaeude fuer oeffentliche Zwecke mit Wohnen",
    "3200":"Gebaeude fuer Erholungszwecke",
    "3210":"Gebaeude fuer Sportzwecke",
    "3211":"Sport-, Turnhalle",
    "3212":"Gebaeude zum Sportplatz",
    "3220":"Badegebaeude",
    "3221":"Hallenbad",
    "3222":"Gebaeude im Freibad",
    "3230":"Gebaeude im Stadion",
    "3240":"Gebaeude fuer Kurbetrieb",
    "3241":"Badegebaeude fuer medizinische Zwecke",
    "3242":"Sanatorium",
    "3260":"Gebaeude im Zoo",
    "3261":"Empfangsgebaeude des Zoos",
    "3262":"Aquarium, Terrarium, Voliere",
    "3263":"Tierschauhaus",
    "3264":"Stall im Zoo",
    "3270":"Gebaeude im botanischen Garten",
    "3271":"Empfangsgebaeude des botanischen Gartens",
    "3272":"Gewaechshaus (Botanik)",
    "3273":"Pflanzenschauhaus",
    "3280":"Gebaeude fuer andere Erholungseinrichtung",
    "3281":"Schutzhuette",
    "3290":"Touristisches Informationszentrum"
}

    #Output Name and Use is defined
    bui_typ = ALKNAME.get(xin[0],"no NAME specified")

    return (bui_typ.encode('utf8'))
