# MOE GeoPortal Loader

[![English](https://img.shields.io/badge/English-blue)](README.md)
[![環境ジオポータル](https://img.shields.io/badge/環境ジオポータル-forestgreen)](https://geoportal.env.go.jp/)
[![QGIS公式プラグインリポジトリ](https://img.shields.io/badge/QGIS公式プラグインリポジトリ-green)](https://plugins.qgis.org/plugins/moe_geoportal_loader/)

## 概要

- 環境省が運営する地理空間情報ポータルサイト [環境ジオポータル](https://geoportal.env.go.jp/) で公開されているデータを QGIS に直接読み込めるプラグインです。
- データタイプが **Feature Service** で、ライセンスが **CC BY 4.0** のデータセットを対象としています。

## 機能

- 環境ジオポータルのデータセットを QGIS に直接読み込み
- データセットと出力先を選択すると、ファイルとスタイル設定を自動保存
- ArcGIS Feature Service レイヤとしての読み込みにも対応
- QGIS のプロセシングツールとして実行可能

## データセット

#### 植生図（11 データセット）

| データセット             | 詳細                                                   |
| ------------------------ | ------------------------------------------------------ |
| 現存植生図（1/50,000）   | 都道府県別                                             |
| 自然度区分図（1/50,000） | 都道府県別                                             |
| 現存植生図 2024          | 北海道、東北、関東、北陸、中部、近畿、中四国、九州沖縄 |
| 北方領土植生概況図       |                                                        |

#### 哺乳類分布調査（4 データセット）

| データセット           | 詳細                     |
| ---------------------- | ------------------------ |
| 中大型哺乳類分布調査   | アナグマ、キツネ、タヌキ |
| クマ類全国分布メッシュ | 基礎調査 1980            |

#### サンゴ礁生態系調査（19 データセット）

| データセット                 | 詳細                                                                                                                                                        |
| ---------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------- |
| サンゴ浅海生態系現況把握調査 | トカラ列島周辺（2021）、久米島（2018）、多良間島（2018）、大隅諸島周辺（2021）、奄美群島（2018–2019）、宮古島（2018）、小笠原周辺（2020）、石西礁湖（2017） |
| サンゴ第4回（1988–1993）     | サンゴ礁地域分布地域、小笠原の小規模サンゴ礁分布地域、非サンゴ礁地域の分布地域                                                                              |
| サンゴ第5回（1993–1999）     | 分布地域                                                                                                                                                    |

#### サンゴ礁変化検出（24 データセット）

| 地域           | 比較                                   |
| -------------- | -------------------------------------- |
| 奄美大島       | H20 vs R01、第4回 vs R01、第5回 vs R01 |
| 徳之島         | H20 vs R01、第4回 vs R01、第5回 vs R01 |
| 久米島         | H20 vs H30、第4回 vs H30               |
| 宮古島         | H20 vs H30、第4回 vs H30               |
| 小笠原         | H20 vs H30、第4回 vs R02、第5回 vs R02 |
| 沖永良部島     | H20 vs H30、第4回 vs H30               |
| 多良間島       | H20 vs H30、第4回 vs H30               |
| 与論島         | H20 vs H30、第4回 vs H30               |
| 宝島・小宝島   | H20 vs R03、第4回 vs R03               |
| 種子島・屋久島 | H20 vs R03、第4回 vs R03、第5回 vs R03 |

#### 藻場調査（7 データセット）

| データセット               | 詳細                              |
| -------------------------- | --------------------------------- |
| 藻場調査第4回（1988–1993） |                                   |
| 藻場調査第5回（1993–1999） |                                   |
| 藻場調査（2018–2020）      | UTM51、UTM52、UTM53、UTM54、UTM55 |

## 動作環境

- QGIS 3.40 以上

## ライセンス

- このプラグインは [GNU General Public License v2.0](LICENSE) の下で公開されています。
- プラグインを介して読み込めるデータセットは、環境ジオポータルより [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/) で提供されています。

## 開発者

- [Keita Uemori](@Geo-Jagaimo)
