# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MODIS
                                 A QGIS plugin
 This plugin is made to download and visualise MODIS LST data. you can get raw data from the usgs server, select multiple tiles, get mean values of a timespan and download different product types such as 1km-1day or 1km-8day product and MODIS AQUA or MODIS Terra.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-02-18
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Jonas Apelt
        email                : jonas.apelt@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, Qgis, QgsRasterLayer, QgsApplication, QgsCoordinateReferenceSystem
import datetime
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .MODIS_dialog import MODISDialog
import pandas as pd
import requests
from qgis.utils import iface
from pathlib import Path
import imp
import subprocess
packages = ['os', 'osgeo', 'pymodis', 'glob', 'pathlib', 'getpass']
for i in packages:
    try:
        imp.find_module(i)
        pass
    except ImportError:
        subprocess.check_call(['python', '-m', 'pip', 'install', i])
        
from pymodis import downmodis
import os # This is is needed in the pyqgis console also
import os.path
import numpy as np
from osgeo import gdal, osr   
import glob
import getpass


class MODIS:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MODIS_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&MODIS LST download and processing')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MODIS', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/MODIS/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'MODIS download and visualization'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&MODIS LST download and processing'),
                action)
            self.iface.removeToolBarIcon(action)
    
    # define function to get directory path to write to by Buttonclick
    def select_output_file(self):
        # open a window to choose path
      wd = QFileDialog.getExistingDirectory(
        self.dlg, "Select output directory ")
      #put pathstring in lineEdit
      self.dlg.lineEdit.setText(wd)
    
        #define function to get tilenames from extent on Buttonclick
    def tilesFromExtent (self):
        #https://code.env.duke.edu/projects/mget/wiki/SinusoidalMODISimport requests
        #get current extent of map
        extent = iface.mapCanvas().extent()
        ################################################
        #find tile, which is the closest to that extent!
        ################################################
        #get coordinates of current map
        xmax = extent.xMaximum()
        ymax = extent.yMaximum()
        xmin = extent.xMinimum()
        ymin = extent.yMinimum()
        
        ##########################
        ##      parameters      ##
        ##########################
        tile_width = 1111950.5196666666
        tile_height = 1111950.5196666666
        d = tile_width
        
        # toto : down left corner of the coordinate system 
        toto = -20015109.354
        tutu = -10007554.677
        ##########################
        
        # use download to get column with tile names
        direc = Path().cwd()
        url = 'https://modis-land.gsfc.nasa.gov/pdf/sn_bound_10deg.txt'
        tiles_txt = requests.get(url, allow_redirects=True)
        
        tile_bounds = direc.joinpath('tiles_bounds.txt') 
        tile_bounds.write_bytes(tiles_txt.content)
        
        # always open files with a with statement to avoid unclosed files
        with tile_bounds.open() as f:
            text = f.read()
            text = text.splitlines()
        
            del text[0:7] 
            del text[-2:]
            
        # the file is now useless unlink it 
        tile_bounds.unlink()
            
        df_bounds = pd.DataFrame(columns=['tile','horizontal', 'vertical','xmin_m','xmax_m', 'ymin_m', 'ymax_m'])
        
        hor, ver, xmin_m, xmax_m, ymin_m, ymax_m=[], [], [], [],[], []
        
        # create a dataframe and calculate bounds of tiles 
        df_bounds.tile = [f"h{text[i][5:7].replace(' ', '0')}v{text[i][1:3].replace(' ', '0')}" for i in range(len(text))]
        df_bounds.horizontal = df_bounds.tile.map(lambda row: row[1:3]).astype(int)
        df_bounds.vertical = df_bounds.tile.map(lambda row: row[4:6]).astype(int)
        df_bounds.xmin_m = df_bounds.horizontal.map(lambda r: toto + r*tile_width)
        df_bounds.ymin_m = df_bounds.vertical.map(lambda r: tutu + (17 - r)*tile_height)
        df_bounds.xmax_m = df_bounds.xmin_m.map(lambda r: r + tile_width)
        df_bounds.ymax_m = df_bounds.ymin_m.map(lambda r: r + tile_height)
        
        #filter the names of the tiles inside the box
        tile_names = df_bounds[(df_bounds['xmin_m'] >= xmin-d) & 
                               (df_bounds['xmax_m'] <= xmax+d) & 
                               (df_bounds['ymin_m'] >= ymin-d) &
                               (df_bounds['ymax_m'] <= ymax+d)]
        
        # improvement for the print 
        tile_names = ','.join(tile_names.tile)
        self.dlg.lineEdit_2.setText(tile_names) 
    
    
    def run(self):
        """Run method that performs all the real work"""
        #when starting thge plugin change the CRS to target MODIS crs
        crs_wkt = 'PROJCS["unnamed",GEOGCS["Unknown datum based upon the custom spheroid",DATUM["Not_specified_based_on_custom_spheroid",SPHEROID["Custom spheroid",6371007.181,0]],PRIMEM["Greenwich",0],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]]],PROJECTION["Sinusoidal"],PARAMETER["longitude_of_center",0],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["Meter",1],AXIS["Easting",EAST],AXIS["Northing",NORTH]]'
        self.iface.mapCanvas().setDestinationCrs(QgsCoordinateReferenceSystem(crs_wkt))
        
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = MODISDialog()
            #activate Button to select output directory
            self.dlg.pushButton.clicked.connect(self.select_output_file)
            #activate Button to get string of tiles from current map extent
            self.dlg.pushButton_ext.clicked.connect(self.tilesFromExtent)
        
        items = ['1km 1 day', '1km 8 days']
        self.dlg.comboBox.clear()
        # Populate the comboBox with names of all the loaded layers
        self.dlg.comboBox.addItems([it for it in items])
        password="JonasApelt123"
        user="JonasApelt"
        # populate user and PW editLines with default values
        self.dlg.lineEdit_UN.setText(user)
        self.dlg.lineEdit_PW.setText(password)
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            # get working directory before assessed with pushButton
            wd = self.dlg.lineEdit.text()
            #define tiles from lineEdit efore assessed via pushButton_ext
            tiles = self.dlg.lineEdit_2.text()
            tiles = tiles.split(',')
            tiles = [t.replace(' ', '')for t in tiles]
            #get user and PW from lineEdit
            user = self.dlg.lineEdit_UN.text()
            password = self.dlg.lineEdit_PW.text()
            
            #get suffix for file name from lineEdit_suf
            suffix = self.dlg.lineEdit_suf.text()
            
            # define enndate and today from dateEdit
            start_var = self.dlg.dateEdit_start.date() 
            enddate = start_var.toPyDate()
            enddate = enddate.strftime("%Y-%m-%d")
            
            end_var = self.dlg.dateEdit_end.date() 
            today = end_var.toPyDate()
            today = today.strftime("%Y-%m-%d")
            
            #get the information from comboBox of data product type
            productIn = str(self.dlg.comboBox.currentText())
            if productIn == '1km 1 day':
                product = 'A1.006'
            if productIn == '1km 8 days':
                product = 'A2.006'
            #choose 'A2.006' for 8day or 'A1.006' for one day version
            #product='A1.006'
            #if checkBoxes are activated hand in parameters of satellite type
            if self.dlg.checkBox_aq.isChecked():
                MYD = True
            else:
                MYD = False
            if self.dlg.checkBox_ter.isChecked():
                MOD = True
            else:
                MOD = False
            #set True to download and select satellite type, must select one to download anything
            
            if self.dlg.checkBox_del.isChecked():
                delete = True
            else:
                delete = False
            
            ###################################################################################
            ###################################################################################
            
            #https://stackoverflow.com/questions/56764046/gdal-ogr2ogr-cannot-find-proj-db-error 
            # create new variavle in windows environemnt PROJ_LIB and save value 
            #C:\Users\Jonas\.conda\envs\modis\Library\share\proj what is the path of proj.db file; 
            #then reboot your computer
            if product == 'A2.006':
                Path(wd+"/8day_mean").mkdir(parents=True, exist_ok=True)
                wd = wd+"/8day_mean"
            if product =='A1.006':
                Path(wd+"/oneday").mkdir(parents=True, exist_ok=True)
                wd = wd+"/oneday"
            #create folder for unmerged tiles
            Path(wd+"/unmergedTiles").mkdir(parents=True, exist_ok=True)
            wd = wd+"/unmergedTiles"
            
            #define function to download from usgs server
            def download (path, product, Tile, wd, today, enddate, user, password):
                modisOgg = downmodis.downModis(destinationFolder=wd, password=password, user=user,
                               url='https://e4ftl01.cr.usgs.gov', tiles=Tile, path=path, 
                               product=product, today=today, enddate=enddate, delta=0, 
                               jpg=False, debug=True, timeout=None, checkgdal=True)
            
                modisOgg.connect()
                modisOgg.downloadsAllDay(clean=True, allDays=False)
            
            #function to get array from .hdf files and spatial information   
            def get_data(wd, listFile, f, int_key, kind_str):
                hdf_file = wd + '/'+listFile[f]
                scale_factor = 0.02
                # open the dataset
                hdf_ds = gdal.Open(hdf_file, gdal.GA_ReadOnly)
                subdatasets = hdf_ds.GetSubDatasets()
            
                subdataset_name = subdatasets[int_key][0]
                band_ds = gdal.Open(subdataset_name, gdal.GA_ReadOnly)
                band_path = os.path.join(wd, listFile[f][:-4]+ kind_str + '.tiff')
                array = band_ds.ReadAsArray()
                array = scale_factor * array
                array = array.astype(float)
                array[array == 0] = np.nan
                return array, band_ds, band_path
            
            #function to create a georeferenced .tiff from array
            def to_tiff(array, band_path, band_ds):
                out_ds = gdal.GetDriverByName('GTiff').Create(band_path,
                                                              band_ds.RasterXSize,
                                                              band_ds.RasterYSize,
                                                              1,
                                                              gdal.GDT_Float32,
                                                              ['COMPRESS=LZW', 'TILED=YES'])
                proj = 'PROJCS["unnamed",GEOGCS["Unknown datum based upon the custom spheroid",DATUM["Not_specified_based_on_custom_spheroid",SPHEROID["Custom spheroid",6371007.181,0]],PRIMEM["Greenwich",0],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]]],PROJECTION["Sinusoidal"],PARAMETER["longitude_of_center",0],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["Meter",1],AXIS["Easting",EAST],AXIS["Northing",NORTH]]'
                out_ds.SetGeoTransform(band_ds.GetGeoTransform())
                out_ds.SetProjection(proj)
                out_ds.GetRasterBand(1).WriteArray(array)
                out_ds.GetRasterBand(1).SetNoDataValue(0)
                out_ds.FlushCache()
                out_ds = None  #close dataset to write to disc
            
            #try and delete every useless file downloaded
            def delete_down (wd):
                listdir = os.listdir(wd+ '/unmergedTiles')
                listdir_merged = os.listdir(wd + '/mergedTiles')
                listdir = [o for o in listdir if o.endswith('.hdf') or o.endswith('.xml') or o.endswith('.txt') or o.endswith('.log') or o.endswith('day.tiff') or o.endswith('night.tiff')] # get list of all .hdf, .xml, .log and .txt in folder
                listdir_merged = [o for o in listdir_merged if o.endswith('day.tiff') or o.endswith('night.tiff')]
                #try to delete all files if error raises pass
                for fd in listdir:
                    try:
                        os.remove(wd + '/unmergedTiles/' + fd)
                    except:
                        pass
                for fd in listdir_merged:
                    try:
                        os.remove(wd + '/mergedTiles/' + fd)
                    except:
                        pass
            #read information from listFile file to get names of .hdf files
            def getFileList(num, wd):
                #try reading file for every data product, if not exist just return empty list
                try:
                    listfileMOD2 = open(wd + '/listfileMOD11A'+ num +'.006.txt')
                    listfileMOD = listfileMOD2.read().replace("\n" , ",").split(',')
                    listfileMOD2.close()
                    del listfileMOD[-1]
                except:
                    listfileMOD = []
                try:
                    listfileMYD2 = open(wd + '/listfileMYD11A'+num+'.006.txt')
                    listfileMYD = listfileMYD2.read().replace("\n" , ",").split(',')
                    listfileMYD2.close()
                    del listfileMYD[-1]
                except:
                    listfileMYD = []
                #merge both lists
                listfileMOD = [s for s in listfileMOD if s.endswith('.hdf')]
                listfileMYD = [s for s in listfileMYD if s.endswith('.hdf')]
                listFile = listfileMOD + listfileMYD
                return listFile
            ##################################################################
            ##################################################################
            ##################################################################
            #depending on the input, tiles can have different datatypes, 
            #coerce them to list
            if type(tiles) == tuple:
                tiles = list(tiles)
            elif type(tiles) == list:
                tiles = tiles
            elif type(tiles) == str:
                tiles = list([tiles])
            else:
                tiles = tiles
            
            
            #depending on how many tiles we want to download, download files
            for Tile in tiles:
                if MOD == True:
                    #MOD11A2 ADDDDDDDD
                    '''FOR MODIS TERRA SATALLITE''' 
                    download('MOLT', 'MOD11'+product, Tile, wd, today, enddate, user, password)
                if MYD == True:
                    #MYD11A2 ADDDDDDDDD
                    '''FOR MODIS AQUA'''
                    download('MOLA', 'MYD11'+product, Tile, wd, today, enddate, user, password)
                if MYD == False and MOD == False:
                    #if no input in CheckBoxes was given, push message
                    self.iface.messageBar().pushMessage(
                    "Missing input", "Must select TERRA and/or AQUA satellite ",
                    level=Qgis.Critical, duration=3)
            
                ##############################################################
                #depending on product type get lists with filenames
                if product == 'A2.006':
                    listFile = getFileList('2', wd)
                if product == 'A1.006':
                    listFile = getFileList('1', wd)
            
               ###############################################################
                # for every file in list, get arrays for night and day and write them to tiff
                for f in range(len(listFile)):
            
                    ##########################################################
                    array_day, band_ds, band_path = get_data(wd, listFile, f, int_key=0, kind_str='LST_day')
                    #array_day = get_data(int_key=0, kind_str='LST_day')
                    to_tiff(array_day, band_path, band_ds)
            
                    array_night, band_ds, band_path = get_data(wd, listFile, f, int_key=4, kind_str='LST_night')
                    to_tiff(array_night, band_path, band_ds) 
                ###############################################################
            del listFile, MOD, MYD, tiles
            del password, user

            ###################################################################
            # merge tiles
            ###################################################################
            # /unmergedTiles directory back to original wd
            wd = wd[:-14]
            # Define directories for merged Tiles
            Path(wd+"/mergedTiles").mkdir(parents=True, exist_ok=True)
            out_dir = wd + '/mergedTiles/'
            
            # Get tif files in wd
            tile_list = glob.glob(wd+'/unmergedTiles' + '/*LST_*.tiff')
            
            #get sublists and zip to get unique merged- filenames
            str_start = [s.split('\\')[1][:17] for s in tile_list]
            str_end = [s.split('\\')[1].split('_')[1] for s in tile_list]
            res = np.unique([i + j for i, j in zip(str_start, str_end)])
            
            #https://stackoverflow.com/questions/1124810/how-can-i-find-path-to-given-file
            #get username of this PC
            getuser = getpass.getuser()
            #get current path where plugin is installed
            py = 'MODIS.py'
            for root, dirs, files in os.walk(r'C:/Users/'+getuser+'/AppData/Roaming/QGIS/QGIS3/profiles'):
                for name in files:
                    if name == py:
                        pluginPath = os.path.abspath(os.path.join(root, name))
            pluginPath = pluginPath.replace("\\", "/")[:-9]
            #set this path as current wd to enable gdal_merge.py to be found
            os.chdir(pluginPath)
            #merge files with same tilename
            for label in res: 
                files = [wd+'/unmergedTiles/' + s.split('\\')[1] for s in tile_list if s.endswith(label[17:]) and s.split('\\')[1][:17] == label[:17]]
                out_path = out_dir + label
                cmd = 'python ' + "gdal_merge.py" +' -co COMPRESSED=YES'+ ' -o' + ' ' + out_path + ' ' + '-of gtiff ' + " ".join(files)
                output = subprocess.check_output(cmd)
                
            #Delete Loop Variables
            del cmd, output, out_path, label, files 
            
            # Delete the other Variables
            del str_start,str_end, res, out_dir, tile_list
            
            
            ###################################################################
            #MEAN of oneday files: night, all and day
            ###################################################################
            '''define fun to make a list_stack of all files in list, get mean 
            array from stack and write to tiff'''
            def mean(liste, add, suffix):
                list_stack = []
                for i in liste:
                    ds = gdal.Open(wd_mer + i)
                    bounds = ds.GetGeoTransform()
                    myarray = np.array(ds.GetRasterBand(1).ReadAsArray())
                    ds = None
                    list_stack.append(myarray)
            
                mean = np.nanmean(list_stack, axis=0)
                mean = mean.astype(float)
                out_ds = gdal.GetDriverByName('GTiff').Create(wd_mer+add+ enddate+'_'+today+suffix+'.tiff'.replace(' ', ''),
                                                          mean.shape[1],
                                                          mean.shape[0],
                                                          1,
                                                          gdal.GDT_Float32,
                                                          ['COMPRESS=LZW', 'TILED=YES'])
                proj = 'PROJCS["unnamed",GEOGCS["Unknown datum based upon the custom spheroid",DATUM["Not_specified_based_on_custom_spheroid",SPHEROID["Custom spheroid",6371007.181,0]],PRIMEM["Greenwich",0],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]]],PROJECTION["Sinusoidal"],PARAMETER["longitude_of_center",0],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["Meter",1],AXIS["Easting",EAST],AXIS["Northing",NORTH]]'
                out_ds.SetGeoTransform(bounds)
                out_ds.SetProjection(proj)
                out_ds.GetRasterBand(1).WriteArray(mean)
                out_ds.FlushCache()
                out_ds = None  #close dataset to write to disc
                return list_stack, mean
            '''create .tiff to output file with percentage of existing pixel 
            values which are not NAN'''
            def sum_tiff(liste, index, add, suffix):
                for i in liste:
                    i[i > 0] = 1
                summ = np.nansum(liste,0)/len(liste)*100#count existance of values
                ds = gdal.Open(wd_mer + list_sum[index])###
                bounds = ds.GetGeoTransform()
                ds = None
                out_ds = gdal.GetDriverByName('GTiff').Create(wd_mer+'COUNT_VALUE_%_'+add+ enddate +'_'+ today+suffix+'.tiff',#suffix from lineEdit
                                                              summ.shape[1],
                                                              summ.shape[0],
                                                              1,
                                                              gdal.GDT_Float32,
                                                              ['COMPRESS=LZW', 'TILED=YES'])
                proj = 'PROJCS["unnamed",GEOGCS["Unknown datum based upon the custom spheroid",DATUM["Not_specified_based_on_custom_spheroid",SPHEROID["Custom spheroid",6371007.181,0]],PRIMEM["Greenwich",0],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]]],PROJECTION["Sinusoidal"],PARAMETER["longitude_of_center",0],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["Meter",1],AXIS["Easting",EAST],AXIS["Northing",NORTH]]'
                out_ds.SetGeoTransform(bounds)
                out_ds.SetProjection(proj)
                out_ds.GetRasterBand(1).WriteArray(summ)
                out_ds.FlushCache()
                out_ds = None
            #all merging is only happening if downloaded data is 1km1day type   
            if product == 'A1.006':
                wd_mer = wd + '/mergedTiles/'
                #make a subset of all files we want to have mean from
                list_mean = os.listdir(wd_mer)
                list_mean = [i for i in list_mean if i.endswith('night.tiff') or i.endswith('day.tiff')]
                list_mean_night = [i for i in list_mean if i.endswith('night.tiff')]
                list_mean_day = [i for i in list_mean if i.endswith('day.tiff')]
            
                #all mean
                list_stack_all, mean_all = mean(liste = list_mean, add = 'MEANall_stacked' , suffix=suffix)
                #night mean
                list_stack_night, mean_night = mean(liste = list_mean_night, add = 'MEANnight_', suffix=suffix)
                #day mean
                list_stack_day, mean_day = mean(liste= list_mean_day, add = 'MEANday_', suffix=suffix)
                
                ####calculate mean from day and night mean####similar as in function "mean"
                list_stacky = []
                #make a stack from "mean" function returned arrays night and day mean
                list_stacky.append(mean_night)
                list_stacky.append(mean_day)
                #mean of means (for more exact results)
                mean_all = np.nanmean(list_stacky, axis=0)
                mean_all = mean_all.astype(float)
                #write new mean to tiff
                out_ds = gdal.GetDriverByName('GTiff').Create(wd_mer+'MEANdayNight(morePrecise)'+ enddate+'_'+today+suffix+'.tiff'.replace(' ', ''),
                                                          mean_all.shape[1],
                                                          mean_all.shape[0],
                                                          1,
                                                          gdal.GDT_Float32,
                                                          ['COMPRESS=LZW', 'TILED=YES'])
                proj = 'PROJCS["unnamed",GEOGCS["Unknown datum based upon the custom spheroid",DATUM["Not_specified_based_on_custom_spheroid",SPHEROID["Custom spheroid",6371007.181,0]],PRIMEM["Greenwich",0],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]]],PROJECTION["Sinusoidal"],PARAMETER["longitude_of_center",0],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["Meter",1],AXIS["Easting",EAST],AXIS["Northing",NORTH]]'
                ds = gdal.Open(wd_mer + list_mean[0])
                bounds = ds.GetGeoTransform()
                out_ds.SetGeoTransform(bounds)
                out_ds.SetProjection(proj)
                out_ds.GetRasterBand(1).WriteArray(mean_all)
                out_ds.FlushCache()
                del ds, bounds, proj, mean_all, list_stacky
                out_ds = None
                ################################################################
                '''count appearance of values frequency of values which are not 
                nan per pixel in percent'''
                ################################################################
                
                #get all MEAN files for spatial information inm sum_tiff function
                list_sum = os.listdir(wd_mer)
                list_sum = [i for i in list_sum if i[0:4] == 'MEAN' and i.endswith(suffix+'.tiff')]
            
                sum_tiff(liste = list_stack_all, index = 0, add = 'all', suffix=suffix)
                sum_tiff(liste = list_stack_day, index = 1, add = 'day', suffix=suffix)
                sum_tiff(liste = list_stack_night, index = 2, add = 'night', suffix=suffix)   
                
            #delete everything in 1km1day what litters your memory
            #delete all unneccessary files 
            
            if delete == True and product == 'A1.006':
                delete_down(wd)
    
            if delete == True and product == 'A2.006':
                listdir_8 = os.listdir(wd+ '/unmergedTiles')
                listdir_8 = [o for o in listdir_8 if o.endswith('.hdf') or o.endswith('.xml') or o.endswith('.txt') or o.endswith('.log')] 
                # get list of all .hdf, .xml, .log and .txt in folder
                #try to delete all files if error raises pass
                for fd in listdir_8:
                    try:
                        os.remove(wd + '/unmergedTiles/' + fd)
                    except:
                        pass
            
            del product
# =============================================================================
#             wd_to_tif = wd + '/mergedTiles'
#             wd_to_tif = [x for x in os.listdir(wd_to_tif) if x.startswith('MEAN') or x.startswith('COUNT')]
# 
# =============================================================================
            # addLayer doesn't work because of unknown error
# =============================================================================
#             for layer in wd_to_tif:
#                 rlayer = QgsRasterLayer(layer, layer[-52:].split('/')[1])
#                 if not rlayer.isValid():
#                     print("Layer"+layer[-52:].split('/')[1]+ "failed to load!")
#                 self.iface.addRasterLayer(layer, layer[-52:].split('/')[1]) 
# =============================================================================
                
            self.iface.messageBar().pushMessage(
            "Success", "Output files written at " + wd,
            level=Qgis.Success, duration=3)
            del wd