from qgis.core import QgsProcessingProvider, QgsApplication
from qgis.PyQt.QtGui import QIcon
import os

class MobiVistaFacebookMobility2Provider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'mobivista_facebook_mobility2'

    def name(self):
        return self.tr('Meta Mobility Analyzer')

    def icon(self):
        path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(path)

    def loadAlgorithms(self):
        from .algorithms.mobivista_facebook_mobility2 import MobiVistaFacebookMobility2
        self.addAlgorithm(MobiVistaFacebookMobility2())

