# --------------------------------------------------------
#    mmqgis_menu - QGIS plugins menu class
#
#    begin                : August 5, 2009
#    copyright            : (c) 2009 - 2012 by Michael Minn
#    email                : See michaelminn.com
#
#   MMQGIS is free software and is offered without guarantee
#   or warranty. You can redistribute it and/or modify it 
#   under the terms of version 2 of the GNU General Public 
#   License (GPL v2) as published by the Free Software 
#   Foundation (www.gnu.org).
# --------------------------------------------------------

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

from mmqgis_dialogs import *

# ---------------------------------------------

class mmqgis_menu:
	def __init__(self, iface):
		self.iface = iface

	def initGui(self):
		# Animate Submenu
		self.animate_menu = QMenu(QCoreApplication.translate("mmqgis", "&Animate"))
		self.iface.addPluginToMenu("&mmqgis", self.animate_menu.menuAction())

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_animate_columns.png")
		self.animate_columns_action = QAction(icon, "Animate Columns", self.iface.mainWindow())
		QObject.connect(self.animate_columns_action, SIGNAL("triggered()"), self.animate_columns)
		self.animate_menu.addAction(self.animate_columns_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_animate_rows.png")
		self.animate_rows_action = QAction(icon, "Animate Rows", self.iface.mainWindow())
		QObject.connect(self.animate_rows_action, SIGNAL("triggered()"), self.animate_rows)
		self.animate_menu.addAction(self.animate_rows_action)


		# Create Submenu
		self.create_menu = QMenu(QCoreApplication.translate("mmqgis", "&Create"))
		self.iface.addPluginToMenu("&mmqgis", self.create_menu.menuAction())

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_grid.png")
		self.grid_action = QAction(icon, "Create Grid Layer", self.iface.mainWindow())
		QObject.connect(self.grid_action, SIGNAL("triggered()"), self.grid)
		self.create_menu.addAction(self.grid_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_label.png")
		self.label_action = QAction(icon, "Create Label Layer", self.iface.mainWindow())
		QObject.connect(self.label_action, SIGNAL("triggered()"), self.label)
		self.create_menu.addAction(self.label_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_hub_distance.png")
		self.hub_distance_action = QAction(icon, "Hub Distance", self.iface.mainWindow())
		QObject.connect(self.hub_distance_action, SIGNAL("triggered()"), self.hub_distance)
		self.create_menu.addAction(self.hub_distance_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_hub_distance.png")
		self.hub_lines_action = QAction(icon, "Hub Lines", self.iface.mainWindow())
		QObject.connect(self.hub_lines_action, SIGNAL("triggered()"), self.hub_lines)
		self.create_menu.addAction(self.hub_lines_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_voronoi.png")
		self.voronoi_action = QAction(icon, "Voronoi Diagram", self.iface.mainWindow())
		QObject.connect(self.voronoi_action, SIGNAL("triggered()"), self.voronoi)
		self.create_menu.addAction(self.voronoi_action)


		# Modify Submenu
		self.modify_menu = QMenu(QCoreApplication.translate("mmqgis", "&Modify"))
		self.iface.addPluginToMenu("&mmqgis", self.modify_menu.menuAction())

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_color_map.png")
		self.color_map_action = QAction(icon, "Color Map", self.iface.mainWindow())
		QObject.connect(self.color_map_action, SIGNAL("triggered()"), self.color_map)
		self.modify_menu.addAction(self.color_map_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_attribute_export.png")
		self.geometry_convert_action = QAction(icon, "Convert Geometry Type", self.iface.mainWindow())
		QObject.connect(self.geometry_convert_action, SIGNAL("triggered()"), self.geometry_convert)
		self.modify_menu.addAction(self.geometry_convert_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_attribute_join.png")
		self.delete_columns_action = QAction(icon, "Delete Column(s)", self.iface.mainWindow())
		QObject.connect(self.delete_columns_action, SIGNAL("triggered()"), self.delete_columns)
		self.modify_menu.addAction(self.delete_columns_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_attribute_join.png")
		self.delete_duplicate_action = QAction(icon, "Delete Duplicate Geometries", self.iface.mainWindow())
		QObject.connect(self.delete_duplicate_action, SIGNAL("triggered()"), self.delete_duplicate_geometries)
		self.modify_menu.addAction(self.delete_duplicate_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_float_to_text.png")
		self.float_to_text_action = QAction(icon, "Float to Text", self.iface.mainWindow())
		QObject.connect(self.float_to_text_action, SIGNAL("triggered()"), self.float_to_text)
		self.modify_menu.addAction(self.float_to_text_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_gridify.png")
		self.gridify_action = QAction(icon, "Gridify", self.iface.mainWindow())
		QObject.connect(self.gridify_action, SIGNAL("triggered()"), self.gridify)
		self.modify_menu.addAction(self.gridify_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_sort.png")
		self.sort_action = QAction(icon, "Sort", self.iface.mainWindow())
		QObject.connect(self.sort_action, SIGNAL("triggered()"), self.sort)
		self.modify_menu.addAction(self.sort_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_text_to_float.png")
		self.text_to_float_action = QAction(icon, "Text to Float", self.iface.mainWindow())
		QObject.connect(self.text_to_float_action, SIGNAL("triggered()"), self.text_to_float)
		self.modify_menu.addAction(self.text_to_float_action)


		# Transfer Submenu
		self.transfer_menu = QMenu(QCoreApplication.translate("mmqgis", "&Transfer"))
		self.iface.addPluginToMenu("&mmqgis", self.transfer_menu.menuAction())

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_attribute_export.png")
		self.attribute_export_action = QAction(icon, "Attributes Export to CSV File", self.iface.mainWindow())
		QObject.connect(self.attribute_export_action, SIGNAL("triggered()"), self.attribute_export)
		self.transfer_menu.addAction(self.attribute_export_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_attribute_join.png")
		self.attribute_join_action = QAction(icon, "Attributes Join from CSV File", self.iface.mainWindow())
		QObject.connect(self.attribute_join_action, SIGNAL("triggered()"), self.attribute_join)
		self.transfer_menu.addAction(self.attribute_join_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_attribute_export.png")
		self.geometry_export_action = QAction(icon, "Geometry Export to CSV File", self.iface.mainWindow())
		QObject.connect(self.geometry_export_action, SIGNAL("triggered()"), self.geometry_export)
		self.transfer_menu.addAction(self.geometry_export_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_attribute_join.png")
		self.geometry_import_action = QAction(icon, "Geometry Import from CSV File", self.iface.mainWindow())
		QObject.connect(self.geometry_import_action, SIGNAL("triggered()"), self.geometry_import)
		self.transfer_menu.addAction(self.geometry_import_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_geocode_google.png")
		self.geocode_google_action = QAction(icon, "Geocode CSV with Google", self.iface.mainWindow())
		QObject.connect(self.geocode_google_action, SIGNAL("triggered()"), self.geocode_google)
		self.transfer_menu.addAction(self.geocode_google_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_geocode_street_layer.png")
		self.geocode_street_layer_action = QAction(icon, "Geocode from Street Layer", self.iface.mainWindow())
		QObject.connect(self.geocode_street_layer_action, SIGNAL("triggered()"), self.geocode_street_layer)
		self.transfer_menu.addAction(self.geocode_street_layer_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_merge.png")
		self.merge_action = QAction(icon, "Merge Layers", self.iface.mainWindow())
		QObject.connect(self.merge_action, SIGNAL("triggered()"), self.merge)
		self.transfer_menu.addAction(self.merge_action)

		icon = QIcon(os.path.dirname(__file__) + "/icons/mmqgis_select.png")
		self.select_action = QAction(icon, "Select", self.iface.mainWindow())
		QObject.connect(self.select_action, SIGNAL("triggered()"), self.select)
		self.transfer_menu.addAction(self.select_action)



	def unload(self):
		self.iface.removePluginMenu("&mmqgis", self.create_menu.menuAction())
		self.iface.removePluginMenu("&mmqgis", self.modify_menu.menuAction())
		self.iface.removePluginMenu("&mmqgis", self.transfer_menu.menuAction())

	def animate_columns(self):
		dialog = mmqgis_animate_columns_dialog(self.iface)
		dialog.exec_()

	def animate_rows(self):
		dialog = mmqgis_animate_rows_dialog(self.iface)
		dialog.exec_()

	def attribute_export(self):
		dialog = mmqgis_attribute_export_dialog(self.iface)
		dialog.exec_()

	def attribute_join(self):
		dialog = mmqgis_attribute_join_dialog(self.iface)
		dialog.exec_()

	def color_map(self):
		dialog = mmqgis_color_map_dialog(self.iface)
		dialog.exec_()

	def delete_columns(self):
		dialog = mmqgis_delete_columns_dialog(self.iface)
		dialog.exec_()

	def delete_duplicate_geometries(self):
		dialog = mmqgis_delete_duplicate_dialog(self.iface)
		dialog.exec_()

	def float_to_text(self):
		dialog = mmqgis_float_to_text_dialog(self.iface)
		dialog.exec_()

	def geocode_google(self):
		dialog = mmqgis_geocode_google_dialog(self.iface)
		dialog.exec_()

	def geometry_convert(self):
		dialog = mmqgis_geometry_convert_dialog(self.iface)
		dialog.exec_()

	def geometry_export(self):
		dialog = mmqgis_geometry_export_dialog(self.iface)
		dialog.exec_()

	def geometry_import(self):
		dialog = mmqgis_geometry_import_dialog(self.iface)
		dialog.exec_()

	def grid(self):
		dialog = mmqgis_grid_dialog(self.iface)
		dialog.exec_()

	def gridify(self):
		dialog = mmqgis_gridify_dialog(self.iface)
		dialog.exec_()

	def hub_distance(self):
		dialog = mmqgis_hub_distance_dialog(self.iface)
		dialog.exec_()

	def hub_lines(self):
		dialog = mmqgis_hub_lines_dialog(self.iface)
		dialog.exec_()

	def label(self):
		dialog = mmqgis_label_dialog(self.iface)
		dialog.exec_()

	def merge(self):
		dialog = mmqgis_merge_dialog(self.iface)
		dialog.exec_()

	def select(self):
		dialog = mmqgis_select_dialog(self.iface)
		dialog.exec_()

	def sort(self):
		dialog = mmqgis_sort_dialog(self.iface)
		dialog.exec_()

	def geocode_street_layer(self):
		dialog = mmqgis_geocode_street_layer_dialog(self.iface)
		dialog.exec_()

	def text_to_float(self):
		dialog = mmqgis_text_to_float_dialog(self.iface)
		dialog.exec_()

	def voronoi(self):
		dialog = mmqgis_voronoi_dialog(self.iface)
		dialog.exec_()

