# -*- coding: utf-8 -*-
"""
/***************************************************************************
 mLasMediaDialog
                                 A QGIS plugin
 Wtyczka pozwalająca wyświetlić pomiary wyeksportowane za pomocą aplikacji mLas.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-06-15
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Katarzyna Kucharczyk Taxus IT sp. z o. o.
        email                : taxus@taxusit.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import zipfile
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5 import QtGui
from qgis.utils import iface
from qgis.core import QgsApplication, QgsProject, QgsVectorLayer, QgsWkbTypes


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'mlasmedia_dialog_base.ui'))


class mLasMediaDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(mLasMediaDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap(":/plugins/mlasmedia/icons/wybor_pliku.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.setWindowIcon(icon)
        self.button_box.clicked.connect(self.on_bb_accepted)

    def on_bb_accepted(self):

        # getting zip directory
        zip_path = self.fwZipFile.filePath()
        if not os.path.isfile(zip_path):
            iface.messageBar().pushMessage("Info", "Brak ścieżki do folderu zip.", level=0)
            return

        # creating directory for unzipped files
        path = os.path.splitext(zip_path)[0]
        os.makedirs(path, exist_ok=True)

        # unzipping zip
        with zipfile.ZipFile(zip_path, 'r') as zip_ref:
            zip_ref.extractall(path)

        # creating group of layers named as zip
        root = QgsProject.instance().layerTreeRoot()
        group = root.addGroup(os.path.basename(path))

        # loading all layers to group
        for file in os.listdir(path):
            if file.endswith(".shp"):
                full_path = os.path.join(path, file)

                # creating coding file - mLas's layers are in WINDOWS-1250
                if not os.path.isfile(os.path.splitext(full_path)[0] + ".cpg"):
                    with open(os.path.splitext(full_path)[0] + ".cpg", "w", encoding="ascii") as f:
                        f.write("WINDOWS-1250")

                # adding layer to map
                layer = QgsVectorLayer(full_path, os.path.splitext(file)[0], "ogr")
                if layer.isValid():
                    QgsProject.instance().addMapLayer(layer, False)
                    group.addLayer(layer)

                    # adding style (not working!)
                    style_path = os.path.join(path, os.path.splitext(file)[0] + ".sld")
                    if os.path.isfile(style_path):
                        layer.loadNamedStyle(style_path)

                    # adding default style - differencing objects with and without multimedia
                    user_directory = QgsApplication.qgisSettingsDirPath()
                    if self.cbDefaultStyle.isChecked():
                        if layer.geometryType() == QgsWkbTypes.PointGeometry:
                            layer.loadNamedStyle(os.path.join(user_directory, 'python/plugins/mlasmedia/style/punkt.qml'))
                        elif layer.geometryType() == QgsWkbTypes.LineGeometry:
                            layer.loadNamedStyle(os.path.join(user_directory, 'python/plugins/mlasmedia/style/linia.qml'))
                        elif layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                            layer.loadNamedStyle(os.path.join(user_directory, 'python/plugins/mlasmedia/style/poligon.qml'))

                    layer.triggerRepaint()
                    iface.layerTreeView().refreshLayerSymbology(layer.id())

        iface.mapCanvas().refresh()
        self.close()



