# -*- coding: utf-8 -*-
"""
/***************************************************************************
 mLasMediaDialog
                                 A QGIS plugin
 Wtyczka pozwalająca wyświetlić pomiary wyeksportowane za pomocą aplikacji mLas.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-06-15
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Katarzyna Kucharczyk Taxus IT sp. z o. o.
        email                : taxus@taxusit.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import subprocess
import platform
from functools import partial
from PyQt5.QtCore import Qt
from PyQt5 import QtGui
from qgis.utils import iface
from qgis.gui import QgsMapToolIdentify, QgsHighlight
from qgis.core import QgsApplication
from PyQt5.QtWidgets import QTabWidget, QPushButton, QVBoxLayout, QDockWidget, QWidget, QHBoxLayout, QLabel, QGraphicsPixmapItem


class mLasMediaIdentifyOutput(QDockWidget):
    def __init__(self, results):
        self.highlights = [None for _ in results]
        self.tab_list = [result.mFeature.geometry() for result in results]
        self.layer = results[0].mLayer
        super().__init__("Identyfikacja obiektów mLas")
        self.setAllowedAreas(Qt.LeftDockWidgetArea | Qt.RightDockWidgetArea)
        self.setFloating(True)
        self.tab_widget = QTabWidget()
        self.tab_widget.currentChanged.connect(self.on_tab_changed)

        for i, result in enumerate(results):
            self.layer = result.mLayer
            feature = result.mFeature

            widget = QWidget()
            self.layout = QVBoxLayout()

            # adding layout for layer name
            self.layout_layer = QHBoxLayout()
            self.label_layer = QLabel("Warstwa: " + self.layer.name())
            self.label_layer.setTextInteractionFlags(Qt.TextSelectableByMouse)
            self.layout_layer.addWidget(self.label_layer)

            # adding layout for attributes
            self.layout_attr = QHBoxLayout()
            self.label_key = QLabel("Atrybuty kod")
            self.label_key.setTextInteractionFlags(Qt.TextSelectableByMouse)
            self.label_value = QLabel("Atrybuty wartość")
            self.label_value.setTextInteractionFlags(Qt.TextSelectableByMouse)
            self.layout_attr.addWidget(self.label_key)
            self.layout_attr.addWidget(self.label_value)

            text_k = '\n'.join(field.name() for field in feature.fields())
            text_v = '\n'.join(str(val) for val in feature.attributes())
            self.label_key.setText(text_k)
            self.label_value.setText(text_v)

            # adding layout for multimedia buttons
            self.layout_media = QHBoxLayout()

            # getting variables to create paths to multimedia folders
            layer_path = os.path.dirname(self.layer.source().split("|")[0])
            layer_name = self.layer.name().replace(".shp", "")

            if 'guid' in feature.fields().names():
                guid = feature['guid']

                # adding multimedia buttons
                if 'photos' in feature.fields().names():
                    if str(feature.attribute('photos')) != 'NULL' and str(feature.attribute('photos')) != '0':
                        button_photo = QPushButton("Zdjęcia")
                        button_photo.setIcon(QtGui.QIcon(":/plugins/mlasmedia/icons/photo.png"))
                        self.layout_media.addWidget(button_photo)
                        path_p = os.path.join(layer_path, 'media', layer_name, 'photos', guid)
                        button_photo.clicked.connect(partial(self.open_folder, path_p))

                if 'movies' in feature.fields().names():
                    if str(feature.attribute('movies')) != 'NULL' and str(feature.attribute('movies')) != '0':
                        button_movie = QPushButton("Filmy")
                        button_movie.setIcon(QtGui.QIcon(":/plugins/mlasmedia/icons/movie.png"))
                        self.layout_media.addWidget(button_movie)
                        path_m = os.path.join(layer_path, 'media', layer_name, 'movies', guid)
                        button_movie.clicked.connect(partial(self.open_folder, path_m))

                if 'records' in feature.fields().names():
                    if str(feature.attribute('records')) != 'NULL' and str(feature.attribute('records')) != '0':
                        button_record = QPushButton("Dźwięki")
                        button_record.setIcon(QtGui.QIcon(":/plugins/mlasmedia/icons/record.png"))
                        self.layout_media.addWidget(button_record)
                        path_r = os.path.join(layer_path, 'media', layer_name, 'records', guid)
                        button_record.clicked.connect(partial(self.open_folder, path_r))

            # adding all layouts to tab
            self.layout.addLayout(self.layout_layer)
            self.layout.addLayout(self.layout_attr)
            self.layout.addLayout(self.layout_media)
            widget.setLayout(self.layout)
            self.tab_widget.addTab(widget, f"Obiekt {i + 1}")
        self.setWidget(self.tab_widget)

    def open_folder(self, path):
        # method for opening folders on different platforms
        if platform.system() == "Windows":
            os.startfile(path)
        elif platform.system() == "Darwin":  # macOS
            subprocess.Popen(["open", path])
        else:  # Linux
            subprocess.Popen(["xdg-open", path])

    def on_tab_changed(self, index):
        # method for changing tab on widget and highlighting object from active tab
        for h in self.highlights:
            if h:
                h.hide()
        if index < len(self.tab_list):
            h = QgsHighlight(iface.mapCanvas(), self.tab_list[index], self.layer)
            h.setColor(QtGui.QColor("red"))
            h.setWidth(2)
            h.show()
            self.highlights[index] = h

    def closeEvent(self, event):
        # method for closing widget and hiding highlights
        for h in self.highlights:
            if h:
                h.hide()
        event.accept()


class mLasMediaIdentify(QgsMapToolIdentify):
    def __init__(self, iface):
        """Constructor."""
        super().__init__(iface.mapCanvas())
        self.iface = iface
        self.canvas = iface.mapCanvas()
        self.setCursor(Qt.CrossCursor)
        self.tooltip = None
        self.dock = None

    def canvasMoveEvent(self, event):
        # method for moving mouse over objects

        # identifying on all layers
        results = self.identify(event.x(), event.y(), self.canvas.layers(), self.TopDownAll)
        if results:
            for result in results:
                layer = result.mLayer
                feature = result.mFeature

                # showing multimedia tooltip
                filed_list = [f.name() for f in layer.fields()]
                if "photos" in filed_list or "movies" in filed_list or "records" in filed_list:
                    if ((str(feature.attribute('photos')) != 'NULL' and str(feature.attribute('photos')) != '0') or
                            (str(feature.attribute('movies')) != 'NULL' and str(feature.attribute('movies')) != '0') or
                            (str(feature.attribute('records')) != 'NULL' and str(feature.attribute('records')) != '0')):
                        self.show_tooltip(event.pos())
        else:
            self.hide_tooltip()

    def canvasReleaseEvent(self, event):
        # method for clicking on objects

        # closing old dock
        if self.dock is not None:
            for h in self.dock.highlights:
                if h:
                    h.hide()
            self.dock.close()
            self.dock = None

        # identifying on all layers
        results = self.identify(event.x(), event.y(), self.canvas.layers(), self.TopDownAll)
        if results:
            # creating dock with output
            self.dock = mLasMediaIdentifyOutput(results)
            iface.addDockWidget(Qt.RightDockWidgetArea, self.dock)
            self.dock.show()
        else:
            iface.messageBar().pushMessage("Info", "Nie znaleziono obiektów.", level=0)

    def show_tooltip(self, pos):
        # method for showing multimedia tooltip
        if self.tooltip is None:
            user_directory = QgsApplication.qgisSettingsDirPath()
            multi_path = os.path.join(user_directory, 'python/plugins/mlasmedia/icons/media.png')
            multi_uri = multi_path.replace("\\", "/")
            pixmap = QtGui.QPixmap(multi_uri).scaled(40, 40, Qt.KeepAspectRatio, Qt.SmoothTransformation)
            self.tooltip = QGraphicsPixmapItem(pixmap)
            self.tooltip.setZValue(1000)
            self.tooltip.setAcceptedMouseButtons(Qt.NoButton)
            self.canvas.scene().addItem(self.tooltip)

        self.tooltip.setPos(pos)

    def hide_tooltip(self):
        # method for hiding multimedia tooltip
        if self.tooltip:
            self.canvas.scene().removeItem(self.tooltip)
            self.tooltip = None
