# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mineral_Exploration_Web_Services
                                 A QGIS plugin
 This plugin connects your QGIS User Profile to many openly hosted web services related to mineral exploration. These include Country and State geological surveys that provide mapped geology and data such as mineral occurence locations, geophysics, geochemistry etc.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-13
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Jack Maughan
        email                : jack_maughan@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, qVersion
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QWidget
from qgis.core import QgsProject, Qgis
from qgis.utils import iface
from .web_services_list import select_all_connections

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the dialog
from .Mineral_Exploration_Web_Services_dialog import Mineral_Exploration_Web_ServicesDialog
import os.path


class Mineral_Exploration_Web_Services:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Mineral_Exploration_Web_Services_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Mineral Exploration Web Services')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Mineral_Exploration_Web_Services', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Mineral_Exploration_Web_Services/icon2.png'
        icon_path =  f'{self.plugin_dir}/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Connect to Servers'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Mineral Exploration Web Services'),
                action)
            self.iface.removeToolBarIcon(action)


    

    def connect_all(self):
        """
        This script should be run from the Python consol inside QGIS.

        It adds online sources to the QGIS Browser.
        Each source should contain a list with the folowing items (string type):
        [sourcetype, title, authconfig, password, referer, url, username, zmax, zmin]

        You can add or remove sources from the sources section of the code.

        Script by Klas Karlsson
        Sources from https://qms.nextgis.com/

        Some services require you to supply your own API key for the services to work.

        Licence GPL-3

        Regarding the terms of use for these background maps YOU will need to verify that you
        follow the individual EULA that comes with the different services,
        Most likely they will restrict how you can use the data.
        Example:
        For Esri basemaps you will need a valid ArcGIS online subscription to use the maps.

        """

        sources = select_all_connections()

        # Add sources to browser
        for source in sources:
            connectionType = source[0]
            connectionName = source[1]
            
            QSettings().setValue("qgis/%s/%s/authcfg" % (connectionType, connectionName), source[2])
            QSettings().setValue("qgis/%s/%s/password" % (connectionType, connectionName), source[3])
            QSettings().setValue("qgis/%s/%s/referer" % (connectionType, connectionName), source[4])
            QSettings().setValue("qgis/%s/%s/url" % (connectionType, connectionName), source[5])
            QSettings().setValue("qgis/%s/%s/username" % (connectionType, connectionName), source[6])
            QSettings().setValue("qgis/%s/%s/zmax" % (connectionType, connectionName), source[7])
            QSettings().setValue("qgis/%s/%s/zmin" % (connectionType, connectionName), source[8])
            
        self.iface.reloadConnections()


    def remove_all(self):
        "Removes all the services in the above list"
        self.iface.reloadConnections()
        sources = select_all_connections()
        
        # Loop through sources
        for source in sources:
            #Get connection name
            connectionName = source[1]
            
            #from all the keys find the specific one
            allkeys = QSettings().allKeys()
            specific_keys = [key for key in allkeys if connectionName in key]

            #allkeys = [key for key in QSettings().allKeys() if 'connections' in key]
            #specific_key = [key for key in allkeys if connectionName == key.split(r'/')[2]]
            #keysplit = [key.split(r'/')[2] for key in allkeys if 'connections' in key]
            
            if len(specific_keys) > 0:
                for specific_key in specific_keys:
                    QSettings().remove(specific_key)
        self.iface.reloadConnections()

        # Update GUI
        # self.iface.reloadConnections()
        self.iface.browserModel().reload()

    def run(self):
        """Run method that performs all the real work"""
        
        self.iface.reloadConnections()

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Mineral_Exploration_Web_ServicesDialog()

            # Connect buttons to their respective functions
            self.dlg.ConnectButton.clicked.connect(self.on_connect_button_clicked)
            self.dlg.RemoveButton.clicked.connect(self.on_remove_button_clicked)
        
        # Update GUI
        self.iface.browserModel().reload()

        # show the dialog
        self.dlg.show()

    def on_connect_button_clicked(self):
        "Connect all services"
        self.connect_all()
        self.iface.messageBar().pushMessage(
            "Success", "Connected to Servers - Please Restart QGIS to see the new connections",
            level=Qgis.Success, duration=3)
        self.dlg.ConnectButton.setChecked(False)
        self.iface.reloadConnections()
        self.iface.browserModel().reload()

    def on_remove_button_clicked(self):
        "Remove all services (only works if ran twice??)"
        self.remove_all()
        # self.remove_all()
        self.iface.messageBar().pushMessage(
            "Success", "Removed Servers",
            level=Qgis.Success, duration=3)
        self.dlg.RemoveButton.setChecked(False)
        self.iface.reloadConnections()
        self.iface.browserModel().reload()