# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MINDED_FBA
                                 A QGIS plugin
 Determine the extention of flooded/burned areas
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-12
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Eduardo R. Oliveira
        email                : eduardo.oliveira@ua.pt
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from qgis.core import *
from qgis.analysis import *
from qgis import processing
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .MINDED_FBA_dialog import MINDED_FBADialog
import os.path
#Import packages for GRASSGIS
import pandas as pd
#import csv
#import grass.script as gscript
import os
import glob
import sys
import subprocess
import re
class MINDED_FBA:
    """QGIS Plugin Implementation."""
    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MINDED_FBA_{}.qm'.format(locale))
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)
        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&MINDED_FBA')
        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        #self.first_start = None
       # TODO: We are going to let the user set this up in a future iteration
      #  self.toolbar = self.iface.addToolBar(u'MINDED_FBA')
     #   self.toolbar.setObjectName(u'MINDED_FBA')
        self.first_start = None
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MINDED_FBA', message)
    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)
        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)
        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)
        self.actions.append(action)
        return action
    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        #icon_path = ':/plugins/MINDED_FBA/icon.png'
        icon_path = self.plugin_dir +'/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'MINDED_FBA'),
            callback=self.run,
            parent=self.iface.mainWindow())
        # will be set False in run()
        self.first_start = True
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&MINDED_FBA'),
                action)
            self.iface.removeToolBarIcon(action)
    def select_input0_folder(self):
        input0= QFileDialog.getExistingDirectory(None, "Select pre-event scene folder") 
        self.dlg.lin_folder0.setText(input0)
    def select_input1_folder(self):        
        input1= QFileDialog.getExistingDirectory(None, "Select post-event scene folder") 
        self.dlg.lin_folder1.setText(input1)
    def select_SARinput0_folder(self):
        SARinput0= QFileDialog.getExistingDirectory(None, "Select pre-event scene folder") 
        self.dlg.linSAR_folder0.setText(SARinput0)
    def select_SARinput1_folder(self):        
        SARinput1= QFileDialog.getExistingDirectory(None, "Select post-event scene folder") 
        self.dlg.linSAR_folder1.setText(SARinput1)
    def select_output_folder(self):
        foldername= QFileDialog.getExistingDirectory(None, "Select output folder") 
        self.dlg.lin_out.setText(foldername)
    def loadlayersbox(self):
        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        self.dlg.mcb_study.clear()
        self.dlg.mcb_water.clear() 
        self.dlg.mcb_DEM.clear() 
    # Load layers in the QComboBoxes
        for layer in layers:
            self.dlg.mcb_study.addItem(layer.name(), layer)         #0  
            self.dlg.mcb_water.addItem(layer.name(), layer)    #1
            self.dlg.mcb_DEM.addItem(layer.name(), layer)    #2
    def executeMINDED_FBA(self):
        NDVIL=[10]
        NDWIL=[10]
        MNDWIL=[10]
        NBRsL=[10]
        NBRlL=[10]
        NBR2L=[10]
        dNRPBL=[10]
        NDTIVVL=[10]
        NDTIVHL=[10]
        bin_set=self.dlg.Sp_bin.value()
        bin_n=[10]
        for a in range(1,bin_set):
            bini=int(10**(1+0.15*(a)))
            biniS1=int(10**(1+0.15*(a)))
            bin_n.append(bini)
            NDVIL.append(bini)
            NDWIL.append(bini)
            MNDWIL.append(bini)
            NBRsL.append(bini)
            NBRlL.append(bini)
            NBR2L.append(bini)
            dNRPBL.append(biniS1)
            NDTIVVL.append(biniS1)
            NDTIVHL.append(biniS1)
        NDVILBinratiod1f=[]
        NDVILBinratiod2f=[]
        NDWILBinratiod1f=[]
        NDWILBinratiod2f=[]
        MNDWILBinratiod1f=[]
        MNDWILBinratiod2f=[]
        NBRsLBinratiod1f=[]
        NBRsLBinratiod2f=[]
        NBRlLBinratiod1f=[]
        NBRlLBinratiod2f=[]
        NBR2LBinratiod1f=[]
        NBR2LBinratiod2f=[]
        dNRPBLBinratiod1f=[]
        dNRPBLBinratiod2f=[]
        NDTIVVLBinratiod1f=[]
        NDTIVVLBinratiod2f=[]       
        NDTIVHLBinratiod1f=[]
        NDTIVHLBinratiod2f=[]  
#Import pre-event SAR bands
        if (self.dlg.Cb_SAR.isChecked()):
            study = self.getlayerbyname(self.dlg.mcb_study.currentText())
            water = self.getlayerbyname(self.dlg.mcb_water.currentText())
            layersSAR = [study, water]        
            ex=layersSAR[0].extent()
            xmax = ex.xMaximum()
            ymax = ex.yMaximum()
            xmin = ex.xMinimum()
            ymin = ex.yMinimum()
            cr=QgsProject.instance().crs().authid() 
            targ_ext=str(xmin)+","+str(xmax)+","+str(ymin)+","+str(ymax)+" ["+str(cr)+"]"
            if layersSAR[0].type() == QgsMapLayer.VectorLayer:
                study_raster= self.dlg.lin_out.text()+ '/study10.tif'
                processing.run("gdal:rasterize", {'INPUT':layersSAR[0],'FIELD':'','BURN':1,'USE_Z':False,'UNITS':1,'WIDTH':10,'HEIGHT':10,'EXTENT':ex,'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':study_raster})
                study10_layer= QgsRasterLayer(study_raster,'study')
                extent=study10_layer.extent()
                width=study10_layer.width()
                height=study10_layer.height()
                layersSAR[0]=study_raster
            else:
                extent=layersSAR[0].extent()
                width=layersSAR[0].width()
                height=layersSAR[0].height()
            if layersSAR[1].type() == QgsMapLayer.VectorLayer:
                water_raster= self.dlg.lin_out.text()+ '/water10.tif'
                processing.run("gdal:rasterize", {'INPUT':layersSAR[1],'FIELD':'','BURN':1,'USE_Z':False,'UNITS':1,'WIDTH':10,'HEIGHT':10,'EXTENT':ex,'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':water_raster})
                water10_layer= QgsRasterLayer(water_raster,'water')
                layersSAR[1]=water_raster
            SARfolder0=self.dlg.linSAR_folder0.text()
            os.chdir(SARfolder0)
            bS1_0_p=glob.glob('./**/*001.tif*',  recursive = True)
            bS1_0 =os.path.abspath(bS1_0_p[0])
            bS2_0_p=glob.glob('./**/*002.tif*',  recursive = True)
            bS2_0 =os.path.abspath(bS2_0_p[0])
            VV0_proj=self.dlg.lin_out.text()+ '/VV0_proj.tiff'
            VH0_proj=self.dlg.lin_out.text()+ '/VH0_proj.tiff'
            processing.run("gdal:warpreproject", {'INPUT':bS1_0,'SOURCE_CRS':None,'TARGET_CRS':None,'RESAMPLING':0,'NODATA':None,'TARGET_RESOLUTION':None,'OPTIONS':'','DATA_TYPE':0,'TARGET_EXTENT':targ_ext,'TARGET_EXTENT_CRS':cr,'MULTITHREADING':False,'EXTRA':'','OUTPUT':VV0_proj})
            processing.run("gdal:warpreproject", {'INPUT':bS2_0,'SOURCE_CRS':None,'TARGET_CRS':None,'RESAMPLING':0,'NODATA':None,'TARGET_RESOLUTION':None,'OPTIONS':'','DATA_TYPE':0,'TARGET_EXTENT':targ_ext,'TARGET_EXTENT_CRS':cr,'MULTITHREADING':False,'EXTRA':'','OUTPUT':VH0_proj})
            S1_0  = QgsRasterLayer(VV0_proj,'S1_0')
            S2_0  = QgsRasterLayer(VH0_proj,'S2_0')
            SARfolder1=self.dlg.linSAR_folder1.text() 
            os.chdir(SARfolder1)      
            bS1_1_p=glob.glob('./**/*001.tif*',  recursive = True)
            bS1_1 =os.path.abspath(bS1_1_p[0])
            bS2_1_p=glob.glob('./**/*002.tif*',  recursive = True)   
            bS2_1 =os.path.abspath(bS2_1_p[0])
            VV1_proj=self.dlg.lin_out.text()+ '/VV1_proj.tiff'
            VH1_proj=self.dlg.lin_out.text()+ '/VH1_proj.tiff'
            processing.run("gdal:warpreproject", {'INPUT':bS1_1,'SOURCE_CRS':None,'TARGET_CRS':None,'RESAMPLING':0,'NODATA':None,'TARGET_RESOLUTION':None,'OPTIONS':'','DATA_TYPE':0,'TARGET_EXTENT':targ_ext,'TARGET_EXTENT_CRS':cr,'MULTITHREADING':False,'EXTRA':'','OUTPUT':VV1_proj})
            processing.run("gdal:warpreproject", {'INPUT':bS2_1,'SOURCE_CRS':None,'TARGET_CRS':None,'RESAMPLING':0,'NODATA':None,'TARGET_RESOLUTION':None,'OPTIONS':'','DATA_TYPE':0,'TARGET_EXTENT':targ_ext,'TARGET_EXTENT_CRS':cr,'MULTITHREADING':False,'EXTRA':'','OUTPUT':VH1_proj})
            S1_1  = QgsRasterLayer(VV1_proj,'S1_1')
            S2_1  = QgsRasterLayer(VH1_proj,'S2_1')
            #S1A difference:
            QgsProject.instance().addMapLayer(S1_0)
            QgsProject.instance().addMapLayer(S1_1)
            QgsProject.instance().addMapLayer(S2_0)
            QgsProject.instance().addMapLayer(S2_1)
            dNRPB_file = self.dlg.lin_out.text()+ '/dNRPB.tif'
            NDTIVV_file= self.dlg.lin_out.text()+ '/NDTIVV.tif'
            NDTIVH_file= self.dlg.lin_out.text()+ '/NDTIVH.tif'
            if self.dlg.Cb_flood.isChecked():
                processing.run("qgis:rastercalculator", {'EXPRESSION':'(((10*log10("S1_1@1"^2))-(10*log10("S1_0@1"^2)))/((10*log10("S1_1@1"^2))+(10*log10("S1_0@1"^2))))','LAYERS':layersSAR[0],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':NDTIVV_file})
                processing.run("qgis:rastercalculator", {'EXPRESSION':'(((10*log10("S2_1@1"^2))-(10*log10("S2_0@1"^2)))/((10*log10("S2_1@1"^2))+(10*log10("S2_0@1"^2))))','LAYERS':layersSAR[0],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':NDTIVH_file})
                processing.run("qgis:rastercalculator", {'EXPRESSION':'(((10*log10("S2_0@1"^2))-(10*log10("S1_0@1"^2)))/((10*log10("S2_0@1"^2))+(10*log10("S1_0@1"^2))))-(((10*log10("S2_1@1"^2))-(10*log10("S1_1@1"^2)))/((10*log10("S2_1@1"^2))+(10*log10("S1_1@1"^2))))','LAYERS':layersSAR[0],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':dNRPB_file})
            elif self.dlg.Cb_fire.isChecked():
                processing.run("qgis:rastercalculator", {'EXPRESSION':'(((10*log10("S1_0@1"^2))-(10*log10("S1_1@1"^2)))/((10*log10("S1_0@1"^2))+(10*log10("S1_1@1"^2))))','LAYERS':layersSAR[0],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':NDTIVV_file})
                processing.run("qgis:rastercalculator", {'EXPRESSION':'(((10*log10("S2_0@1"^2))-(10*log10("S2_1@1"^2)))/((10*log10("S2_0@1"^2))+(10*log10("S2_1@1"^2))))','LAYERS':layersSAR[0],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':NDTIVH_file})
                processing.run("qgis:rastercalculator", {'EXPRESSION':'(((10*log10("S2_1@1"^2))-(10*log10("S1_1@1"^2)))/((10*log10("S2_1@1"^2))+(10*log10("S1_1@1"^2))))-(((10*log10("S2_0@1"^2))-(10*log10("S1_0@1"^2)))/((10*log10("S2_0@1"^2))+(10*log10("S1_0@1"^2))))','LAYERS':layersSAR[0],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':dNRPB_file})
            if self.dlg.Cb_water.isChecked():
                processing.run("grass7:r.mapcalc.simple", {'a':dNRPB_file,'b':layersSAR[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':dNRPB_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.mapcalc.simple", {'a':NDTIVV_file,'b':layersSAR[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':NDTIVV_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.mapcalc.simple", {'a':NDTIVH_file,'b':layersSAR[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':NDTIVH_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
            QgsProject.instance().removeMapLayer(S1_0) 
            QgsProject.instance().removeMapLayer(S1_1)
            QgsProject.instance().removeMapLayer(S2_0) 
            QgsProject.instance().removeMapLayer(S2_1)
            dNRPB_layer = QgsRasterLayer(dNRPB_file,'dNRPB')
            NDTIVV_layer= QgsRasterLayer(NDTIVV_file,'NDTIVV')
            NDTIVH_layer= QgsRasterLayer(NDTIVH_file,'NDTIVH')
            for b in NDTIVVL:
                bstr=str(b)
                bint=b
                NDTIVVstats=self.dlg.lin_out.text()+'/NDTIVV_'+bstr+'.csv'
                NDTIVVpath=self.dlg.lin_out.text()+'/NDTIVV_'+bstr+'_d2f.csv' 
                processing.run("grass7:r.stats", {'input':[NDTIVV_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(NDTIVVstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                f = open(NDTIVVstats)
                text = f.read()
                f.close()
                clean = re.sub('<[^>]+>', '', text)
                f   = open(NDTIVVstats, 'w')
                f.write(clean)
                f.close()
                NDTIVVdf_uns=pd.read_csv(NDTIVVstats, header=None)
                NDTIVVdf_uns.columns= ["x","count"]
                NDTIVVdf = NDTIVVdf_uns.sort_values (by=['x'])
                NDTIVVdf.to_csv(NDTIVVstats, index=False)
                NDTIVVup=len(NDTIVVdf)
                NDTIVVup2=len(NDTIVVdf)-1
                NDTIVVup3=len(NDTIVVdf)-2
                NDTIVVup4=len(NDTIVVdf)-3
                NDTIVVup5=len(NDTIVVdf)-4
                NDTIVVj=0
                NDTIVVr=list(range(0,NDTIVVup2))
                NDTIVVl1=list(range(0,NDTIVVup))
                NDTIVVr2=list(range(3,NDTIVVup3))
                NDTIVVl2=list(range(0,NDTIVVup))
                NDTIVVr3=list(range(2,NDTIVVup3))
                NDTIVVl3=list(range(0,NDTIVVup))
                NDTIVVl4=list(range(0,NDTIVVup))
                NDTIVVr4=list(range(2,NDTIVVup3))
                NDTIVVr5=list(range(3,NDTIVVup3))
     #NDTIVV d1f calculation
                for ig in NDTIVVr:
                    NDTIVVj0=ig
                    NDTIVVji=NDTIVVj0+1
                    NDTIVVxi=NDTIVVdf.iloc[NDTIVVji]["x"]
                    NDTIVVyi=NDTIVVdf.iloc[NDTIVVji]["count"]
                    NDTIVVx0=NDTIVVdf.iloc[NDTIVVj0]["x"]
                    NDTIVVy0=NDTIVVdf.iloc[NDTIVVj0]["count"]
                    NDTIVVdi=(NDTIVVyi-NDTIVVy0)/(NDTIVVxi-NDTIVVx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                    NDTIVVl1[NDTIVVj0]=NDTIVVdi
                NDTIVVl1[NDTIVVup2]=" "
                NDTIVVdf.insert(2,'d1f',NDTIVVl1, True)
         #NDTIVVd2f calculation   
                for ih in NDTIVVr3:
                    NDTIVVhi=ih
                    NDTIVVh0=NDTIVVhi-1
                    NDTIVVxi=NDTIVVdf.iloc[NDTIVVhi]["x"]
                    NDTIVVd1fi=float(NDTIVVdf.iloc[NDTIVVhi]['d1f'])
                    NDTIVVx0=NDTIVVdf.iloc[NDTIVVh0]["x"]
                    NDTIVVd1f0=float(NDTIVVdf.iloc[NDTIVVh0]['d1f'])
                    NDTIVVd2i=((NDTIVVd1fi-NDTIVVd1f0)/(2*NDTIVVxi-2*NDTIVVx0))/1.5
                    NDTIVVl2[NDTIVVhi]=NDTIVVd2i
                NDTIVVl2[0]=" "
                NDTIVVl2[NDTIVVup2]=" "
                NDTIVVdf.insert(3,'d2f',NDTIVVl2, True)
        #NDTIVV Calculate consecutive values ratio for d1f
                NDTIVVcountposd1f=0
                NDTIVVcountnegd1f=0
                NDTIVVlistposnegd1f=[]
                NDTIVVdf['count']=pd.to_numeric(NDTIVVdf['count'], errors='coerce')
                NDTIVVdf['d1f']=pd.to_numeric(NDTIVVdf['d1f'], errors='coerce')
                NDTIVVdf['d2f']=pd.to_numeric(NDTIVVdf['d2f'], errors='coerce')
                NDTIVVcountmax=NDTIVVdf['count'][1:NDTIVVup5].max()
                try:
                    NDTIVVxmax=float(NDTIVVdf[NDTIVVdf['count']==NDTIVVcountmax]['x'])
                except Exception:
                    NDTIVVxmax=0.0
                NDTIVVinf=NDTIVVdf[(NDTIVVdf['x']<=NDTIVVxmax)] 
                NDTIVVup1=len(NDTIVVinf)
                NDTIVVr1=list(range(1,NDTIVVup1))
                NDTIVVr1len=len(NDTIVVr1)
                for iib in NDTIVVr1:
                    NDTIVVji=iib
                    NDTIVVj0=NDTIVVji-1
                    NDTIVVd1fi=float(NDTIVVinf.iloc[NDTIVVji]["d1f"])
                    NDTIVVd1f0=float(NDTIVVinf.iloc[NDTIVVj0]["d1f"])
                    NDTIVVx0=float(NDTIVVinf.iloc[NDTIVVj0]["x"])
                    if (NDTIVVd1fi>NDTIVVd1f0):
                        NDTIVVlistposnegd1f.append(1)
                    elif (NDTIVVd1fi<NDTIVVd1f0):
                        NDTIVVlistposnegd1f.append(0)
                for iiib in range(1,len(NDTIVVlistposnegd1f)):
                        if NDTIVVlistposnegd1f[iiib-1] == NDTIVVlistposnegd1f[iiib]:
                            if NDTIVVlistposnegd1f[iiib-1] == 1:
                                NDTIVVcountposd1f = NDTIVVcountposd1f + 1
                            else:
                                NDTIVVcountnegd1f = NDTIVVcountnegd1f + 1     
                try:
                    NDTIVVBinratiod1f= (NDTIVVcountposd1f+NDTIVVcountnegd1f)/float(NDTIVVr1len)
                except:
                    continue
                NDTIVVLBinratiod1f.append(NDTIVVBinratiod1f)
          # NDTIVV calculate consecutive values ratio for d2f
                NDTIVVcountposd2f=0
                NDTIVVcountnegd2f=0
                NDTIVVlistposnegd2f=[]
                NDTIVVup2=len(NDTIVVinf)
                NDTIVVr2=list(range(1,NDTIVVup2))
                NDTIVVr2len=len(NDTIVVr2)
                for ivb in NDTIVVr2:
                    NDTIVVji=ivb
                    NDTIVVj0=NDTIVVji-1
                    NDTIVVd2fi=float(NDTIVVinf.iloc[NDTIVVji]["d2f"])
                    NDTIVVd2f0=float(NDTIVVinf.iloc[NDTIVVj0]["d2f"])
                    NDTIVVx0=float(NDTIVVinf.iloc[NDTIVVj0]["x"])
                    if (NDTIVVd2fi>NDTIVVd2f0):
                        NDTIVVlistposnegd2f.append(1)
                    elif (NDTIVVd2fi<NDTIVVd2f0):
                        NDTIVVlistposnegd2f.append(0)
                for vb in range(1,len(NDTIVVlistposnegd2f)):
                        if NDTIVVlistposnegd2f[vb-1] == NDTIVVlistposnegd2f[vb]:
                            if NDTIVVlistposnegd2f[vb-1] == 1:
                                NDTIVVcountposd2f = NDTIVVcountposd2f + 1
                            else:
                                NDTIVVcountnegd2f = NDTIVVcountnegd2f + 1
                try:
                    NDTIVVBinratiod2f=(NDTIVVcountposd2f+NDTIVVcountnegd2f)/float(NDTIVVr2len)
                except:
                    continue
                NDTIVVLBinratiod2f.append(NDTIVVBinratiod2f)
                NDTIVVdf.to_csv(NDTIVVpath, index=False)
                os.remove(NDTIVVstats)
            # NDTIVV: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
            del NDTIVVdf
            NDTIVVp = pd.DataFrame(NDTIVVL, columns = ['bin_n'])
            NDTIVVp['Binratiod1f']=NDTIVVLBinratiod1f
            NDTIVVp['Binratiod2f']=NDTIVVLBinratiod2f
            NDTIVVratio=self.dlg.lin_out.text()+'/NDTIVV_ratio.csv'
            NDTIVVp.to_csv(NDTIVVratio, index = False)
            NDTIVVbd1f = NDTIVVp.max()['Binratiod1f']
            NDTIVVbd2f = NDTIVVp.max()['Binratiod2f']
            NDTIVVlista1 = []
            NDTIVVlista2 = []
            NDTIVVbind1f=self.dlg.lin_out.text()+'/NDTIVV_d1fbin.csv'
            NDTIVVbind2f=self.dlg.lin_out.text()+'/NDTIVV_d2fbin.csv'
            NDTIVVselecao1 = NDTIVVp[NDTIVVp.Binratiod1f == NDTIVVbd1f]
            NDTIVVc1 = NDTIVVselecao1[NDTIVVselecao1.bin_n == NDTIVVselecao1.bin_n.max()]
            NDTIVVlista1.append(int(NDTIVVc1.bin_n.tolist()[0]))
            NDTIVVselecao2 = NDTIVVp[NDTIVVp.Binratiod2f == NDTIVVbd2f]
            NDTIVVc2 = NDTIVVselecao2[NDTIVVselecao2.bin_n == NDTIVVselecao2.bin_n.max()]
            NDTIVVlista2.append(int(NDTIVVc2.bin_n.tolist()[0]))
            NDTIVVchoice1 = pd.DataFrame(NDTIVVlista1)
            NDTIVVchoice2 = pd.DataFrame(NDTIVVlista2)
            NDTIVVchoice1.to_csv(NDTIVVbind1f,index= False, header=False)   
            NDTIVVchoice2.to_csv(NDTIVVbind2f,index= False, header=False)   
            NDTIVVT1list=[]
            NDTIVVT2list=[]
            rNDTIVVT2list=[]
            #NDTIVV Select one threshold based on d1f (if any)
            NDTIVVbind1f_num=str(NDTIVVlista1[0])
            NDTIVVp1=self.dlg.lin_out.text()+'/NDTIVV_'+NDTIVVbind1f_num+'_d2f.csv'
            NDTIVVc1=pd.read_csv(NDTIVVp1)
            NDTIVVc1up5=len(NDTIVVc1)
            NDTIVVc1['d1f']=pd.to_numeric(NDTIVVc1['d1f'], errors='coerce')
            NDTIVVc1countmax=NDTIVVc1['count'][1:NDTIVVc1up5].max()
            NDTIVVc1xmax=float(NDTIVVc1[NDTIVVc1['count']==NDTIVVc1countmax]['x'])
            NDTIVVc1inf=NDTIVVc1[(NDTIVVc1['x']<=NDTIVVc1xmax)]
            NDTIVVc1up1=len(NDTIVVc1inf)-1
            NDTIVVc1r1=list(range(1,NDTIVVc1up1))
            for i in NDTIVVc1r1:
                    NDTIVVji=i
                    NDTIVVji2=NDTIVVji+1
                    NDTIVVj0=i-1
                    NDTIVVxi=NDTIVVc1inf.iloc[NDTIVVji]["x"]
                    NDTIVVxi2=NDTIVVc1inf.iloc[NDTIVVji2]["x"]
                    NDTIVVx0=NDTIVVc1inf.iloc[NDTIVVj0]["x"]
                    NDTIVVd1fi=float(NDTIVVc1inf.iloc[NDTIVVji]["d1f"])
                    NDTIVVd1fi2=float(NDTIVVc1inf.iloc[NDTIVVji2]["d1f"])
                    NDTIVVd1f0=float(NDTIVVc1inf.iloc[NDTIVVj0]["d1f"])
                    if (NDTIVVd1fi>0 and NDTIVVd1f0<0):
                        NDTIVVT1=(NDTIVVx0+NDTIVVxi)/2
                        NDTIVVT1list.append(NDTIVVT1)
                    else:
                        continue    
    # NDTIVV Select threshold(s) based on d2f
            NDTIVVbind2f_num=str(NDTIVVlista2[0])
            NDTIVVp1=self.dlg.lin_out.text()+'/NDTIVV_'+NDTIVVbind2f_num+'_d2f.csv'
            NDTIVVc1=pd.read_csv(NDTIVVp1)
            NDTIVVup5=len(NDTIVVc1)
            NDTIVVc1['d2f']=pd.to_numeric(NDTIVVc1['d2f'], errors='coerce')
            NDTIVVd2fmin=NDTIVVc1['d2f'][1:NDTIVVup5].min()
            NDTIVVxmax=float(NDTIVVc1[NDTIVVc1['d2f']==NDTIVVd2fmin]['x'])
            NDTIVVc1inf=NDTIVVc1[(NDTIVVc1['x']<=NDTIVVxmax)]
            NDTIVVc1up2=len(NDTIVVc1inf)-1
            NDTIVVc1r2=list(range(NDTIVVc1up2,2,-1))
            NDTIVVcnt=1
            for i in NDTIVVc1r2:
                    NDTIVVji2=i
                    NDTIVVji=i-1
                    NDTIVVj0=i-2
                    NDTIVVxi=NDTIVVc1inf.iloc[NDTIVVji]["x"]
                    NDTIVVx0=NDTIVVc1inf.iloc[NDTIVVj0]["x"]
                    NDTIVVxi2=NDTIVVc1inf.iloc[NDTIVVji2]["x"]
                    NDTIVVd2fi=float(NDTIVVc1inf.iloc[NDTIVVji]["d2f"])
                    NDTIVVd2fi2=float(NDTIVVc1inf.iloc[NDTIVVji2]["d2f"])
                    NDTIVVd2f0=float(NDTIVVc1inf.iloc[NDTIVVj0]["d2f"])
                    if NDTIVVd2fi<0:
                        NDTIVVcnt=1
                    if (NDTIVVd2fi>NDTIVVd2f0 and NDTIVVd2fi>NDTIVVd2fi2 and NDTIVVd2fi>0 and NDTIVVcnt>=1):
                        NDTIVVT2=NDTIVVxi
                        NDTIVVT2list.append(NDTIVVT2)
                        NDTIVVcnt=0
                    else:
                        continue
            rNDTIVVT2list=NDTIVVT2list[::-1]
    #NDTIVV Save Threshold list to csvsl
            NDTIVVT1L= pd.DataFrame(NDTIVVT1list)
            NDTIVVT1_p=self.dlg.lin_out.text()+'/NDTIVVT1.csv'
            NDTIVVT2_p=self.dlg.lin_out.text()+'/NDTIVVT2.csv'
            NDTIVVThresh_p=self.dlg.lin_out.text()+'/NDTIVVThresh.csv'
            NDTIVVT1L.to_csv(NDTIVVT1_p, header= False, index = False)
            NDTIVVT2L= pd.DataFrame(rNDTIVVT2list)
            NDTIVVT2L.to_csv(NDTIVVT2_p, header= False, index = False)
            NDTIVVT1Len=len(NDTIVVT1list)
            rNDTIVVT2Len=len(rNDTIVVT2list)
            NDTIVVThresh=[]
            i, j= 0, 0
            while i<NDTIVVT1Len and j<rNDTIVVT2Len:
                if NDTIVVT1list[i] < rNDTIVVT2list[j]:
                    NDTIVVThresh.append(NDTIVVT1list[i])
                    i +=1
                else:
                    NDTIVVThresh.append(rNDTIVVT2list[j])
                    j +=1
            NDTIVVThresh=NDTIVVThresh+ NDTIVVT1list[i:] + rNDTIVVT2list[j:]
            NDTIVVThreshL=pd.DataFrame(NDTIVVThresh)
            NDTIVVThreshL.to_csv(NDTIVVThresh_p, header= False, index = False)
            NDTIVVly=[]
            for tr in NDTIVVThresh:
                NDTIVVly.append(tr)
                NDTIVVlw=len(NDTIVVly)
            if NDTIVVlw>=1:
                if NDTIVVlw==1:
                    NDTIVVT1=[]
                    NDTIVVT1=[str(NDTIVVly[0])]
                    consequences_c_NDTIVV = []
                    cons_c_NDTIVV=QgsRasterCalculatorEntry()
                    cons_c_NDTIVV.ref='NDTIVV@1'
                    cons_c_NDTIVV.raster = NDTIVV_layer
                    cons_c_NDTIVV.bandNumber=1
                    consequences_c_NDTIVV.append(cons_c_NDTIVV)    
                    c_NDTIVV_exp='(' +consequences_c_NDTIVV[0].ref + ' <' +NDTIVVT1[0]+')* 1 + (' +consequences_c_NDTIVV[0].ref + '>= ' +NDTIVVT1[0]+' )*0'
                    c_NDTIVV_file = self.dlg.lin_out.text()+ '/c_NDTIVV.tif'
                    c_NDTIVV = QgsRasterCalculator(c_NDTIVV_exp,
                                               c_NDTIVV_file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               consequences_c_NDTIVV)                            
                    c_NDTIVV.processCalculation()
                    c_NDTIVV_layer = QgsRasterLayer(c_NDTIVV_file,'c_NDTIVV')
                    QgsProject.instance().addMapLayer(c_NDTIVV_layer)
                elif NDTIVVlw>=2:
                    NDTIVVT1=[]
                    NDTIVVT2=[]
                    aa=NDTIVVlw-1
                    bb=NDTIVVlw-2
                    NDTIVVT1=[str(NDTIVVly[aa])]
                    NDTIVVT2=[str(NDTIVVly[bb])]
                    consequences_c_NDTIVV = []
                    cons_c_NDTIVV=QgsRasterCalculatorEntry()
                    cons_c_NDTIVV.ref='NDTIVV@1'
                    cons_c_NDTIVV.raster = NDTIVV_layer
                    cons_c_NDTIVV.bandNumber=1
                    consequences_c_NDTIVV.append(cons_c_NDTIVV)     
                    c_NDTIVV_exp='(' +consequences_c_NDTIVV[0].ref + ' >=' +NDTIVVT1[0]+')* 0 + (' +consequences_c_NDTIVV[0].ref + '< ' +NDTIVVT1[0]+' )*(' +consequences_c_NDTIVV[0].ref + ' <' +NDTIVVT2[0]+')*10+ (' +consequences_c_NDTIVV[0].ref + '< ' +NDTIVVT1[0]+' )*(' +consequences_c_NDTIVV[0].ref + ' >=' +NDTIVVT2[0]+')*1'
                    c_NDTIVV_file = self.dlg.lin_out.text()+ '/c_NDTIVV.tif'
                    c_NDTIVV = QgsRasterCalculator(c_NDTIVV_exp,
                                               c_NDTIVV_file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               consequences_c_NDTIVV)                            
                    c_NDTIVV.processCalculation()
                    c_NDTIVV_layer = QgsRasterLayer(c_NDTIVV_file,'c_NDTIVV')
                    QgsProject.instance().addMapLayer(c_NDTIVV_layer)
#####
            for b in NDTIVHL:
                bstr=str(b)
                bint=b
                NDTIVHstats=self.dlg.lin_out.text()+'/NDTIVH_'+bstr+'.csv'
                NDTIVHpath=self.dlg.lin_out.text()+'/NDTIVH_'+bstr+'_d2f.csv' 
                processing.run("grass7:r.stats", {'input':[NDTIVH_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(NDTIVHstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                f = open(NDTIVHstats)
                text = f.read()
                f.close()
                clean = re.sub('<[^>]+>', '', text)
                f   = open(NDTIVHstats, 'w')
                f.write(clean)
                f.close()
                NDTIVHdf_uns=pd.read_csv(NDTIVHstats, header=None)
                NDTIVHdf_uns.columns= ["x","count"]
                NDTIVHdf = NDTIVHdf_uns.sort_values (by=['x'])
                NDTIVHdf.to_csv(NDTIVHstats, index=False)
                NDTIVHup=len(NDTIVHdf)
                NDTIVHup2=len(NDTIVHdf)-1
                NDTIVHup3=len(NDTIVHdf)-2
                NDTIVHup4=len(NDTIVHdf)-3
                NDTIVHup5=len(NDTIVHdf)-4
                NDTIVHj=0
                NDTIVHr=list(range(0,NDTIVHup2))
                NDTIVHl1=list(range(0,NDTIVHup))
                NDTIVHr2=list(range(3,NDTIVHup3))
                NDTIVHl2=list(range(0,NDTIVHup))
                NDTIVHr3=list(range(2,NDTIVHup3))
                NDTIVHl3=list(range(0,NDTIVHup))
                NDTIVHl4=list(range(0,NDTIVHup))
                NDTIVHr4=list(range(2,NDTIVHup3))
                NDTIVHr5=list(range(3,NDTIVHup3))
     #NDTIVH d1f calculation
                for ig in NDTIVHr:
                    NDTIVHj0=ig
                    NDTIVHji=NDTIVHj0+1
                    NDTIVHxi=NDTIVHdf.iloc[NDTIVHji]["x"]
                    NDTIVHyi=NDTIVHdf.iloc[NDTIVHji]["count"]
                    NDTIVHx0=NDTIVHdf.iloc[NDTIVHj0]["x"]
                    NDTIVHy0=NDTIVHdf.iloc[NDTIVHj0]["count"]
                    NDTIVHdi=(NDTIVHyi-NDTIVHy0)/(NDTIVHxi-NDTIVHx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                    NDTIVHl1[NDTIVHj0]=NDTIVHdi
                NDTIVHl1[NDTIVHup2]=" "
                NDTIVHdf.insert(2,'d1f',NDTIVHl1, True)
         #NDTIVHd2f calculation   
                for ih in NDTIVHr3:
                    NDTIVHhi=ih
                    NDTIVHh0=NDTIVHhi-1
                    NDTIVHxi=NDTIVHdf.iloc[NDTIVHhi]["x"]
                    NDTIVHd1fi=float(NDTIVHdf.iloc[NDTIVHhi]['d1f'])
                    NDTIVHx0=NDTIVHdf.iloc[NDTIVHh0]["x"]
                    NDTIVHd1f0=float(NDTIVHdf.iloc[NDTIVHh0]['d1f'])
                    NDTIVHd2i=((NDTIVHd1fi-NDTIVHd1f0)/(2*NDTIVHxi-2*NDTIVHx0))/1.5
                    NDTIVHl2[NDTIVHhi]=NDTIVHd2i
                NDTIVHl2[0]=" "
                NDTIVHl2[NDTIVHup2]=" "
                NDTIVHdf.insert(3,'d2f',NDTIVHl2, True)
        #NDTIVH Calculate consecutive values ratio for d1f
                NDTIVHcountposd1f=0
                NDTIVHcountnegd1f=0
                NDTIVHlistposnegd1f=[]
                NDTIVHdf['count']=pd.to_numeric(NDTIVHdf['count'], errors='coerce')
                NDTIVHdf['d1f']=pd.to_numeric(NDTIVHdf['d1f'], errors='coerce')
                NDTIVHdf['d2f']=pd.to_numeric(NDTIVHdf['d2f'], errors='coerce')
                NDTIVHcountmax=NDTIVHdf['count'][1:NDTIVHup5].max()
                try:
                    NDTIVHxmax=float(NDTIVHdf[NDTIVHdf['count']==NDTIVHcountmax]['x'])
                except Exception:
                    NDTIVHxmax=0.0
                NDTIVHinf=NDTIVHdf[(NDTIVHdf['x']<=NDTIVHxmax)] 
                NDTIVHup1=len(NDTIVHinf)
                NDTIVHr1=list(range(1,NDTIVHup1))
                NDTIVHr1len=len(NDTIVHr1)
                for iib in NDTIVHr1:
                    NDTIVHji=iib
                    NDTIVHj0=NDTIVHji-1
                    NDTIVHd1fi=float(NDTIVHinf.iloc[NDTIVHji]["d1f"])
                    NDTIVHd1f0=float(NDTIVHinf.iloc[NDTIVHj0]["d1f"])
                    NDTIVHx0=float(NDTIVHinf.iloc[NDTIVHj0]["x"])
                    if (NDTIVHd1fi>NDTIVHd1f0):
                        NDTIVHlistposnegd1f.append(1)
                    elif (NDTIVHd1fi<NDTIVHd1f0):
                        NDTIVHlistposnegd1f.append(0)
                for iiib in range(1,len(NDTIVHlistposnegd1f)):
                        if NDTIVHlistposnegd1f[iiib-1] == NDTIVHlistposnegd1f[iiib]:
                            if NDTIVHlistposnegd1f[iiib-1] == 1:
                                NDTIVHcountposd1f = NDTIVHcountposd1f + 1
                            else:
                                NDTIVHcountnegd1f = NDTIVHcountnegd1f + 1     
                try:
                    NDTIVHBinratiod1f= (NDTIVHcountposd1f+NDTIVHcountnegd1f)/float(NDTIVHr1len)
                except:
                    continue
                NDTIVHLBinratiod1f.append(NDTIVHBinratiod1f)
          # NDTIVH calculate consecutive values ratio for d2f
                NDTIVHcountposd2f=0
                NDTIVHcountnegd2f=0
                NDTIVHlistposnegd2f=[]
                NDTIVHup2=len(NDTIVHinf)
                NDTIVHr2=list(range(1,NDTIVHup2))
                NDTIVHr2len=len(NDTIVHr2)
                for ivb in NDTIVHr2:
                    NDTIVHji=ivb
                    NDTIVHj0=NDTIVHji-1
                    NDTIVHd2fi=float(NDTIVHinf.iloc[NDTIVHji]["d2f"])
                    NDTIVHd2f0=float(NDTIVHinf.iloc[NDTIVHj0]["d2f"])
                    NDTIVHx0=float(NDTIVHinf.iloc[NDTIVHj0]["x"])
                    if (NDTIVHd2fi>NDTIVHd2f0):
                        NDTIVHlistposnegd2f.append(1)
                    elif (NDTIVHd2fi<NDTIVHd2f0):
                        NDTIVHlistposnegd2f.append(0)
                for vb in range(1,len(NDTIVHlistposnegd2f)):
                        if NDTIVHlistposnegd2f[vb-1] == NDTIVHlistposnegd2f[vb]:
                            if NDTIVHlistposnegd2f[vb-1] == 1:
                                NDTIVHcountposd2f = NDTIVHcountposd2f + 1
                            else:
                                NDTIVHcountnegd2f = NDTIVHcountnegd2f + 1
                try:
                    NDTIVHBinratiod2f=(NDTIVHcountposd2f+NDTIVHcountnegd2f)/float(NDTIVHr2len)
                except:
                    continue
                NDTIVHLBinratiod2f.append(NDTIVHBinratiod2f)
                NDTIVHdf.to_csv(NDTIVHpath, index=False)
                os.remove(NDTIVHstats)
            # NDTIVH: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
            del NDTIVHdf
            NDTIVHp = pd.DataFrame(NDTIVHL, columns = ['bin_n'])
            NDTIVHp['Binratiod1f']=NDTIVHLBinratiod1f
            NDTIVHp['Binratiod2f']=NDTIVHLBinratiod2f
            NDTIVHratio=self.dlg.lin_out.text()+'/NDTIVH_ratio.csv'
            NDTIVHp.to_csv(NDTIVHratio, index = False)
            NDTIVHbd1f = NDTIVHp.max()['Binratiod1f']
            NDTIVHbd2f = NDTIVHp.max()['Binratiod2f']
            NDTIVHlista1 = []
            NDTIVHlista2 = []
            NDTIVHbind1f=self.dlg.lin_out.text()+'/NDTIVH_d1fbin.csv'
            NDTIVHbind2f=self.dlg.lin_out.text()+'/NDTIVH_d2fbin.csv'
            NDTIVHselecao1 = NDTIVHp[NDTIVHp.Binratiod1f == NDTIVHbd1f]
            NDTIVHc1 = NDTIVHselecao1[NDTIVHselecao1.bin_n == NDTIVHselecao1.bin_n.max()]
            NDTIVHlista1.append(int(NDTIVHc1.bin_n.tolist()[0]))
            NDTIVHselecao2 = NDTIVHp[NDTIVHp.Binratiod2f == NDTIVHbd2f]
            NDTIVHc2 = NDTIVHselecao2[NDTIVHselecao2.bin_n == NDTIVHselecao2.bin_n.max()]
            NDTIVHlista2.append(int(NDTIVHc2.bin_n.tolist()[0]))
            NDTIVHchoice1 = pd.DataFrame(NDTIVHlista1)
            NDTIVHchoice2 = pd.DataFrame(NDTIVHlista2)
            NDTIVHchoice1.to_csv(NDTIVHbind1f,index= False, header=False)   
            NDTIVHchoice2.to_csv(NDTIVHbind2f,index= False, header=False)   
            NDTIVHT1list=[]
            NDTIVHT2list=[]
            rNDTIVHT2list=[]
            #NDTIVH Select one threshold based on d1f (if any)
            NDTIVHbind1f_num=str(NDTIVHlista1[0])
            NDTIVHp1=self.dlg.lin_out.text()+'/NDTIVH_'+NDTIVHbind1f_num+'_d2f.csv'
            NDTIVHc1=pd.read_csv(NDTIVHp1)
            NDTIVHc1up5=len(NDTIVHc1)
            NDTIVHc1['d1f']=pd.to_numeric(NDTIVHc1['d1f'], errors='coerce')
            NDTIVHc1countmax=NDTIVHc1['count'][1:NDTIVHc1up5].max()
            NDTIVHc1xmax=float(NDTIVHc1[NDTIVHc1['count']==NDTIVHc1countmax]['x'])
            NDTIVHc1inf=NDTIVHc1[(NDTIVHc1['x']<=NDTIVHc1xmax)]
            NDTIVHc1up1=len(NDTIVHc1inf)-1
            NDTIVHc1r1=list(range(1,NDTIVHc1up1))
            for i in NDTIVHc1r1:
                    NDTIVHji=i
                    NDTIVHji2=NDTIVHji+1
                    NDTIVHj0=i-1
                    NDTIVHxi=NDTIVHc1inf.iloc[NDTIVHji]["x"]
                    NDTIVHxi2=NDTIVHc1inf.iloc[NDTIVHji2]["x"]
                    NDTIVHx0=NDTIVHc1inf.iloc[NDTIVHj0]["x"]
                    NDTIVHd1fi=float(NDTIVHc1inf.iloc[NDTIVHji]["d1f"])
                    NDTIVHd1fi2=float(NDTIVHc1inf.iloc[NDTIVHji2]["d1f"])
                    NDTIVHd1f0=float(NDTIVHc1inf.iloc[NDTIVHj0]["d1f"])
                    if (NDTIVHd1fi>0 and NDTIVHd1f0<0):
                        NDTIVHT1=(NDTIVHxi+NDTIVHx0)/2
                        NDTIVHT1list.append(NDTIVHT1)
                    else:
                        continue    
    # NDTIVH Select threshold(s) based on d2f
            NDTIVHbind2f_num=str(NDTIVHlista2[0])
            NDTIVHp1=self.dlg.lin_out.text()+'/NDTIVH_'+NDTIVHbind2f_num+'_d2f.csv'
            NDTIVHc1=pd.read_csv(NDTIVHp1)
            NDTIVHup5=len(NDTIVHc1)
            NDTIVHc1['d2f']=pd.to_numeric(NDTIVHc1['d2f'], errors='coerce')
            NDTIVHd2fmin=NDTIVHc1['d2f'][1:NDTIVHup5].min()
            NDTIVHxmax=float(NDTIVHc1[NDTIVHc1['d2f']==NDTIVHd2fmin]['x'])
            NDTIVHc1inf=NDTIVHc1[(NDTIVHc1['x']<=NDTIVHxmax)]
            NDTIVHc1up2=len(NDTIVHc1inf)-1
            NDTIVHc1r2=list(range(NDTIVHc1up2,2,-1))
            NDTIVHcnt=1
            for i in NDTIVHc1r2:
                    NDTIVHji2=i
                    NDTIVHji=i-1
                    NDTIVHj0=i-2
                    NDTIVHxi=NDTIVHc1inf.iloc[NDTIVHji]["x"]
                    NDTIVHx0=NDTIVHc1inf.iloc[NDTIVHj0]["x"]
                    NDTIVHxi2=NDTIVHc1inf.iloc[NDTIVHji2]["x"]
                    NDTIVHd2fi=float(NDTIVHc1inf.iloc[NDTIVHji]["d2f"])
                    NDTIVHd2fi2=float(NDTIVHc1inf.iloc[NDTIVHji2]["d2f"])
                    NDTIVHd2f0=float(NDTIVHc1inf.iloc[NDTIVHj0]["d2f"])
                    if NDTIVHd2fi<0:
                        NDTIVHcnt=1
                    if (NDTIVHd2fi>NDTIVHd2f0 and NDTIVHd2fi>NDTIVHd2fi2 and NDTIVHd2fi>0 and NDTIVHcnt>=1):
                        NDTIVHT2=NDTIVHxi
                        NDTIVHT2list.append(NDTIVHT2)
                        NDTIVHcnt=0
                    else:
                        continue
            rNDTIVHT2list=NDTIVHT2list[::-1]
    #NDTIVH Save Threshold list to csvsl
            NDTIVHT1L= pd.DataFrame(NDTIVHT1list)
            NDTIVHT1_p=self.dlg.lin_out.text()+'/NDTIVHT1.csv'
            NDTIVHT2_p=self.dlg.lin_out.text()+'/NDTIVHT2.csv'
            NDTIVHThresh_p=self.dlg.lin_out.text()+'/NDTIVHThresh.csv'
            NDTIVHT1L.to_csv(NDTIVHT1_p, header= False, index = False)
            NDTIVHT2L= pd.DataFrame(rNDTIVHT2list)
            NDTIVHT2L.to_csv(NDTIVHT2_p, header= False, index = False)
            NDTIVHT1Len=len(NDTIVHT1list)
            rNDTIVHT2Len=len(rNDTIVHT2list)
            NDTIVHThresh=[]
            i, j= 0, 0
            while i<NDTIVHT1Len and j<rNDTIVHT2Len:
                if NDTIVHT1list[i] < rNDTIVHT2list[j]:
                    NDTIVHThresh.append(NDTIVHT1list[i])
                    i +=1
                else:
                    NDTIVHThresh.append(rNDTIVHT2list[j])
                    j +=1
            NDTIVHThresh=NDTIVHThresh+ NDTIVHT1list[i:] + rNDTIVHT2list[j:]
            NDTIVHThreshL=pd.DataFrame(NDTIVHThresh)
            NDTIVHThreshL.to_csv(NDTIVHThresh_p, header= False, index = False)
            NDTIVHly=[]
            for tr in NDTIVHThresh:
                NDTIVHly.append(tr)
                NDTIVHlw=len(NDTIVHly)
            if NDTIVHlw>=1:
                if NDTIVHlw==1:
                    NDTIVHT1=[]
                    NDTIVHT1=[str(NDTIVHly[0])]
                    consequences_c_NDTIVH = []
                    cons_c_NDTIVH=QgsRasterCalculatorEntry()
                    cons_c_NDTIVH.ref='NDTIVH@1'
                    cons_c_NDTIVH.raster = NDTIVH_layer
                    cons_c_NDTIVH.bandNumber=1
                    consequences_c_NDTIVH.append(cons_c_NDTIVH)    
                    c_NDTIVH_exp='(' +consequences_c_NDTIVH[0].ref + ' <' +NDTIVHT1[0]+')* 1 + (' +consequences_c_NDTIVH[0].ref + '>= ' +NDTIVHT1[0]+' )*0'
                    c_NDTIVH_file = self.dlg.lin_out.text()+ '/c_NDTIVH.tif'
                    c_NDTIVH = QgsRasterCalculator(c_NDTIVH_exp,
                                               c_NDTIVH_file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               consequences_c_NDTIVH) 
                    c_NDTIVH.processCalculation()
                    c_NDTIVH_layer = QgsRasterLayer(c_NDTIVH_file,'c_NDTIVH')
                    QgsProject.instance().addMapLayer(c_NDTIVH_layer)
                elif NDTIVHlw>=2:
                    NDTIVHT1=[]
                    NDTIVHT2=[]
                    aa=NDTIVHlw-1
                    bb=NDTIVHlw-2
                    NDTIVHT1=[str(NDTIVHly[aa])]
                    NDTIVHT2=[str(NDTIVHly[bb])]
                    consequences_c_NDTIVH = []
                    cons_c_NDTIVH=QgsRasterCalculatorEntry()
                    cons_c_NDTIVH.ref='NDTIVH@1'
                    cons_c_NDTIVH.raster = NDTIVH_layer
                    cons_c_NDTIVH.bandNumber=1
                    consequences_c_NDTIVH.append(cons_c_NDTIVH)     
                    c_NDTIVH_exp='(' +consequences_c_NDTIVH[0].ref + ' >=' +NDTIVHT1[0]+')* 0 + (' +consequences_c_NDTIVH[0].ref + '< ' +NDTIVHT1[0]+' )*(' +consequences_c_NDTIVH[0].ref + ' <' +NDTIVHT2[0]+')*10+ (' +consequences_c_NDTIVH[0].ref + '< ' +NDTIVHT1[0]+' )*(' +consequences_c_NDTIVH[0].ref + ' >=' +NDTIVHT2[0]+')*1'
                    c_NDTIVH_file = self.dlg.lin_out.text()+ '/c_NDTIVH.tif'
                    c_NDTIVH = QgsRasterCalculator(c_NDTIVH_exp,
                                               c_NDTIVH_file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               consequences_c_NDTIVH)
                    c_NDTIVH.processCalculation()
                    c_NDTIVH_layer = QgsRasterLayer(c_NDTIVH_file,'c_NDTIVH')
                    QgsProject.instance().addMapLayer(c_NDTIVH_layer)
#######            
            for b in dNRPBL:
                bstr=str(b)
                bint=b
                dNRPBstats=self.dlg.lin_out.text()+'/dNRPB_'+bstr+'.csv'
                dNRPBpath=self.dlg.lin_out.text()+'/dNRPB_'+bstr+'_d2f.csv' 
                processing.run("grass7:r.stats", {'input':[dNRPB_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(dNRPBstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                f = open(dNRPBstats)
                text = f.read()
                f.close()
                clean = re.sub('<[^>]+>', '', text)
                f   = open(dNRPBstats, 'w')
                f.write(clean)
                f.close()
                dNRPBdf_uns=pd.read_csv(dNRPBstats, header=None)
                dNRPBdf_uns.columns= ["x","count"]
                dNRPBdf = dNRPBdf_uns.sort_values (by=['x'])
                dNRPBdf.to_csv(dNRPBstats, index=False)
                dNRPBup=len(dNRPBdf)
                dNRPBup2=len(dNRPBdf)-1
                dNRPBup3=len(dNRPBdf)-2
                dNRPBup4=len(dNRPBdf)-3
                dNRPBup5=len(dNRPBdf)-4
                dNRPBj=0
                dNRPBr=list(range(0,dNRPBup2))
                dNRPBl1=list(range(0,dNRPBup))
                dNRPBr2=list(range(3,dNRPBup3))
                dNRPBl2=list(range(0,dNRPBup))
                dNRPBr3=list(range(2,dNRPBup3))
                dNRPBl3=list(range(0,dNRPBup))
                dNRPBl4=list(range(0,dNRPBup))
                dNRPBr4=list(range(2,dNRPBup3))
                dNRPBr5=list(range(3,dNRPBup3))
     #dNRPB d1f calculation
                for ig in dNRPBr:
                    dNRPBj0=ig
                    dNRPBji=dNRPBj0+1
                    dNRPBxi=dNRPBdf.iloc[dNRPBji]["x"]
                    dNRPByi=dNRPBdf.iloc[dNRPBji]["count"]
                    dNRPBx0=dNRPBdf.iloc[dNRPBj0]["x"]
                    dNRPBy0=dNRPBdf.iloc[dNRPBj0]["count"]
                    dNRPBdi=(dNRPByi-dNRPBy0)/(dNRPBxi-dNRPBx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                    dNRPBl1[dNRPBj0]=dNRPBdi
                dNRPBl1[dNRPBup2]=" "
                dNRPBdf.insert(2,'d1f',dNRPBl1, True)
         #dNRPBd2f calculation   
                for ih in dNRPBr3:
                    dNRPBhi=ih
                    dNRPBh0=dNRPBhi-1
                    dNRPBxi=dNRPBdf.iloc[dNRPBhi]["x"]
                    dNRPBd1fi=float(dNRPBdf.iloc[dNRPBhi]['d1f'])
                    dNRPBx0=dNRPBdf.iloc[dNRPBh0]["x"]
                    dNRPBd1f0=float(dNRPBdf.iloc[dNRPBh0]['d1f'])
                    dNRPBd2i=((dNRPBd1fi-dNRPBd1f0)/(2*dNRPBxi-2*dNRPBx0))/1.5
                    dNRPBl2[dNRPBhi]=dNRPBd2i
                dNRPBl2[0]=" "
                dNRPBl2[dNRPBup2]=" "
                dNRPBdf.insert(3,'d2f',dNRPBl2, True)
        #dNRPB Calculate consecutive values ratio for d1f
                dNRPBcountposd1f=0
                dNRPBcountnegd1f=0
                dNRPBlistposnegd1f=[]
                dNRPBdf['count']=pd.to_numeric(dNRPBdf['count'], errors='coerce')
                dNRPBdf['d1f']=pd.to_numeric(dNRPBdf['d1f'], errors='coerce')
                dNRPBdf['d2f']=pd.to_numeric(dNRPBdf['d2f'], errors='coerce')
                dNRPBcountmax=dNRPBdf['count'][1:dNRPBup5].max()
                try:
                    dNRPBxmax=float(dNRPBdf[dNRPBdf['count']==dNRPBcountmax]['x'])
                except Exception:
                    dNRPBxmax=0.0
                dNRPBinf=dNRPBdf[(dNRPBdf['x']<=dNRPBxmax)] 
                dNRPBup1=len(dNRPBinf)
                dNRPBr1=list(range(1,dNRPBup1))
                dNRPBr1len=len(dNRPBr1)
                for iib in dNRPBr1:
                    dNRPBji=iib
                    dNRPBj0=dNRPBji-1
                    dNRPBd1fi=float(dNRPBinf.iloc[dNRPBji]["d1f"])
                    dNRPBd1f0=float(dNRPBinf.iloc[dNRPBj0]["d1f"])
                    dNRPBx0=float(dNRPBinf.iloc[dNRPBj0]["x"])
                    if (dNRPBd1fi>dNRPBd1f0):
                        dNRPBlistposnegd1f.append(1)
                    elif (dNRPBd1fi<dNRPBd1f0):
                        dNRPBlistposnegd1f.append(0)
                for iiib in range(1,len(dNRPBlistposnegd1f)):
                        if dNRPBlistposnegd1f[iiib-1] == dNRPBlistposnegd1f[iiib]:
                            if dNRPBlistposnegd1f[iiib-1] == 1:
                                dNRPBcountposd1f = dNRPBcountposd1f + 1
                            else:
                                dNRPBcountnegd1f = dNRPBcountnegd1f + 1     
                try:
                    dNRPBBinratiod1f= (dNRPBcountposd1f+dNRPBcountnegd1f)/float(dNRPBr1len)
                except:
                    continue
                dNRPBLBinratiod1f.append(dNRPBBinratiod1f)
          # dNRPB calculate consecutive values ratio for d2f
                dNRPBcountposd2f=0
                dNRPBcountnegd2f=0
                dNRPBlistposnegd2f=[]
                dNRPBup2=len(dNRPBinf)
                dNRPBr2=list(range(1,dNRPBup2))
                dNRPBr2len=len(dNRPBr2)
                for ivb in dNRPBr2:
                    dNRPBji=ivb
                    dNRPBj0=dNRPBji-1
                    dNRPBd2fi=float(dNRPBinf.iloc[dNRPBji]["d2f"])
                    dNRPBd2f0=float(dNRPBinf.iloc[dNRPBj0]["d2f"])
                    dNRPBx0=float(dNRPBinf.iloc[dNRPBj0]["x"])
                    if (dNRPBd2fi>dNRPBd2f0):
                        dNRPBlistposnegd2f.append(1)
                    elif (dNRPBd2fi<dNRPBd2f0):
                        dNRPBlistposnegd2f.append(0)
                for vb in range(1,len(dNRPBlistposnegd2f)):
                        if dNRPBlistposnegd2f[vb-1] == dNRPBlistposnegd2f[vb]:
                            if dNRPBlistposnegd2f[vb-1] == 1:
                                dNRPBcountposd2f = dNRPBcountposd2f + 1
                            else:
                                dNRPBcountnegd2f = dNRPBcountnegd2f + 1
                try:
                    dNRPBBinratiod2f=(dNRPBcountposd2f+dNRPBcountnegd2f)/float(dNRPBr2len)
                except:
                    continue
                dNRPBLBinratiod2f.append(dNRPBBinratiod2f)
                dNRPBdf.to_csv(dNRPBpath, index=False)
                os.remove(dNRPBstats)
            # dNRPB: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
            del dNRPBdf
            dNRPBp = pd.DataFrame(dNRPBL, columns = ['bin_n'])
            dNRPBp['Binratiod1f']=dNRPBLBinratiod1f
            dNRPBp['Binratiod2f']=dNRPBLBinratiod2f
            dNRPBratio=self.dlg.lin_out.text()+'/dNRPB_ratio.csv'
            dNRPBp.to_csv(dNRPBratio, index = False)
            dNRPBbd1f = dNRPBp.max()['Binratiod1f']
            dNRPBbd2f = dNRPBp.max()['Binratiod2f']
            dNRPBlista1 = []
            dNRPBlista2 = []
            dNRPBbind1f=self.dlg.lin_out.text()+'/dNRPB_d1fbin.csv'
            dNRPBbind2f=self.dlg.lin_out.text()+'/dNRPB_d2fbin.csv'
            dNRPBselecao1 = dNRPBp[dNRPBp.Binratiod1f == dNRPBbd1f]
            dNRPBc1 = dNRPBselecao1[dNRPBselecao1.bin_n == dNRPBselecao1.bin_n.max()]
            dNRPBlista1.append(int(dNRPBc1.bin_n.tolist()[0]))
            dNRPBselecao2 = dNRPBp[dNRPBp.Binratiod2f == dNRPBbd2f]
            dNRPBc2 = dNRPBselecao2[dNRPBselecao2.bin_n == dNRPBselecao2.bin_n.max()]
            dNRPBlista2.append(int(dNRPBc2.bin_n.tolist()[0]))
            dNRPBchoice1 = pd.DataFrame(dNRPBlista1)
            dNRPBchoice2 = pd.DataFrame(dNRPBlista2)
            dNRPBchoice1.to_csv(dNRPBbind1f,index= False, header=False)   
            dNRPBchoice2.to_csv(dNRPBbind2f,index= False, header=False)   
            NRPBT1list=[]
            NRPBT2list=[]
            rNRPBT2list=[]
            #dNRPB Select one threshold based on d1f (if any)
            dNRPBbind1f_num=str(dNRPBlista1[0])
            dNRPBp1=self.dlg.lin_out.text()+'/dNRPB_'+dNRPBbind1f_num+'_d2f.csv'
            dNRPBc1=pd.read_csv(dNRPBp1)
            dNRPBc1up5=len(dNRPBc1)
            dNRPBc1['d1f']=pd.to_numeric(dNRPBc1['d1f'], errors='coerce')
            dNRPBc1countmax=dNRPBc1['count'][1:dNRPBc1up5].max()
            dNRPBc1xmax=float(dNRPBc1[dNRPBc1['count']==dNRPBc1countmax]['x'])
            dNRPBc1inf=dNRPBc1[(dNRPBc1['x']<=dNRPBc1xmax)]
            dNRPBc1up1=len(dNRPBc1inf)-1
            dNRPBc1r1=list(range(1,dNRPBc1up1))
            for i in dNRPBc1r1:
                    dNRPBji=i
                    dNRPBji2=dNRPBji+1
                    dNRPBj0=i-1
                    dNRPBxi=dNRPBc1inf.iloc[dNRPBji]["x"]
                    dNRPBxi2=dNRPBc1inf.iloc[dNRPBji2]["x"]
                    dNRPBx0=dNRPBc1inf.iloc[dNRPBj0]["x"]
                    dNRPBd1fi=float(dNRPBc1inf.iloc[dNRPBji]["d1f"])
                    dNRPBd1fi2=float(dNRPBc1inf.iloc[dNRPBji2]["d1f"])
                    dNRPBd1f0=float(dNRPBc1inf.iloc[dNRPBj0]["d1f"])
                    if (dNRPBd1fi>0 and dNRPBd1f0<0):
                        NRPBT1=(dNRPBxi+dNRPBx0)/2
                        NRPBT1list.append(NRPBT1)
                    else:
                        continue    
    # dNRPB Select threshold(s) based on d2f
            dNRPBbind2f_num=str(dNRPBlista2[0])
            dNRPBp1=self.dlg.lin_out.text()+'/dNRPB_'+dNRPBbind2f_num+'_d2f.csv'
            dNRPBc1=pd.read_csv(dNRPBp1)
            dNRPBup5=len(dNRPBc1)
            dNRPBc1['d2f']=pd.to_numeric(dNRPBc1['d2f'], errors='coerce')
            dNRPBd2fmin=dNRPBc1['d2f'][1:dNRPBup5].min()
            dNRPBxmax=float(dNRPBc1[dNRPBc1['d2f']==dNRPBd2fmin]['x'])
            dNRPBc1inf=dNRPBc1[(dNRPBc1['x']<=dNRPBxmax)]
            dNRPBc1up2=len(dNRPBc1inf)-1
            dNRPBc1r2=list(range(dNRPBc1up2,2,-1))
            dNRPBcnt=1
            for i in dNRPBc1r2:
                    dNRPBji2=i
                    dNRPBji=i-1
                    dNRPBj0=i-2
                    dNRPBxi=dNRPBc1inf.iloc[dNRPBji]["x"]
                    dNRPBx0=dNRPBc1inf.iloc[dNRPBj0]["x"]
                    dNRPBxi2=dNRPBc1inf.iloc[dNRPBji2]["x"]
                    dNRPBd2fi=float(dNRPBc1inf.iloc[dNRPBji]["d2f"])
                    dNRPBd2fi2=float(dNRPBc1inf.iloc[dNRPBji2]["d2f"])
                    dNRPBd2f0=float(dNRPBc1inf.iloc[dNRPBj0]["d2f"])
                    if dNRPBd2fi<0:
                        dNRPBcnt=1
                    if (dNRPBd2fi>dNRPBd2f0 and dNRPBd2fi>dNRPBd2fi2 and dNRPBd2fi>0 and dNRPBcnt>=1):
                        NRPBT2=dNRPBxi
                        NRPBT2list.append(NRPBT2)
                        dNRPBcnt=0
                    else:
                        continue
            rNRPBT2list=NRPBT2list[::-1]
    #dNRPB Save Threshold list to csvsl
            NRPBT1L= pd.DataFrame(NRPBT1list)
            NRPBT1_p=self.dlg.lin_out.text()+'/NRPBT1.csv'
            NRPBT2_p=self.dlg.lin_out.text()+'/NRPBT2.csv'
            NRPBThresh_p=self.dlg.lin_out.text()+'/NRPBThresh.csv'
            NRPBT1L.to_csv(NRPBT1_p, header= False, index = False)
            NRPBT2L= pd.DataFrame(rNRPBT2list)
            NRPBT2L.to_csv(NRPBT2_p, header= False, index = False)
            NRPBT1Len=len(NRPBT1list)
            rNRPBT2Len=len(rNRPBT2list)
            NRPBThresh=[]
            i, j= 0, 0
            while i<NRPBT1Len and j<rNRPBT2Len:
                if NRPBT1list[i] < rNRPBT2list[j]:
                    NRPBThresh.append(NRPBT1list[i])
                    i +=1
                else:
                    NRPBThresh.append(rNRPBT2list[j])
                    j +=1
            NRPBThresh=NRPBThresh+ NRPBT1list[i:] + rNRPBT2list[j:]
            NRPBThreshL=pd.DataFrame(NRPBThresh)
            NRPBThreshL.to_csv(NRPBThresh_p, header= False, index = False)
            dNRPBly=[]
            for tr in NRPBThresh:
                dNRPBly.append(tr)
                dNRPBlw=len(dNRPBly)
            if dNRPBlw>=1:
                if dNRPBlw==1:
                    NRPBT1=[]
                    NRPBT1=[str(dNRPBly[0])]
                    consequences_c_dNRPB = []
                    cons_c_dNRPB=QgsRasterCalculatorEntry()
                    cons_c_dNRPB.ref='dNRPB@1'
                    cons_c_dNRPB.raster = dNRPB_layer
                    cons_c_dNRPB.bandNumber=1
                    consequences_c_dNRPB.append(cons_c_dNRPB)    
                    c_dNRPB_exp='(' +consequences_c_dNRPB[0].ref + ' <' +NRPBT1[0]+')* 1 + (' +consequences_c_dNRPB[0].ref + '>= ' +NRPBT1[0]+' )*0'
                    c_dNRPB_file = self.dlg.lin_out.text()+ '/c_dNRPB.tif'
                    c_dNRPB = QgsRasterCalculator(c_dNRPB_exp,
                                               c_dNRPB_file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               consequences_c_dNRPB)                                 
                    c_dNRPB.processCalculation()
                    c_dNRPB_layer = QgsRasterLayer(c_dNRPB_file,'c_dNRPB')
                    QgsProject.instance().addMapLayer(c_dNRPB_layer)
                elif dNRPBlw>=2:
                    NRPBT1=[]
                    NRPBT2=[]
                    aa=dNRPBlw-1
                    bb=dNRPBlw-2
                    NRPBT1=[str(dNRPBly[aa])]
                    NRPBT2=[str(dNRPBly[bb])]
                    consequences_c_dNRPB = []
                    cons_c_dNRPB=QgsRasterCalculatorEntry()
                    cons_c_dNRPB.ref='dNRPB@1'
                    cons_c_dNRPB.raster = dNRPB_layer
                    cons_c_dNRPB.bandNumber=1
                    consequences_c_dNRPB.append(cons_c_dNRPB)     
                    c_dNRPB_exp='(' +consequences_c_dNRPB[0].ref + ' >=' +NRPBT1[0]+')* 0 + (' +consequences_c_dNRPB[0].ref + '< ' +NRPBT1[0]+' )*(' +consequences_c_dNRPB[0].ref + ' <' +NRPBT2[0]+')*10+ (' +consequences_c_dNRPB[0].ref + '< ' +NRPBT1[0]+' )*(' +consequences_c_dNRPB[0].ref + ' >=' +NRPBT2[0]+')*1'
                    c_dNRPB_file = self.dlg.lin_out.text()+ '/c_dNRPB.tif'
                    c_dNRPB = QgsRasterCalculator(c_dNRPB_exp,
                                               c_dNRPB_file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               consequences_c_dNRPB)                             
                    c_dNRPB.processCalculation()
                    c_dNRPB_layer = QgsRasterLayer(c_dNRPB_file,'c_dNRPB')
                    QgsProject.instance().addMapLayer(c_dNRPB_layer)
 ##############
            if self.dlg.Cb_flood.isChecked():
                OSumNDTI_file= self.dlg.lin_out.text()+ '/OSumNDTI.tif'
                processing.run("grass7:r.mapcalc.simple", {'a':c_NDTIVV_file,'b':c_NDTIVH_file,'c':None,'d':None,'e':None,'f':None,'expression':'A+B','output':OSumNDTI_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                OSumNDTIlayer = QgsRasterLayer(OSumNDTI_file,'OSumNDTI')          
                QgsProject.instance().addMapLayer(OSumNDTIlayer)   
                c_NDTI_file=self.dlg.lin_out.text()+'/FloodNDTI.tif'
                processing.run("grass7:r.reclass", {'input':OSumNDTIlayer,'rules':'','txtrules':'0 = 0\n2 11 = 1\n20=10\n1 10 =-100','output':c_NDTI_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                c_NDTI_layer = QgsRasterLayer(c_NDTI_file,'Flood NDTI')
                QgsProject.instance().addMapLayer(c_NDTI_layer)                   
                UncertaintyNDTI_file= self.dlg.lin_out.text()+ '/UncertaintyNDTI.tif'
                processing.run("grass7:r.reclass", {'input':OSumNDTIlayer,'rules':'','txtrules':'0 2 20 = 0\n1 10 11  = 3','output':UncertaintyNDTI_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})               
            else:
                OSumNDTI_file= self.dlg.lin_out.text()+ '/OSumNDTI.tif'
                processing.run("grass7:r.mapcalc.simple", {'a':c_NDTIVV_file,'b':c_NDTIVH_file,'c':None,'d':None,'e':None,'f':None,'expression':'A+B','output':OSumNDTI_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})              
                OSumNDTIlayer = QgsRasterLayer(OSumNDTI_file,'OSumNDTI')          
                QgsProject.instance().addMapLayer(OSumNDTIlayer)   
                c_NDTI_file=self.dlg.lin_out.text()+'/BurnedNDTI.tif'
                processing.run("grass7:r.reclass", {'input':OSumNDTIlayer,'rules':'','txtrules':'0 = 0\n2 11 = 1\n20=10\n1 10 =-100','output':c_NDTI_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                c_NDTI_layer = QgsRasterLayer(c_NDTI_file,'Burned NDTI')
                QgsProject.instance().addMapLayer(c_NDTI_layer)                                   
                UncertaintyNDTI_file= self.dlg.lin_out.text()+ '/UncertaintyNDTI.tif'
                processing.run("grass7:r.reclass", {'input':OSumNDTIlayer,'rules':'','txtrules':'0 2 20 = 0\n1 10 11  = 3','output':UncertaintyNDTI_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    
#############################
        if (self.dlg.Cb_MULTI.isChecked()):
            layers= self.loadlayers()
            ex=layers[0].extent()
            xmax = ex.xMaximum()
            ymax = ex.yMaximum()
            xmin = ex.xMinimum()
            ymin = ex.yMinimum()
            cr=QgsProject.instance().crs().authid() 
            targ_ext=str(xmin)+","+str(xmax)+","+str(ymin)+","+str(ymax)+" ["+str(cr)+"]"
            if layers[0].type() == QgsMapLayer.VectorLayer:
                if ((self.dlg.Cmb_0.currentText() == "Sentinel 2A or 2B (MSI)") and (self.dlg.Cmb_1.currentText() == "Sentinel 2A or 2B (MSI)")):
                    study_raster= self.dlg.lin_out.text()+ '/study20.tif'
                    processing.run("gdal:rasterize", {'INPUT':layers[0],'FIELD':'','BURN':1,'USE_Z':False,'UNITS':1,'WIDTH':20,'HEIGHT':20,'EXTENT':ex,'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':study_raster})
                    study20_layer= QgsRasterLayer(study_raster,'study')
                    extent=study20_layer.extent()
                    width=study20_layer.width()
                    height=study20_layer.height()
                    layers[0]=QgsRasterLayer(study_raster,'study')
                else:
                    study_raster= self.dlg.lin_out.text()+ '/study30.tif'
                    processing.run("gdal:rasterize", {'INPUT':layers[0],'FIELD':'','BURN':1,'USE_Z':False,'UNITS':1,'WIDTH':30,'HEIGHT':30,'EXTENT':ex,'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':study_raster})
                    study30_layer= QgsRasterLayer(study_raster,'study')
                    extent=study30_layer.extent()
                    width=study30_layer.width()
                    height=study30_layer.height()
                    layers[0]=QgsRasterLayer(study_raster,'study')
            else:
                extent=layers[0].extent()
                width=layers[0].width()
                height=layers[0].height()
            if layers[1].type() == QgsMapLayer.VectorLayer:
                if ((self.dlg.Cmb_0.currentText() == "Sentinel 2A or 2B (MSI)") and (self.dlg.Cmb_1.currentText() == "Sentinel 2A or 2B (MSI)")):                       
                    water_raster= self.dlg.lin_out.text()+ '/water20.tif'
                    processing.run("gdal:rasterize", {'INPUT':layers[1],'FIELD':'','BURN':1,'USE_Z':False,'UNITS':1,'WIDTH':20,'HEIGHT':20,'EXTENT':ex,'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':water_raster})
                    layers[1]=QgsRasterLayer(water_raster,'water')
                else:
                    water_raster= self.dlg.lin_out.text()+ '/water30.tif'
                    processing.run("gdal:rasterize", {'INPUT':layers[1],'FIELD':'','BURN':1,'USE_Z':False,'UNITS':1,'WIDTH':30,'HEIGHT':30,'EXTENT':ex,'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':water_raster})
                    water30_layer= QgsRasterLayer(water_raster,'water')
                    layers[1]=QgsRasterLayer(water_raster,'water')
            
            if layers[2].type() == QgsMapLayer.VectorLayer:
                if self.dlg.Cb_topo.isChecked():
                    QMessageBox.warning(None, 'Error', 'DEM must be raster type.')
                    exit
                else:
                    if layers[0].type() == QgsMapLayer.VectorLayer:
                        dem_raster= study_raster
                        layers[2]=QgsRasterLayer(dem_raster,'dem')
                    else:
                        layers[2]=layers[0]
            folder0=self.dlg.lin_folder0.text()
            os.chdir(folder0)
            if (self.dlg.Cmb_0.currentText() == "Landsat 5 (TM)" or self.dlg.Cmb_0.currentText() == "Landsat 7 (ETM+)"):
                bblue0=glob.glob('./**/*SR_B1.tif',  recursive = True)
                bgreen0=glob.glob('./**/*SR_B2.tif',  recursive = True)
                bred0=glob.glob('./**/*SR_B3.tif',  recursive = True)
                bnir0=glob.glob('./**/*SR_B4.tif',  recursive = True)
                bswirs0=glob.glob('./**/*SR_B5.tif',  recursive = True)
                bswirl0=glob.glob('./**/*SR_B7.tif',  recursive = True)
                meta0_path=glob.glob('./**/*MTL.txt',  recursive = True)
                cloud0_path=glob.glob('./**/*QA_PIXEL.tif',  recursive = True)
                meta0_file=open(meta0_path[0])
                azimuth0=[]
                elevation0=[]
                zenith0=[]
                for a in meta0_file:
                    if "SUN_AZIMUTH =" in a:
                        b=a.split('= ')
                        c=b[1]
                        azimuth0=c.rstrip("\n")
                    elif "SUN_ELEVATION =" in a:
                        d=a.split('= ')
                        e=d[1]
                        elevation0=e.rstrip("\n")
                        zenith0=90-float(elevation0)
                    else:
                        continue
            elif (self.dlg.Cmb_0.currentText() == "Landsat 8 (OLI)" or self.dlg.Cmb_0.currentText() == "Landsat 9 (OLI)"):
                bblue0=glob.glob('./**/*SR_B2.tif',  recursive = True)
                bgreen0=glob.glob('./**/*SR_B3.tif',  recursive = True)
                bred0=glob.glob('./**/*SR_B4.tif',  recursive = True)
                bnir0=glob.glob('./**/*SR_B5.tif',  recursive = True)
                bswirs0=glob.glob('./**/*SR_B6.tif',  recursive = True)
                bswirl0=glob.glob('./**/*SR_B7.tif',  recursive = True)
                meta0_path=glob.glob('./**/*MTL.txt',  recursive = True)
                cloud0_path=glob.glob('./**/*QA_PIXEL.tif',  recursive = True)
                meta0_file=open(meta0_path[0])
                azimuth0=[]
                elevation0=[]
                zenith0=[]
                for a in meta0_file:
                    if "SUN_AZIMUTH =" in a:
                        b=a.split('= ')
                        c=b[1]
                        azimuth0=c.rstrip("\n")
                    elif "SUN_ELEVATION =" in a:
                        d=a.split('= ')
                        e=d[1]
                        elevation0=e.rstrip("\n")
                        zenith0=90-float(elevation0)
                    else:
                        continue
            elif (self.dlg.Cmb_0.currentText() == "Sentinel 2A or 2B (MSI)"):        
                bblue0=glob.glob('./**/*B02_20m.jp2',  recursive = True)
                bgreen0=glob.glob('./**/*B03_20m.jp2', recursive = True)
                bred0=glob.glob('./**/*B04_20m.jp2',   recursive = True)
                bnir0=glob.glob('./**/*B8A_20m.jp2',   recursive = True)
                bswirs0=glob.glob('./**/*B11_20m.jp2', recursive = True)
                bswirl0=glob.glob('./**/*B12_20m.jp2', recursive = True)
                meta0_path=glob.glob('./**/MTD_TL.xml',  recursive = True)
                cloud0_path=glob.glob('./**/*SCL_20m.jp2',  recursive = True)
                meta0_file=open(meta0_path[0])
                azimuth0=[]
                elevation0=[]
                zenith0=[]
                ze=0
                az=0
                for a in meta0_file:
                    if ("<ZENITH_ANGLE unit=" in a) and (ze==0):
                        b=a.split('>')
                        c=b[1]
                        d=c.split('<')
                        e=d[0]
                        zenith0=float(e)
                        elevation0=90-zenith0
                        ze=1
                    elif ("<AZIMUTH_ANGLE unit=" in a) and (az==0):
                        b=a.split('>')
                        c=b[1]
                        d=c.split('<')
                        e=d[0]
                        azimuth0=float(e)
                        az=1
                    else:
                        continue
            else:
                QMessageBox.warning(self.dlg, 'Select sensor', 'Before continuing, please select the post-event multispectral sensor path')
                exit()
            blue0  = QgsRasterLayer(bblue0[0],'Blue_0')
            green0 = QgsRasterLayer(bgreen0[0],'Green_0')
            red0 = QgsRasterLayer(bred0[0],'Red_0')
            nir0 = QgsRasterLayer(bnir0[0],'Nir_0')
            swirs0 = QgsRasterLayer(bswirs0[0],'Swirs_0')
            swirl0 = QgsRasterLayer(bswirl0[0],'Swirl_0')
            cloud0_abspath =os.path.abspath(cloud0_path[0])
            cloud0 = QgsRasterLayer(cloud0_abspath,'Cloud_0')
    #Import post-event bands
            folder1=self.dlg.lin_folder1.text() 
            os.chdir(folder1) 
            if (self.dlg.Cmb_1.currentText() == "Landsat 5 (TM)" or self.dlg.Cmb_1.currentText() == "Landsat 7 (ETM+)"):
                bblue1=glob.glob('./**/*SR_B1.tif',  recursive = True)
                bgreen1=glob.glob('./**/*SR_B2.tif',  recursive = True)
                bred1=glob.glob('./**/*SR_B3.tif',  recursive = True)
                bnir1=glob.glob('./**/*SR_B4.tif',  recursive = True)
                bswirs1=glob.glob('./**/*SR_B5.tif',  recursive = True)
                bswirl1=glob.glob('./**/*SR_B7.tif',  recursive = True)
                meta1_path=glob.glob('./**/*MTL.txt',  recursive = True)
                cloud1_path=glob.glob('./**/*QA_PIXEL.tif',  recursive = True)
                meta1_file=open(meta1_path[0])
                azimuth1=[]
                elevation1=[]
                zenith1=[]
                for a in meta1_file:
                    if "SUN_AZIMUTH =" in a:
                        b=a.split('= ')
                        c=b[1]
                        azimuth1=c.rstrip("\n")
                    elif "SUN_ELEVATION =" in a:
                        d=a.split('= ')
                        e=d[1]
                        elevation1=e.rstrip("\n")
                        zenith1=90-float(elevation1)
                    else:
                        continue
            elif (self.dlg.Cmb_1.currentText() == "Landsat 8 (OLI)" or self.dlg.Cmb_1.currentText() == "Landsat 9 (OLI)"):
                bblue1=glob.glob('./**/*SR_B2.tif',  recursive = True)
                bgreen1=glob.glob('./**/*SR_B3.tif',  recursive = True)
                bred1=glob.glob('./**/*SR_B4.tif',  recursive = True)
                bnir1=glob.glob('./**/*SR_B5.tif',  recursive = True)
                bswirs1=glob.glob('./**/*SR_B6.tif',  recursive = True)
                bswirl1=glob.glob('./**/*SR_B7.tif',  recursive = True)
                meta1_path=glob.glob('./**/*MTL.txt',  recursive = True)
                cloud1_path=glob.glob('./**/*QA_PIXEL.tif',  recursive = True)
                meta1_file=open(meta1_path[0])
                azimuth1=[]
                elevation1=[]
                zenith1=[]
                for a in meta1_file:
                    if "SUN_AZIMUTH =" in a:
                        b=a.split('= ')
                        c=b[1]
                        azimuth1=c.rstrip("\n")
                    elif "SUN_ELEVATION =" in a:
                        d=a.split('= ')
                        e=d[1]
                        elevation1=e.rstrip("\n")
                        zenith1=90-float(elevation1)
                    else:
                        continue
            elif (self.dlg.Cmb_1.currentText() == "Sentinel 2A or 2B (MSI)"):
                bblue1=glob.glob('./**/*B02_20m.jp2',
                               recursive = True)
                bgreen1=glob.glob('./**/*B03_20m.jp2',
                               recursive = True)
                bred1=glob.glob('./**/*B04_20m.jp2',
                               recursive = True)
                bnir1=glob.glob('./**/*B8A_20m.jp2',
                               recursive = True)
                bswirs1=glob.glob('./**/*B11_20m.jp2',
                               recursive = True)
                bswirl1=glob.glob('./**/*B12_20m.jp2',
                               recursive = True)
                meta1_path=glob.glob('./**/MTD_TL.xml',  recursive = True)
                cloud1_path=glob.glob('./**/*SCL_20m.jp2',  recursive = True)
                meta1_file=open(meta1_path[0])
                azimuth1=[]
                elevation1=[]
                zenith1=[]
                ze=0
                az=0
                for a in meta1_file:
                    if ("<ZENITH_ANGLE unit=" in a) and (ze==0):
                        b=a.split('>')
                        c=b[1]
                        d=c.split('<')
                        e=d[0]
                        zenith1=float(e)
                        elevation1=90-zenith1
                        ze=1
                    elif ("<AZIMUTH_ANGLE unit=" in a) and (az==0):
                        b=a.split('>')
                        c=b[1]
                        d=c.split('<')
                        e=d[0]
                        azimuth1=float(e)
                        az=1
                    else:
                        continue
            else:
                QMessageBox.warning(self.dlg, 'Select sensor', 'Before continuing, please select the post-event multispectral sensor path')
                exit()
            blue1  = QgsRasterLayer(bblue1[0],'Blue_1')
            green1 = QgsRasterLayer(bgreen1[0],'Green_1')
            red1 = QgsRasterLayer(bred1[0],'Red_1')
            nir1 = QgsRasterLayer(bnir1[0],'Nir_1')
            swirs1 = QgsRasterLayer(bswirs1[0],'Swirs_1')
            swirl1 = QgsRasterLayer(bswirl1[0],'Swirl_1') 
            cloud1_abspath =os.path.abspath(cloud1_path[0])
            cloud1 = QgsRasterLayer(cloud1_abspath,'Cloud_1')
            relief0_path= self.dlg.lin_out.text()+ '/relief0.tif'
            relief1_path= self.dlg.lin_out.text()+ '/relief1.tif'
            ts0_path=self.dlg.lin_out.text()+ '/ts0.tif'
            ts1_path=self.dlg.lin_out.text()+ '/ts1.tif'
            cs0_path=os.path.abspath(self.dlg.lin_out.text()+ '/cs0.tif')
            cs1_path=os.path.abspath(self.dlg.lin_out.text()+ '/cs1.tif')
            csg_path=os.path.abspath(self.dlg.lin_out.text()+ '/csg.tif')
            il0_path=self.dlg.lin_out.text()+ '/il0.tif'
            il1_path=self.dlg.lin_out.text()+ '/il1.tif'
            tblue0_path= self.dlg.lin_out.text()+ '/tblue0.tif' 
            tgreen0_path= self.dlg.lin_out.text()+ '/tgreen0.tif'
            tred0_path= self.dlg.lin_out.text()+ '/tred0.tif'
            tnir0_path= self.dlg.lin_out.text()+ '/tnir0.tif'
            tswirs0_path= self.dlg.lin_out.text()+ '/tswirs0.tif'
            tswirl0_path= self.dlg.lin_out.text()+ '/tswirl0.tif'
            tblue1_path= self.dlg.lin_out.text()+ '/tblue1.tif' 
            tgreen1_path= self.dlg.lin_out.text()+ '/tgreen1.tif'
            tred1_path= self.dlg.lin_out.text()+ '/tred1.tif'
            tnir1_path= self.dlg.lin_out.text()+ '/tnir1.tif'
            tswirs1_path= self.dlg.lin_out.text()+ '/tswirs1.tif'
            tswirl1_path= self.dlg.lin_out.text()+ '/tswirl1.tif'       
            UncertaintyMS_file=self.dlg.lin_out.text()+'/UncertaintyMS.tif'
       #TOPOGRAPHIC CORRECTION    
            if self.dlg.Cb_topo.isChecked():
                #Topographic shadows masks:
                processing.run("grass7:r.relief", {'input':layers[2],'altitude':elevation0,'azimuth':azimuth0,'zscale':1,'scale':1,'units':0,'output':relief0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.relief", {'input':layers[2],'altitude':elevation1,'azimuth':azimuth1,'zscale':1,'scale':1,'units':0,'output':relief1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.mapcalc.simple", {'a':relief0_path,'b':None,'c':None,'d':None,'e':None,'f':None,'expression':'if (A<=0, null(), 1)','output':ts0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.mapcalc.simple", {'a':relief1_path,'b':None,'c':None,'d':None,'e':None,'f':None,'expression':'if (A<=0, null(), 1)','output':ts1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                ts0_layer=QgsRasterLayer(ts0_path,'ts0')
                ts1_layer=QgsRasterLayer(ts0_path,'ts1')
                #Illumination models:
                processing.run("grass7:i.topo.coor.ill", {'basemap':layers[2],'zenith':zenith0,'azimuth':azimuth0,'output':il0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:i.topo.coor.ill", {'basemap':layers[2],'zenith':zenith1,'azimuth':azimuth1,'output':il1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                il0_layer = QgsRasterLayer(il0_path,'il0')
                il1_layer = QgsRasterLayer(il1_path,'il1')
                #Topographic correction with cosine method:
                if ((self.dlg.Cmb_0.currentText() == "Landsat 5 (TM)") or (self.dlg.Cmb_0.currentText() == "Landsat 7 (ETM+)" ) or (self.dlg.Cmb_0.currentText() == "Landsat 8 (OLI)" )or (self.dlg.Cmb_0.currentText() == "Landsat 9 (OLI)")) :
                    QgsProject.instance().addMapLayer(blue0)
                    QgsProject.instance().addMapLayer(green0)
                    QgsProject.instance().addMapLayer(red0)
                    QgsProject.instance().addMapLayer(nir0)
                    QgsProject.instance().addMapLayer(swirs0)
                    QgsProject.instance().addMapLayer(swirl0)
                    QgsProject.instance().addMapLayer(ts0_layer)
                    QgsProject.instance().addMapLayer(il0_layer)
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Blue_0@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tblue0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Green_0@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tgreen0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Red_0@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tred0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Nir_0@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tnir0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Swirs_0@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tswirs0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Swirl_0@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tswirl0_path})
                    QgsProject.instance().removeMapLayer(il0_layer) 
                    QgsProject.instance().removeMapLayer(ts0_layer)
                    QgsProject.instance().removeMapLayer(blue0)
                    QgsProject.instance().removeMapLayer(green0)
                    QgsProject.instance().removeMapLayer(red0)
                    QgsProject.instance().removeMapLayer(nir0)
                    QgsProject.instance().removeMapLayer(swirs0)
                    QgsProject.instance().removeMapLayer(swirl0)
                elif (self.dlg.Cmb_0.currentText() == "Sentinel 2A or 2B (MSI)"):
                    QgsProject.instance().addMapLayer(blue0)
                    QgsProject.instance().addMapLayer(green0)
                    QgsProject.instance().addMapLayer(red0)
                    QgsProject.instance().addMapLayer(nir0)
                    QgsProject.instance().addMapLayer(swirs0)
                    QgsProject.instance().addMapLayer(swirl0)
                    QgsProject.instance().addMapLayer(ts0_layer)
                    QgsProject.instance().addMapLayer(il0_layer)
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Blue_0@1" )*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tblue0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Green_0@1" )*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tgreen0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Red_0@1" )*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tred0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Nir_0@1" )*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tnir0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Swirs_0@1" )*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tswirs0_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts0@1"*"Swirl_0@1" )*cos(3.14159265359 / 180 *'+str(zenith0)+')/cos(3.14159265359 / 180 *"il0@1")','LAYERS':[il0_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tswirl0_path})
                    QgsProject.instance().removeMapLayer(il0_layer) 
                    QgsProject.instance().removeMapLayer(ts0_layer)
                    QgsProject.instance().removeMapLayer(blue0)
                    QgsProject.instance().removeMapLayer(green0)
                    QgsProject.instance().removeMapLayer(red0)
                    QgsProject.instance().removeMapLayer(nir0)
                    QgsProject.instance().removeMapLayer(swirs0)
                    QgsProject.instance().removeMapLayer(swirl0)
                if ((self.dlg.Cmb_1.currentText() == "Landsat 5 (TM)") or (self.dlg.Cmb_1.currentText() =="Landsat 7 (ETM+)")  or (self.dlg.Cmb_1.currentText() =="Landsat 8 (OLI)") or (self.dlg.Cmb_1.currentText() == "Landsat 9 (OLI)")) :
                    QgsProject.instance().addMapLayer(blue1)
                    QgsProject.instance().addMapLayer(green1)
                    QgsProject.instance().addMapLayer(red1)
                    QgsProject.instance().addMapLayer(nir1)
                    QgsProject.instance().addMapLayer(swirs1)
                    QgsProject.instance().addMapLayer(swirl1)
                    QgsProject.instance().addMapLayer(ts1_layer)
                    QgsProject.instance().addMapLayer(il1_layer)
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Blue_1@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tblue1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Green_1@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tgreen1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Red_1@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tred1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Nir_1@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tnir1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Swirs_1@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tswirs1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Swirl_1@1" * 0.0000275 -0.2)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tswirl1_path})
                    QgsProject.instance().removeMapLayer(il1_layer) 
                    QgsProject.instance().removeMapLayer(ts1_layer)
                    QgsProject.instance().removeMapLayer(blue1)
                    QgsProject.instance().removeMapLayer(green1)
                    QgsProject.instance().removeMapLayer(red1)
                    QgsProject.instance().removeMapLayer(nir1)
                    QgsProject.instance().removeMapLayer(swirs1)
                    QgsProject.instance().removeMapLayer(swirl1)                  
                elif (self.dlg.Cmb_1.currentText() == "Sentinel 2A or 2B (MSI)"):
                    QgsProject.instance().addMapLayer(blue1)
                    QgsProject.instance().addMapLayer(green1)
                    QgsProject.instance().addMapLayer(red1)
                    QgsProject.instance().addMapLayer(nir1)
                    QgsProject.instance().addMapLayer(swirs1)
                    QgsProject.instance().addMapLayer(swirl1)
                    QgsProject.instance().addMapLayer(ts1_layer)
                    QgsProject.instance().addMapLayer(il1_layer)
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Blue_1@1" *0.0001 )*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tblue1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Green_1@1" *0.0001 )*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tgreen1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Red_1@1" *0.0001)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tred1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Nir_1@1" *0.0001)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tnir1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Swirs_1@1" *0.0001)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tswirs1_path})
                    processing.run("qgis:rastercalculator", {'EXPRESSION':'("ts1@1"*"Swirl_1@1" *0.0001)*cos(3.14159265359 / 180 *'+str(zenith1)+')/cos(3.14159265359 / 180 *"il1@1")','LAYERS':[il1_path],'CELLSIZE':0,'EXTENT':None,'CRS':None,'OUTPUT':tswirl1_path})
                    QgsProject.instance().removeMapLayer(il1_layer) 
                    QgsProject.instance().removeMapLayer(ts1_layer)
                    QgsProject.instance().removeMapLayer(blue1)
                    QgsProject.instance().removeMapLayer(green1)
                    QgsProject.instance().removeMapLayer(red1)
                    QgsProject.instance().removeMapLayer(nir1)
                    QgsProject.instance().removeMapLayer(swirs1)
                    QgsProject.instance().removeMapLayer(swirl1)
                CRS_study=QgsMapLayer.crs(layers[0])
                processing.run("grass7:r.proj", {'input':tblue0_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tblue0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tgreen0_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tgreen0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tred0_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tred0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tnir0_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tnir0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tswirs0_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tswirs0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tswirl0_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tswirl0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tblue1_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tblue1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tgreen1_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tgreen1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tred1_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tred1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tnir1_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tnir1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tswirs1_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tswirs1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                processing.run("grass7:r.proj", {'input':tswirl1_path,'crs':CRS_study,'method':0,'memory':1900,'resolution':None,'-n':False,'output':tswirl1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                tblue0=QgsRasterLayer(tblue0_path[0],"tblue0")
                tgreen0=QgsRasterLayer(tgreen0_path[0],"tgreen0")
                tred0=QgsRasterLayer(tred0_path[0],"tred0")
                tnir0=QgsRasterLayer(tnir0_path[0],"tnir0")
                tswirs0=QgsRasterLayer(tswirs0_path[0],"tswirs0")
                tswirl0=QgsRasterLayer(tswirl0_path[0],"tswirl0")
                tblue1=QgsRasterLayer(tblue1_path[0],"tblue1")
                tgreen1=QgsRasterLayer(tgreen1_path[0],"tgreen1")
                tred1=QgsRasterLayer(tred1_path[0],"tred1")
                tnir1=QgsRasterLayer(tnir1_path[0],"tnir1")
                tswirs1=QgsRasterLayer(tswirs1_path[0],"tswirs1")
                tswirl1=QgsRasterLayer(tswirl1_path[0],"tswirl1") 
                layers.append(tblue0) #3
                layers.append(tgreen0) #4
                layers.append(tred0) #5
                layers.append(tnir0) #6
                layers.append(tswirs0) #7
                layers.append(tswirl0) #8
                layers.append(tblue1) #9
                layers.append(tgreen1) #10
                layers.append(tred1) #11
                layers.append(tnir1) #12
                layers.append(tswirs1) #13
                layers.append(tswirl1) #14            
            else:
                layers.append(blue0) #3
                layers.append(green0) #4
                layers.append(red0) #5
                layers.append(nir0) #6
                layers.append(swirs0) #7
                layers.append(swirl0) #8
                layers.append(blue1) #9
                layers.append(green1) #10
                layers.append(red1) #11
                layers.append(nir1) #12
                layers.append(swirs1) #13
                layers.append(swirl1) #14
            if self.dlg.Cb_cloud.isChecked():
                if (self.dlg.Cmb_0.currentText() == "Landsat 5 (TM)" or self.dlg.Cmb_0.currentText() == "Landsat 7 (ETM+)" or self.dlg.Cmb_0.currentText() == "Landsat 8 (OLI)" or self.dlg.Cmb_0.currentText() == "Landsat 9 (OLI)"):
                    cloud0_file=self.dlg.lin_out.text()+ '/c0_table.html'
                    processing.run("native:rasterlayeruniquevaluesreport", {'INPUT':cloud0_abspath,'BAND':1,'OUTPUT_HTML_FILE':cloud0_file})
                    cloud0_file_abs=os.path.abspath(cloud0_file)
                    c0_html=open(cloud0_file_abs,"r")
                    c0_text_path=self.dlg.lin_out.text()+ '/c0_table.txt'
                    c0_text_abs=os.path.abspath(c0_text_path)
                    c0_text=open(c0_text_abs,"w")
                    for i in c0_html:
                        i=re.sub(r'</td>'," ", i)
                        i = re.sub(r'<.*?>', '', i)
                        c0_text.write(i)
                    c0_text.close()   
                    c0_html.close()
                    c0_values=[]
                    c0_rules=['1=null\n']
                    c0_text_r=open(c0_text_abs,"r")
                    for a_c0 in c0_text_r:
                        a0=a_c0.partition(" ")[0] 
                        if a0.isdigit():
                            na0=int(a0)
                            b0=bin(na0)
                            inv_d0=b0[::-1]
                            if len(inv_d0)>3:
                                if (inv_d0[1]=="1" or inv_d0[3]=="1"or inv_d0[2]=="1"or inv_d0[4]=="1"or inv_d0[5]=="1"):
                                    d0_rev=inv_d0[::-1]
                                    cloud0_bit=int(d0_rev,2)
                                    c0_values.append(cloud0_bit)
                                else:
                                    continue
                            else:
                                continue   
                        else:
                            continue
                    c0_text_r.close()
                    f_values_path=self.dlg.lin_out.text()+"/c0_values.txt"
                    f_values_abs=os.path.abspath(f_values_path)
                    f_values_c0 = open(f_values_abs, "w")
                    for cd0 in c0_values:
                        strn=str(cd0)    
                        f_values_c0.write(strn +"\n")
                    f_values_c0.close()
                    f_values_path=self.dlg.lin_out.text()+"/c0_values.txt"
                    f_values_abs=os.path.abspath(f_values_path)
                    f_values_c0_r = open(f_values_abs, "r")
                    for c0 in f_values_c0_r:
                        c0 = re.sub("\n","",c0)
                        d0 = str(c0)+"=null\n"
                        c0_rules.append(d0)
                    c0_rules.append('*=1\n')
                    c0_rule="".join(c0_rules)
                    processing.run("grass7:r.reclass", {'input':cloud0_abspath,'rules':'','txtrules':c0_rule,'output':cs0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    cs0_layer  = QgsRasterLayer(cs0_path,'cs0')
                elif (self.dlg.Cmb_0.currentText() == "Sentinel 2A or 2B (MSI)"):
                    processing.run("grass7:r.reclass", {'input':cloud0_abspath,'rules':'','txtrules':'1 2 3 6 8 9 10 11 = null\n*=1','output':cs0_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    cs0_layer  = QgsRasterLayer(cs0_path,'cs0')
            if self.dlg.Cb_cloud.isChecked():
                if (self.dlg.Cmb_1.currentText() == "Landsat 5 (TM)" or self.dlg.Cmb_1.currentText() == "Landsat 7 (ETM+)" or self.dlg.Cmb_1.currentText() == "Landsat 8 (OLI)" or self.dlg.Cmb_1.currentText() == "Landsat 9 (OLI)"):
                    cloud1_file=self.dlg.lin_out.text()+ '/c1_table.html'
                    processing.run("native:rasterlayeruniquevaluesreport", {'INPUT':cloud1_abspath,'BAND':1,'OUTPUT_HTML_FILE':cloud1_file})
                    cloud1_file_abs=os.path.abspath(cloud1_file)
                    c1_html=open(cloud1_file_abs,"r")
                    c1_text_path=self.dlg.lin_out.text()+ '/c1_table.txt'
                    c1_text_abs=os.path.abspath(c1_text_path)
                    c1_text=open(c1_text_abs,"w")
                    for i in c1_html:
                        i=re.sub(r'</td>'," ", i)
                        i = re.sub(r'<.*?>', '', i)
                        c1_text.write(i)
                    c1_text.close()   
                    c1_html.close()
                    c1_values=[]
                    c1_rules=['1=null\n']
                    c1_text_r=open(c1_text_abs,"r")
                    for a_c1 in c1_text_r:
                        a1=a_c1.partition(" ")[0] 
                        if a1.isdigit():
                            na1=int(a1)
                            b1=bin(na1)
                            inv_d1=b1[::-1]
                            if len(inv_d1)>3:
                                if (inv_d1[1]=="1" or inv_d1[3]=="1"or inv_d1[2]=="1"or inv_d1[4]=="1"or inv_d1[5]=="1"):
                                    d1_rev=inv_d1[::-1]
                                    cloud1_bit=int(d1_rev,2)
                                    c1_values.append(cloud1_bit)
                                else:
                                    continue
                            else:
                                continue   
                        else:
                            continue
                    c1_text_r.close()
                    f_values_path=self.dlg.lin_out.text()+"/c1_values.txt"
                    f_values_abs=os.path.abspath(f_values_path)
                    f_values_c1 = open(f_values_abs, "w")
                    for cd1 in c1_values:
                        strn=str(cd1)    
                        f_values_c1.write(strn +"\n")
                    f_values_c1.close()
                    f_values_path=self.dlg.lin_out.text()+"/c1_values.txt"
                    f_values_abs=os.path.abspath(f_values_path)
                    f_values_c1_r = open(f_values_abs, "r")
                    for c1 in f_values_c1_r:
                        c1 = re.sub("\n","",c1)
                        d1 = str(c1)+"=null\n"
                        c1_rules.append(d1)
                    c1_rules.append('*=1\n')
                    c1_rule="".join(c1_rules)
                    processing.run("grass7:r.reclass", {'input':cloud1_abspath,'rules':'','txtrules':c1_rule,'output':cs1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    cs1_layer  = QgsRasterLayer(cs0_path,'cs1')
                elif (self.dlg.Cmb_1.currentText() == "Sentinel 2A or 2B (MSI)"):
                    if self.dlg.Cb_water.isChecked():
                        processing.run("grass7:r.reclass", {'input':cloud1_abspath,'rules':'','txtrules':'1 2 3 8 9 10 11 = null\n*=1','output':cs1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        cs1_layer  = QgsRasterLayer(cs1_path,'cs1')
                    elif self.dlg.Cb_fire.isChecked():
                        processing.run("grass7:r.reclass", {'input':cloud1_abspath,'rules':'','txtrules':'1 2 3 4 6 8 9 10 11 = null\n*=1','output':cs1_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        cs1_layer  = QgsRasterLayer(cs1_path,'cs1')
            if self.dlg.Cb_cloud.isChecked():
                processing.run("grass7:r.mapcalc.simple", {'a':cs0_path,'b':cs1_path,'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':csg_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                csg_layer  = QgsRasterLayer(csg_path,'csg')

    #HRS masking for t1 (for fires, mostly):
            if self.dlg.Cb_hrs.isChecked(): 
                hrs_path=self.dlg.lin_out.text()+"/hrs_mask.tif"
                HRS_value=self.dlg.Qs_HRS.value()
                if HRS_value==4:
                    t_L5="0.1503"
                    t_L7="0.1099"
                    t_L8="0.1692"
                    t_S2="0.1155"
                elif HRS_value==3:
                    t_L5="0.1728"
                    t_L7="0.1272"
                    t_L8="0.1942"
                    t_S2="0.1327"
                elif HRS_value==2:
                    t_L5="0.2002"
                    t_L7="0.1479"
                    t_L8="0.2261"
                    t_S2="0.1538"
                elif HRS_value==1:
                    t_L5="0.2252"
                    t_L7="0.1664"
                    t_L8="0.2564"
                    t_S2="0.1728"
                if (self.dlg.Cb_topo.isChecked()):
                    if (self.dlg.Cmb_1.currentText() == "Landsat 5 (TM)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':tgreen1_path,'b':tred1_path,'c':tswirs1_path,'d':tswirl1_path,'e':None,'f':None,'expression':'if((0.4158*(A)+ 0.5524*(B) + 0.3124*(C) +0.2303*(D))<('+t_L5+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
                    elif (self.dlg.Cmb_1.currentText() == "Landsat 7 (ETM+)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':tgreen1_path,'b':tred1_path,'c':tswirs1_path,'d':tswirl1_path,'e':None,'f':None,'expression':'if((0.3972*(A)+ 0.3904*(B) + 0.2286*(C) +0.1596*(D))<('+t_L7+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
                    elif (self.dlg.Cmb_1.currentText() == "Landsat 8 (OLI)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':tgreen1_path,'b':tred1_path,'c':tswirs1_path,'d':tswirl1_path,'e':None,'f':None,'expression':'if((0.2786*(A)+ 0.4733*(B) + 0.508*(C) +0.1872*(D))<('+t_L8+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
                    elif (self.dlg.Cmb_1.currentText() == "Landsat 9 (OLI)"): 
                        processing.run("grass7:r.mapcalc.simple", {'a':tgreen1_path,'b':tred1_path,'c':tswirs1_path,'d':tswirl1_path,'e':None,'f':None,'expression':'if((0.2786*(A)+ 0.4733*(B) + 0.508*(C) +0.1872*(D))<('+t_L8+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
                    elif (self.dlg.Cmb_1.currentText() == "Sentinel 2A or 2B (MSI)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':tgreen1_path,'b':tred1_path,'c':tswirs1_path,'d':tswirl1_path,'e':None,'f':None,'expression':'if((0.3813*(A)+ 0.3437*(B) + 0.2396*(C) +0.1949*(D))<('+t_S2+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')            
                else:
                    if (self.dlg.Cmb_1.currentText() == "Landsat 5 (TM)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':layers[10],'b':layers[11],'c':layers[13],'d':layers[14],'e':None,'f':None,'expression':'if((0.4158*(A*0.0000275 -0.2)+ 0.5524*(B*0.0000275 -0.2) + 0.3124*(C*0.0000275 -0.2) +0.2303*(D*0.0000275 -0.2))<('+t_L5+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
                    elif (self.dlg.Cmb_1.currentText() == "Landsat 7 (ETM+)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':layers[10],'b':layers[11],'c':layers[13],'d':layers[14],'e':None,'f':None,'expression':'if((0.3972*(A*0.0000275 -0.2)+ 0.3904*(B*0.0000275 -0.2) + 0.2286*(C*0.0000275 -0.2) +0.1596*(D*0.0000275 -0.2))<('+t_L7+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
                    elif (self.dlg.Cmb_1.currentText() == "Landsat 8 (OLI)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':layers[10],'b':layers[11],'c':layers[13],'d':layers[14],'e':None,'f':None,'expression':'if((0.2786*(A*0.0000275 -0.2)+ 0.4733*(B*0.0000275 -0.2) + 0.508*(C*0.0000275 -0.2) +0.1872*(D*0.0000275 -0.2))<('+t_L8+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
                    elif (self.dlg.Cmb_1.currentText() == "Landsat 9 (OLI)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':layers[10],'b':layers[11],'c':layers[13],'d':layers[14],'e':None,'f':None,'expression':'if((0.2786*(A*0.0000275 -0.2)+ 0.4733*(B*0.0000275 -0.2) + 0.508*(C*0.0000275 -0.2) +0.1872*(D*0.0000275 -0.2))<('+t_L8+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
                    elif (self.dlg.Cmb_1.currentText() == "Sentinel 2A or 2B (MSI)"):
                        processing.run("grass7:r.mapcalc.simple", {'a':layers[10],'b':layers[11],'c':layers[13],'d':layers[14],'e':None,'f':None,'expression':'if((0.3813*(A*0.0001)+ 0.3437*(B*0.0001) + 0.2396*(C*0.0001) +0.1949*(D*0.0001))<('+t_S2+'),1,null())','output':hrs_path,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                        hrs_mask  = QgsRasterLayer(hrs_path,'hrs')
            entries = self.defineentries(layers)
            if self.dlg.Cb_flood.isChecked():
            #NDVI:
                ndvi0file = self.dlg.lin_out.text()+ '/NDVI0.tif'
                ndvi1file = self.dlg.lin_out.text()+ '/NDVI1.tif'
                if self.dlg.Cb_topo.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':tnir0_path,'b':tred0_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':ndvi0file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.mapcalc.simple", {'a':tnir1_path,'b':tred1_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':ndvi1file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    ndvi0_layer = QgsRasterLayer(ndvi0file,'NDVI_0')
                    ndvi1_layer = QgsRasterLayer(ndvi1file,'NDVI_1')
                else:
                    ndvi0_exp = '((((' + entries[6].ref + ' - ' + entries[5].ref + ') / ('+ entries[6].ref + ' + ' + entries[5].ref +'))>=-1)*(((' + entries[6].ref + ' - ' + entries[5].ref + ') / ('+ entries[6].ref + ' + ' + entries[5].ref +'))<=1))*(((' + entries[6].ref + ' - ' + entries[5].ref + ') / ('+ entries[6].ref + ' + ' + entries[5].ref +')))' 
                    ndvi1_exp = '((((' + entries[12].ref + ' - ' + entries[10].ref + ') / ('+ entries[12].ref + ' + ' + entries[10].ref +'))>=-1)*(((' + entries[12].ref + ' - ' + entries[10].ref + ') / ('+ entries[12].ref + ' + ' + entries[10].ref +'))<=1))*(((' + entries[12].ref + ' - ' + entries[10].ref + ') / ('+ entries[12].ref + ' + ' + entries[10].ref +')))' 
                    ndvi0 = QgsRasterCalculator(ndvi0_exp,
                                                ndvi0file,
                                                'GTiff',
                                                extent,
                                                width,
                                                height,
                                                entries)
                    ndvi0.processCalculation()
                    ndvi0_layer = QgsRasterLayer(ndvi0file,'NDVI_0')
                    ndvi1 = QgsRasterCalculator(ndvi1_exp,
                                            ndvi1file,
                                            'GTiff',
                                            extent,
                                            width,
                                            height,
                                            entries)
                    ndvi1.processCalculation()
                    ndvi1_layer = QgsRasterLayer(ndvi1file,'NDVI_1')
            #dNDVI:
                consequences = []
                cons_ndvi0=QgsRasterCalculatorEntry()
                cons_ndvi0.ref='ndvi0@1'
                cons_ndvi0.raster = ndvi0_layer
                cons_ndvi0.bandNumber=1
                consequences.append(cons_ndvi0)
                cons_ndvi1=QgsRasterCalculatorEntry()
                cons_ndvi1.ref='ndvi1@1'
                cons_ndvi1.raster = ndvi1_layer
                cons_ndvi1.bandNumber=1
                consequences.append(cons_ndvi1)   
                
                dndvi_exp='(' +consequences[1].ref + ' - '+ consequences[0].ref + ')'
                if self.dlg.Cb_cloud.isChecked():
                    cons_csg=QgsRasterCalculatorEntry()
                    cons_csg.ref='csg@1'
                    cons_csg.raster = csg_layer
                    cons_csg.bandNumber=1
                    consequences.append(cons_csg)
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dndvi_exp='(' +consequences[2].ref + '*' +consequences[1].ref + '*' +consequences[3].ref + ' - ' + consequences[0].ref + ')'
                    else:
                        dndvi_exp='(' +consequences[2].ref + '*' +consequences[1].ref + ' - ' + consequences[0].ref + ')'
                else:
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dndvi_exp='(' +consequences[2].ref + '*' +consequences[1].ref + ' - '+ consequences[0].ref + ')'
                    else:
                        dndvi_exp='(' +consequences[1].ref + ' - '+ consequences[0].ref + ')'
                dndvi_file = self.dlg.lin_out.text()+ '/d_NDVI.tif'


                dndvi = QgsRasterCalculator(dndvi_exp,
                                           dndvi_file,
                                           'GTiff',
                                           extent,
                                           width,
                                           height,
                                           consequences)                        
                dndvi.processCalculation()
                if self.dlg.Cb_water.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':dndvi_file,'b':layers[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':dndvi_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                dndvi_layer = QgsRasterLayer(dndvi_file,'dNDVI')
                for b in bin_n:
                    bstr=str(b)
                    bint=b
                    dNDVIstats=self.dlg.lin_out.text()+'/dNDVI_'+bstr+'.csv'
                    NDVIpath=self.dlg.lin_out.text()+'/dNDVI_'+bstr+'_d2f.csv' 
                    processing.run("grass7:r.stats", {'input':[dndvi_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(dNDVIstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                    f = open(dNDVIstats)
                    text = f.read()
                    f.close()
                    clean = re.sub('<[^>]+>', '', text)
                    f   = open(dNDVIstats, 'w')
                    f.write(clean)
                    f.close()
                    NDVIdf_uns=pd.read_csv(dNDVIstats, header=None)
                    NDVIdf_uns.columns= ["x","count"]
                    NDVIdf = NDVIdf_uns.sort_values (by=['x'])
                    NDVIdf.to_csv(dNDVIstats, index=False)
                    NDVIup=len(NDVIdf)
                    NDVIup2=len(NDVIdf)-1
                    NDVIup3=len(NDVIdf)-2
                    NDVIup4=len(NDVIdf)-3
                    NDVIup5=len(NDVIdf)-4
                    NDVIj=0
                    NDVIr=list(range(0,NDVIup2))
                    NDVIl1=list(range(0,NDVIup))
                    NDVIr2=list(range(3,NDVIup3))
                    NDVIl2=list(range(0,NDVIup))
                    NDVIr3=list(range(2,NDVIup3))
                    NDVIl3=list(range(0,NDVIup))
                    NDVIl4=list(range(0,NDVIup))
                    NDVIr4=list(range(2,NDVIup3))
                    NDVIr5=list(range(3,NDVIup3))
         #NDVI d1f calculation
                    for ig in NDVIr:
                        NDVIj0=ig
                        NDVIji=NDVIj0+1
                        NDVIxi=NDVIdf.iloc[NDVIji]["x"]
                        NDVIyi=NDVIdf.iloc[NDVIji]["count"]
                        NDVIx0=NDVIdf.iloc[NDVIj0]["x"]
                        NDVIy0=NDVIdf.iloc[NDVIj0]["count"]
                        NDVIdi=(NDVIyi-NDVIy0)/(NDVIxi-NDVIx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                        NDVIl1[NDVIj0]=NDVIdi
                    NDVIl1[NDVIup2]=" "
                    NDVIdf.insert(2,'d1f',NDVIl1, True)
             #NDVId2f calculation   
                    for ih in NDVIr3:
                        NDVIhi=ih
                        NDVIh0=NDVIhi-1
                        NDVIxi=NDVIdf.iloc[NDVIhi]["x"]
                        NDVId1fi=float(NDVIdf.iloc[NDVIhi]['d1f'])
                        NDVIx0=NDVIdf.iloc[NDVIh0]["x"]
                        NDVId1f0=float(NDVIdf.iloc[NDVIh0]['d1f'])
                        NDVId2i=((NDVId1fi-NDVId1f0)/(2*NDVIxi-2*NDVIx0))/1.5
                        NDVIl2[NDVIhi]=NDVId2i
                    NDVIl2[0]=" "
                    NDVIl2[NDVIup2]=" "
                    NDVIdf.insert(3,'d2f',NDVIl2, True)
            #NDVI Calculate consecutive values ratio for d1f
                    NDVIcountposd1f=0
                    NDVIcountnegd1f=0
                    NDVIlistposnegd1f=[]
                    NDVIdf['count']=pd.to_numeric(NDVIdf['count'], errors='coerce')
                    NDVIdf['d1f']=pd.to_numeric(NDVIdf['d1f'], errors='coerce')
                    NDVIdf['d2f']=pd.to_numeric(NDVIdf['d2f'], errors='coerce')
                    NDVIcountmax=NDVIdf['count'][1:NDVIup5].max()
                    try:
                        NDVIxmax=float(NDVIdf[NDVIdf['count']==NDVIcountmax]['x'])
                    except Exception:
                        NDVIxmax=0.0
                    NDVIinf=NDVIdf[(NDVIdf['x']<=NDVIxmax)] 
                    NDVIup1=len(NDVIinf)
                    NDVIr1=list(range(1,NDVIup1))
                    NDVIr1len=len(NDVIr1)
                    for iib in NDVIr1:
                        NDVIji=iib
                        NDVIj0=NDVIji-1
                        NDVId1fi=float(NDVIinf.iloc[NDVIji]["d1f"])
                        NDVId1f0=float(NDVIinf.iloc[NDVIj0]["d1f"])
                        NDVIx0=float(NDVIinf.iloc[NDVIj0]["x"])
                        if (NDVId1fi>NDVId1f0):
                            NDVIlistposnegd1f.append(1)
                        elif (NDVId1fi<NDVId1f0):
                            NDVIlistposnegd1f.append(0)
                    for iiib in range(1,len(NDVIlistposnegd1f)):
                            if NDVIlistposnegd1f[iiib-1] == NDVIlistposnegd1f[iiib]:
                                if NDVIlistposnegd1f[iiib-1] == 1:
                                    NDVIcountposd1f = NDVIcountposd1f + 1
                                else:
                                    NDVIcountnegd1f = NDVIcountnegd1f + 1     
                    try:
                        NDVIBinratiod1f= (NDVIcountposd1f+NDVIcountnegd1f)/float(NDVIr1len)
                    except:
                        continue
                    NDVILBinratiod1f.append(NDVIBinratiod1f)
              # NDVI calculate consecutive values ratio for d2f
                    NDVIcountposd2f=0
                    NDVIcountnegd2f=0
                    NDVIlistposnegd2f=[]
                    NDVIup2=len(NDVIinf)
                    NDVIr2=list(range(1,NDVIup2))
                    NDVIr2len=len(NDVIr2)
                    for ivb in NDVIr2:
                        NDVIji=ivb
                        NDVIj0=NDVIji-1
                        NDVId2fi=float(NDVIinf.iloc[NDVIji]["d2f"])
                        NDVId2f0=float(NDVIinf.iloc[NDVIj0]["d2f"])
                        NDVIx0=float(NDVIinf.iloc[NDVIj0]["x"])
                        if (NDVId2fi>NDVId2f0):
                            NDVIlistposnegd2f.append(1)
                        elif (NDVId2fi<NDVId2f0):
                            NDVIlistposnegd2f.append(0)
                    for vb in range(1,len(NDVIlistposnegd2f)):
                            if NDVIlistposnegd2f[vb-1] == NDVIlistposnegd2f[vb]:
                                if NDVIlistposnegd2f[vb-1] == 1:
                                    NDVIcountposd2f = NDVIcountposd2f + 1
                                else:
                                    NDVIcountnegd2f = NDVIcountnegd2f + 1
                    try:
                        NDVIBinratiod2f=(NDVIcountposd2f+NDVIcountnegd2f)/float(NDVIr2len)
                    except:
                        continue
                    NDVILBinratiod2f.append(NDVIBinratiod2f)
                    NDVIdf.to_csv(NDVIpath, index=False)
                    os.remove(dNDVIstats)
                # NDVI: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
                del NDVIdf
                NDVIp = pd.DataFrame(NDVIL, columns = ['bin_n'])
                NDVIp['Binratiod1f']=NDVILBinratiod1f
                NDVIp['Binratiod2f']=NDVILBinratiod2f
                NDVIratio=self.dlg.lin_out.text()+'/dNDVI_ratio.csv'
                NDVIp.to_csv(NDVIratio, index = False)
                NDVIbd1f = NDVIp.max()['Binratiod1f']
                NDVIbd2f = NDVIp.max()['Binratiod2f']
                NDVIlista1 = []
                NDVIlista2 = []
                NDVIbind1f=self.dlg.lin_out.text()+'/dNDVI_d1fbin.csv'
                NDVIbind2f=self.dlg.lin_out.text()+'/dNDVI_d2fbin.csv'
                NDVIselecao1 = NDVIp[NDVIp.Binratiod1f == NDVIbd1f]
                NDVIc1 = NDVIselecao1[NDVIselecao1.bin_n == NDVIselecao1.bin_n.max()]
                NDVIlista1.append(int(NDVIc1.bin_n.tolist()[0]))
                NDVIselecao2 = NDVIp[NDVIp.Binratiod2f == NDVIbd2f]
                NDVIc2 = NDVIselecao2[NDVIselecao2.bin_n == NDVIselecao2.bin_n.max()]
                NDVIlista2.append(int(NDVIc2.bin_n.tolist()[0]))
                NDVIchoice1 = pd.DataFrame(NDVIlista1)
                NDVIchoice2 = pd.DataFrame(NDVIlista2)
                NDVIchoice1.to_csv(NDVIbind1f,index= False, header=False)   
                NDVIchoice2.to_csv(NDVIbind2f,index= False, header=False)   
                NDVIT1list=[]
                NDVIT2list=[]
                rNDVIT2list=[]
                #NDVI Select one threshold based on d1f (if any)
                NDVIbind1f_num=str(NDVIlista1[0])
                NDVIp1=self.dlg.lin_out.text()+'/dNDVI_'+NDVIbind1f_num+'_d2f.csv'
                NDVIc1=pd.read_csv(NDVIp1)
                NDVIc1up5=len(NDVIc1)
                NDVIc1['d1f']=pd.to_numeric(NDVIc1['d1f'], errors='coerce')
                NDVIc1countmax=NDVIc1['count'][1:NDVIc1up5].max()
                NDVIc1xmax=float(NDVIc1[NDVIc1['count']==NDVIc1countmax]['x'])
                NDVIc1inf=NDVIc1[(NDVIc1['x']<=NDVIc1xmax)]
                NDVIc1up1=len(NDVIc1inf)-1
                NDVIc1r1=list(range(1,NDVIc1up1))
                for i in NDVIc1r1:
                        NDVIji=i
                        NDVIji2=NDVIji+1
                        NDVIj0=i-1
                        NDVIxi=NDVIc1inf.iloc[NDVIji]["x"]
                        NDVIxi2=NDVIc1inf.iloc[NDVIji2]["x"]
                        NDVIx0=NDVIc1inf.iloc[NDVIj0]["x"]
                        NDVId1fi=float(NDVIc1inf.iloc[NDVIji]["d1f"])
                        NDVId1fi2=float(NDVIc1inf.iloc[NDVIji2]["d1f"])
                        NDVId1f0=float(NDVIc1inf.iloc[NDVIj0]["d1f"])
                        if (NDVId1fi>0 and NDVId1f0<0):
                            NDVIT1=(NDVIxi+NDVIx0)/2
                            NDVIT1list.append(NDVIT1)
                        else:
                            continue    
        # NDVI Select threshold(s) based on d2f
                NDVIbind2f_num=str(NDVIlista2[0])
                NDVIp1=self.dlg.lin_out.text()+'/dNDVI_'+NDVIbind2f_num+'_d2f.csv'
                NDVIc1=pd.read_csv(NDVIp1)
                NDVIup5=len(NDVIc1)
                NDVIc1['d2f']=pd.to_numeric(NDVIc1['d2f'], errors='coerce')
                NDVId2fmin=NDVIc1['d2f'][1:NDVIup5].min()
                NDVIxmax=float(NDVIc1[NDVIc1['d2f']==NDVId2fmin]['x'])
                NDVIc1inf=NDVIc1[(NDVIc1['x']<=NDVIxmax)]
                NDVIc1up2=len(NDVIc1inf)-1
                NDVIc1r2=list(range(NDVIc1up2,2,-1))
                NDVIcnt=1
                for i in NDVIc1r2:
                        NDVIji2=i
                        NDVIji=i-1
                        NDVIj0=i-2
                        NDVIxi=NDVIc1inf.iloc[NDVIji]["x"]
                        NDVIx0=NDVIc1inf.iloc[NDVIj0]["x"]
                        NDVIxi2=NDVIc1inf.iloc[NDVIji2]["x"]
                        NDVId2fi=float(NDVIc1inf.iloc[NDVIji]["d2f"])
                        NDVId2fi2=float(NDVIc1inf.iloc[NDVIji2]["d2f"])
                        NDVId2f0=float(NDVIc1inf.iloc[NDVIj0]["d2f"])
                        if NDVId2fi<0:
                            NDVIcnt=1
                        if (NDVId2fi>NDVId2f0 and NDVId2fi>NDVId2fi2 and NDVId2fi>0 and NDVIcnt>=1):
                            NDVIT2=NDVIxi
                            NDVIT2list.append(NDVIT2)
                            NDVIcnt=0
                        else:
                            continue
                rNDVIT2list=NDVIT2list[::-1]
        #NDVI Save Threshold list to csvsl
                NDVIT1L= pd.DataFrame(NDVIT1list)
                NDVIT1_p=self.dlg.lin_out.text()+'/NDVIT1.csv'
                NDVIT2_p=self.dlg.lin_out.text()+'/NDVIT2.csv'
                NDVIThresh_p=self.dlg.lin_out.text()+'/NDVIThresh.csv'
                NDVIT1L.to_csv(NDVIT1_p, header= False, index = False)
                NDVIT2L= pd.DataFrame(rNDVIT2list)
                NDVIT2L.to_csv(NDVIT2_p, header= False, index = False)
                NDVIT1Len=len(NDVIT1list)
                rNDVIT2Len=len(rNDVIT2list)
                NDVIThresh=[]
                i, j= 0, 0
                while i<NDVIT1Len and j<rNDVIT2Len:
                    if NDVIT1list[i] < rNDVIT2list[j]:
                        NDVIThresh.append(NDVIT1list[i])
                        i +=1
                    else:
                        NDVIThresh.append(rNDVIT2list[j])
                        j +=1
                NDVIThresh=NDVIThresh+ NDVIT1list[i:] + rNDVIT2list[j:]
                NDVIThreshL=pd.DataFrame(NDVIThresh)
                NDVIThreshL.to_csv(NDVIThresh_p, header= False, index = False)
                NDVIly=[]
                for tr in NDVIThresh:
                    NDVIly.append(tr)
                    NDVIlw=len(NDVIly)
                if NDVIlw>=1:
                    if NDVIlw==1:
                        NDVIT1=[]
                        NDVIT1=[str(NDVIly[0])]
                        consequences_c_dNDVI = []
                        cons_c_dndvi=QgsRasterCalculatorEntry()
                        cons_c_dndvi.ref='dndvi@1'
                        cons_c_dndvi.raster = dndvi_layer
                        cons_c_dndvi.bandNumber=1
                        consequences_c_dNDVI.append(cons_c_dndvi)    
                        c_dndvi_exp='(' +consequences_c_dNDVI[0].ref + ' <' +NDVIT1[0]+')* 1 + (' +consequences_c_dNDVI[0].ref + '>= ' +NDVIT1[0]+' )*0'
                        c_dndvi_file = self.dlg.lin_out.text()+ '/c_dNDVI.tif'
                        c_dndvi = QgsRasterCalculator(c_dndvi_exp,
                                                   c_dndvi_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNDVI)                           
                        c_dndvi.processCalculation()
                        c_dndvi_layer = QgsRasterLayer(c_dndvi_file,'c_dNDVI')
                        QgsProject.instance().addMapLayer(c_dndvi_layer)   
                    elif NDVIlw>=2:
                        NDVIT1=[]
                        NDVIT2=[]
                        aa=NDVIlw-1
                        bb=NDVIlw-2
                        NDVIT1=[str(NDVIly[aa])]
                        NDVIT2=[str(NDVIly[bb])]
                        consequences_c_dNDVI = []
                        cons_c_dndvi=QgsRasterCalculatorEntry()
                        cons_c_dndvi.ref='dndvi@1'
                        cons_c_dndvi.raster = dndvi_layer
                        cons_c_dndvi.bandNumber=1
                        consequences_c_dNDVI.append(cons_c_dndvi)     
                        c_dndvi_exp='(' +consequences_c_dNDVI[0].ref + ' >=' +NDVIT1[0]+')* 0 + (' +consequences_c_dNDVI[0].ref + '< ' +NDVIT1[0]+' )*(' +consequences_c_dNDVI[0].ref + ' <' +NDVIT2[0]+')*10+ (' +consequences_c_dNDVI[0].ref + '< ' +NDVIT1[0]+' )*(' +consequences_c_dNDVI[0].ref + ' >=' +NDVIT2[0]+')*1'
                        c_dndvi_file = self.dlg.lin_out.text()+ '/c_dNDVI.tif'
                        c_dndvi = QgsRasterCalculator(c_dndvi_exp,
                                                   c_dndvi_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNDVI)                               
                        c_dndvi.processCalculation()
                        c_dndvi_layer = QgsRasterLayer(c_dndvi_file,'c_dNDVI')
                        QgsProject.instance().addMapLayer(c_dndvi_layer)              
           #NDWI: 
                NDWI0file = self.dlg.lin_out.text()+ '/NDWI0.tif'
                NDWI1file = self.dlg.lin_out.text()+ '/NDWI1.tif'
                if self.dlg.Cb_topo.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':tgreen0_path,'b':tnir0_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NDWI0file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.mapcalc.simple", {'a':tgreen1_path,'b':tnir1_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NDWI1file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    NDWI0_layer = QgsRasterLayer(NDWI0file,'NDWI_0')
                    NDWI1_layer = QgsRasterLayer(NDWI1file,'NDWI_1')
                else:
                    NDWI0_exp = '((((' + entries[4].ref + ' - ' + entries[6].ref + ') / ('+ entries[4].ref + ' + ' + entries[6].ref +'))>=-1)*(((' + entries[4].ref + ' - ' + entries[6].ref + ') / ('+ entries[4].ref + ' + ' + entries[6].ref +'))<=1))*(((' + entries[4].ref + ' - ' + entries[6].ref + ') / ('+ entries[4].ref + ' + ' + entries[6].ref +')))' 
                    NDWI1_exp = '((((' + entries[10].ref + ' - ' + entries[12].ref + ') / ('+ entries[10].ref + ' + ' + entries[12].ref +'))>=-1)*(((' + entries[10].ref + ' - ' + entries[12].ref + ') / ('+ entries[10].ref + ' + ' + entries[12].ref +'))<=1))*(((' + entries[10].ref + ' - ' + entries[12].ref + ') / ('+ entries[10].ref + ' + ' + entries[12].ref +')))' 
                    NDWI0 = QgsRasterCalculator(NDWI0_exp,
                                               NDWI0file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries) 
                    NDWI0.processCalculation()
                    NDWI0_layer = QgsRasterLayer(NDWI0file,'NDWI_0')
                    NDWI1 = QgsRasterCalculator(NDWI1_exp,
                                               NDWI1file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    NDWI1.processCalculation()
                    NDWI1_layer = QgsRasterLayer(NDWI1file,'NDWI_1')
            #dNDWI:
                consequences = []
                cons_NDWI0=QgsRasterCalculatorEntry()
                cons_NDWI0.ref='NDWI0@1'
                cons_NDWI0.raster = NDWI0_layer
                cons_NDWI0.bandNumber=1
                consequences.append(cons_NDWI0)
                cons_NDWI1=QgsRasterCalculatorEntry()
                cons_NDWI1.ref='NDWI1@1'
                cons_NDWI1.raster = NDWI1_layer
                cons_NDWI1.bandNumber=1
                consequences.append(cons_NDWI1)  
                if self.dlg.Cb_cloud.isChecked():
                    cons_csg=QgsRasterCalculatorEntry()
                    cons_csg.ref='csg@1'
                    cons_csg.raster = csg_layer
                    cons_csg.bandNumber=1
                    consequences.append(cons_csg)
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNDWI_exp='(' +consequences[2].ref + '*' +consequences[3].ref + '*' +consequences[1].ref + ' - ' + consequences[0].ref + ')'
                    else:
                        dNDWI_exp='(' +consequences[2].ref + '*' +consequences[1].ref + ' - ' + consequences[0].ref + ')'
                else:
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNDWI_exp='(' +consequences[2].ref + '*' +consequences[1].ref + ' - '+ consequences[0].ref + ')'
                    else:
                        dNDWI_exp='(' +consequences[1].ref + ' - '+ consequences[0].ref + ')'
                dNDWI_file = self.dlg.lin_out.text()+ '/d_NDWI.tif'
                
                dNDWI = QgsRasterCalculator(dNDWI_exp,
                                           dNDWI_file,
                                           'GTiff',
                                           extent,
                                           width,
                                           height,
                                           consequences)                                
                dNDWI.processCalculation()
                if self.dlg.Cb_water.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':dNDWI_file,'b':layers[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':dNDWI_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                dNDWI_layer = QgsRasterLayer(dNDWI_file,'dNDWI')  
                for b in bin_n:
                    bstr=str(b)
                    bint=b
                    dNDWIstats=self.dlg.lin_out.text()+'/dNDWI_'+bstr+'.csv'
                    NDWIpath=self.dlg.lin_out.text()+'/dNDWI_'+bstr+'_d2f.csv' 
                    processing.run("grass7:r.stats", {'input':[dNDWI_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(dNDWIstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                    f = open(dNDWIstats)
                    text = f.read()
                    f.close()
                    clean = re.sub('<[^>]+>', '', text)
                    f   = open(dNDWIstats, 'w')
                    f.write(clean)
                    f.close()
                    NDWIdf_uns=pd.read_csv(dNDWIstats, header=None)
                    NDWIdf_uns.columns= ["x","count"]
                    NDWIdf = NDWIdf_uns.sort_values (by=['x'])
                    NDWIdf.to_csv(dNDWIstats, index=False)
                    NDWIup=len(NDWIdf)
                    NDWIup2=len(NDWIdf)-1
                    NDWIup3=len(NDWIdf)-2
                    NDWIup4=len(NDWIdf)-3
                    NDWIup5=len(NDWIdf)-4
                    NDWIj=0
                    NDWIr=list(range(0,NDWIup2))
                    NDWIl1=list(range(0,NDWIup))
                    NDWIr2=list(range(3,NDWIup3))
                    NDWIl2=list(range(0,NDWIup))
                    NDWIr3=list(range(2,NDWIup3))
                    NDWIl3=list(range(0,NDWIup))
                    NDWIl4=list(range(0,NDWIup))
                    NDWIr4=list(range(2,NDWIup3))
                    NDWIr5=list(range(3,NDWIup3))
         #NDWI d1f calculation
                    for ig in NDWIr:
                        NDWIj0=ig
                        NDWIji=NDWIj0+1
                        NDWIxi=NDWIdf.iloc[NDWIji]["x"]
                        NDWIyi=NDWIdf.iloc[NDWIji]["count"]
                        NDWIx0=NDWIdf.iloc[NDWIj0]["x"]
                        NDWIy0=NDWIdf.iloc[NDWIj0]["count"]
                        NDWIdi=(NDWIyi-NDWIy0)/(NDWIxi-NDWIx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                        NDWIl1[NDWIj0]=NDWIdi
                    NDWIl1[NDWIup2]=" "
                    NDWIdf.insert(2,'d1f',NDWIl1, True)
             #NDWId2f calculation   
                    for ih in NDWIr3:
                        NDWIhi=ih
                        NDWIh0=NDWIhi-1
                        NDWIxi=NDWIdf.iloc[NDWIhi]["x"]
                        NDWId1fi=float(NDWIdf.iloc[NDWIhi]['d1f'])
                        NDWIx0=NDWIdf.iloc[NDWIh0]["x"]
                        NDWId1f0=float(NDWIdf.iloc[NDWIh0]['d1f'])
                        NDWId2i=((NDWId1fi-NDWId1f0)/(2*NDWIxi-2*NDWIx0))/1.5
                        NDWIl2[NDWIhi]=NDWId2i
                    NDWIl2[0]=" "
                    NDWIl2[NDWIup2]=" "
                    NDWIdf.insert(3,'d2f',NDWIl2, True)
            #NDWI Calculate consecutive values ratio for d1f
                    NDWIcountposd1f=0
                    NDWIcountnegd1f=0
                    NDWIlistposnegd1f=[]
                    NDWIdf['count']=pd.to_numeric(NDWIdf['count'], errors='coerce')
                    NDWIdf['d1f']=pd.to_numeric(NDWIdf['d1f'], errors='coerce')
                    NDWIdf['d2f']=pd.to_numeric(NDWIdf['d2f'], errors='coerce')
                    NDWIcountmax=NDWIdf['count'][1:NDWIup5].max()
                    try:
                        NDWIxmax=float(NDWIdf[NDWIdf['count']==NDWIcountmax]['x'])
                    except Exception:
                        NDWIxmax=0.0
                    NDWIsup=NDWIdf[(NDWIdf['x']>=NDWIxmax)] 
                    NDWIup1=len(NDWIsup)-1
                    NDWIr1=list(range(0,NDWIup1))
                    NDWIr1len=len(NDWIr1)
                    for iib in NDWIr1:
                        NDWIji=iib
                        NDWIj0=NDWIji-1
                        NDWId1fi=float(NDWIsup.iloc[NDWIji]["d1f"])
                        NDWId1f0=float(NDWIsup.iloc[NDWIj0]["d1f"])
                        NDWIx0=float(NDWIsup.iloc[NDWIj0]["x"])
                        if (NDWId1fi>NDWId1f0):
                            NDWIlistposnegd1f.append(1)
                        elif (NDWId1fi<NDWId1f0):
                            NDWIlistposnegd1f.append(0)
                    for iiib in range(1,len(NDWIlistposnegd1f)):
                            if NDWIlistposnegd1f[iiib-1] == NDWIlistposnegd1f[iiib]:
                                if NDWIlistposnegd1f[iiib-1] == 1:
                                    NDWIcountposd1f = NDWIcountposd1f + 1
                                else:
                                    NDWIcountnegd1f = NDWIcountnegd1f + 1
                    try:
                        NDWIBinratiod1f= (NDWIcountposd1f+NDWIcountnegd1f)/float(NDWIr1len)
                    except:
                        continue
                    NDWILBinratiod1f.append(NDWIBinratiod1f)
              # NDWI calculate consecutive values ratio for d2f
                    NDWIcountposd2f=0
                    NDWIcountnegd2f=0
                    NDWIlistposnegd2f=[]
                    NDWIup2=len(NDWIsup)-1
                    NDWIr2=list(range(0,NDWIup2))
                    NDWIr2len=len(NDWIr2)
                    for ivb in NDWIr2:
                        NDWIji=ivb
                        NDWIj0=NDWIji-1
                        NDWId2fi=float(NDWIsup.iloc[NDWIji]["d2f"])
                        NDWId2f0=float(NDWIsup.iloc[NDWIj0]["d2f"])
                        NDWIx0=float(NDWIsup.iloc[NDWIj0]["x"])
                        if (NDWId2fi>NDWId2f0):
                            NDWIlistposnegd2f.append(1)
                        elif (NDWId2fi<NDWId2f0):
                            NDWIlistposnegd2f.append(0)
                    for vb in range(1,len(NDWIlistposnegd2f)):
                            if NDWIlistposnegd2f[vb-1] == NDWIlistposnegd2f[vb]:
                                if NDWIlistposnegd2f[vb-1] == 1:
                                    NDWIcountposd2f = NDWIcountposd2f + 1
                                else:
                                    NDWIcountnegd2f = NDWIcountnegd2f + 1
                    try:
                        NDWIBinratiod2f=(NDWIcountposd2f+NDWIcountnegd2f)/float(NDWIr2len)
                    except:
                        continue
                    NDWILBinratiod2f.append(NDWIBinratiod2f)
                    NDWIdf.to_csv(NDWIpath, index=False)
                    os.remove(dNDWIstats)
                # NDWI: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
                del NDWIdf
                NDWIp = pd.DataFrame(NDWIL, columns = ['bin_n'])
                NDWIp['Binratiod1f']=NDWILBinratiod1f
                NDWIp['Binratiod2f']=NDWILBinratiod2f
                NDWIratio=self.dlg.lin_out.text()+'/dNDWI_ratio.csv'
                NDWIp.to_csv(NDWIratio, index = False)
                NDWIbd1f = NDWIp.max()['Binratiod1f']
                NDWIbd2f = NDWIp.max()['Binratiod2f']
                NDWIlista1 = []
                NDWIlista2 = []
                NDWIbind1f=self.dlg.lin_out.text()+'/dNDWI_d1fbin.csv'
                NDWIbind2f=self.dlg.lin_out.text()+'/dNDWI_d2fbin.csv'
                NDWIselecao1 = NDWIp[NDWIp.Binratiod1f == NDWIbd1f]
                NDWIc1 = NDWIselecao1[NDWIselecao1.bin_n == NDWIselecao1.bin_n.max()]
                NDWIlista1.append(int(NDWIc1.bin_n.tolist()[0]))
                NDWIselecao2 = NDWIp[NDWIp.Binratiod2f == NDWIbd2f]
                NDWIc2 = NDWIselecao2[NDWIselecao2.bin_n == NDWIselecao2.bin_n.max()]
                NDWIlista2.append(int(NDWIc2.bin_n.tolist()[0]))
                NDWIchoice1 = pd.DataFrame(NDWIlista1)
                NDWIchoice2 = pd.DataFrame(NDWIlista2)
                NDWIchoice1.to_csv(NDWIbind1f,index= False, header=False)   
                NDWIchoice2.to_csv(NDWIbind2f,index= False, header=False)   
                NDWIT1list=[]
                NDWIT2list=[]
        #NDWI Select one threshold based on d1f (if any)
                NDWIbind1f_num=str(NDWIlista1[0])
                NDWIp1=self.dlg.lin_out.text()+'/dNDWI_'+NDWIbind1f_num+'_d2f.csv'
                NDWIc1=pd.read_csv(NDWIp1)
                NDWIc1up5=len(NDWIc1)
                NDWIc1['d1f']=pd.to_numeric(NDWIc1['d1f'], errors='coerce')
                NDWIc1countmax=NDWIc1['count'][1:NDWIc1up5].max()
                NDWIc1xmax=float(NDWIc1[NDWIc1['count']==NDWIc1countmax]['x'])
                NDWIc1sup=NDWIc1[(NDWIc1['x']>=NDWIc1xmax)]
                NDWIc1up1=len(NDWIc1sup)-2
                NDWIc1r1=list(range(NDWIc1up1))
                for i in NDWIc1r1:
                        NDWIji=i
                        NDWIj0=i-1
                        NDWIxi=NDWIc1sup.iloc[NDWIji]["x"]
                        NDWIx0=NDWIc1sup.iloc[NDWIj0]["x"]
                        NDWId1fi=float(NDWIc1sup.iloc[NDWIji]["d1f"])
                        NDWId1f0=float(NDWIc1sup.iloc[NDWIj0]["d1f"])
                        if (NDWId1f0<0 and NDWId1fi>0):
                            NDWIT1=(NDWIxi+NDWIx0)/2
                            NDWIT1list.append(NDWIT1)
                        else:
                            continue    
        # NDWI Select threshold(s) based on d2f
                NDWIbind2f_num=str(NDWIlista2[0])
                NDWIp1=self.dlg.lin_out.text()+'/dNDWI_'+NDWIbind2f_num+'_d2f.csv'
                NDWIc1=pd.read_csv(NDWIp1)
                NDWIup5=len(NDWIc1)
                NDWIc1['d2f']=pd.to_numeric(NDWIc1['d2f'], errors='coerce')
                NDWId2fmin=NDWIc1['d2f'][1:NDWIup5].min()
                NDWIxmax=float(NDWIc1[NDWIc1['d2f']==NDWId2fmin]['x'])
                NDWIc1sup=NDWIc1[(NDWIc1['x']>=NDWIxmax)]
                NDWIc1up2=len(NDWIc1sup)-3
                NDWIc1r2=list(range(NDWIc1up2))
                NDWIcnt=1
                for i in NDWIc1r2:
                    NDWIji2=i+1
                    NDWIji=i
                    NDWIj0=i-1
                    NDWIxi=NDWIc1sup.iloc[NDWIji]["x"]
                    NDWIx0=NDWIc1sup.iloc[NDWIj0]["x"]
                    NDWIxi2=NDWIc1sup.iloc[NDWIji2]["x"]
                    NDWId2fi=float(NDWIc1sup.iloc[NDWIji]["d2f"])
                    NDWId2fi2=float(NDWIc1sup.iloc[NDWIji2]["d2f"])
                    NDWId2f0=float(NDWIc1sup.iloc[NDWIj0]["d2f"])
                    if NDWId2f0<0:
                        NDWIcnt=1
                    if (NDWId2fi>NDWId2f0 and NDWId2fi>NDWId2fi2 and NDWId2fi>0 and NDWIcnt>=1): 
                        NDWIT2=NDWIxi
                        NDWIT2list.append(NDWIT2)
                        NDWIcnt=0
                    else:
                        continue
        #NDWI Save Threshold list to csvsl
                NDWIT1L= pd.DataFrame(NDWIT1list)
                NDWIT1_p=self.dlg.lin_out.text()+'/NDWIT1.csv'
                NDWIT2_p=self.dlg.lin_out.text()+'/NDWIT2.csv'
                NDWIThresh_p=self.dlg.lin_out.text()+'/NDWIThresh.csv'
                NDWIT1L.to_csv(NDWIT1_p, header= False, index = False)
                NDWIT2L= pd.DataFrame(NDWIT2list)
                NDWIT2L.to_csv(NDWIT2_p, header= False, index = False)
                NDWIT1Len=len(NDWIT1list)
                NDWIT2Len=len(NDWIT2list)
                NDWIThresh=[]
                i, j= 0, 0
                while i<NDWIT1Len and j<NDWIT2Len:
                    if NDWIT1list[i] < NDWIT2list[j]:
                        NDWIThresh.append(NDWIT1list[i])
                        i +=1
                    else:
                        NDWIThresh.append(NDWIT2list[j])
                        j +=1
                NDWIThresh=NDWIThresh+ NDWIT1list[i:] + NDWIT2list[j:]
                NDWIThreshL=pd.DataFrame(NDWIThresh)
                NDWIThreshL.to_csv(NDWIThresh_p, header= False, index = False)
                NDWIly=[]
                for tr in NDWIThresh:
                    NDWIly.append(tr)
                    NDWIlw=len(NDWIly)
                if NDWIlw>=1:
                    if NDWIlw==1:
                        NDWIT1=[]
                        NDWIT1=[str(NDWIly[0])]
                        consequences_c_dNDWI = []
                        cons_c_dNDWI=QgsRasterCalculatorEntry()
                        cons_c_dNDWI.ref='dNDWI@1'
                        cons_c_dNDWI.raster = dNDWI_layer
                        cons_c_dNDWI.bandNumber=1
                        consequences_c_dNDWI.append(cons_c_dNDWI)    
                        c_dNDWI_exp='(' +consequences_c_dNDWI[0].ref + ' >' +NDWIT1[0]+')* 1 + (' +consequences_c_dNDWI[0].ref + '<= ' +NDWIT1[0]+' )*0'
                        c_dNDWI_file = self.dlg.lin_out.text()+ '/c_dNDWI.tif'
                        c_dNDWI = QgsRasterCalculator(c_dNDWI_exp,
                                                   c_dNDWI_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNDWI)                           
                        c_dNDWI.processCalculation()
                        c_dNDWI_layer = QgsRasterLayer(c_dNDWI_file,'c_dNDWI')
                        QgsProject.instance().addMapLayer(c_dNDWI_layer)   
                    elif NDWIlw>=2:
                        NDWIT1=[]
                        NDWIT2=[]
                        NDWIT1=[str(NDWIly[0])]
                        NDWIT2=[str(NDWIly[1])]
                        consequences_c_dNDWI = []
                        cons_c_dNDWI=QgsRasterCalculatorEntry()
                        cons_c_dNDWI.ref='dNDWI@1'
                        cons_c_dNDWI.raster = dNDWI_layer
                        cons_c_dNDWI.bandNumber=1
                        consequences_c_dNDWI.append(cons_c_dNDWI)     
                        c_dNDWI_exp='(' +consequences_c_dNDWI[0].ref + ' <=' +NDWIT1[0]+')* 0 + (' +consequences_c_dNDWI[0].ref + '> ' +NDWIT1[0]+' )*(' +consequences_c_dNDWI[0].ref + ' >=' +NDWIT2[0]+')*10+ (' +consequences_c_dNDWI[0].ref + '> ' +NDWIT1[0]+' )*(' +consequences_c_dNDWI[0].ref + ' <' +NDWIT2[0]+')*1'
                        c_dNDWI_file = self.dlg.lin_out.text()+ '/c_dNDWI.tif'
                        c_dNDWI = QgsRasterCalculator(c_dNDWI_exp,
                                                   c_dNDWI_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNDWI)                    
                        c_dNDWI.processCalculation()
                        c_dNDWI_layer = QgsRasterLayer(c_dNDWI_file,'c_dNDWI')
                        QgsProject.instance().addMapLayer(c_dNDWI_layer)              
                #MNDWI: 
                MNDWI0file = self.dlg.lin_out.text()+ '/MNDWI0.tif'
                MNDWI1file = self.dlg.lin_out.text()+ '/MNDWI1.tif'
                if self.dlg.Cb_topo.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':tgreen0_path,'b':tswirs0_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':MNDWI0file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.mapcalc.simple", {'a':tgreen1_path,'b':tswirs1_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':MNDWI1file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    MNDWI0_layer = QgsRasterLayer(MNDWI0file,'MNDWI_0')
                    MNDWI1_layer = QgsRasterLayer(MNDWI1file,'MNDWI_1')
                else:    
                    MNDWI0_exp = '((((' + entries[4].ref + ' - ' + entries[7].ref + ') / ('+ entries[4].ref + ' + ' + entries[7].ref +'))>=-1)*(((' + entries[4].ref + ' - ' + entries[7].ref + ') / ('+ entries[4].ref + ' + ' + entries[7].ref +'))<=1))*(((' + entries[4].ref + ' - ' + entries[7].ref + ') / ('+ entries[4].ref + ' + ' + entries[7].ref +')))' 
                    MNDWI1_exp = '((((' + entries[10].ref + ' - ' + entries[13].ref + ') / ('+ entries[10].ref + ' + ' + entries[13].ref +'))>=-1)*(((' + entries[10].ref + ' - ' + entries[13].ref + ') / ('+ entries[10].ref + ' + ' + entries[13].ref +'))<=1))*(((' + entries[10].ref + ' - ' + entries[13].ref + ') / ('+ entries[10].ref + ' + ' + entries[13].ref +')))' 
                    MNDWI0 = QgsRasterCalculator(MNDWI0_exp,
                                               MNDWI0file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    MNDWI0.processCalculation()
                    MNDWI0_layer = QgsRasterLayer(MNDWI0file,'MNDWI_0')
                    MNDWI1 = QgsRasterCalculator(MNDWI1_exp,
                                               MNDWI1file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries) 
                    MNDWI1.processCalculation()
                    MNDWI1_layer = QgsRasterLayer(MNDWI1file,'MNDWI_1')
            #dMNDWI:
                consequences = []
                cons_MNDWI0=QgsRasterCalculatorEntry()
                cons_MNDWI0.ref='MNDWI0@1'
                cons_MNDWI0.raster = MNDWI0_layer
                cons_MNDWI0.bandNumber=1
                consequences.append(cons_MNDWI0)
                cons_MNDWI1=QgsRasterCalculatorEntry()
                cons_MNDWI1.ref='MNDWI1@1'
                cons_MNDWI1.raster = MNDWI1_layer
                cons_MNDWI1.bandNumber=1
                consequences.append(cons_MNDWI1)       
                if self.dlg.Cb_cloud.isChecked():
                    cons_csg=QgsRasterCalculatorEntry()
                    cons_csg.ref='csg@1'
                    cons_csg.raster = csg_layer
                    cons_csg.bandNumber=1
                    consequences.append(cons_csg)
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dMNDWI_exp='(' +consequences[2].ref + '*' +consequences[3].ref + '*' +consequences[1].ref + ' - ' + consequences[0].ref + ')'
                    else:
                        dMNDWI_exp='(' +consequences[2].ref + '*' +consequences[1].ref + ' - ' + consequences[0].ref + ')'
                else:
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dMNDWI_exp='(' +consequences[2].ref + '*' +consequences[1].ref + ' - '+ consequences[0].ref + ')'
                    else:
                        dMNDWI_exp='(' +consequences[1].ref + ' - '+ consequences[0].ref + ')'
     #      
                dMNDWI_file = self.dlg.lin_out.text()+ '/d_MNDWI.tif'
                dMNDWI = QgsRasterCalculator(dMNDWI_exp,
                                           dMNDWI_file,
                                           'GTiff',
                                           extent,
                                           width,
                                           height,
                                           consequences)                               
                dMNDWI.processCalculation()
                if self.dlg.Cb_water.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':dMNDWI_file,'b':layers[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':dMNDWI_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                dMNDWI_layer = QgsRasterLayer(dMNDWI_file,'dMNDWI')
                for b in bin_n:
                    bstr=str(b)
                    bint=b
                    dMNDWIstats=self.dlg.lin_out.text()+'/dMNDWI_'+bstr+'.csv'
                    MNDWIpath=self.dlg.lin_out.text()+'/dMNDWI_'+bstr+'_d2f.csv' 
                    processing.run("grass7:r.stats", {'input':[dMNDWI_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(dMNDWIstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                    f = open(dMNDWIstats)
                    text = f.read()
                    f.close()
                    clean = re.sub('<[^>]+>', '', text)
                    f   = open(dMNDWIstats, 'w')
                    f.write(clean)
                    f.close()
                    MNDWIdf_uns=pd.read_csv(dMNDWIstats, header=None)
                    MNDWIdf_uns.columns= ["x","count"]
                    MNDWIdf = MNDWIdf_uns.sort_values (by=['x'])
                    MNDWIdf.to_csv(dMNDWIstats, index=False)
                    MNDWIup=len(MNDWIdf)
                    MNDWIup2=len(MNDWIdf)-1
                    MNDWIup3=len(MNDWIdf)-2
                    MNDWIup4=len(MNDWIdf)-3
                    MNDWIup5=len(MNDWIdf)-4
                    MNDWIj=0
                    MNDWIr=list(range(0,MNDWIup2))
                    MNDWIl1=list(range(0,MNDWIup))
                    MNDWIr2=list(range(3,MNDWIup3))
                    MNDWIl2=list(range(0,MNDWIup))
                    MNDWIr3=list(range(2,MNDWIup3))
                    MNDWIl3=list(range(0,MNDWIup))
                    MNDWIl4=list(range(0,MNDWIup))
                    MNDWIr4=list(range(2,MNDWIup3))
                    MNDWIr5=list(range(3,MNDWIup3))
         #MNDWI d1f calculation
                    for ig in MNDWIr:
                        MNDWIj0=ig
                        MNDWIji=MNDWIj0+1
                        MNDWIxi=MNDWIdf.iloc[MNDWIji]["x"]
                        MNDWIyi=MNDWIdf.iloc[MNDWIji]["count"]
                        MNDWIx0=MNDWIdf.iloc[MNDWIj0]["x"]
                        MNDWIy0=MNDWIdf.iloc[MNDWIj0]["count"]
                        MNDWIdi=(MNDWIyi-MNDWIy0)/(MNDWIxi-MNDWIx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                        MNDWIl1[MNDWIj0]=MNDWIdi
                    MNDWIl1[MNDWIup2]=" "
                    MNDWIdf.insert(2,'d1f',MNDWIl1, True)
             #MNDWId2f calculation   
                    for ih in MNDWIr3:
                        MNDWIhi=ih
                        MNDWIh0=MNDWIhi-1
                        MNDWIxi=MNDWIdf.iloc[MNDWIhi]["x"]
                        MNDWId1fi=float(MNDWIdf.iloc[MNDWIhi]['d1f'])
                        MNDWIx0=MNDWIdf.iloc[MNDWIh0]["x"]
                        MNDWId1f0=float(MNDWIdf.iloc[MNDWIh0]['d1f'])
                        MNDWId2i=((MNDWId1fi-MNDWId1f0)/(2*MNDWIxi-2*MNDWIx0))/1.5
                        MNDWIl2[MNDWIhi]=MNDWId2i
                    MNDWIl2[0]=" "
                    MNDWIl2[MNDWIup2]=" "
                    MNDWIdf.insert(3,'d2f',MNDWIl2, True)
            #MNDWI Calculate consecutive values ratio for d1f
                    MNDWIcountposd1f=0
                    MNDWIcountnegd1f=0
                    MNDWIlistposnegd1f=[]
                    MNDWIdf['count']=pd.to_numeric(MNDWIdf['count'], errors='coerce')
                    MNDWIdf['d1f']=pd.to_numeric(MNDWIdf['d1f'], errors='coerce')
                    MNDWIdf['d2f']=pd.to_numeric(MNDWIdf['d2f'], errors='coerce')
                    MNDWIcountmax=MNDWIdf['count'][1:MNDWIup5].max()
                    try:
                        MNDWIxmax=float(MNDWIdf[MNDWIdf['count']==MNDWIcountmax]['x'])
                    except Exception:
                        MNDWIxmax=0.0
                    MNDWIsup=MNDWIdf[(MNDWIdf['x']>=MNDWIxmax)] 
                    MNDWIup1=len(MNDWIsup)-1
                    MNDWIr1=list(range(0,MNDWIup1))
                    MNDWIr1len=len(MNDWIr1)
                    for iib in MNDWIr1:
                        MNDWIji=iib
                        MNDWIj0=MNDWIji-1
                        MNDWId1fi=float(MNDWIsup.iloc[MNDWIji]["d1f"])
                        MNDWId1f0=float(MNDWIsup.iloc[MNDWIj0]["d1f"])
                        MNDWIx0=float(MNDWIsup.iloc[MNDWIj0]["x"])
                        if (MNDWId1fi>MNDWId1f0):
                            MNDWIlistposnegd1f.append(1)
                        elif (MNDWId1fi<MNDWId1f0):
                            MNDWIlistposnegd1f.append(0)
                    for iiib in range(1,len(MNDWIlistposnegd1f)):
                            if MNDWIlistposnegd1f[iiib-1] == MNDWIlistposnegd1f[iiib]:
                                if MNDWIlistposnegd1f[iiib-1] == 1:
                                    MNDWIcountposd1f = MNDWIcountposd1f + 1
                                else:
                                    MNDWIcountnegd1f = MNDWIcountnegd1f + 1
                    try:
                        MNDWIBinratiod1f= (MNDWIcountposd1f+MNDWIcountnegd1f)/float(MNDWIr1len)
                    except:
                        continue
                    MNDWILBinratiod1f.append(MNDWIBinratiod1f)
              # MNDWI calculate consecutive values ratio for d2f
                    MNDWIcountposd2f=0
                    MNDWIcountnegd2f=0
                    MNDWIlistposnegd2f=[]
                    MNDWIup2=len(MNDWIsup)-1
                    MNDWIr2=list(range(0,MNDWIup2))
                    MNDWIr2len=len(MNDWIr2)
                    for ivb in MNDWIr2:
                        MNDWIji=ivb
                        MNDWIj0=MNDWIji-1
                        MNDWId2fi=float(MNDWIsup.iloc[MNDWIji]["d2f"])
                        MNDWId2f0=float(MNDWIsup.iloc[MNDWIj0]["d2f"])
                        MNDWIx0=float(MNDWIsup.iloc[MNDWIj0]["x"])
                        if (MNDWId2fi>MNDWId2f0):
                            MNDWIlistposnegd2f.append(1)
                        elif (MNDWId2fi<MNDWId2f0):
                            MNDWIlistposnegd2f.append(0)
                    for vb in range(1,len(MNDWIlistposnegd2f)):
                            if MNDWIlistposnegd2f[vb-1] == MNDWIlistposnegd2f[vb]:
                                if MNDWIlistposnegd2f[vb-1] == 1:
                                    MNDWIcountposd2f = MNDWIcountposd2f + 1
                                else:
                                    MNDWIcountnegd2f = MNDWIcountnegd2f + 1
                    try:
                        MNDWIBinratiod2f=(MNDWIcountposd2f+MNDWIcountnegd2f)/float(MNDWIr2len)
                    except:
                        continue
                    MNDWILBinratiod2f.append(MNDWIBinratiod2f)
                    MNDWIdf.to_csv(MNDWIpath, index=False)
                    os.remove(dMNDWIstats)
                # MNDWI: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
                del MNDWIdf
                MNDWIp = pd.DataFrame(MNDWIL, columns = ['bin_n'])
                MNDWIp['Binratiod1f']=MNDWILBinratiod1f
                MNDWIp['Binratiod2f']=MNDWILBinratiod2f
                MNDWIratio=self.dlg.lin_out.text()+'/dMNDWI_ratio.csv'
                MNDWIp.to_csv(MNDWIratio, index = False)
                MNDWIbd1f = MNDWIp.max()['Binratiod1f']
                MNDWIbd2f = MNDWIp.max()['Binratiod2f']
                MNDWIlista1 = []
                MNDWIlista2 = []
                MNDWIbind1f=self.dlg.lin_out.text()+'/dMNDWI_d1fbin.csv'
                MNDWIbind2f=self.dlg.lin_out.text()+'/dMNDWI_d2fbin.csv'
                MNDWIselecao1 = MNDWIp[MNDWIp.Binratiod1f == MNDWIbd1f]
                MNDWIc1 = MNDWIselecao1[MNDWIselecao1.bin_n == MNDWIselecao1.bin_n.max()]
                MNDWIlista1.append(int(MNDWIc1.bin_n.tolist()[0]))
                MNDWIselecao2 = MNDWIp[MNDWIp.Binratiod2f == MNDWIbd2f]
                MNDWIc2 = MNDWIselecao2[MNDWIselecao2.bin_n == MNDWIselecao2.bin_n.max()]
                MNDWIlista2.append(int(MNDWIc2.bin_n.tolist()[0]))
                MNDWIchoice1 = pd.DataFrame(MNDWIlista1)
                MNDWIchoice2 = pd.DataFrame(MNDWIlista2)
                MNDWIchoice1.to_csv(MNDWIbind1f,index= False, header=False)   
                MNDWIchoice2.to_csv(MNDWIbind2f,index= False, header=False)   
                MNDWIT1list=[]
                MNDWIT2list=[]
        #MNDWI Select one threshold based on d1f (if any)
                MNDWIbind1f_num=str(MNDWIlista1[0])
                MNDWIp1=self.dlg.lin_out.text()+'/dMNDWI_'+MNDWIbind1f_num+'_d2f.csv'
                MNDWIc1=pd.read_csv(MNDWIp1)
                MNDWIc1up5=len(MNDWIc1)
                MNDWIc1['d1f']=pd.to_numeric(MNDWIc1['d1f'], errors='coerce')
                MNDWIc1countmax=MNDWIc1['count'][1:MNDWIc1up5].max()
                MNDWIc1xmax=float(MNDWIc1[MNDWIc1['count']==MNDWIc1countmax]['x'])
                MNDWIc1sup=MNDWIc1[(MNDWIc1['x']>=MNDWIc1xmax)]
                MNDWIc1up1=len(MNDWIc1sup)-2
                MNDWIc1r1=list(range(MNDWIc1up1))
                for i in MNDWIc1r1:
                        MNDWIji=i
                        MNDWIj0=i-1
                        MNDWIxi=MNDWIc1sup.iloc[MNDWIji]["x"]
                        MNDWIx0=MNDWIc1sup.iloc[MNDWIj0]["x"]
                        MNDWId1fi=float(MNDWIc1sup.iloc[MNDWIji]["d1f"])
                        MNDWId1f0=float(MNDWIc1sup.iloc[MNDWIj0]["d1f"])
                        if (MNDWId1f0<0 and MNDWId1fi>0):
                            MNDWIT1=(MNDWIxi+MNDWIx0)/2
                            MNDWIT1list.append(MNDWIT1)
                        else:
                            continue    
        # MNDWI Select threshold(s) based on d2f
                MNDWIbind2f_num=str(MNDWIlista2[0])
                MNDWIp1=self.dlg.lin_out.text()+'/dMNDWI_'+MNDWIbind2f_num+'_d2f.csv'
                MNDWIc1=pd.read_csv(MNDWIp1)
                MNDWIup5=len(MNDWIc1)
                MNDWIc1['d2f']=pd.to_numeric(MNDWIc1['d2f'], errors='coerce')
                MNDWId2fmin=MNDWIc1['d2f'][1:MNDWIup5].min()
                MNDWIxmax=float(MNDWIc1[MNDWIc1['d2f']==MNDWId2fmin]['x'])
                MNDWIc1sup=MNDWIc1[(MNDWIc1['x']>=MNDWIxmax)]
                MNDWIc1up2=len(MNDWIc1sup)-3
                MNDWIc1r2=list(range(MNDWIc1up2))
                MNDWIcnt=1
                for i in MNDWIc1r2:
                    MNDWIji2=i+1
                    MNDWIji=i
                    MNDWIj0=i-1
                    MNDWIxi=MNDWIc1sup.iloc[MNDWIji]["x"]
                    MNDWIx0=MNDWIc1sup.iloc[MNDWIj0]["x"]
                    MNDWIxi2=MNDWIc1sup.iloc[MNDWIji2]["x"]
                    MNDWId2fi=float(MNDWIc1sup.iloc[MNDWIji]["d2f"])
                    MNDWId2fi2=float(MNDWIc1sup.iloc[MNDWIji2]["d2f"])
                    MNDWId2f0=float(MNDWIc1sup.iloc[MNDWIj0]["d2f"])
                    if MNDWId2f0<0:
                        MNDWIcnt=1
                    if (MNDWId2fi>MNDWId2f0 and MNDWId2fi>MNDWId2fi2 and MNDWId2fi>0 and MNDWIcnt>=1): 
                        MNDWIT2=MNDWIxi
                        MNDWIT2list.append(MNDWIT2)
                        MNDWIcnt=0
                    else:
                        continue
        #MNDWI Save Threshold list to csvsl
                MNDWIT1L= pd.DataFrame(MNDWIT1list)
                MNDWIT1_p=self.dlg.lin_out.text()+'/MNDWIT1.csv'
                MNDWIT2_p=self.dlg.lin_out.text()+'/MNDWIT2.csv'
                MNDWIThresh_p=self.dlg.lin_out.text()+'/MNDWIThresh.csv'
                MNDWIT1L.to_csv(MNDWIT1_p, header= False, index = False)
                MNDWIT2L= pd.DataFrame(MNDWIT2list)
                MNDWIT2L.to_csv(MNDWIT2_p, header= False, index = False)
                MNDWIT1Len=len(MNDWIT1list)
                MNDWIT2Len=len(MNDWIT2list)
                MNDWIThresh=[]
                i, j= 0, 0
                while i<MNDWIT1Len and j<MNDWIT2Len:
                    if MNDWIT1list[i] < MNDWIT2list[j]:
                        MNDWIThresh.append(MNDWIT1list[i])
                        i +=1
                    else:
                        MNDWIThresh.append(MNDWIT2list[j])
                        j +=1
                MNDWIThresh=MNDWIThresh+ MNDWIT1list[i:] + MNDWIT2list[j:]
                MNDWIThreshL=pd.DataFrame(MNDWIThresh)
                MNDWIThreshL.to_csv(MNDWIThresh_p, header= False, index = False)
                MNDWIly=[]
                for tr in MNDWIThresh:
                    MNDWIly.append(tr)
                    MNDWIlw=len(MNDWIly)
                if MNDWIlw>=1:
                    if MNDWIlw==1:
                        MNDWIT1=[]
                        MNDWIT1=[str(MNDWIly[0])]
                        consequences_c_dMNDWI = []
                        cons_c_dMNDWI=QgsRasterCalculatorEntry()
                        cons_c_dMNDWI.ref='dMNDWI@1'
                        cons_c_dMNDWI.raster = dMNDWI_layer
                        cons_c_dMNDWI.bandNumber=1
                        consequences_c_dMNDWI.append(cons_c_dMNDWI)    
                        c_dMNDWI_exp='(' +consequences_c_dMNDWI[0].ref + ' >' +MNDWIT1[0]+')* 1 + (' +consequences_c_dMNDWI[0].ref + '<= ' +MNDWIT1[0]+' )*0'
                        c_dMNDWI_file = self.dlg.lin_out.text()+ '/c_dMNDWI.tif'
                        c_dMNDWI = QgsRasterCalculator(c_dMNDWI_exp,
                                                   c_dMNDWI_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dMNDWI)                 
                        c_dMNDWI.processCalculation()
                        c_dMNDWI_layer = QgsRasterLayer(c_dMNDWI_file,'c_dMNDWI')
                        QgsProject.instance().addMapLayer(c_dMNDWI_layer)   
                    elif MNDWIlw>=2:
                        MNDWIT1=[]
                        MNDWIT2=[]
                        MNDWIT1=[str(MNDWIly[0])]
                        MNDWIT2=[str(MNDWIly[1])]
                        consequences_c_dMNDWI = []
                        cons_c_dMNDWI=QgsRasterCalculatorEntry()
                        cons_c_dMNDWI.ref='dMNDWI@1'
                        cons_c_dMNDWI.raster = dMNDWI_layer
                        cons_c_dMNDWI.bandNumber=1
                        consequences_c_dMNDWI.append(cons_c_dMNDWI)     
                        c_dMNDWI_exp='(' +consequences_c_dMNDWI[0].ref + ' <=' +MNDWIT1[0]+')* 0 + (' +consequences_c_dMNDWI[0].ref + '> ' +MNDWIT1[0]+' )*(' +consequences_c_dMNDWI[0].ref + ' >=' +MNDWIT2[0]+')*10+ (' +consequences_c_dMNDWI[0].ref + '> ' +MNDWIT1[0]+' )*(' +consequences_c_dMNDWI[0].ref + ' <' +MNDWIT2[0]+')*1'
                        c_dMNDWI_file = self.dlg.lin_out.text()+ '/c_dMNDWI.tif'
                        c_dMNDWI = QgsRasterCalculator(c_dMNDWI_exp,
                                                   c_dMNDWI_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dMNDWI)                                
                        c_dMNDWI.processCalculation()
                        c_dMNDWI_layer = QgsRasterLayer(c_dMNDWI_file,'c_dMNDWI')
                        QgsProject.instance().addMapLayer(c_dMNDWI_layer)              
#####
                OSumMS_file=self.dlg.lin_out.text()+'/OSumMS.tif'
                consequences_OSum=[]
                cons_OSum=QgsRasterCalculatorEntry()
                cons_OSum.ref='C_dNDVI@1'
                cons_OSum.raster = c_dndvi_layer
                cons_OSum.bandNumber=1
                consequences_OSum.append(cons_OSum)
                cons_OSum=QgsRasterCalculatorEntry()
                cons_OSum.ref='C_dNDWI@1'
                cons_OSum.raster = c_dNDWI_layer
                cons_OSum.bandNumber=1
                consequences_OSum.append(cons_OSum)
                cons_OSum=QgsRasterCalculatorEntry()
                cons_OSum.ref='C_dMNDWI@1'
                cons_OSum.raster = c_dMNDWI_layer
                cons_OSum.bandNumber=1
                consequences_OSum.append(cons_OSum)
                if (self.dlg.Cb_SAR.isChecked()):
                    OSumMSSAR_file=self.dlg.lin_out.text()+'/OSumMSSAR.tif'
                    cons_OSum=QgsRasterCalculatorEntry()
                    cons_OSum.ref='c_NDTIVV@1'
                    cons_OSum.raster = c_NDTIVV_layer
                    cons_OSum.bandNumber=1
                    consequences_OSum.append(cons_OSum)
                    cons_OSum=QgsRasterCalculatorEntry()
                    cons_OSum.ref='c_NDTIVH@1'
                    cons_OSum.raster = c_NDTIVH_layer
                    cons_OSum.bandNumber=1
                    consequences_OSum.append(cons_OSum)
                    Overall_sumMS_exp= '(' +consequences_OSum[0].ref + '+'+consequences_OSum[1].ref + '+' +consequences_OSum[2].ref +')'
                    Overall_sumMSSAR_exp= '(' +consequences_OSum[0].ref + '+'+consequences_OSum[1].ref + '+' +consequences_OSum[2].ref +'+' +consequences_OSum[3].ref +'+' +consequences_OSum[4].ref +')'
##
                    OSumMS= QgsRasterCalculator(Overall_sumMS_exp,
                                                       OSumMS_file,
                                                       'GTiff',
                                                       extent,
                                                       width,
                                                       height,
                                                       consequences_OSum)
                    OSumMS.processCalculation()
                    OSumMS_layer = QgsRasterLayer(OSumMS_file,'OSumMS')
                    QgsProject.instance().addMapLayer(OSumMS_layer) 
                    OSumMSSAR = QgsRasterCalculator(Overall_sumMSSAR_exp,
                                                       OSumMSSAR_file,
                                                       'GTiff',
                                                       extent,
                                                       width,
                                                       height,
                                                       consequences_OSum)
                    OSumMSSAR.processCalculation()
                    OSumMSSAR_layer = QgsRasterLayer(OSumMSSAR_file,'OSumMSSAR')
                    QgsProject.instance().addMapLayer(OSumMSSAR_layer)   
                    FloodFusion_file=self.dlg.lin_out.text()+'/FloodFusion.tif'
                    FloodMS_file=self.dlg.lin_out.text()+'/FloodMS.tif'
                    FloodMSSAR_file=self.dlg.lin_out.text()+'/FloodMSSAR.tif'
                    NDTIextent=c_NDTI_layer.extent()
                    processing.run("grass7:r.reclass", {'input':OSumMS_layer,'rules':'','txtrules':'0 1 10=0\n3 2 12=1\n30 20 21=10\n11 =-100','output':FloodMS_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.reclass", {'input':OSumMSSAR_layer,'rules':'','txtrules':'0 1 10 2 11=0\n 5 4 14 3 13 23 12 13 22=1\n 50 40 41 30 31 32 =10\n 21 20=-100','output':FloodMSSAR_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.patch", {'input':[FloodMSSAR_file,FloodMS_file],'-z':False,'output':FloodFusion_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})       
                    processing.run("grass7:r.patch", {'input':[FloodFusion_file,c_NDTI_file],'-z':False,'output':FloodFusion_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    os.remove(FloodMSSAR_file)                   
                    if self.dlg.Cb_hrs.isChecked():
                        processing.run("grass7:r.mapcalc.simple", {'a':FloodFusion_file,'b':hrs_mask,'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':FloodFusion_file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    FloodFusion_layer = QgsRasterLayer(FloodFusion_file,'Flood_Fusion')
                    FloodFusion_layer.loadNamedStyle(self.plugin_dir +"/flood_color.qml")
                    QgsProject.instance().addMapLayer(FloodFusion_layer) 
                    UncertaintyMSSAR_file=self.dlg.lin_out.text()+'/UncertaintyMSSAR.tif'
                    UncertaintyNDTI_file=self.dlg.lin_out.text()+'/UncertaintyNDTI.tif'
                    UncertaintyFusion_file=self.dlg.lin_out.text()+'/UncertaintyFusion.tif'
                    processing.run("grass7:r.reclass", {'input':OSumMS_layer,'rules':'','txtrules':'0 3 30=0\n1 10 2 12 20 21=1\n11 =3','output':UncertaintyMS_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.reclass", {'input':OSumMSSAR_layer,'rules':'','txtrules':'0 5 50=0\n1 4 1 10 14 40 41 2 20 11 3 23 13 30 32 31=1\n12 21 22=3','output':UncertaintyMSSAR_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.patch", {'input':[UncertaintyMSSAR_file,UncertaintyMS_file,UncertaintyNDTI_file],'-z':False,'output':UncertaintyFusion_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    UncertaintyFusion_layer = QgsRasterLayer(UncertaintyFusion_file, 'UncertaintyFusion')
                    UncertaintyFusion_layer.loadNamedStyle(self.plugin_dir +"/uncertainty_color.qml")
                    QgsProject.instance().addMapLayer(UncertaintyFusion_layer) 
                    QgsProject.instance().removeMapLayer(OSumMS_layer) 
                    QgsProject.instance().removeMapLayer(OSumMSSAR_layer) 
                    QgsProject.instance().removeMapLayer(OSumNDTIlayer)

                    os.remove(UncertaintyMSSAR_file) 
                else:                          
                    Overall_sumMS_exp= '(' +consequences_OSum[0].ref + '+'+consequences_OSum[1].ref + '+' +consequences_OSum[2].ref +')'
                    OSumMS= QgsRasterCalculator(Overall_sumMS_exp,
                                                       OSumMS_file,
                                                       'GTiff',
                                                       extent,
                                                       width,
                                                       height,
                                                       consequences_OSum)
                    OSumMS.processCalculation()
                    OSumMS_layer = QgsRasterLayer(OSumMS_file,'OSumMS')
                    QgsProject.instance().addMapLayer(OSumMS_layer)   
                    FloodMS_file=self.dlg.lin_out.text()+'/FloodMS.tif'
                    processing.run("grass7:r.reclass", {'input':OSumMS_layer,'rules':'','txtrules':'0 1 10=0\n3 2 12=1\n30 20 21=10\n11 =-100','output':FloodMS_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    FloodMS_layer = QgsRasterLayer(FloodMS_file,'FloodMS')
                    FloodMS_layer.loadNamedStyle(self.plugin_dir +"/flood_color.qml")                                  
                    QgsProject.instance().addMapLayer(FloodMS_layer) 
                    processing.run("grass7:r.reclass", {'input':OSumMS_layer,'rules':'','txtrules':'0 3 30=0\n1 10 2 12 20 21=1\n11 =3','output':UncertaintyMS_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    UncertaintyMS_layer = QgsRasterLayer(UncertaintyMS_file, 'UncertaintyMS')
                    UncertaintyMS_layer.loadNamedStyle(self.plugin_dir +"/uncertainty_color.qml")
                    QgsProject.instance().addMapLayer(UncertaintyMS_layer) 
                    QgsProject.instance().removeMapLayer(OSumMS_layer) 
            elif self.dlg.Cb_fire.isChecked():
            #NDVI:
                NDVI0file = self.dlg.lin_out.text()+ '/NDVI0.tif'
                NDVI1file = self.dlg.lin_out.text()+ '/NDVI1.tif'
                if self.dlg.Cb_topo.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':tnir0_path,'b':tred0_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NDVI0file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.mapcalc.simple", {'a':tnir1_path,'b':tred1_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NDVI1file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    NDVI0_layer = QgsRasterLayer(NDVI0file,'NDVI_0')
                    NDVI1_layer = QgsRasterLayer(NDVI1file,'NDVI_1')
                else:      
                    NDVI0_exp='((((' + entries[6].ref + ' - ' + entries[5].ref + ') / ('+ entries[6].ref + ' + ' + entries[5].ref +'))>=-1)*(((' + entries[6].ref + ' - ' + entries[5].ref + ') / ('+ entries[6].ref + ' + ' + entries[5].ref +'))<=1))*(((' + entries[6].ref + ' - ' + entries[5].ref + ') / ('+ entries[6].ref + ' + ' + entries[5].ref +')))' 
                    NDVI1_exp = '((((' + entries[12].ref + ' - ' + entries[10].ref + ') / ('+ entries[12].ref + ' + ' + entries[10].ref +'))>=-1)*(((' + entries[12].ref + ' - ' + entries[10].ref + ') / ('+ entries[12].ref + ' + ' + entries[10].ref +'))<=1))*(((' + entries[12].ref + ' - ' + entries[10].ref + ') / ('+ entries[12].ref + ' + ' + entries[10].ref +')))' 
                    NDVI0 = QgsRasterCalculator(NDVI0_exp,
                                               NDVI0file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    NDVI0.processCalculation()
                    NDVI0_layer = QgsRasterLayer(NDVI0file,'NDVI_0')
                    NDVI1 = QgsRasterCalculator(NDVI1_exp,
                                               NDVI1file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    NDVI1.processCalculation()
                    if self.dlg.Cb_water.isChecked():
                        processing.run("grass7:r.mapcalc.simple", {'a':NDVI1file,'b':layers[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':NDVI1file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    NDVI1_layer = QgsRasterLayer(NDVI1file,'NDVI_1')
            #dNDVI:
                consequences = []
                cons_NDVI0=QgsRasterCalculatorEntry()
                cons_NDVI0.ref='NDVI0@1'
                cons_NDVI0.raster = NDVI0_layer
                cons_NDVI0.bandNumber=1
                consequences.append(cons_NDVI0)
                cons_NDVI1=QgsRasterCalculatorEntry()
                cons_NDVI1.ref='NDVI1@1'
                cons_NDVI1.raster = NDVI1_layer
                cons_NDVI1.bandNumber=1
                consequences.append(cons_NDVI1)   
                if self.dlg.Cb_cloud.isChecked():
                    cons_csg=QgsRasterCalculatorEntry()
                    cons_csg.ref='csg@1'
                    cons_csg.raster = csg_layer
                    cons_csg.bandNumber=1
                    consequences.append(cons_csg)
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNDVI_exp='(' +consequences[2].ref + '*' +consequences[0].ref + '*' +consequences[3].ref + ' - ' + consequences[1].ref + ')'
                    else:
                        dNDVI_exp='(' +consequences[2].ref + '*' +consequences[0].ref + ' - ' + consequences[1].ref + ')'
                else:
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNDVI_exp='('+consequences[0].ref + ' - '+ consequences[1].ref + '*'  +consequences[2].ref + ')'
                    else:
                        dNDVI_exp='(' +consequences[0].ref + ' - '+ consequences[1].ref + ')'
                dNDVI_file = self.dlg.lin_out.text()+ '/d_NDVI.tif'
                dNDVI = QgsRasterCalculator(dNDVI_exp,
                                           dNDVI_file,
                                           'GTiff',
                                           extent,
                                           width,
                                           height,
                                           consequences)
                dNDVI.processCalculation()
                if self.dlg.Cb_water.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':dNDVI_file,'b':layers[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':dNDVI_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                dNDVI_layer = QgsRasterLayer(dNDVI_file,'dNDVI')
                for b in bin_n:
                    bstr=str(b)
                    bint=b
                    dNDVIstats=self.dlg.lin_out.text()+'/dNDVI_'+bstr+'.csv'
                    NDVIpath=self.dlg.lin_out.text()+'/dNDVI_'+bstr+'_d2f.csv' 
                    processing.run("grass7:r.stats", {'input':[dNDVI_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(dNDVIstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                    f = open(dNDVIstats)
                    text = f.read()
                    f.close()
                    clean = re.sub('<[^>]+>', '', text)
                    f   = open(dNDVIstats, 'w')
                    f.write(clean)
                    f.close()
                    NDVIdf_uns=pd.read_csv(dNDVIstats, header=None)
                    NDVIdf_uns.columns= ["x","count"]
                    NDVIdf = NDVIdf_uns.sort_values (by=['x'])
                    NDVIdf.to_csv(dNDVIstats, index=False)
                    NDVIup=len(NDVIdf)
                    NDVIup2=len(NDVIdf)-1
                    NDVIup3=len(NDVIdf)-2
                    NDVIup4=len(NDVIdf)-3
                    NDVIup5=len(NDVIdf)-4
                    NDVIj=0
                    NDVIr=list(range(0,NDVIup2))
                    NDVIl1=list(range(0,NDVIup))
                    NDVIr2=list(range(3,NDVIup3))
                    NDVIl2=list(range(0,NDVIup))
                    NDVIr3=list(range(2,NDVIup3))
                    NDVIl3=list(range(0,NDVIup))
                    NDVIl4=list(range(0,NDVIup))
                    NDVIr4=list(range(2,NDVIup3))
                    NDVIr5=list(range(3,NDVIup3))
         #NDVI d1f calculation
                    for ig in NDVIr:
                        NDVIj0=ig
                        NDVIji=NDVIj0+1
                        NDVIxi=NDVIdf.iloc[NDVIji]["x"]
                        NDVIyi=NDVIdf.iloc[NDVIji]["count"]
                        NDVIx0=NDVIdf.iloc[NDVIj0]["x"]
                        NDVIy0=NDVIdf.iloc[NDVIj0]["count"]
                        try:
                            NDVIdi=(NDVIyi-NDVIy0)/(NDVIxi-NDVIx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                        except: continue
                        NDVIl1[NDVIj0]=NDVIdi
                    NDVIl1[NDVIup2]=" "
                    NDVIdf.insert(2,'d1f',NDVIl1, True)
             #NDVId2f calculation   
                    for ih in NDVIr3:
                        NDVIhi=ih
                        NDVIh0=NDVIhi-1
                        NDVIxi=NDVIdf.iloc[NDVIhi]["x"]
                        NDVId1fi=float(NDVIdf.iloc[NDVIhi]['d1f'])
                        NDVIx0=NDVIdf.iloc[NDVIh0]["x"]
                        NDVId1f0=float(NDVIdf.iloc[NDVIh0]['d1f'])
                        NDVId2i=((NDVId1fi-NDVId1f0)/(2*NDVIxi-2*NDVIx0))/1.5
                        NDVIl2[NDVIhi]=NDVId2i
                    NDVIl2[0]=" "
                    NDVIl2[NDVIup2]=" "
                    NDVIdf.insert(3,'d2f',NDVIl2, True)
            #NDVI Calculate consecutive values ratio for d1f
                    NDVIcountposd1f=0
                    NDVIcountnegd1f=0
                    NDVIlistposnegd1f=[]
                    NDVIdf['count']=pd.to_numeric(NDVIdf['count'], errors='coerce')
                    NDVIdf['d1f']=pd.to_numeric(NDVIdf['d1f'], errors='coerce')
                    NDVIdf['d2f']=pd.to_numeric(NDVIdf['d2f'], errors='coerce')
                    NDVIcountmax=NDVIdf['count'][1:NDVIup5].max()
                    try:
                        NDVIxmax=float(NDVIdf[NDVIdf['count']==NDVIcountmax]['x'])
                    except Exception:
                        NDVIxmax=0.0
                    NDVIsup=NDVIdf[(NDVIdf['x']>=NDVIxmax)] 
                    NDVIup1=len(NDVIsup)-1
                    NDVIr1=list(range(0,NDVIup1))
                    NDVIr1len=len(NDVIr1)
                    for iib in NDVIr1:
                        NDVIji=iib
                        NDVIj0=NDVIji-1
                        NDVId1fi=float(NDVIsup.iloc[NDVIji]["d1f"])
                        NDVId1f0=float(NDVIsup.iloc[NDVIj0]["d1f"])
                        NDVIx0=float(NDVIsup.iloc[NDVIj0]["x"])
                        if (NDVId1fi>NDVId1f0):
                            NDVIlistposnegd1f.append(1)
                        elif (NDVId1fi<NDVId1f0):
                            NDVIlistposnegd1f.append(0)
                    for iiib in range(1,len(NDVIlistposnegd1f)):
                            if NDVIlistposnegd1f[iiib-1] == NDVIlistposnegd1f[iiib]:
                                if NDVIlistposnegd1f[iiib-1] == 1:
                                    NDVIcountposd1f = NDVIcountposd1f + 1
                                else:
                                    NDVIcountnegd1f = NDVIcountnegd1f + 1
                    try:
                        NDVIBinratiod1f= (NDVIcountposd1f+NDVIcountnegd1f)/float(NDVIr1len)
                    except: continue
                    NDVILBinratiod1f.append(NDVIBinratiod1f)
              # NDVI calculate consecutive values ratio for d2f
                    NDVIcountposd2f=0
                    NDVIcountnegd2f=0
                    NDVIlistposnegd2f=[]
                    NDVIup2=len(NDVIsup)-1
                    NDVIr2=list(range(0,NDVIup2))
                    NDVIr2len=len(NDVIr2)
                    for ivb in NDVIr2:
                        NDVIji=ivb
                        NDVIj0=NDVIji-1
                        NDVId2fi=float(NDVIsup.iloc[NDVIji]["d2f"])
                        NDVId2f0=float(NDVIsup.iloc[NDVIj0]["d2f"])
                        NDVIx0=float(NDVIsup.iloc[NDVIj0]["x"])
                        if (NDVId2fi>NDVId2f0):
                            NDVIlistposnegd2f.append(1)
                        elif (NDVId2fi<NDVId2f0):
                            NDVIlistposnegd2f.append(0)
                    for vb in range(1,len(NDVIlistposnegd2f)):
                            if NDVIlistposnegd2f[vb-1] == NDVIlistposnegd2f[vb]:
                                if NDVIlistposnegd2f[vb-1] == 1:
                                    NDVIcountposd2f = NDVIcountposd2f + 1
                                else:
                                    NDVIcountnegd2f = NDVIcountnegd2f + 1
                    try:
                        NDVIBinratiod2f=(NDVIcountposd2f+NDVIcountnegd2f)/float(NDVIr2len)
                    except:
                        continue
                    NDVILBinratiod2f.append(NDVIBinratiod2f)
                    NDVIdf.to_csv(NDVIpath, index=False)
                    os.remove(dNDVIstats)
                # NDVI: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
                del NDVIdf
                NDVIp = pd.DataFrame(NDVIL, columns = ['bin_n'])
                NDVIp['Binratiod1f']=NDVILBinratiod1f
                NDVIp['Binratiod2f']=NDVILBinratiod2f
                NDVIratio=self.dlg.lin_out.text()+'/dNDVI_ratio.csv'
                NDVIp.to_csv(NDVIratio, index = False)
                NDVIbd1f = NDVIp.max()['Binratiod1f']
                NDVIbd2f = NDVIp.max()['Binratiod2f']
                NDVIlista1 = []
                NDVIlista2 = []
                NDVIbind1f=self.dlg.lin_out.text()+'/dNDVI_d1fbin.csv'
                NDVIbind2f=self.dlg.lin_out.text()+'/dNDVI_d2fbin.csv'
                NDVIselecao1 = NDVIp[NDVIp.Binratiod1f == NDVIbd1f]
                NDVIc1 = NDVIselecao1[NDVIselecao1.bin_n == NDVIselecao1.bin_n.max()]
                NDVIlista1.append(int(NDVIc1.bin_n.tolist()[0]))
                NDVIselecao2 = NDVIp[NDVIp.Binratiod2f == NDVIbd2f]
                NDVIc2 = NDVIselecao2[NDVIselecao2.bin_n == NDVIselecao2.bin_n.max()]
                NDVIlista2.append(int(NDVIc2.bin_n.tolist()[0]))
                NDVIchoice1 = pd.DataFrame(NDVIlista1)
                NDVIchoice2 = pd.DataFrame(NDVIlista2)
                NDVIchoice1.to_csv(NDVIbind1f,index= False, header=False)   
                NDVIchoice2.to_csv(NDVIbind2f,index= False, header=False)   
                NDVIT1list=[]
                NDVIT2list=[]
        #NDVI Select one threshold based on d1f (if any)
                NDVIbind1f_num=str(NDVIlista1[0])
                NDVIp1=self.dlg.lin_out.text()+'/dNDVI_'+NDVIbind1f_num+'_d2f.csv'
                NDVIc1=pd.read_csv(NDVIp1)
                NDVIc1up5=len(NDVIc1)
                NDVIc1['d1f']=pd.to_numeric(NDVIc1['d1f'], errors='coerce')
                NDVIc1countmax=NDVIc1['count'][1:NDVIc1up5].max()
                NDVIc1xmax=float(NDVIc1[NDVIc1['count']==NDVIc1countmax]['x'])
                NDVIc1sup=NDVIc1[(NDVIc1['x']>=NDVIc1xmax)]
                NDVIc1up1=len(NDVIc1sup)-2
                NDVIc1r1=list(range(NDVIc1up1))
                for i in NDVIc1r1:
                        NDVIji=i
                        NDVIj0=i-1
                        NDVIxi=NDVIc1sup.iloc[NDVIji]["x"]
                        NDVIx0=NDVIc1sup.iloc[NDVIj0]["x"]
                        NDVId1fi=float(NDVIc1sup.iloc[NDVIji]["d1f"])
                        NDVId1f0=float(NDVIc1sup.iloc[NDVIj0]["d1f"])
                        if (NDVId1f0<0 and NDVId1fi>0):
                            NDVIT1=(NDVIxi+NDVIx0)/2
                            NDVIT1list.append(NDVIT1)
                        else:
                            continue    
        # NDVI Select threshold(s) based on d2f
                NDVIbind2f_num=str(NDVIlista2[0])
                NDVIp1=self.dlg.lin_out.text()+'/dNDVI_'+NDVIbind2f_num+'_d2f.csv'
                NDVIc1=pd.read_csv(NDVIp1)
                NDVIup5=len(NDVIc1)
                NDVIc1['d2f']=pd.to_numeric(NDVIc1['d2f'], errors='coerce')
                NDVId2fmin=NDVIc1['d2f'][1:NDVIup5].min()
                NDVIxmax=float(NDVIc1[NDVIc1['d2f']==NDVId2fmin]['x'])
                NDVIc1sup=NDVIc1[(NDVIc1['x']>=NDVIxmax)]
                NDVIc1up2=len(NDVIc1sup)-3
                NDVIc1r2=list(range(NDVIc1up2))
                NDVIcnt=1
                for i in NDVIc1r2:
                    NDVIji2=i+1
                    NDVIji=i
                    NDVIj0=i-1
                    NDVIxi=NDVIc1sup.iloc[NDVIji]["x"]
                    NDVIx0=NDVIc1sup.iloc[NDVIj0]["x"]
                    NDVIxi2=NDVIc1sup.iloc[NDVIji2]["x"]
                    NDVId2fi=float(NDVIc1sup.iloc[NDVIji]["d2f"])
                    NDVId2fi2=float(NDVIc1sup.iloc[NDVIji2]["d2f"])
                    NDVId2f0=float(NDVIc1sup.iloc[NDVIj0]["d2f"])
                    if NDVId2f0<0:
                        NDVIcnt=1
                    if (NDVId2fi>NDVId2f0 and NDVId2fi>NDVId2fi2 and NDVId2fi>0 and NDVIcnt>=1):
                        NDVIT2=NDVIxi
                        NDVIT2list.append(NDVIT2)
                        NDVIcnt=0
                    else:
                        continue
        #NDVI Save Threshold list to csvsl
                NDVIT1L= pd.DataFrame(NDVIT1list)
                NDVIT1_p=self.dlg.lin_out.text()+'/NDVIT1.csv'
                NDVIT2_p=self.dlg.lin_out.text()+'/NDVIT2.csv'
                NDVIThresh_p=self.dlg.lin_out.text()+'/NDVIThresh.csv'
                NDVIT1L.to_csv(NDVIT1_p, header= False, index = False)
                NDVIT2L= pd.DataFrame(NDVIT2list)
                NDVIT2L.to_csv(NDVIT2_p, header= False, index = False)
                NDVIT1Len=len(NDVIT1list)
                NDVIT2Len=len(NDVIT2list)
                NDVIThresh=[]
                i, j= 0, 0
                while i<NDVIT1Len and j<NDVIT2Len:
                    if NDVIT1list[i] < NDVIT2list[j]:
                        NDVIThresh.append(NDVIT1list[i])
                        i +=1
                    else:
                        NDVIThresh.append(NDVIT2list[j])
                        j +=1
                NDVIThresh=NDVIThresh+ NDVIT1list[i:] + NDVIT2list[j:]
                NDVIThreshL=pd.DataFrame(NDVIThresh)
                NDVIThreshL.to_csv(NDVIThresh_p, header= False, index = False)
                NDVIly=[]
                for tr in NDVIThresh:
                    NDVIly.append(tr)
                    NDVIlw=len(NDVIly)
                if NDVIlw>=1:
                    if NDVIlw==1:
                        NDVIT1=[]
                        NDVIT1=[str(NDVIly[0])]
                        consequences_c_dNDVI = []
                        cons_c_dNDVI=QgsRasterCalculatorEntry()
                        cons_c_dNDVI.ref='dNDVI@1'
                        cons_c_dNDVI.raster = dNDVI_layer
                        cons_c_dNDVI.bandNumber=1
                        consequences_c_dNDVI.append(cons_c_dNDVI)    
                        c_dNDVI_exp='(' +consequences_c_dNDVI[0].ref + ' >' +NDVIT1[0]+')* 1 + (' +consequences_c_dNDVI[0].ref + '<= ' +NDVIT1[0]+' )*0'
                        c_dNDVI_file = self.dlg.lin_out.text()+ '/c_dNDVI.tif'
                        c_dNDVI = QgsRasterCalculator(c_dNDVI_exp,
                                                   c_dNDVI_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNDVI)                       
                        c_dNDVI.processCalculation()
                        c_dNDVI_layer = QgsRasterLayer(c_dNDVI_file,'c_dNDVI')
                        QgsProject.instance().addMapLayer(c_dNDVI_layer)   
                    elif NDVIlw>=2:
                        NDVIT1=[]
                        NDVIT2=[]
                        NDVIT1=[str(NDVIly[0])]
                        NDVIT2=[str(NDVIly[1])]
                        consequences_c_dNDVI = []
                        cons_c_dNDVI=QgsRasterCalculatorEntry()
                        cons_c_dNDVI.ref='dNDVI@1'
                        cons_c_dNDVI.raster = dNDVI_layer
                        cons_c_dNDVI.bandNumber=1
                        consequences_c_dNDVI.append(cons_c_dNDVI)     
                        c_dNDVI_exp='(' +consequences_c_dNDVI[0].ref + ' <=' +NDVIT1[0]+')* 0 + (' +consequences_c_dNDVI[0].ref + '> ' +NDVIT1[0]+' )*(' +consequences_c_dNDVI[0].ref + ' >=' +NDVIT2[0]+')*10+ (' +consequences_c_dNDVI[0].ref + '> ' +NDVIT1[0]+' )*(' +consequences_c_dNDVI[0].ref + ' <' +NDVIT2[0]+')*1'
                        c_dNDVI_file = self.dlg.lin_out.text()+ '/c_dNDVI.tif'
                        c_dNDVI = QgsRasterCalculator(c_dNDVI_exp,
                                                   c_dNDVI_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNDVI)                       
                        c_dNDVI.processCalculation()
                        c_dNDVI_layer = QgsRasterLayer(c_dNDVI_file,'c_dNDVI')
                        QgsProject.instance().addMapLayer(c_dNDVI_layer)              
            #NBRs calculation 
                NBRs0file = self.dlg.lin_out.text()+ '/NBRs0.tif'
                NBRs1file = self.dlg.lin_out.text()+ '/NBRs1.tif'
                if self.dlg.Cb_topo.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':tnir0_path,'b':tswirs0_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NBRs0file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.mapcalc.simple", {'a':tnir1_path,'b':tswirs1_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NBRs1file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    NBRs0_layer = QgsRasterLayer(NBRs0file,'NBRs_0')
                    NBRs1_layer = QgsRasterLayer(NBRs1file,'NBRs_1')
                else:
                    NBRs0_exp = '((((' + entries[6].ref + ' - ' + entries[7].ref + ') / ('+ entries[6].ref + ' + ' + entries[7].ref +'))>=-1)*(((' + entries[6].ref + ' - ' + entries[7].ref + ') / ('+ entries[6].ref + ' + ' + entries[7].ref +'))<=1))*(((' + entries[6].ref + ' - ' + entries[7].ref + ') / ('+ entries[6].ref + ' + ' + entries[7].ref +')))' 
                    NBRs1_exp = '((((' + entries[12].ref + ' - ' + entries[13].ref + ') / ('+ entries[12].ref + ' + ' + entries[13].ref +'))>=-1)*(((' + entries[12].ref + ' - ' + entries[13].ref + ') / ('+ entries[12].ref + ' + ' + entries[13].ref +'))<=1))*(((' + entries[12].ref + ' - ' + entries[13].ref + ') / ('+ entries[12].ref + ' + ' + entries[13].ref +')))' 
                    NBRs0 = QgsRasterCalculator(NBRs0_exp,
                                               NBRs0file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    NBRs0.processCalculation()
                    NBRs0_layer = QgsRasterLayer(NBRs0file,'NBRs_0')
                    NBRs1 = QgsRasterCalculator(NBRs1_exp,
                                               NBRs1file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    NBRs1.processCalculation()
                    NBRs1_layer = QgsRasterLayer(NBRs1file,'NBRs_1')
            #dNBRs:
                consequences = []
                cons_NBRs0=QgsRasterCalculatorEntry()
                cons_NBRs0.ref='NBRs0@1'
                cons_NBRs0.raster = NBRs0_layer
                cons_NBRs0.bandNumber=1
                consequences.append(cons_NBRs0)
                cons_NBRs1=QgsRasterCalculatorEntry()
                cons_NBRs1.ref='NBRs1@1'
                cons_NBRs1.raster = NBRs1_layer
                cons_NBRs1.bandNumber=1
                consequences.append(cons_NBRs1)   
                if self.dlg.Cb_cloud.isChecked():
                    cons_csg=QgsRasterCalculatorEntry()
                    cons_csg.ref='csg@1'
                    cons_csg.raster = csg_layer
                    cons_csg.bandNumber=1
                    consequences.append(cons_csg)
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNBRs_exp='(' +consequences[2].ref + '*' +consequences[0].ref + '*' +consequences[3].ref + ' - ' + consequences[1].ref + ')'
                    else:
                        dNBRs_exp='(' +consequences[2].ref + '*' +consequences[0].ref + ' - ' + consequences[1].ref + ')'
                else:
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNBRs_exp='('+consequences[0].ref + ' - '+ consequences[1].ref + '*'  +consequences[2].ref + ')'
                    else:
                        dNBRs_exp='(' +consequences[0].ref + ' - '+ consequences[1].ref + ')'
                dNBRs_file = self.dlg.lin_out.text()+ '/d_NBRs.tif'
                dNBRs = QgsRasterCalculator(dNBRs_exp,
                                           dNBRs_file,
                                           'GTiff',
                                           extent,
                                           width,
                                           height,
                                           consequences)
                dNBRs.processCalculation()
                if self.dlg.Cb_water.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':dNBRs_file,'b':layers[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':dNBRs_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                dNBRs_layer = QgsRasterLayer(dNBRs_file,'dNBRs')
                for b in bin_n:
                    bstr=str(b)
                    bint=b
                    dNBRsstats=self.dlg.lin_out.text()+'/dNBRs_'+bstr+'.csv'
                    NBRspath=self.dlg.lin_out.text()+'/dNBRs_'+bstr+'_d2f.csv' 
                    processing.run("grass7:r.stats", {'input':[dNBRs_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(dNBRsstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                    f = open(dNBRsstats)
                    text = f.read()
                    f.close()
                    clean = re.sub('<[^>]+>', '', text)
                    f   = open(dNBRsstats, 'w')
                    f.write(clean)
                    f.close()
                    NBRsdf_uns=pd.read_csv(dNBRsstats, header=None)
                    NBRsdf_uns.columns= ["x","count"]
                    NBRsdf = NBRsdf_uns.sort_values (by=['x'])
                    NBRsdf.to_csv(dNBRsstats, index=False)
                    NBRsup=len(NBRsdf)
                    NBRsup2=len(NBRsdf)-1
                    NBRsup3=len(NBRsdf)-2
                    NBRsup4=len(NBRsdf)-3
                    NBRsup5=len(NBRsdf)-4
                    NBRsj=0
                    NBRsr=list(range(0,NBRsup2))
                    NBRsl1=list(range(0,NBRsup))
                    NBRsr2=list(range(3,NBRsup3))
                    NBRsl2=list(range(0,NBRsup))
                    NBRsr3=list(range(2,NBRsup3))
                    NBRsl3=list(range(0,NBRsup))
                    NBRsl4=list(range(0,NBRsup))
                    NBRsr4=list(range(2,NBRsup3))
                    NBRsr5=list(range(3,NBRsup3))
         #NBRs d1f calculation
                    for ig in NBRsr:
                        NBRsj0=ig
                        NBRsji=NBRsj0+1
                        NBRsxi=NBRsdf.iloc[NBRsji]["x"]
                        NBRsyi=NBRsdf.iloc[NBRsji]["count"]
                        NBRsx0=NBRsdf.iloc[NBRsj0]["x"]
                        NBRsy0=NBRsdf.iloc[NBRsj0]["count"]
                        try:
                            NBRsdi=(NBRsyi-NBRsy0)/(NBRsxi-NBRsx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                        except: continue
                        NBRsl1[NBRsj0]=NBRsdi
                    NBRsl1[NBRsup2]=" "
                    NBRsdf.insert(2,'d1f',NBRsl1, True)
             #NBRsd2f calculation   
                    for ih in NBRsr3:
                        NBRshi=ih
                        NBRsh0=NBRshi-1
                        NBRsxi=NBRsdf.iloc[NBRshi]["x"]
                        NBRsd1fi=float(NBRsdf.iloc[NBRshi]['d1f'])
                        NBRsx0=NBRsdf.iloc[NBRsh0]["x"]
                        NBRsd1f0=float(NBRsdf.iloc[NBRsh0]['d1f'])
                        NBRsd2i=((NBRsd1fi-NBRsd1f0)/(2*NBRsxi-2*NBRsx0))/1.5
                        NBRsl2[NBRshi]=NBRsd2i
                    NBRsl2[0]=" "
                    NBRsl2[NBRsup2]=" "
                    NBRsdf.insert(3,'d2f',NBRsl2, True)
            #NBRs Calculate consecutive values ratio for d1f
                    NBRscountposd1f=0
                    NBRscountnegd1f=0
                    NBRslistposnegd1f=[]
                    NBRsdf['count']=pd.to_numeric(NBRsdf['count'], errors='coerce')
                    NBRsdf['d1f']=pd.to_numeric(NBRsdf['d1f'], errors='coerce')
                    NBRsdf['d2f']=pd.to_numeric(NBRsdf['d2f'], errors='coerce')
                    NBRscountmax=NBRsdf['count'][1:NBRsup5].max()
                    try:
                        NBRsxmax=float(NBRsdf[NBRsdf['count']==NBRscountmax]['x'])
                    except Exception:
                        NBRsxmax=0.0
                    NBRssup=NBRsdf[(NBRsdf['x']>=NBRsxmax)] 
                    NBRsup1=len(NBRssup)-1
                    NBRsr1=list(range(0,NBRsup1))
                    NBRsr1len=len(NBRsr1)
                    for iib in NBRsr1:
                        NBRsji=iib
                        NBRsj0=NBRsji-1
                        NBRsd1fi=float(NBRssup.iloc[NBRsji]["d1f"])
                        NBRsd1f0=float(NBRssup.iloc[NBRsj0]["d1f"])
                        NBRsx0=float(NBRssup.iloc[NBRsj0]["x"])
                        if (NBRsd1fi>NBRsd1f0):
                            NBRslistposnegd1f.append(1)
                        elif (NBRsd1fi<NBRsd1f0):
                            NBRslistposnegd1f.append(0)
                    for iiib in range(1,len(NBRslistposnegd1f)):
                            if NBRslistposnegd1f[iiib-1] == NBRslistposnegd1f[iiib]:
                                if NBRslistposnegd1f[iiib-1] == 1:
                                    NBRscountposd1f = NBRscountposd1f + 1
                                else:
                                    NBRscountnegd1f = NBRscountnegd1f + 1
                    try:
                        NBRsBinratiod1f= (NBRscountposd1f+NBRscountnegd1f)/float(NBRsr1len)
                    except: continue
                    NBRsLBinratiod1f.append(NBRsBinratiod1f)
              # NBRs calculate consecutive values ratio for d2f
                    NBRscountposd2f=0
                    NBRscountnegd2f=0
                    NBRslistposnegd2f=[]
                    NBRsup2=len(NBRssup)-1
                    NBRsr2=list(range(0,NBRsup2))
                    NBRsr2len=len(NBRsr2)
                    for ivb in NBRsr2:
                        NBRsji=ivb
                        NBRsj0=NBRsji-1
                        NBRsd2fi=float(NBRssup.iloc[NBRsji]["d2f"])
                        NBRsd2f0=float(NBRssup.iloc[NBRsj0]["d2f"])
                        NBRsx0=float(NBRssup.iloc[NBRsj0]["x"])
                        if (NBRsd2fi>NBRsd2f0):
                            NBRslistposnegd2f.append(1)
                        elif (NBRsd2fi<NBRsd2f0):
                            NBRslistposnegd2f.append(0)
                    for vb in range(1,len(NBRslistposnegd2f)):
                            if NBRslistposnegd2f[vb-1] == NBRslistposnegd2f[vb]:
                                if NBRslistposnegd2f[vb-1] == 1:
                                    NBRscountposd2f = NBRscountposd2f + 1
                                else:
                                    NBRscountnegd2f = NBRscountnegd2f + 1
                    try:
                        NBRsBinratiod2f=(NBRscountposd2f+NBRscountnegd2f)/float(NBRsr2len)
                    except:
                        continue
                    NBRsLBinratiod2f.append(NBRsBinratiod2f)
                    NBRsdf.to_csv(NBRspath, index=False)
                    os.remove(dNBRsstats)
                # NBRs: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
                del NBRsdf
                NBRsp = pd.DataFrame(NBRsL, columns = ['bin_n'])
                NBRsp['Binratiod1f']=NBRsLBinratiod1f
                NBRsp['Binratiod2f']=NBRsLBinratiod2f
                NBRsratio=self.dlg.lin_out.text()+'/dNBRs_ratio.csv'
                NBRsp.to_csv(NBRsratio, index = False)
                NBRsbd1f = NBRsp.max()['Binratiod1f']
                NBRsbd2f = NBRsp.max()['Binratiod2f']
                NBRslista1 = []
                NBRslista2 = []
                NBRsbind1f=self.dlg.lin_out.text()+'/dNBRs_d1fbin.csv'
                NBRsbind2f=self.dlg.lin_out.text()+'/dNBRs_d2fbin.csv'
                NBRsselecao1 = NBRsp[NBRsp.Binratiod1f == NBRsbd1f]
                NBRsc1 = NBRsselecao1[NBRsselecao1.bin_n == NBRsselecao1.bin_n.max()]
                NBRslista1.append(int(NBRsc1.bin_n.tolist()[0]))
                NBRsselecao2 = NBRsp[NBRsp.Binratiod2f == NBRsbd2f]
                NBRsc2 = NBRsselecao2[NBRsselecao2.bin_n == NBRsselecao2.bin_n.max()]
                NBRslista2.append(int(NBRsc2.bin_n.tolist()[0]))
                NBRschoice1 = pd.DataFrame(NBRslista1)
                NBRschoice2 = pd.DataFrame(NBRslista2)
                NBRschoice1.to_csv(NBRsbind1f,index= False, header=False)   
                NBRschoice2.to_csv(NBRsbind2f,index= False, header=False)   
                NBRsT1list=[]
                NBRsT2list=[]
        #NBRs Select one threshold based on d1f (if any)
                NBRsbind1f_num=str(NBRslista1[0])
                NBRsp1=self.dlg.lin_out.text()+'/dNBRs_'+NBRsbind1f_num+'_d2f.csv'
                NBRsc1=pd.read_csv(NBRsp1)
                NBRsc1up5=len(NBRsc1)
                NBRsc1['d1f']=pd.to_numeric(NBRsc1['d1f'], errors='coerce')
                NBRsc1countmax=NBRsc1['count'][1:NBRsc1up5].max()
                NBRsc1xmax=float(NBRsc1[NBRsc1['count']==NBRsc1countmax]['x'])
                NBRsc1sup=NBRsc1[(NBRsc1['x']>=NBRsc1xmax)]
                NBRsc1up1=len(NBRsc1sup)-2
                NBRsc1r1=list(range(NBRsc1up1))
                for i in NBRsc1r1:
                        NBRsji=i
                        NBRsj0=i-1
                        NBRsxi=NBRsc1sup.iloc[NBRsji]["x"]
                        NBRsx0=NBRsc1sup.iloc[NBRsj0]["x"]
                        NBRsd1fi=float(NBRsc1sup.iloc[NBRsji]["d1f"])
                        NBRsd1f0=float(NBRsc1sup.iloc[NBRsj0]["d1f"])
                        if (NBRsd1f0<0 and NBRsd1fi>0):
                            NBRsT1=(NBRsxi+NBRsx0)/2
                            NBRsT1list.append(NBRsT1)
                        else:
                            continue    
        # NBRs Select threshold(s) based on d2f
                NBRsbind2f_num=str(NBRslista2[0])
                NBRsp1=self.dlg.lin_out.text()+'/dNBRs_'+NBRsbind2f_num+'_d2f.csv'
                NBRsc1=pd.read_csv(NBRsp1)
                NBRsup5=len(NBRsc1)
                NBRsc1['d2f']=pd.to_numeric(NBRsc1['d2f'], errors='coerce')
                NBRsd2fmin=NBRsc1['d2f'][1:NBRsup5].min()
                NBRsxmax=float(NBRsc1[NBRsc1['d2f']==NBRsd2fmin]['x'])
                NBRsc1sup=NBRsc1[(NBRsc1['x']>=NBRsxmax)]
                NBRsc1up2=len(NBRsc1sup)-3
                NBRsc1r2=list(range(NBRsc1up2))
                NBRscnt=1
                for i in NBRsc1r2:
                    NBRsji2=i+1
                    NBRsji=i
                    NBRsj0=i-1
                    NBRsxi=NBRsc1sup.iloc[NBRsji]["x"]
                    NBRsx0=NBRsc1sup.iloc[NBRsj0]["x"]
                    NBRsxi2=NBRsc1sup.iloc[NBRsji2]["x"]
                    NBRsd2fi=float(NBRsc1sup.iloc[NBRsji]["d2f"])
                    NBRsd2fi2=float(NBRsc1sup.iloc[NBRsji2]["d2f"])
                    NBRsd2f0=float(NBRsc1sup.iloc[NBRsj0]["d2f"])
                    if NBRsd2f0<0:
                        NBRscnt=1
                    if (NBRsd2fi>NBRsd2f0 and NBRsd2fi>NBRsd2fi2 and NBRsd2fi>0 and NBRscnt>=1):
                        NBRsT2=NBRsxi
                        NBRsT2list.append(NBRsT2)
                        NBRscnt=0
                    else:
                        continue
        #NBRs Save Threshold list to csvsl
                NBRsT1L= pd.DataFrame(NBRsT1list)
                NBRsT1_p=self.dlg.lin_out.text()+'/NBRsT1.csv'
                NBRsT2_p=self.dlg.lin_out.text()+'/NBRsT2.csv'
                NBRsThresh_p=self.dlg.lin_out.text()+'/NBRsThresh.csv'
                NBRsT1L.to_csv(NBRsT1_p, header= False, index = False)
                NBRsT2L= pd.DataFrame(NBRsT2list)
                NBRsT2L.to_csv(NBRsT2_p, header= False, index = False)
                NBRsT1Len=len(NBRsT1list)
                NBRsT2Len=len(NBRsT2list)
                NBRsThresh=[]
                i, j= 0, 0
                while i<NBRsT1Len and j<NBRsT2Len:
                    if NBRsT1list[i] < NBRsT2list[j]:
                        NBRsThresh.append(NBRsT1list[i])
                        i +=1
                    else:
                        NBRsThresh.append(NBRsT2list[j])
                        j +=1
                NBRsThresh=NBRsThresh+ NBRsT1list[i:] + NBRsT2list[j:]
                NBRsThreshL=pd.DataFrame(NBRsThresh)
                NBRsThreshL.to_csv(NBRsThresh_p, header= False, index = False)
                NBRsly=[]
                for tr in NBRsThresh:
                    NBRsly.append(tr)
                    NBRslw=len(NBRsly)
                if NBRslw>=1:
                    if NBRslw==1:
                        NBRsT1=[]
                        NBRsT1=[str(NBRsly[0])]
                        consequences_c_dNBRs = []
                        cons_c_dNBRs=QgsRasterCalculatorEntry()
                        cons_c_dNBRs.ref='dNBRs@1'
                        cons_c_dNBRs.raster = dNBRs_layer
                        cons_c_dNBRs.bandNumber=1
                        consequences_c_dNBRs.append(cons_c_dNBRs)    
                        c_dNBRs_exp='(' +consequences_c_dNBRs[0].ref + ' >' +NBRsT1[0]+')* 1 + (' +consequences_c_dNBRs[0].ref + '<= ' +NBRsT1[0]+' )*0'
                        c_dNBRs_file = self.dlg.lin_out.text()+ '/c_dNBRs.tif'
                        c_dNBRs = QgsRasterCalculator(c_dNBRs_exp,
                                                   c_dNBRs_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNBRs)                       
                        c_dNBRs.processCalculation()
                        c_dNBRs_layer = QgsRasterLayer(c_dNBRs_file,'c_dNBRs')
                        QgsProject.instance().addMapLayer(c_dNBRs_layer)   
                    elif NBRslw>=2:
                        NBRsT1=[]
                        NBRsT2=[]
                        NBRsT1=[str(NBRsly[0])]
                        NBRsT2=[str(NBRsly[1])]
                        consequences_c_dNBRs = []
                        cons_c_dNBRs=QgsRasterCalculatorEntry()
                        cons_c_dNBRs.ref='dNBRs@1'
                        cons_c_dNBRs.raster = dNBRs_layer
                        cons_c_dNBRs.bandNumber=1
                        consequences_c_dNBRs.append(cons_c_dNBRs)     
                        c_dNBRs_exp='(' +consequences_c_dNBRs[0].ref + ' <=' +NBRsT1[0]+')* 0 + (' +consequences_c_dNBRs[0].ref + '> ' +NBRsT1[0]+' )*(' +consequences_c_dNBRs[0].ref + ' >=' +NBRsT2[0]+')*10+ (' +consequences_c_dNBRs[0].ref + '> ' +NBRsT1[0]+' )*(' +consequences_c_dNBRs[0].ref + ' <' +NBRsT2[0]+')*1'
                        c_dNBRs_file = self.dlg.lin_out.text()+ '/c_dNBRs.tif'
                        c_dNBRs = QgsRasterCalculator(c_dNBRs_exp,
                                                   c_dNBRs_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNBRs)                   
                        c_dNBRs.processCalculation()
                        c_dNBRs_layer = QgsRasterLayer(c_dNBRs_file,'c_dNBRs')
                        QgsProject.instance().addMapLayer(c_dNBRs_layer)              
            #NBRl calculation 
                NBRl0file = self.dlg.lin_out.text()+ '/NBRl0.tif'
                NBRl1file = self.dlg.lin_out.text()+ '/NBRl1.tif'
                if self.dlg.Cb_topo.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':tnir0_path,'b':tswirl0_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NBRl0file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.mapcalc.simple", {'a':tnir1_path,'b':tswirl1_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NBRl1file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    NBRl0_layer = QgsRasterLayer(NBRl0file,'NBRl_0')
                    NBRl1_layer = QgsRasterLayer(NBRl1file,'NBRl_1')
                else:  
                    NBRl0_exp = '((((' + entries[6].ref + ' - ' + entries[8].ref + ') / ('+ entries[6].ref + ' + ' + entries[8].ref +'))>=-1)*(((' + entries[6].ref + ' - ' + entries[8].ref + ') / ('+ entries[6].ref + ' + ' + entries[8].ref +'))<=1))*(((' + entries[6].ref + ' - ' + entries[8].ref + ') / ('+ entries[6].ref + ' + ' + entries[8].ref +')))' 
                    NBRl1_exp = '((((' + entries[12].ref + ' - ' + entries[14].ref + ') / ('+ entries[12].ref + ' + ' + entries[14].ref +'))>=-1)*(((' + entries[12].ref + ' - ' + entries[14].ref + ') / ('+ entries[12].ref + ' + ' + entries[14].ref +'))<=1))*(((' + entries[12].ref + ' - ' + entries[14].ref + ') / ('+ entries[12].ref + ' + ' + entries[14].ref +')))' 
                    NBRl0 = QgsRasterCalculator(NBRl0_exp,
                                               NBRl0file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries) 
                    NBRl0.processCalculation()
                    NBRl0_layer = QgsRasterLayer(NBRl0file,'NBRl_0')
                    NBRl1 = QgsRasterCalculator(NBRl1_exp,
                                               NBRl1file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    NBRl1.processCalculation()
                    NBRl1_layer = QgsRasterLayer(NBRl1file,'NBRl_1')
            #dNBRl:
                consequences = []
                cons_NBRl0=QgsRasterCalculatorEntry()
                cons_NBRl0.ref='NBRl0@1'
                cons_NBRl0.raster = NBRl0_layer
                cons_NBRl0.bandNumber=1
                consequences.append(cons_NBRl0)
                cons_NBRl1=QgsRasterCalculatorEntry()
                cons_NBRl1.ref='NBRl1@1'
                cons_NBRl1.raster = NBRl1_layer
                cons_NBRl1.bandNumber=1
                consequences.append(cons_NBRl1)      
                if self.dlg.Cb_cloud.isChecked():
                    cons_csg=QgsRasterCalculatorEntry()
                    cons_csg.ref='csg@1'
                    cons_csg.raster = csg_layer
                    cons_csg.bandNumber=1
                    consequences.append(cons_csg)
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNBRl_exp='(' +consequences[2].ref + '*' +consequences[0].ref + '*' +consequences[3].ref + ' - ' + consequences[1].ref + ')'
                    else:
                        dNBRl_exp='(' +consequences[2].ref + '*' +consequences[0].ref + ' - ' + consequences[1].ref + ')'
                else:
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNBRl_exp='('+consequences[0].ref + ' - '+ consequences[1].ref + '*'  +consequences[2].ref + ')'
                    else:
                        dNBRl_exp='(' +consequences[0].ref + ' - '+ consequences[1].ref + ')'
                dNBRl_file = self.dlg.lin_out.text()+ '/d_NBRl.tif'
                dNBRl = QgsRasterCalculator(dNBRl_exp,
                                           dNBRl_file,
                                           'GTiff',
                                           extent,
                                           width,
                                           height,
                                           consequences)
        #                                   
                dNBRl.processCalculation()
                if self.dlg.Cb_water.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':dNBRl_file,'b':layers[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':dNBRl_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                dNBRl_layer = QgsRasterLayer(dNBRl_file,'dNBRl')
                for b in bin_n:
                    bstr=str(b)
                    bint=b
                    dNBRlstats=self.dlg.lin_out.text()+'/dNBRl_'+bstr+'.csv'
                    NBRlpath=self.dlg.lin_out.text()+'/dNBRl_'+bstr+'_d2f.csv' 
                    processing.run("grass7:r.stats", {'input':[dNBRl_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(dNBRlstats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                    f = open(dNBRlstats)
                    text = f.read()
                    f.close()
                    clean = re.sub('<[^>]+>', '', text)
                    f   = open(dNBRlstats, 'w')
                    f.write(clean)
                    f.close()
                    NBRldf_uns=pd.read_csv(dNBRlstats, header=None)
                    NBRldf_uns.columns= ["x","count"]
                    NBRldf = NBRldf_uns.sort_values (by=['x'])
                    NBRldf.to_csv(dNBRlstats, index=False)
                    NBRlup=len(NBRldf)
                    NBRlup2=len(NBRldf)-1
                    NBRlup3=len(NBRldf)-2
                    NBRlup4=len(NBRldf)-3
                    NBRlup5=len(NBRldf)-4
                    NBRlj=0
                    NBRlr=list(range(0,NBRlup2))
                    NBRll1=list(range(0,NBRlup))
                    NBRlr2=list(range(3,NBRlup3))
                    NBRll2=list(range(0,NBRlup))
                    NBRlr3=list(range(2,NBRlup3))
                    NBRll3=list(range(0,NBRlup))
                    NBRll4=list(range(0,NBRlup))
                    NBRlr4=list(range(2,NBRlup3))
                    NBRlr5=list(range(3,NBRlup3))
         #NBRl d1f calculation
                    for ig in NBRlr:
                        NBRlj0=ig
                        NBRlji=NBRlj0+1
                        NBRlxi=NBRldf.iloc[NBRlji]["x"]
                        NBRlyi=NBRldf.iloc[NBRlji]["count"]
                        NBRlx0=NBRldf.iloc[NBRlj0]["x"]
                        NBRly0=NBRldf.iloc[NBRlj0]["count"]
                        try:
                            NBRldi=(NBRlyi-NBRly0)/(NBRlxi-NBRlx0) /2  # the /2 is required to correct the d1f, because we are using average x values
                        except: continue
                        NBRll1[NBRlj0]=NBRldi
                    NBRll1[NBRlup2]=" "
                    NBRldf.insert(2,'d1f',NBRll1, True)
             #NBRld2f calculation   
                    for ih in NBRlr3:
                        NBRlhi=ih
                        NBRlh0=NBRlhi-1
                        NBRlxi=NBRldf.iloc[NBRlhi]["x"]
                        NBRld1fi=float(NBRldf.iloc[NBRlhi]['d1f'])
                        NBRlx0=NBRldf.iloc[NBRlh0]["x"]
                        NBRld1f0=float(NBRldf.iloc[NBRlh0]['d1f'])
                        NBRld2i=((NBRld1fi-NBRld1f0)/(2*NBRlxi-2*NBRlx0))/1.5
                        NBRll2[NBRlhi]=NBRld2i
                    NBRll2[0]=" "
                    NBRll2[NBRlup2]=" "
                    NBRldf.insert(3,'d2f',NBRll2, True)
            #NBRl Calculate consecutive values ratio for d1f
                    NBRlcountposd1f=0
                    NBRlcountnegd1f=0
                    NBRllistposnegd1f=[]
                    NBRldf['count']=pd.to_numeric(NBRldf['count'], errors='coerce')
                    NBRldf['d1f']=pd.to_numeric(NBRldf['d1f'], errors='coerce')
                    NBRldf['d2f']=pd.to_numeric(NBRldf['d2f'], errors='coerce')
                    NBRlcountmax=NBRldf['count'][1:NBRlup5].max()
                    try:
                        NBRlxmax=float(NBRldf[NBRldf['count']==NBRlcountmax]['x'])
                    except Exception:
                        NBRlxmax=0.0
                    NBRlsup=NBRldf[(NBRldf['x']>=NBRlxmax)] 
                    NBRlup1=len(NBRlsup)-1
                    NBRlr1=list(range(0,NBRlup1))
                    NBRlr1len=len(NBRlr1)
                    for iib in NBRlr1:
                        NBRlji=iib
                        NBRlj0=NBRlji-1
                        NBRld1fi=float(NBRlsup.iloc[NBRlji]["d1f"])
                        NBRld1f0=float(NBRlsup.iloc[NBRlj0]["d1f"])
                        NBRlx0=float(NBRlsup.iloc[NBRlj0]["x"])
                        if (NBRld1fi>NBRld1f0):
                            NBRllistposnegd1f.append(1)
                        elif (NBRld1fi<NBRld1f0):
                            NBRllistposnegd1f.append(0)
                    for iiib in range(1,len(NBRllistposnegd1f)):
                            if NBRllistposnegd1f[iiib-1] == NBRllistposnegd1f[iiib]:
                                if NBRllistposnegd1f[iiib-1] == 1:
                                    NBRlcountposd1f = NBRlcountposd1f + 1
                                else:
                                    NBRlcountnegd1f = NBRlcountnegd1f + 1
                    try:
                        NBRlBinratiod1f= (NBRlcountposd1f+NBRlcountnegd1f)/float(NBRlr1len)
                    except:
                        continue
                    NBRlLBinratiod1f.append(NBRlBinratiod1f)
              # NBRl calculate consecutive values ratio for d2f
                    NBRlcountposd2f=0
                    NBRlcountnegd2f=0
                    NBRllistposnegd2f=[]
                    NBRlup2=len(NBRlsup)-1
                    NBRlr2=list(range(0,NBRlup2))
                    NBRlr2len=len(NBRlr2)
                    for ivb in NBRlr2:
                        NBRlji=ivb
                        NBRlj0=NBRlji-1
                        NBRld2fi=float(NBRlsup.iloc[NBRlji]["d2f"])
                        NBRld2f0=float(NBRlsup.iloc[NBRlj0]["d2f"])
                        NBRlx0=float(NBRlsup.iloc[NBRlj0]["x"])
                        if (NBRld2fi>NBRld2f0):
                            NBRllistposnegd2f.append(1)
                        elif (NBRld2fi<NBRld2f0):
                            NBRllistposnegd2f.append(0)
                    for vb in range(1,len(NBRllistposnegd2f)):
                            if NBRllistposnegd2f[vb-1] == NBRllistposnegd2f[vb]:
                                if NBRllistposnegd2f[vb-1] == 1:
                                    NBRlcountposd2f = NBRlcountposd2f + 1
                                else:
                                    NBRlcountnegd2f = NBRlcountnegd2f + 1
                    try:
                        NBRlBinratiod2f=(NBRlcountposd2f+NBRlcountnegd2f)/float(NBRlr2len)
                    except:
                        continue
                    NBRlLBinratiod2f.append(NBRlBinratiod2f)
                    NBRldf.to_csv(NBRlpath, index=False)
                    os.remove(dNBRlstats)
                # NBRl: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
                del NBRldf
                NBRlp = pd.DataFrame(NBRlL, columns = ['bin_n'])
                NBRlp['Binratiod1f']=NBRlLBinratiod1f
                NBRlp['Binratiod2f']=NBRlLBinratiod2f
                NBRlratio=self.dlg.lin_out.text()+'/dNBRl_ratio.csv'
                NBRlp.to_csv(NBRlratio, index = False)
                NBRlbd1f = NBRlp.max()['Binratiod1f']
                NBRlbd2f = NBRlp.max()['Binratiod2f']
                NBRllista1 = []
                NBRllista2 = []
                NBRlbind1f=self.dlg.lin_out.text()+'/dNBRl_d1fbin.csv'
                NBRlbind2f=self.dlg.lin_out.text()+'/dNBRl_d2fbin.csv'
                NBRlselecao1 = NBRlp[NBRlp.Binratiod1f == NBRlbd1f]
                NBRlc1 = NBRlselecao1[NBRlselecao1.bin_n == NBRlselecao1.bin_n.max()]
                NBRllista1.append(int(NBRlc1.bin_n.tolist()[0]))
                NBRlselecao2 = NBRlp[NBRlp.Binratiod2f == NBRlbd2f]
                NBRlc2 = NBRlselecao2[NBRlselecao2.bin_n == NBRlselecao2.bin_n.max()]
                NBRllista2.append(int(NBRlc2.bin_n.tolist()[0]))
                NBRlchoice1 = pd.DataFrame(NBRllista1)
                NBRlchoice2 = pd.DataFrame(NBRllista2)
                NBRlchoice1.to_csv(NBRlbind1f,index= False, header=False)   
                NBRlchoice2.to_csv(NBRlbind2f,index= False, header=False)   
                NBRlT1list=[]
                NBRlT2list=[]
        #NBRl Select one threshold based on d1f (if any)
                NBRlbind1f_num=str(NBRllista1[0])
                NBRlp1=self.dlg.lin_out.text()+'/dNBRl_'+NBRlbind1f_num+'_d2f.csv'
                NBRlc1=pd.read_csv(NBRlp1)
                NBRlc1up5=len(NBRlc1)
                NBRlc1['d1f']=pd.to_numeric(NBRlc1['d1f'], errors='coerce')
                NBRlc1countmax=NBRlc1['count'][1:NBRlc1up5].max()
                NBRlc1xmax=float(NBRlc1[NBRlc1['count']==NBRlc1countmax]['x'])
                NBRlc1sup=NBRlc1[(NBRlc1['x']>=NBRlc1xmax)]
                NBRlc1up1=len(NBRlc1sup)-2
                NBRlc1r1=list(range(NBRlc1up1))
                for i in NBRlc1r1:
                        NBRlji=i
                        NBRlj0=i-1
                        NBRlxi=NBRlc1sup.iloc[NBRlji]["x"]
                        NBRlx0=NBRlc1sup.iloc[NBRlj0]["x"]
                        NBRld1fi=float(NBRlc1sup.iloc[NBRlji]["d1f"])
                        NBRld1f0=float(NBRlc1sup.iloc[NBRlj0]["d1f"])
                        if (NBRld1f0<0 and NBRld1fi>0):
                            NBRlT1=(NBRlxi+NBRlx0)/2
                            NBRlT1list.append(NBRlT1)
                        else:
                            continue    
        # NBRl Select threshold(s) based on d2f
                NBRlbind2f_num=str(NBRllista2[0])
                NBRlp1=self.dlg.lin_out.text()+'/dNBRl_'+NBRlbind2f_num+'_d2f.csv'
                NBRlc1=pd.read_csv(NBRlp1)
                NBRlup5=len(NBRlc1)
                NBRlc1['d2f']=pd.to_numeric(NBRlc1['d2f'], errors='coerce')
                NBRld2fmin=NBRlc1['d2f'][1:NBRlup5].min()
                NBRlxmax=float(NBRlc1[NBRlc1['d2f']==NBRld2fmin]['x'])
                NBRlc1sup=NBRlc1[(NBRlc1['x']>=NBRlxmax)]
                NBRlc1up2=len(NBRlc1sup)-3
                NBRlc1r2=list(range(NBRlc1up2))
                NBRlcnt=1
                for i in NBRlc1r2:
                    NBRlji2=i+1
                    NBRlji=i
                    NBRlj0=i-1
                    NBRlxi=NBRlc1sup.iloc[NBRlji]["x"]
                    NBRlx0=NBRlc1sup.iloc[NBRlj0]["x"]
                    NBRlxi2=NBRlc1sup.iloc[NBRlji2]["x"]
                    NBRld2fi=float(NBRlc1sup.iloc[NBRlji]["d2f"])
                    NBRld2fi2=float(NBRlc1sup.iloc[NBRlji2]["d2f"])
                    NBRld2f0=float(NBRlc1sup.iloc[NBRlj0]["d2f"])
                    if NBRld2f0<0:
                        NBRlcnt=1
                    if (NBRld2fi>NBRld2f0 and NBRld2fi>NBRld2fi2 and NBRld2fi>0 and NBRlcnt>=1):
                        NBRlT2=NBRlxi
                        NBRlT2list.append(NBRlT2)
                        NBRlcnt=0
                    else:
                        continue
        #NBRl Save Threshold list to csvsl
                NBRlT1L= pd.DataFrame(NBRlT1list)
                NBRlT1_p=self.dlg.lin_out.text()+'/NBRlT1.csv'
                NBRlT2_p=self.dlg.lin_out.text()+'/NBRlT2.csv'
                NBRlThresh_p=self.dlg.lin_out.text()+'/NBRlThresh.csv'
                NBRlT1L.to_csv(NBRlT1_p, header= False, index = False)
                NBRlT2L= pd.DataFrame(NBRlT2list)
                NBRlT2L.to_csv(NBRlT2_p, header= False, index = False)
                NBRlT1Len=len(NBRlT1list)
                NBRlT2Len=len(NBRlT2list)
                NBRlThresh=[]
                i, j= 0, 0
                while i<NBRlT1Len and j<NBRlT2Len:
                    if NBRlT1list[i] < NBRlT2list[j]:
                        NBRlThresh.append(NBRlT1list[i])
                        i +=1
                    else:
                        NBRlThresh.append(NBRlT2list[j])
                        j +=1
                NBRlThresh=NBRlThresh+ NBRlT1list[i:] + NBRlT2list[j:]
                NBRlThreshL=pd.DataFrame(NBRlThresh)
                NBRlThreshL.to_csv(NBRlThresh_p, header= False, index = False)
                NBRlly=[]
                for tr in NBRlThresh:
                    NBRlly.append(tr)
                    NBRllw=len(NBRlly)
                if NBRllw>=1:
                    if NBRllw==1:
                        NBRlT1=[]
                        NBRlT1=[str(NBRlly[0])]
                        consequences_c_dNBRl = []
                        cons_c_dNBRl=QgsRasterCalculatorEntry()
                        cons_c_dNBRl.ref='dNBRl@1'
                        cons_c_dNBRl.raster = dNBRl_layer
                        cons_c_dNBRl.bandNumber=1
                        consequences_c_dNBRl.append(cons_c_dNBRl)    
                        c_dNBRl_exp='(' +consequences_c_dNBRl[0].ref + ' >' +NBRlT1[0]+')* 1 + (' +consequences_c_dNBRl[0].ref + '<= ' +NBRlT1[0]+' )*0'
                        c_dNBRl_file = self.dlg.lin_out.text()+ '/c_dNBRl.tif'
                        c_dNBRl = QgsRasterCalculator(c_dNBRl_exp,
                                                   c_dNBRl_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNBRl)                        
                        c_dNBRl.processCalculation()
                        c_dNBRl_layer = QgsRasterLayer(c_dNBRl_file,'c_dNBRl')
                        QgsProject.instance().addMapLayer(c_dNBRl_layer)   
                    elif NBRllw>=2:
                        NBRlT1=[]
                        NBRlT2=[]
                        NBRlT1=[str(NBRlly[0])]
                        NBRlT2=[str(NBRlly[1])]
                        consequences_c_dNBRl = []
                        cons_c_dNBRl=QgsRasterCalculatorEntry()
                        cons_c_dNBRl.ref='dNBRl@1'
                        cons_c_dNBRl.raster = dNBRl_layer
                        cons_c_dNBRl.bandNumber=1
                        consequences_c_dNBRl.append(cons_c_dNBRl)     
                        c_dNBRl_exp='(' +consequences_c_dNBRl[0].ref + ' <=' +NBRlT1[0]+')* 0 + (' +consequences_c_dNBRl[0].ref + '> ' +NBRlT1[0]+' )*(' +consequences_c_dNBRl[0].ref + ' >=' +NBRlT2[0]+')*10+ (' +consequences_c_dNBRl[0].ref + '> ' +NBRlT1[0]+' )*(' +consequences_c_dNBRl[0].ref + ' <' +NBRlT2[0]+')*1'
                        c_dNBRl_file = self.dlg.lin_out.text()+ '/c_dNBRl.tif'
                        c_dNBRl = QgsRasterCalculator(c_dNBRl_exp,
                                                   c_dNBRl_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNBRl)                               
                        c_dNBRl.processCalculation()
                        c_dNBRl_layer = QgsRasterLayer(c_dNBRl_file,'c_dNBRl')
                        QgsProject.instance().addMapLayer(c_dNBRl_layer)              
            #   NBR2 calculation 
                NBR20file = self.dlg.lin_out.text()+ '/NBR20.tif'
                NBR21file = self.dlg.lin_out.text()+ '/NBR21.tif'
                if self.dlg.Cb_topo.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':tswirs0_path,'b':tswirl0_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NBR20file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.mapcalc.simple", {'a':tswirs1_path,'b':tswirl1_path,'c':None,'d':None,'e':None,'f':None,'expression':'if(((A-B)/(A+B))<-1,-1,if(((A-B)/(A+B))>1,1,((A-B)/(A+B))))','output':NBR21file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    NBR20_layer = QgsRasterLayer(NBR20file,'NBR2_0')
                    NBR21_layer = QgsRasterLayer(NBR21file,'NBR2_1')
                else:              
                    NBR20_exp = '((((' + entries[7].ref + ' - ' + entries[8].ref + ') / ('+ entries[7].ref + ' + ' + entries[8].ref +'))>=-1)*(((' + entries[7].ref + ' - ' + entries[8].ref + ') / ('+ entries[7].ref + ' + ' + entries[8].ref +'))<=1))*(((' + entries[7].ref + ' - ' + entries[8].ref + ') / ('+ entries[7].ref + ' + ' + entries[8].ref +')))' 
                    NBR21_exp = '((((' + entries[13].ref + ' - ' + entries[14].ref + ') / ('+ entries[13].ref + ' + ' + entries[14].ref +'))>=-1)*(((' + entries[13].ref + ' - ' + entries[14].ref + ') / ('+ entries[13].ref + ' + ' + entries[14].ref +'))<=1))*(((' + entries[13].ref + ' - ' + entries[14].ref + ') / ('+ entries[13].ref + ' + ' + entries[14].ref +')))' 
                    NBR20 = QgsRasterCalculator(NBR20_exp,
                                               NBR20file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    NBR20.processCalculation()
                    NBR20_layer = QgsRasterLayer(NBR20file,'NBR2_0')
                    NBR21 = QgsRasterCalculator(NBR21_exp,
                                               NBR21file,
                                               'GTiff',
                                               extent,
                                               width,
                                               height,
                                               entries)
                    NBR21.processCalculation()
                    NBR21_layer = QgsRasterLayer(NBR21file,'NBR2_1')
            #dNBR2:
                consequences = []
                cons_NBR20=QgsRasterCalculatorEntry()
                cons_NBR20.ref='NBR20@1'
                cons_NBR20.raster = NBR20_layer
                cons_NBR20.bandNumber=1
                consequences.append(cons_NBR20)
                cons_NBR21=QgsRasterCalculatorEntry()
                cons_NBR21.ref='NBR21@1'
                cons_NBR21.raster = NBR21_layer
                cons_NBR21.bandNumber=1
                consequences.append(cons_NBR21)     
    #
                if self.dlg.Cb_cloud.isChecked():
                    cons_csg=QgsRasterCalculatorEntry()
                    cons_csg.ref='csg@1'
                    cons_csg.raster = csg_layer
                    cons_csg.bandNumber=1
                    consequences.append(cons_csg)
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNBR2_exp='(' +consequences[2].ref + '*' +consequences[0].ref + '*' +consequences[3].ref + ' - ' + consequences[1].ref + ')'
                    else:
                        dNBR2_exp='(' +consequences[2].ref + '*' +consequences[0].ref + ' - ' + consequences[1].ref + ')'
                else:
                    if self.dlg.Cb_hrs.isChecked():
                        cons_hrs=QgsRasterCalculatorEntry()
                        cons_hrs.ref='hrs@1'
                        cons_hrs.raster = hrs_mask
                        cons_hrs.bandNumber=1
                        consequences.append(cons_hrs)
                        dNBR2_exp='('+consequences[0].ref + ' - '+ consequences[1].ref + '*'  +consequences[2].ref + ')'
                    else:
                        dNBR2_exp='(' +consequences[0].ref + ' - '+ consequences[1].ref + ')'
                dNBR2_file = self.dlg.lin_out.text()+ '/d_NBR2.tif'
                dNBR2 = QgsRasterCalculator(dNBR2_exp,
                                           dNBR2_file,
                                           'GTiff',
                                           extent,
                                           width,
                                           height,
                                           consequences)
                dNBR2.processCalculation()
                if self.dlg.Cb_water.isChecked():
                    processing.run("grass7:r.mapcalc.simple", {'a':dNBR2_file,'b':layers[1],'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':dNBR2_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                dNBR2_layer = QgsRasterLayer(dNBR2_file,'dNBR2')
                for b in bin_n:
                    bstr=str(b)
                    bint=b
                    dNBR2stats=self.dlg.lin_out.text()+'/dNBR2_'+bstr+'.csv'
                    NBR2path=self.dlg.lin_out.text()+'/dNBR2_'+bstr+'_d2f.csv' 
                    processing.run("grass7:r.stats", {'input':[dNBR2_layer],'separator':',','null_value':'*','nsteps':bint,'sort':0,'-1':False,'-A':True,'-a':False,'-c':True,'-p':False,'-l':False,'-g':False,'-x':False,'-r':False,'-n':True,'-N':True,'-C':False,'-i':False,'html':str(dNBR2stats),'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0})
                    f = open(dNBR2stats)
                    text = f.read()
                    f.close()
                    clean = re.sub('<[^>]+>', '', text)
                    f   = open(dNBR2stats, 'w')
                    f.write(clean)
                    f.close()
                    NBR2df_uns=pd.read_csv(dNBR2stats, header=None)
                    NBR2df_uns.columns= ["x","count"]
                    NBR2df = NBR2df_uns.sort_values (by=['x'])
                    NBR2df.to_csv(dNBR2stats, index=False)
                    NBR2up=len(NBR2df)
                    NBR2up2=len(NBR2df)-1
                    NBR2up3=len(NBR2df)-2
                    NBR2up4=len(NBR2df)-3
                    NBR2up5=len(NBR2df)-4
                    NBR2j=0
                    NBR2r=list(range(0,NBR2up2))
                    NBR2l1=list(range(0,NBR2up))
                    NBR2r2=list(range(3,NBR2up3))
                    NBR2l2=list(range(0,NBR2up))
                    NBR2r3=list(range(2,NBR2up3))
                    NBR2l3=list(range(0,NBR2up))
                    NBR2l4=list(range(0,NBR2up))
                    NBR2r4=list(range(2,NBR2up3))
                    NBR2r5=list(range(3,NBR2up3))
         #NBR2 d1f calculation
                    for ig in NBR2r:
                        NBR2j0=ig
                        NBR2ji=NBR2j0+1
                        NBR2xi=NBR2df.iloc[NBR2ji]["x"]
                        NBR2yi=NBR2df.iloc[NBR2ji]["count"]
                        NBR2x0=NBR2df.iloc[NBR2j0]["x"]
                        NBR2y0=NBR2df.iloc[NBR2j0]["count"]
                        try:
                            NBR2di=(NBR2yi-NBR2y0)/(NBR2xi-NBR2x0) /2  # the /2 is required to correct the d1f, because we are using average x values
                        except: continue
                        NBR2l1[NBR2j0]=NBR2di
                    NBR2l1[NBR2up2]=" "
                    NBR2df.insert(2,'d1f',NBR2l1, True)
             #NBR2d2f calculation   
                    for ih in NBR2r3:
                        NBR2hi=ih
                        NBR2h0=NBR2hi-1
                        NBR2xi=NBR2df.iloc[NBR2hi]["x"]
                        NBR2d1fi=float(NBR2df.iloc[NBR2hi]['d1f'])
                        NBR2x0=NBR2df.iloc[NBR2h0]["x"]
                        NBR2d1f0=float(NBR2df.iloc[NBR2h0]['d1f'])
                        NBR2d2i=((NBR2d1fi-NBR2d1f0)/(2*NBR2xi-2*NBR2x0))/1.5
                        NBR2l2[NBR2hi]=NBR2d2i
                    NBR2l2[0]=" "
                    NBR2l2[NBR2up2]=" "
                    NBR2df.insert(3,'d2f',NBR2l2, True)
            #NBR2 Calculate consecutive values ratio for d1f
                    NBR2countposd1f=0
                    NBR2countnegd1f=0
                    NBR2listposnegd1f=[]
                    NBR2df['count']=pd.to_numeric(NBR2df['count'], errors='coerce')
                    NBR2df['d1f']=pd.to_numeric(NBR2df['d1f'], errors='coerce')
                    NBR2df['d2f']=pd.to_numeric(NBR2df['d2f'], errors='coerce')
                    NBR2countmax=NBR2df['count'][1:NBR2up5].max()
                    try:
                        NBR2xmax=float(NBR2df[NBR2df['count']==NBR2countmax]['x'])
                    except Exception:
                        NBR2xmax=0.0
                    NBR2sup=NBR2df[(NBR2df['x']>=NBR2xmax)] 
                    NBR2up1=len(NBR2sup)-1
                    NBR2r1=list(range(0,NBR2up1))
                    NBR2r1len=len(NBR2r1)
                    for iib in NBR2r1:
                        NBR2ji=iib
                        NBR2j0=NBR2ji-1
                        NBR2d1fi=float(NBR2sup.iloc[NBR2ji]["d1f"])
                        NBR2d1f0=float(NBR2sup.iloc[NBR2j0]["d1f"])
                        NBR2x0=float(NBR2sup.iloc[NBR2j0]["x"])
                        if (NBR2d1fi>NBR2d1f0):
                            NBR2listposnegd1f.append(1)
                        elif (NBR2d1fi<NBR2d1f0):
                            NBR2listposnegd1f.append(0)
                    for iiib in range(1,len(NBR2listposnegd1f)):
                            if NBR2listposnegd1f[iiib-1] == NBR2listposnegd1f[iiib]:
                                if NBR2listposnegd1f[iiib-1] == 1:
                                    NBR2countposd1f = NBR2countposd1f + 1
                                else:
                                    NBR2countnegd1f = NBR2countnegd1f + 1
                    try:
                        NBR2Binratiod1f= (NBR2countposd1f+NBR2countnegd1f)/float(NBR2r1len)
                    except:
                        continue
                    NBR2LBinratiod1f.append(NBR2Binratiod1f)
              # NBR2 calculate consecutive values ratio for d2f
                    NBR2countposd2f=0
                    NBR2countnegd2f=0
                    NBR2listposnegd2f=[]
                    NBR2up2=len(NBR2sup)-1
                    NBR2r2=list(range(0,NBR2up2))
                    NBR2r2len=len(NBR2r2)
                    for ivb in NBR2r2:
                        NBR2ji=ivb
                        NBR2j0=NBR2ji-1
                        NBR2d2fi=float(NBR2sup.iloc[NBR2ji]["d2f"])
                        NBR2d2f0=float(NBR2sup.iloc[NBR2j0]["d2f"])
                        NBR2x0=float(NBR2sup.iloc[NBR2j0]["x"])
                        if (NBR2d2fi>NBR2d2f0):
                            NBR2listposnegd2f.append(1)
                        elif (NBR2d2fi<NBR2d2f0):
                            NBR2listposnegd2f.append(0)
                    for vb in range(1,len(NBR2listposnegd2f)):
                            if NBR2listposnegd2f[vb-1] == NBR2listposnegd2f[vb]:
                                if NBR2listposnegd2f[vb-1] == 1:
                                    NBR2countposd2f = NBR2countposd2f + 1
                                else:
                                    NBR2countnegd2f = NBR2countnegd2f + 1
                    try:
                        NBR2Binratiod2f=(NBR2countposd2f+NBR2countnegd2f)/float(NBR2r2len)
                    except:
                        continue
                    NBR2LBinratiod2f.append(NBR2Binratiod2f)
                    NBR2df.to_csv(NBR2path, index=False)
                    os.remove(dNBR2stats)
                # NBR2: Choose the lowest bin_n per year, which maximises Binratiod1f and Binratiod1f:
                del NBR2df
                NBR2p = pd.DataFrame(NBR2L, columns = ['bin_n'])
                NBR2p['Binratiod1f']=NBR2LBinratiod1f
                NBR2p['Binratiod2f']=NBR2LBinratiod2f
                NBR2ratio=self.dlg.lin_out.text()+'/dNBR2_ratio.csv'
                NBR2p.to_csv(NBR2ratio, index = False)
                NBR2bd1f = NBR2p.max()['Binratiod1f']
                NBR2bd2f = NBR2p.max()['Binratiod2f']
                NBR2lista1 = []
                NBR2lista2 = []
                NBR2bind1f=self.dlg.lin_out.text()+'/dNBR2_d1fbin.csv'
                NBR2bind2f=self.dlg.lin_out.text()+'/dNBR2_d2fbin.csv'
                NBR2selecao1 = NBR2p[NBR2p.Binratiod1f == NBR2bd1f]
                NBR2c1 = NBR2selecao1[NBR2selecao1.bin_n == NBR2selecao1.bin_n.max()]
                NBR2lista1.append(int(NBR2c1.bin_n.tolist()[0]))
                NBR2selecao2 = NBR2p[NBR2p.Binratiod2f == NBR2bd2f]
                NBR2c2 = NBR2selecao2[NBR2selecao2.bin_n == NBR2selecao2.bin_n.max()]
                NBR2lista2.append(int(NBR2c2.bin_n.tolist()[0]))
                NBR2choice1 = pd.DataFrame(NBR2lista1)
                NBR2choice2 = pd.DataFrame(NBR2lista2)
                NBR2choice1.to_csv(NBR2bind1f,index= False, header=False)   
                NBR2choice2.to_csv(NBR2bind2f,index= False, header=False)   
                NBR2T1list=[]
                NBR2T2list=[]
        #NBR2 Select one threshold based on d1f (if any)
                NBR2bind1f_num=str(NBR2lista1[0])
                NBR2p1=self.dlg.lin_out.text()+'/dNBR2_'+NBR2bind1f_num+'_d2f.csv'
                NBR2c1=pd.read_csv(NBR2p1)
                NBR2c1up5=len(NBR2c1)
                NBR2c1['d1f']=pd.to_numeric(NBR2c1['d1f'], errors='coerce')
                NBR2c1countmax=NBR2c1['count'][1:NBR2c1up5].max()
                NBR2c1xmax=float(NBR2c1[NBR2c1['count']==NBR2c1countmax]['x'])
                NBR2c1sup=NBR2c1[(NBR2c1['x']>=NBR2c1xmax)]
                NBR2c1up1=len(NBR2c1sup)-2
                NBR2c1r1=list(range(NBR2c1up1))
                for i in NBR2c1r1:
                        NBR2ji=i
                        NBR2j0=i-1
                        NBR2xi=NBR2c1sup.iloc[NBR2ji]["x"]
                        NBR2x0=NBR2c1sup.iloc[NBR2j0]["x"]
                        NBR2d1fi=float(NBR2c1sup.iloc[NBR2ji]["d1f"])
                        NBR2d1f0=float(NBR2c1sup.iloc[NBR2j0]["d1f"])
                        if (NBR2d1f0<0 and NBR2d1fi>0):
                            NBR2T1=(NBR2xi+NBR2x0)/2
                            NBR2T1list.append(NBR2T1)
                        else:
                            continue    
        # NBR2 Select threshold(s) based on d2f
                NBR2bind2f_num=str(NBR2lista2[0])
                NBR2p1=self.dlg.lin_out.text()+'/dNBR2_'+NBR2bind2f_num+'_d2f.csv'
                NBR2c1=pd.read_csv(NBR2p1)
                NBR2up5=len(NBR2c1)
                NBR2c1['d2f']=pd.to_numeric(NBR2c1['d2f'], errors='coerce')
                NBR2d2fmin=NBR2c1['d2f'][1:NBR2up5].min()
                NBR2xmax=float(NBR2c1[NBR2c1['d2f']==NBR2d2fmin]['x'])
                NBR2c1sup=NBR2c1[(NBR2c1['x']>=NBR2xmax)]
                NBR2c1up2=len(NBR2c1sup)-3
                NBR2c1r2=list(range(NBR2c1up2))
                NBR2cnt=1
                for i in NBR2c1r2:
                    NBR2ji2=i+1
                    NBR2ji=i
                    NBR2j0=i-1
                    NBR2xi=NBR2c1sup.iloc[NBR2ji]["x"]
                    NBR2x0=NBR2c1sup.iloc[NBR2j0]["x"]
                    NBR2xi2=NBR2c1sup.iloc[NBR2ji2]["x"]
                    NBR2d2fi=float(NBR2c1sup.iloc[NBR2ji]["d2f"])
                    NBR2d2fi2=float(NBR2c1sup.iloc[NBR2ji2]["d2f"])
                    NBR2d2f0=float(NBR2c1sup.iloc[NBR2j0]["d2f"])
                    if NBR2d2f0<0:
                        NBR2cnt=1
                    if (NBR2d2fi>NBR2d2f0 and NBR2d2fi>NBR2d2fi2 and NBR2d2fi>0 and NBR2cnt>=1):
                        NBR2T2=NBR2xi
                        NBR2T2list.append(NBR2T2)
                        NBR2cnt=0
                    else:
                        continue
        #NBR2 Save Threshold list to csvsl
                NBR2T1L= pd.DataFrame(NBR2T1list)
                NBR2T1_p=self.dlg.lin_out.text()+'/NBR2T1.csv'
                NBR2T2_p=self.dlg.lin_out.text()+'/NBR2T2.csv'
                NBR2Thresh_p=self.dlg.lin_out.text()+'/NBR2Thresh.csv'
                NBR2T1L.to_csv(NBR2T1_p, header= False, index = False)
                NBR2T2L= pd.DataFrame(NBR2T2list)
                NBR2T2L.to_csv(NBR2T2_p, header= False, index = False)
                NBR2T1Len=len(NBR2T1list)
                NBR2T2Len=len(NBR2T2list)
                NBR2Thresh=[]
                i, j= 0, 0
                while i<NBR2T1Len and j<NBR2T2Len:
                    if NBR2T1list[i] < NBR2T2list[j]:
                        NBR2Thresh.append(NBR2T1list[i])
                        i +=1
                    else:
                        NBR2Thresh.append(NBR2T2list[j])
                        j +=1
                NBR2Thresh=NBR2Thresh+ NBR2T1list[i:] + NBR2T2list[j:]
                NBR2ThreshL=pd.DataFrame(NBR2Thresh)
                NBR2ThreshL.to_csv(NBR2Thresh_p, header= False, index = False)
                NBR2ly=[]
                for tr in NBR2Thresh:
                    NBR2ly.append(tr)
                    NBR2lw=len(NBR2ly)
                if NBR2lw>=1:
                    if NBR2lw==1:
                        NBR2T1=[]
                        NBR2T1=[str(NBR2ly[0])]
                        consequences_c_dNBR2 = []
                        cons_c_dNBR2=QgsRasterCalculatorEntry()
                        cons_c_dNBR2.ref='dNBR2@1'
                        cons_c_dNBR2.raster = dNBR2_layer
                        cons_c_dNBR2.bandNumber=1
                        consequences_c_dNBR2.append(cons_c_dNBR2)    
                        c_dNBR2_exp='(' +consequences_c_dNBR2[0].ref + ' >' +NBR2T1[0]+')* 1 + (' +consequences_c_dNBR2[0].ref + '<= ' +NBR2T1[0]+' )*0'
                        c_dNBR2_file = self.dlg.lin_out.text()+ '/c_dNBR2.tif'
                        c_dNBR2 = QgsRasterCalculator(c_dNBR2_exp,
                                                   c_dNBR2_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNBR2)                             
                        c_dNBR2.processCalculation()
                        c_dNBR2_layer = QgsRasterLayer(c_dNBR2_file,'c_dNBR2')
                        QgsProject.instance().addMapLayer(c_dNBR2_layer)   
                    elif NBR2lw>=2:
                        NBR2T1=[]
                        NBR2T2=[]
                        NBR2T1=[str(NBR2ly[0])]
                        NBR2T2=[str(NBR2ly[1])]
                        consequences_c_dNBR2 = []
                        cons_c_dNBR2=QgsRasterCalculatorEntry()
                        cons_c_dNBR2.ref='dNBR2@1'
                        cons_c_dNBR2.raster = dNBR2_layer
                        cons_c_dNBR2.bandNumber=1
                        consequences_c_dNBR2.append(cons_c_dNBR2)     
                        c_dNBR2_exp='(' +consequences_c_dNBR2[0].ref + ' <=' +NBR2T1[0]+')* 0 + (' +consequences_c_dNBR2[0].ref + '> ' +NBR2T1[0]+' )*(' +consequences_c_dNBR2[0].ref + ' >=' +NBR2T2[0]+')*10+ (' +consequences_c_dNBR2[0].ref + '> ' +NBR2T1[0]+' )*(' +consequences_c_dNBR2[0].ref + ' <' +NBR2T2[0]+')*1'
                        c_dNBR2_file = self.dlg.lin_out.text()+ '/c_dNBR2.tif'
                        c_dNBR2 = QgsRasterCalculator(c_dNBR2_exp,
                                                   c_dNBR2_file,
                                                   'GTiff',
                                                   extent,
                                                   width,
                                                   height,
                                                   consequences_c_dNBR2)                               
                        c_dNBR2.processCalculation()
                        c_dNBR2_layer = QgsRasterLayer(c_dNBR2_file,'c_dNBR2')
                        QgsProject.instance().addMapLayer(c_dNBR2_layer)              
            #MINDED_FBA-BA for burned areas    
                OSumbMS_file=self.dlg.lin_out.text()+'/OSumbMS.tif'
                consequences_OSumb=[]
                cons_OSumb=QgsRasterCalculatorEntry()
                cons_OSumb.ref='C_dNDVI@1'
                cons_OSumb.raster = c_dNDVI_layer
                cons_OSumb.bandNumber=1
                consequences_OSumb.append(cons_OSumb)
                cons_OSumb=QgsRasterCalculatorEntry()
                cons_OSumb.ref='C_dNBRs@1'
                cons_OSumb.raster = c_dNBRs_layer
                cons_OSumb.bandNumber=1
                consequences_OSumb.append(cons_OSumb)
                cons_OSumb=QgsRasterCalculatorEntry()
                cons_OSumb.ref='C_dNBRl@1'
                cons_OSumb.raster = c_dNBRl_layer
                cons_OSumb.bandNumber=1
                consequences_OSumb.append(cons_OSumb)
                cons_OSumb=QgsRasterCalculatorEntry()
                cons_OSumb.ref='C_dNBR2@1'
                cons_OSumb.raster = c_dNBR2_layer
                cons_OSumb.bandNumber=1
                consequences_OSumb.append(cons_OSumb)
                if (self.dlg.Cb_SAR.isChecked()):
                    OSumbMSSAR_file=self.dlg.lin_out.text()+'/OSumbMSSAR.tif'
                    cons_OSumb=QgsRasterCalculatorEntry()
                    cons_OSumb.ref='c_NDTIVV@1'
                    cons_OSumb.raster = c_NDTIVV_layer
                    cons_OSumb.bandNumber=1
                    consequences_OSumb.append(cons_OSumb)
                    cons_OSumb=QgsRasterCalculatorEntry()
                    cons_OSumb.ref='c_NDTIVH@1'
                    cons_OSumb.raster = c_NDTIVH_layer
                    cons_OSumb.bandNumber=1
                    consequences_OSumb.append(cons_OSumb)                   
                    Overall_sumbMS_exp= '(' +consequences_OSumb[0].ref + '+'+consequences_OSumb[1].ref +'+'+consequences_OSumb[2].ref +'+'+consequences_OSumb[3].ref +')'
                    Overall_sumbMSSAR_exp= '(' +consequences_OSumb[0].ref + '+'+consequences_OSumb[1].ref +'+'+consequences_OSumb[2].ref +'+'+consequences_OSumb[3].ref +'+'+consequences_OSumb[4].ref +'+'+consequences_OSumb[5].ref +')'
                    OSumbMS = QgsRasterCalculator(Overall_sumbMS_exp,
                                                       OSumbMS_file,
                                                       'GTiff',
                                                       extent,
                                                       width,
                                                       height,
                                                       consequences_OSumb)    
                    OSumbMS.processCalculation()
                    OSumbMS_layer = QgsRasterLayer(OSumbMS_file,'OSumbMS')
                    QgsProject.instance().addMapLayer(OSumbMS_layer) 
                    OSumbMSSAR = QgsRasterCalculator(Overall_sumbMSSAR_exp,
                                                       OSumbMSSAR_file,
                                                       'GTiff',
                                                       extent,
                                                       width,
                                                       height,
                                                       consequences_OSumb)    
                    OSumbMSSAR.processCalculation()
                    OSumbMSSAR_layer = QgsRasterLayer(OSumbMSSAR_file,'OSumbMSSAR')
                    QgsProject.instance().addMapLayer(OSumbMSSAR_layer)   
                    BurnedMS_file=self.dlg.lin_out.text()+'/BurnedMS.tif'
                    BurnedMSSAR_file=self.dlg.lin_out.text()+'/BurnedMSSAR.tif'
                    BurnedFusion_file=self.dlg.lin_out.text()+'/BurnedFusion.tif'
                    NDTIextent=c_NDTI_layer.extent()
                    processing.run("grass7:r.reclass", {'input':OSumbMS_layer,'rules':'','txtrules':'0 1 10=0\n 4 3 13 12 21 22=1\n 40 30 31 =10\n 2 11 20 =-100','output':BurnedMS_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.reclass", {'input':OSumbMSSAR_layer,'rules':'','txtrules':'0 1 10 2 20 11 12 21=0\n 6 5 15 4 24 14 13 23=1\n 60 50 51 40 42 41 31 32 =10\n 22=-100','output':BurnedMSSAR_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.patch", {'input':[BurnedMSSAR_file,BurnedMS_file],'-z':False,'output':BurnedFusion_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})       
                    processing.run("grass7:r.patch", {'input':[BurnedFusion_file,c_NDTI_file],'-z':False,'output':BurnedFusion_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    os.remove(BurnedMSSAR_file) 
                    if self.dlg.Cb_hrs.isChecked():
                        processing.run("grass7:r.mapcalc.simple", {'a':BurnedFusion_file,'b':hrs_mask,'c':None,'d':None,'e':None,'f':None,'expression':'A*B','output':BurnedFusion_file,'GRASS_REGION_PARAMETER':extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    BurnedFusion_layer = QgsRasterLayer(BurnedFusion_file,'BurnedFusion')
                    BurnedFusion_layer.loadNamedStyle(self.plugin_dir +"/fire_color.qml")
                    QgsProject.instance().addMapLayer(BurnedFusion_layer) 
                    UncertaintyMSSAR_file=self.dlg.lin_out.text()+'/UncertaintyMSSAR.tif'
                    UncertaintyNDTI_file=self.dlg.lin_out.text()+'/UncertaintyNDTI.tif'
                    UncertaintyFusion_file=self.dlg.lin_out.text()+'/UncertaintyFusion.tif'
                    processing.run("grass7:r.reclass", {'input':OSumbMS_layer,'rules':'','txtrules':'0 4 40=0\n1 10 30 31 3 13=1\n11 12 21=2\n2 20 22=3','output':UncertaintyMS_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.reclass", {'input':OSumbMSSAR_layer,'rules':'','txtrules':'0 6 60=0\n1 10 5 15 50 51=1\n2 20 11 4 24 14 40 42 41=2\n12 21 22 13 23 31 32=3','output':UncertaintyMSSAR_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    processing.run("grass7:r.patch", {'input':[UncertaintyMSSAR_file,UncertaintyMS_file,UncertaintyNDTI_file],'-z':False,'output':UncertaintyFusion_file,'GRASS_REGION_PARAMETER':None,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    UncertaintyFusion_layer = QgsRasterLayer(UncertaintyFusion_file, 'UncertaintyFusion')
                    UncertaintyFusion_layer.loadNamedStyle(self.plugin_dir +"/uncertainty_color.qml")
                    QgsProject.instance().addMapLayer(UncertaintyFusion_layer)
                    QgsProject.instance().removeMapLayer(OSumbMS_layer) 
                    QgsProject.instance().removeMapLayer(OSumbMSSAR_layer)
                    QgsProject.instance().removeMapLayer(OSumNDTIlayer)

                    
                    
                    os.remove(UncertaintyMSSAR_file) 
                else:
                    Overall_sumbMS_exp= '(' +consequences_OSumb[0].ref + '+'+consequences_OSumb[1].ref +'+'+consequences_OSumb[2].ref +'+'+consequences_OSumb[3].ref +')'
                    OSumbMS = QgsRasterCalculator(Overall_sumbMS_exp,
                                                       OSumbMS_file,
                                                       'GTiff',
                                                       extent,
                                                       width,
                                                       height,
                                                       consequences_OSumb)     
                    OSumbMS.processCalculation()
                    OSumbMS_layer = QgsRasterLayer(OSumbMS_file,'OSumbMS')
                    QgsProject.instance().addMapLayer(OSumbMS_layer)   
                    BurnedMS_file=self.dlg.lin_out.text()+'/BurnedMS.tif'
                    processing.run("grass7:r.reclass", {'input':OSumbMS_layer,'rules':'','txtrules':'0 1 10=0\n 4 3 13 12 21 22=1\n 40 30 31 =10\n 2 11 20 =-100','output':BurnedMS_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    BurnedMS_layer = QgsRasterLayer(BurnedMS_file,'BurnedMS')
                    BurnedMS_layer.loadNamedStyle(self.plugin_dir +"/fire_color.qml")
                    QgsProject.instance().addMapLayer(BurnedMS_layer) 
                    processing.run("grass7:r.reclass", {'input':OSumbMS_layer,'rules':'','txtrules':'0 4 40=0\n1 10 30 31 3 13=1\n11 12 21=2\n2 20 22=3','output':UncertaintyMS_file,'GRASS_REGION_PARAMETER': extent,'GRASS_REGION_CELLSIZE_PARAMETER':0,'GRASS_RASTER_FORMAT_OPT':'','GRASS_RASTER_FORMAT_META':''})
                    UncertaintyMS_layer = QgsRasterLayer(UncertaintyMS_file, 'UncertaintyMS')
                    UncertaintyMS_layer.loadNamedStyle(self.plugin_dir +"/uncertainty_color.qml")
                    QgsProject.instance().addMapLayer(UncertaintyMS_layer)
                    QgsProject.instance().removeMapLayer(OSumbMS_layer) 
    def loadlayers(self):
        study = self.getlayerbyname(self.dlg.mcb_study.currentText())
        water = self.getlayerbyname(self.dlg.mcb_water.currentText())
        DEM = self.getlayerbyname(self.dlg.mcb_DEM.currentText())
        layers = [study, water, DEM]
        return layers  
    def defineentry(self, layer):
        a = QgsRasterCalculatorEntry()
        a.ref = str(layer.name()) + '@1'
        a.raster = layer
        a.bandNumber = 1
        return a
    def defineentries(self, layers):
        entries = []
        for layer in layers:
            entry = self.defineentry(layer)
            entries.append(entry)
        return entries
    def getlayerbyname(self, layerName):
        layerMap = QgsProject.instance().mapLayers()
        for name, layer in layerMap.items():
            if layer.name() == layerName:
                if layer.isValid():
                    return layer
                else:
                    return None
    def run(self):
        """Run method that performs all the real work"""
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
        self.dlg = MINDED_FBADialog()
        self.dlg.pb_folder0.clicked.connect(self.select_input0_folder)
        self.dlg.pb_folder1.clicked.connect(self.select_input1_folder)
        self.dlg.pbSAR_folder0.clicked.connect(self.select_SARinput0_folder)
        self.dlg.pbSAR_folder1.clicked.connect(self.select_SARinput1_folder)
        self.dlg.pb_out.clicked.connect(self.select_output_folder)
        self.dlg.button_box.clicked.connect(self.executeMINDED_FBA)
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # Load active layers
        self.loadlayersbox()
 # See if OK was pressed
        if result:
            QMessageBox.information(self.dlg, 'Processing completed', 'The model processing is complete. The outputs of the model have been imported to your active project and can be found in the output folder.')
            self.dlg.lin_out.text()
        else:
            QMessageBox.warning(None, 'Canceled', 'Canceled by user.')
            exit           