# -*- coding: utf-8 -*- This line is just for your information, the python plugin will not use the first line

CREATE VIEW view_obs_points AS SELECT rowid, obsid, name, place, type, length, drillstop, diam, material, screen, capacity, drilldate, wmeas_yn, wlogg_yn, east, north, ne_accur, ne_source, h_toc, h_tocags, h_gs, h_accur, h_syst, h_source, source, com_onerow, com_html, geometry FROM obs_points;
INSERT INTO views_geometry_columns (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only) VALUES ('view_obs_points', 'geometry', 'rowid', 'obs_points', 'geometry',1);
CREATE TRIGGER IF NOT EXISTS vw_ins_obs_points INSTEAD OF INSERT ON view_obs_points FOR EACH ROW BEGIN INSERT INTO obs_points (obsid, name, place, type, length, drillstop, diam, material, screen, capacity, drilldate, wmeas_yn, wlogg_yn, east, north, ne_accur, ne_source, h_toc, h_tocags, h_gs, h_accur, h_syst, h_source, source, com_onerow, com_html, geometry)   VALUES (NEW.obsid, NEW.name, NEW.place, NEW.type, NEW.length, NEW.drillstop, NEW.diam, NEW.material, NEW.screen, NEW.capacity, NEW.drilldate, NEW.wmeas_yn, NEW.wlogg_yn, NEW.east, NEW.north, NEW.ne_accur, NEW.ne_source, NEW.h_toc, NEW.h_tocags, NEW.h_gs, NEW.h_accur, NEW.h_syst, NEW.h_source, NEW.source, NEW.com_onerow, NEW.com_html, NEW.geometry); END;
CREATE TRIGGER IF NOT EXISTS vw_upd_obs_points INSTEAD OF UPDATE ON view_obs_points FOR EACH ROW BEGIN UPDATE obs_points SET obsid = NEW.obsid, name = NEW.name, place = NEW.place, type = NEW.type, length = NEW.length, drillstop = NEW.drillstop, diam = NEW.diam, material = NEW.material, screen = NEW.screen, capacity = NEW.capacity, drilldate = NEW.drilldate, wmeas_yn = NEW.wmeas_yn, wlogg_yn = NEW.wlogg_yn, east = NEW.east, north = NEW.north, ne_accur = NEW.ne_accur, ne_source = NEW.ne_source, h_toc = NEW.h_toc, h_tocags = NEW.h_tocags, h_gs = NEW.h_gs, h_accur = NEW.h_accur, h_syst = NEW.h_syst, h_source = NEW.h_source, source = NEW.source, com_onerow = NEW.com_onerow, com_html = NEW.com_html, geometry = NEW.geometry WHERE rowid = OLD.rowid; END;
CREATE TRIGGER IF NOT EXISTS vw_del_obs_points INSTEAD OF DELETE ON view_obs_points BEGIN DELETE FROM obs_points WHERE rowid = OLD.rowid; END;

CREATE VIEW view_obs_lines AS SELECT rowid, obsid, name, place, type, source, geometry FROM obs_lines;
INSERT INTO views_geometry_columns (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only) VALUES ('view_obs_lines', 'geometry', 'rowid', 'obs_lines', 'geometry',1);
CREATE TRIGGER IF NOT EXISTS vw_ins_obs_lines INSTEAD OF INSERT ON view_obs_lines FOR EACH ROW BEGIN INSERT INTO obs_lines (obsid, name, place, type, source, geometry)   VALUES (NEW.obsid, NEW.name, NEW.place, NEW.type, NEW.source, NEW.geometry); END;
CREATE TRIGGER IF NOT EXISTS vw_upd_obs_lines INSTEAD OF UPDATE ON view_obs_lines FOR EACH ROW BEGIN UPDATE obs_lines SET obsid = NEW.obsid, name = NEW.name, place = NEW.place, type = NEW.type, source = NEW.source, geometry = NEW.geometry WHERE rowid = OLD.rowid; END;
CREATE TRIGGER IF NOT EXISTS vw_del_obs_lines INSTEAD OF DELETE ON view_obs_lines BEGIN DELETE FROM obs_lines WHERE rowid = OLD.rowid; END;