# -*- coding: utf-8 -*- This line is just for your information, the python plugin will not use the first line
CREATE FUNCTION after_insert_obs_points_geom_fr_coords() RETURNS trigger AS $BODY$ BEGIN UPDATE obs_points SET geometry = ST_SetSRID(ST_MakePoint(NEW.east, NEW.north),(SELECT srid FROM geometry_columns WHERE f_table_name = 'obs_points')) WHERE (NEW.east IS NOT NULL) AND (NEW.north IS NOT NULL) AND (NEW.geometry IS NULL) AND (NEW.obsid = obsid); RETURN NEW; END; $BODY$ LANGUAGE plpgsql VOLATILE COST 100;
CREATE TRIGGER trigger_after_insert_obs_points_geom_fr_coords AFTER INSERT ON obs_points FOR EACH ROW EXECUTE PROCEDURE after_insert_obs_points_geom_fr_coords();
CREATE FUNCTION after_insert_obs_points_coords_fr_geom() RETURNS trigger AS $BODY$ BEGIN UPDATE obs_points SET  east = ST_X(NEW.geometry), north = ST_Y(NEW.geometry) WHERE (NEW.east is null) AND (NEW.north is null) AND (NEW.geometry is not NULL) AND (NEW.obsid = obsid); RETURN NEW; END; $BODY$ LANGUAGE plpgsql VOLATILE COST 100;
CREATE TRIGGER trigger_after_insert_obs_points_coords_fr_geom AFTER INSERT ON obs_points FOR EACH ROW EXECUTE PROCEDURE after_insert_obs_points_coords_fr_geom();
CREATE FUNCTION after_update_obs_points_geom_fr_coords() RETURNS trigger AS $BODY$ BEGIN UPDATE obs_points SET geometry = ST_SetSRID(ST_MakePoint(NEW.east, NEW.north),(SELECT srid FROM geometry_columns WHERE f_table_name = 'obs_points')) WHERE ((NEW.east != OLD.east) OR (NEW.north != OLD.north) OR (NEW.north IS NOT NULL AND OLD.north IS NULL) OR (NEW.east IS NOT NULL AND OLD.east IS NULL)) AND (NEW.obsid = obsid) AND (NEW.east IS NOT NULL) AND (NEW.north IS NOT NULL); RETURN NEW; END; $BODY$ LANGUAGE plpgsql VOLATILE COST 100;
CREATE TRIGGER trigger_after_update_obs_points_geom_fr_coords AFTER UPDATE ON obs_points FOR EACH ROW EXECUTE PROCEDURE after_update_obs_points_geom_fr_coords();
CREATE FUNCTION after_update_obs_points_coords_fr_geom() RETURNS trigger AS $BODY$ BEGIN UPDATE obs_points SET east = ST_X(geometry), north = ST_Y(geometry) WHERE (NOT ST_Equals(NEW.geometry, OLD.geometry)) AND (NEW.obsid = obsid); RETURN NEW; END; $BODY$ LANGUAGE plpgsql VOLATILE COST 100;
CREATE TRIGGER trigger_after_update_obs_points_coords_fr_geom AFTER UPDATE ON obs_points FOR EACH ROW EXECUTE PROCEDURE after_update_obs_points_coords_fr_geom();