# -*- coding: utf-8 -*-
"""
/***************************************************************************
 This part of the Midvatten plugin originates from the TimeSeriesPlot plugin. 
							 -------------------
		begin				: 2011-10-18
		copyright			: (C) 2011 by joskal
		email				: groundwatergis [at] gmail.com
 ***************************************************************************/

/***************************************************************************
 *																		 *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or	 *
 *   (at your option) any later version.								   *
 *																		 *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
import qgis.utils
# import some more
import resources  # Initialize Qt resources from file resources.py
import os	# Just to be able to read from metadata.txt in the same directory	
from midvsettings import midvsettings  # Import the code for the settings dialog
from tsplot import TimeSeriesPlot
from stratigraphy import Stratigraphy
from xyplot import XYPlot

class midvatten:
	def __init__(self, iface):	# READY  - Might need revision of variables and method for loading default variables
		self.iface = iface
		# settings...
		self.readingSettings = False # To enable resetsettings
		self.settingsdict = self.createsettingsdict()# calling for de method that defines an empty dictionary of settings
		#self.loadSettings()	# stored settings are loaded  NOTE: From ver 0.3.2 it is no longer possible to load settings here
		#The settings are stored in the qgis project file and thus cannot be loaded when qgis is starting (and plugni initialized) 
		#The settings must be loaded after the qgis project is loaded - thus settings is loaded when needed (and this is checked in several methods below)
		self.settingsareloaded = False # To make sure settings are loaded once and only once
		
	def initGui(self):   # READY - Creates actions that will start plugin configuration
		self.actionsetup = QAction(QIcon(":/plugins/midvatten/icons/MidvSettings.png"), "Midvatten Settings", self.iface.mainWindow())
		self.actionsetup.setWhatsThis("Configuration for Midvatten toolset")
		self.iface.registerMainWindowAction(self.actionsetup, "F7")   # The function should also be triggered by the F7 key
		QObject.connect(self.actionsetup, SIGNAL("activated()"), self.setup)
		
		self.actionPlotTS = QAction(QIcon(":/plugins/midvatten/icons/PlotTS.png"), "Time series plot", self.iface.mainWindow())
		self.actionPlotTS.setWhatsThis("Plot time series for selected objects")
		self.iface.registerMainWindowAction(self.actionPlotTS, "F8")   # The function should also be triggered by the F8 key
		QObject.connect(self.actionPlotTS, SIGNAL("triggered()"), self.PlotTS)
		
		self.actionPlotXY = QAction(QIcon(":/plugins/midvatten/icons/PlotXY.png"), "Scatter plot", self.iface.mainWindow())
		self.actionPlotXY.setWhatsThis("Plot XY scatter data (e.g. seismic profiel) for the selected objects")
		self.iface.registerMainWindowAction(self.actionPlotXY, "F9")   # The function should also be triggered by the F9 key
		QObject.connect(self.actionPlotXY, SIGNAL("triggered()"), self.PlotXY)
		
		self.actionPlotStratigraphy = QAction(QIcon(":/plugins/midvatten/icons/PlotStratigraphy.png"), "Plot stratigraphy", self.iface.mainWindow())
		self.actionPlotStratigraphy.setWhatsThis("Show stratigraphy for selected objects (modified ARPAT)")
		self.iface.registerMainWindowAction(self.actionPlotStratigraphy, "F10")   # The function should also be triggered by the F10 key
		QObject.connect(self.actionPlotStratigraphy, SIGNAL("triggered()"), self.PlotStratigraphy)
		
		#self.actionChartMaker = QAction(QIcon(":/plugins/midvatten/icons/ChartMakerSQLite.png"), "ChartMaker for SQLite", self.iface.mainWindow())
		#self.actionChartMaker.setWhatsThis("Start ChartMaker for SQLite data")
		#self.iface.registerMainWindowAction(self.actionChartMaker, "F11")   # The function should also be triggered by the F11 key
		#QObject.connect(self.actionChartMaker, SIGNAL("triggered()"), self.ChartMaker)
		
		self.actionresetSettings = QAction(QIcon(":/plugins/midvatten/icons/ResetSettings.png"), "Reset Settings", self.iface.mainWindow())
		QObject.connect(self.actionresetSettings, SIGNAL("triggered()"), self.resetSettings)
		
		self.actionabout = QAction(QIcon(":/plugins/midvatten/icons/about.png"), "About", self.iface.mainWindow())
		QObject.connect(self.actionabout, SIGNAL("triggered()"), self.about)
		
		# Add toolbar with buttons 
		self.toolBar = self.iface.addToolBar("Midvatten")
		self.toolBar.addAction(self.actionsetup)
		self.toolBar.addAction(self.actionPlotTS)
		self.toolBar.addAction(self.actionPlotXY)
		self.toolBar.addAction(self.actionPlotStratigraphy)
		#self.toolBar.addAction(self.actionChartMaker)
		
		# Add plugins menu items
		self.iface.addPluginToMenu("&Midvatten", self.actionsetup)   
		self.iface.addPluginToMenu("&Midvatten", self.actionPlotTS) 
		self.iface.addPluginToMenu("&Midvatten", self.actionPlotXY)
		self.iface.addPluginToMenu("&Midvatten", self.actionPlotStratigraphy)
		#self.iface.addPluginToMenu("&Midvatten", self.actionChartMaker)
		self.iface.addPluginToMenu("&Midvatten", self.actionresetSettings)
		self.iface.addPluginToMenu("&Midvatten", self.actionabout)

	def unload(self):	# READY
		# Remove the plugin menu item and icon
		self.iface.removePluginMenu("&Midvatten", self.actionsetup)   
		self.iface.removePluginMenu("&Midvatten", self.actionPlotTS) 
		self.iface.removePluginMenu("&Midvatten", self.actionPlotXY)
		self.iface.removePluginMenu("&Midvatten", self.actionPlotStratigraphy)
		#self.iface.removePluginMenu("&Midvatten", self.actionChartMaker)
		self.iface.removePluginMenu("&Midvatten", self.actionresetSettings)
		self.iface.removePluginMenu("&Midvatten", self.actionabout)
		
		# remove tool bar
		del self.toolBar
		
		# Also remove F7 - F11 key triggers
		self.iface.unregisterMainWindowAction(self.actionsetup)
		self.iface.unregisterMainWindowAction(self.actionPlotTS)
		self.iface.unregisterMainWindowAction(self.actionPlotXY)
		self.iface.unregisterMainWindowAction(self.actionPlotStratigraphy)
		#self.iface.unregisterMainWindowAction(self.actionChartMaker)

	def loadSettings(self):   # READY settingsdict is a dictionary belonging to instance midvatten. Must be stored and loaded here.
#		s = QSettings()
#		for key, val in self.settingsdict.items():
#			self.settingsdict[key] = s.value("/Plugins/midvatten/" + str(key)).toString()
		"""read plugin settings from QgsProject instance"""
		self.readingSettings = True  
		# map data types to function names
		prj = QgsProject.instance()
		functions = { 'str' : prj.readEntry,
					 'QString' : prj.readEntry,
					 'int' : prj.readNumEntry,
					 'float' : prj.readDoubleEntry,
					 'bool' : prj.readBoolEntry,
					 'datetime' : prj.readDoubleEntry, # we converted datetimes to float in writeSetting()
					 'QStringList' : prj.readListEntry,
					 'pyqtWrapperType' : prj.readListEntry # strange name for QStringList
					 }
		output = {}
		for (key, value) in self.settingsdict.items():
			dataType = type(value).__name__
			try:
				func = functions[dataType]
				output[key] = func("Midvatten", key)
			except KeyError:
				QMessageBox.information(self.iface.mainWindow(),'Information','Settings key does not exist: '+key)		
		for (key, value) in output.items():
			self.settingsdict[key] = output[key][0]
			#QMessageBox.information(None,'Debug Output','in self.settingsdict is loaded Key: '+key+'\n and value : '+str(output[key]))		
		self.readingSettings = False
		self.settingsareloaded = True


	def saveSettings(self):   # READY settingsdict is a dictionary belonging to instance midvatten. Must be stored and loaded here.
#		s = QSettings()
#		for key, val in self.settingsdict.items():
#			s.setValue("/Plugins/midvatten/" + str(key), QVariant(val))
		if not self.readingSettings:
			for (key, value) in self.settingsdict.items():		# For storing in project file, as Time Manager plugin
				try: # write plugin settings to QgsProject # For storing in project file, as Time Manager plugin
					QgsProject.instance().writeEntry("Midvatten",key, value ) # For storing in project file, as Time Manager plugin
				except TypeError: # For storing in project file, as Time Manager plugin
					QMessageBox.information(self.iface.mainWindow(),'Debug Output','Wrong type for '+key+'!\nType: '+str(type(value))) # For storing in project file, as Time Manager plugin
		
	def setup(self):	# READY
		"""Choose spatialite database and relevant table"""
		if self.settingsareloaded == False:	# If the first thing the user does is to check settings, then load settings from project file
			self.loadSettings()	
		dlg = midvsettings(self.iface.mainWindow(), self.settingsdict)  # dlg is an instance of midvsettings (Probably not needed to send QDialog and Ui_Dialog as arguments)
		if dlg.exec_() == QDialog.Accepted:      # When the settins dialog is closed, all settings are stored in the dictionary
			self.settingsdict['database'] = dlg.txtpath.text()	
			self.settingsdict['tstable'] = dlg.ListOfTables.currentText()
			self.settingsdict['tscolumn'] = dlg.ListOfColumns.currentText()
			self.settingsdict['tsdotmarkers'] = dlg.checkBoxDataPoints.checkState()
			self.settingsdict['tsstepplot'] = dlg.checkBoxStepPlot.checkState()
			self.settingsdict['xytable']  = dlg.ListOfTables_2.currentText()
			self.settingsdict['xy_xcolumn'] = dlg.ListOfColumns_2.currentText()
			self.settingsdict['xy_y1column'] = dlg.ListOfColumns_3.currentText()
			self.settingsdict['xy_y2column'] = dlg.ListOfColumns_4.currentText()
			self.settingsdict['xy_y3column'] = dlg.ListOfColumns_5.currentText()
			self.settingsdict['xydotmarkers'] =  dlg.checkBoxDataPoints_2.checkState()
			self.settingsdict['stratigraphytable'] = dlg.ListOfTables_3.currentText()
			self.settingsdict['tabwidget'] = dlg.tabWidget.currentIndex()
			self.saveSettings()			# Since the SelectTSDialog has saved all settings they should be reached by loading them here...
			msg = ''
			for k, value in self.settingsdict.items():
				msg = str(k).encode('latin-1') + " : " + str(value).encode('latin-1') + ", \n" + msg 
			#QMessageBox.information(None, "info", "settingsdict is \n" + msg)	# DEBUGGING

	def PlotTS(self):			# PlotTS - READY - perhaps just let this method import anoter 'PlotTS-file' with necessary classes and methods?
		if self.settingsareloaded == False:	# If the first thing the user does is to plot time series, then load settings from project file
			self.loadSettings()	
		layer = qgis.utils.iface.activeLayer()
		dlg = TimeSeriesPlot(self.iface, layer, self.settingsdict)

	def PlotXY(self):			#  - Not ready - perhaps just let this method import anoter 'PlotXY-file' with necessary classes and methods?
		if self.settingsareloaded == False:	# If the first thing the user does is to plot xy data, then load settings from project file
			self.loadSettings()	
		layer = qgis.utils.iface.activeLayer()
		dlg = XYPlot(self.iface, layer, self.settingsdict)

	def PlotStratigraphy(self):			#  - READY - perhaps just let this method import anoter 'PlotStratigraphy-file' with necessary classes and methods?
		if self.settingsareloaded == False:	# If the first thing the user does is to plot stratigraphy, then load settings from project file
			self.loadSettings()	
		layer = qgis.utils.iface.activeLayer()
		dlg = Stratigraphy(self.iface, layer, self.settingsdict)
		dlg.showSurvey()
		self.dlg = dlg		# only to prevent the Qdialog from closing.

	def ChartMaker(self):			#  - Not ready - perhaps just let this method import anoter 'ChartMaker-file' with necessary classes and methods?
		if self.settingsareloaded == False:	# If the first thing the user does is to plot time series, then load settings from project file
			self.loadSettings()	
		QMessageBox.information(None, "information", "not yet implemented") #for debugging

	def resetSettings(self):	
		self.settingsdict = self.createsettingsdict()	# calling for the method that defines an empty dictionary of settings
		self.saveSettings()		# the empty settings dictionary is stored

	def createsettingsdict(self):	# Here is where an empty settings dictionary is defined
		dictionary = { 'database' : '',
				'tstable' : '',
				'tscolumn' : '',
				'tsdotmarkers' : 0,
				'tsstepplot' : 0,
				'xytable' : '',
				'xy_xcolumn' : '',
				'xy_y1column' : '',
				'xy_y2column' : '',
				'xy_y3column' : '',
				'xydotmarkers' : 0,
				'stratigraphytable' : '',
				'tabwidget' : 0}
		return dictionary

	def about(self):   # Not ready
		filenamepath = os.path.dirname(__file__) + "/metadata.txt"
		iniText = QSettings(filenamepath , QSettings.IniFormat)
		verno = iniText.value('version').toString()
		author = iniText.value('author').toString()
		email = iniText.value('email').toString()
		homepage = iniText.value('homepage').toString()
		infoString = QString("This is the Midvatten toolset for QGIS. ")
		infoString = infoString.append("\n" + homepage)
		infoString = infoString.append("\n\n" + verno)
		infoString = infoString.append("\nAuthor: " + author)
		infoString = infoString.append("\nEmail: " + email)
		QMessageBox.information(self.iface.mainWindow(), "About the Midvatten toolset", infoString)