# -*- coding: utf-8 -*-

"""
/***************************************************************************
 MGWR
                                 A QGIS plugin
 A QGIS plugin for Multiscale Geographically Weighted Regression (MGWR)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-05-05
        copyright            : (C) 2024 by Huaying Gu & Yi Wu
        email                : aaron.yiwu15@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Huaying Gu & Yi Wu'
__date__ = '2024-05-05'
__copyright__ = '(C) 2024 by Huaying Gu & Yi Wu'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
import processing
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .MGWR_Plugin_provider import MGWRProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class MGWRPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = MGWRProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = os.path.join(os.path.join(cmd_folder, 'mgwr.png'))
        self.action = QAction(QIcon(icon), u"Multiscale Geoghraphical Weighted Regression", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addPluginToMenu(u"&MGWR", self.action)
        self.iface.addToolBarIcon(self.action)

    def icon(self):
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'mgwr.png')))
        return icon

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.iface.removePluginMenu(u"&MGWR", self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        processing.execAlgorithmDialog("Multiscale Geoghraphical Weighted Regression")