# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MGB_InputTool
                                 A QGIS plugin
 This plugin prepares the data for the MGB-IPH model
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-12-24
        git sha              : $Format:%H$
        copyright            : (C) 2024 by André Rodrigues da Silva
        email                : andrerodriguessilva99@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.PyQt.QtWidgets import QApplication, QWidget, QMessageBox
from qgis.core import *

import os.path
import processing
import sys, os
import pandas as pd

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .MGBInputTool_dialog import MGB_InputToolDialog
import os.path


class MGB_InputTool:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MGB_InputTool_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&MGBInputTool')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        
        

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MGB_InputTool', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        #icon = QIcon(icon_path)
        action = QAction(QIcon(self.plugin_dir + '/icon.png'), 'MGBInputTool', self.iface.mainWindow())
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        icon_path = ':/plugins/mgbinputtool/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'MGBInputTool'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&MGBInputTool'),
                action)
            self.iface.removeToolBarIcon(action)
            
    def show_error_message(self, message):
        # Create an error message box with no parent
        msg = QMessageBox()  # No parent passed, this avoids the TypeError
        msg.setIcon(QMessageBox.Critical)
        msg.setText(message)
        msg.setWindowTitle("Error")
        msg.exec_()
        
    def show_success_message(self, message):
        """Displays the success message after processing."""
        msg = QMessageBox()
        msg.setIcon(QMessageBox.Information)
        msg.setWindowTitle("Success")
        msg.setText(message)
        msg.exec_()
            
    def OpenCSV_precipitation(self): 
        """Opens the dialog window to choose a directory and load .csv files into it"""
        # Open the directory selector, passing the 'dlg' widget as the first argument
        input_folder = QFileDialog.getExistingDirectory(self.dlg, caption="Select the directory of .csv files")
    
        # Check if the user selected a directory and update the field in the dialog
        if input_folder:
            self.dlg.lineEdit.setText(input_folder)
            
    def OutputTXT_precipitation(self): 
        """Open the dialog window to choose a directory to save .txt files in it"""
        # Open the directory selector, passing the 'dlg' widget as the first argument
        output_folder = QFileDialog.getExistingDirectory(self.dlg, caption="Select the directory of .txt files")
    
        # Verify if the user selected a directory and update the field in the dialog
        if output_folder:
            self.dlg.lineEdit_2.setText(output_folder)
            
            
    def OpenCSV_flow(self): 
        """Opens the dialog window to choose a directory and load .csv files into it"""
        # Open the directory selector, passing the 'dlg' widget as the first argument
        input_folder = QFileDialog.getExistingDirectory(self.dlg, caption="Select the directory of .csv files")
    
        # Check if the user selected a directory and update the field in the dialog
        if input_folder:
            self.dlg.lineEdit_4.setText(input_folder)
            
    def OutputTXT_flow(self): 
        """Open the dialog window to choose a directory to save .txt files in it"""
        # Open the directory selector, passing the 'dlg' widget as the first argument
        output_folder = QFileDialog.getExistingDirectory(self.dlg, caption="Select the directory of .txt files")
    
        # Verify if the user selected a directory and update the field in the dialog
        if output_folder:
            self.dlg.lineEdit_5.setText(output_folder)
    
    def OpenCSV_climate(self): 
        """Opens the dialog window to choose a directory and load .csv files into it"""
        # Open the directory selector, passing the 'dlg' widget as the first argument
        input_folder = QFileDialog.getExistingDirectory(self.dlg, caption="Select the directory of .csv files")
    
        # Check if the user selected a directory and update the field in the dialog
        if input_folder:
            self.dlg.lineEdit_7.setText(input_folder)
            
    def OutputTXT_climate(self): 
        """Open the dialog window to choose a directory to save .txt files in it"""
        # Open the directory selector, passing the 'dlg' widget as the first argument
        output_folder = QFileDialog.getExistingDirectory(self.dlg, caption="Select the directory of .txt files")
    
        # Verify if the user selected a directory and update the field in the dialog
        if output_folder:
            self.dlg.lineEdit_8.setText(output_folder)
    
        
    def move_and_replace_files(self, output_folder, sub_folder_name):
        """Moves files from the subfolder to 'output_folder' and replaces any existing files."""
        folder = os.path.join(output_folder, sub_folder_name)

        # Check if the subfolder exists
        if not os.path.isdir(folder):
            raise FileNotFoundError(f"The folder '{folder}' does not exist.")

        # List all files in the subfolder
        files = [f for f in os.listdir(folder) if os.path.isfile(os.path.join(folder, f))]

        # Move each file to 'output_folder', replacing if necessary
        for file in files:
            source_path = os.path.join(folder, file)
            destination_path = os.path.join(output_folder, file)  # Correct destination path

            # Replace the file if it already exists
            if os.path.exists(destination_path):
                os.remove(destination_path)  # Remove the destination file

            os.rename(source_path, destination_path)  # Move the file

        # Check if the subfolder is empty and delete it
        if not os.listdir(folder):  # Check if the folder is empty
            os.rmdir(folder)  # Delete the folder
        else:
            raise OSError(f"The folder '{folder}' is not empty and cannot be deleted.")

        

        
    def remove_leading_zeros(self, value):
        """Remove leading zeros from a string representation of a number."""
        return str(int(value)) if value.isdigit() else value
        
#############################################################################################       
# PRECIPITATION 

    def format_file_precipitation(self, input_file, output_file):
        with open(input_file, 'r', encoding='utf-8') as infile, open(output_file, 'w', encoding='ascii') as outfile:
            for line in infile:
                # Split the line into columns using the delimiter ","
                columns = line.strip().split(',')

                if len(columns) < 4:
                    continue  # Ignore lines with less than 4 columns

                # Remove leading zeros from columns 1 and 2
                columns[0] = self.remove_leading_zeros(columns[0])
                columns[1] = self.remove_leading_zeros(columns[1])

                # Formatting the first column
                if len(columns[0]) == 1:  # 1 digit
                    col1 = ' ' * 5 + columns[0]
                elif len(columns[0]) == 2:  # 2 digits
                    col1 = ' ' * 4 + columns[0]
                else:
                    col1 = columns[0]  # Do not format if there are more than 2 digits

                # Formatting the second column
                if len(columns[1]) == 1:  # 1 digit
                    col2 = ' ' * 5 + columns[1]
                elif len(columns[1]) == 2:  # 2 digits
                    col2 = ' ' * 4 + columns[1]
                else:
                    col2 = columns[1]  # Do not format if there are more than 2 digits

                # Formatting the third column with 2 spaces before
                col3 = ' ' * 2 + columns[2]

                # Formatting the fourth column
                try:
                    double_value = float(columns[3])  # Converts the column to float
                    # Formatting based on the original value
                    if double_value < 10:
                        col4 = ' ' * 8 + f"{double_value:.2f}"  # Formats to 2 decimal places
                    if double_value < 100 and double_value >= 10:
                        col4 = ' ' * 7 + f"{double_value:.2f}"  # Formats to 2 decimal places
                    elif double_value >= 100:
                        col4 = ' ' * 6 + f"{double_value:.2f}"  # Formats to 2 decimal places
                except ValueError:
                    col4 = columns[3]  # If it's not a number, leave it as is

                # Joining the formatted columns without the periods and commas
                formatted_line = f"{col1}{col2}{col3}{col4}\n"
                outfile.write(formatted_line)

    def process_all_files_precipitation(self, input_folder, output_folder):
            # Create the output folder if it doesn't exist
            os.makedirs(output_folder, exist_ok=True)

            # Iterate through all the files in the input directory
            for filename in os.listdir(input_folder):
                input_file_path = os.path.join(input_folder, filename)
                
                # Check if it's a file and if it has the .txt extension
                if os.path.isfile(input_file_path) and filename.endswith('.txt'):
                    output_file_path = os.path.join(output_folder, filename)
                    self.format_file_precipitation(input_file_path, output_file_path)
            
            
    
    def process_files_precipitation(self):
        """Method that performs the processing when OK is pressed"""
        input_folder = self.dlg.lineEdit.text()  # Gets the input path (as defined in your .ui)
        output_folder = self.dlg.lineEdit_2.text()  # Gets the output path (as defined in your .ui)
        
        # Check if the input folder is valid
        if not os.path.isdir(input_folder):
            self.show_error_message(f"Error: The input directory '{input_folder}' is not valid or does not exist.")
            return  # Stop further execution if input folder is invalid
        
        # Check if the output folder is valid
        if not os.path.isdir(output_folder):
            self.show_error_message(f"Error: The output directory '{output_folder}' is not valid or does not exist.")
            return  # Stop further execution if output folder is invalid
        
        # Iterates through the files in the input folder
        for file in os.listdir(input_folder):
            if file.endswith('.csv'):
                # Full path of the CSV file
                file_path = os.path.join(input_folder, file)

                # Read the CSV file
                df = pd.read_csv(file_path, sep=',')

                # Convert the first column to datetime
                df[df.columns[0]] = pd.to_datetime(df[df.columns[0]])

                # Create the DataFrame df1 with the day, month, and year columns
                df1 = pd.DataFrame()
                
                # Start date
                start_date = pd.Timestamp(self.dlg.lineEdit_3.text())
                
                if isinstance(start_date, str) and start_date.strip():  # Check if start_date is a string and not empty or only whitespace
                    try:
                        # Ensure start_date is a valid datetime
                        start_date = pd.to_datetime(start_date)
                        
                        # Change the 'date' column based on the start date
                        df[df.columns[0]] = [start_date + pd.Timedelta(days=i) for i in range(len(df))]
                    except ValueError:
                        self.show_error_message("Invalid start date format.")
                    except Exception as e:
                        self.show_error_message(f"An error occurred: {str(e)}")
                elif pd.notna(start_date):  # If start_date is a valid Timestamp (datetime)
                    try:
                        # Use start_date directly as it is already a valid datetime
                        df[df.columns[0]] = [start_date + pd.Timedelta(days=i) for i in range(len(df))]
                    except Exception as e:
                        self.show_error_message(f"An error occurred: {str(e)}")
                else:
                    pass  # If start_date is NaT or invalid, do nothing



                            
                df1['day'] = df[df.columns[0]].dt.day
                df1['month'] = df[df.columns[0]].dt.month
                df1['year'] = df[df.columns[0]].dt.year
                df1[df.columns[1]] = df[df.columns[1]]

                # Define the full path to save the .txt file
                output_file = os.path.join(output_folder, file.replace('.csv', '.txt'))
                # Save the DataFrame df1 as .txt
                df1.to_csv(output_file, sep=',', index=False, header=False)
                
        self.process_all_files_precipitation(output_folder, output_folder+'/Precipitation')
        # Move files from the 'Precipitation' folder to 'output_folder' and delete the folder if necessary
        self.move_and_replace_files(output_folder, 'Precipitation')
        
        self.show_success_message("Processing completed successfully")
        
 #############################################################################################       
 # FLOW      
        
    def format_file_flow(self, input_file, output_file):
        with open(input_file, 'r', encoding='utf-8') as infile, open(output_file, 'w', encoding='ascii') as outfile:
            for line in infile:
                # Split the line into columns using the delimiter ","
                columns = line.strip().split(',')

                if len(columns) < 4:
                    continue  # Ignore lines with less than 4 columns

                # Remove leading zeros from columns 1 and 2
                columns[0] = self.remove_leading_zeros(columns[0])
                columns[1] = self.remove_leading_zeros(columns[1])

                # Formatting the first column
                if len(columns[0]) == 1:  # 1 digit
                    col1 = ' ' * 5 + columns[0]
                elif len(columns[0]) == 2:  # 2 digits
                    col1 = ' ' * 4 + columns[0]
                else:
                    col1 = columns[0]  # Do not format if there are more than 2 digits

                # Formatting the second column
                if len(columns[1]) == 1:  # 1 digit
                    col2 = ' ' * 5 + columns[1]
                elif len(columns[1]) == 2:  # 2 digits
                    col2 = ' ' * 4 + columns[1]
                else:
                    col2 = columns[1]  # Do not format if there are more than 2 digits

                # Formatting the third column with 2 spaces before
                col3 = ' ' * 2 + columns[2]

                # Formatting the fourth column
                try:
                    double_value = float(columns[3])  # Converts the column to float
                    # Formatting based on the original value
                    if double_value < 10:
                        col4 = ' ' * 8 + f"{double_value:.6f}"  # Formats to 2 decimal places
                    if double_value < 100 and double_value >= 10:
                        col4 = ' ' * 7 + f"{double_value:.6f}"  # Formats to 2 decimal places
                    elif double_value >= 100:
                        col4 = ' ' * 6 + f"{double_value:.6f}"  # Formats to 2 decimal places
                except ValueError:
                    col4 = columns[3]  # If it's not a number, leave it as is

                # Joining the formatted columns without the periods and commas
                formatted_line = f"{col1}{col2}{col3}{col4}\n"
                outfile.write(formatted_line)

    def process_all_files_flow(self, input_folder, output_folder):
            # Create the output folder if it doesn't exist
            os.makedirs(output_folder, exist_ok=True)

            # Iterate through all the files in the input directory
            for filename in os.listdir(input_folder):
                input_file_path = os.path.join(input_folder, filename)
                
                # Check if it's a file and if it has the .txt extension
                if os.path.isfile(input_file_path) and filename.endswith('.txt'):
                    output_file_path = os.path.join(output_folder, filename)
                    self.format_file_flow(input_file_path, output_file_path)
            
            
    
    def process_files_flow(self):
        """Method that performs the processing when OK is pressed"""
        input_folder = self.dlg.lineEdit_4.text()  # Gets the input path (as defined in your .ui)
        output_folder = self.dlg.lineEdit_5.text()  # Gets the output path (as defined in your .ui)
        
        # Check if the input folder is valid
        if not os.path.isdir(input_folder):
            self.show_error_message(f"Error: The input directory '{input_folder}' is not valid or does not exist.")
            return  # Stop further execution if input folder is invalid
        
        # Check if the output folder is valid
        if not os.path.isdir(output_folder):
            self.show_error_message(f"Error: The output directory '{output_folder}' is not valid or does not exist.")
            return  # Stop further execution if output folder is invalid
        
        # Iterates through the files in the input folder
        for file in os.listdir(input_folder):
            if file.endswith('.csv'):
                # Full path of the CSV file
                file_path = os.path.join(input_folder, file)

                # Read the CSV file
                df = pd.read_csv(file_path, sep=',')

                # Convert the first column to datetime
                df[df.columns[0]] = pd.to_datetime(df[df.columns[0]])

                # Create the DataFrame df1 with the day, month, and year columns
                df1 = pd.DataFrame()
                
                # Start date
                start_date = pd.Timestamp(self.dlg.lineEdit_6.text())
                
                if isinstance(start_date, str) and start_date.strip():  # Check if start_date is a string and not empty or only whitespace
                    try:
                        # Ensure start_date is a valid datetime
                        start_date = pd.to_datetime(start_date)
                        
                        # Change the 'date' column based on the start date
                        df[df.columns[0]] = [start_date + pd.Timedelta(days=i) for i in range(len(df))]
                    except ValueError:
                        self.show_error_message("Invalid start date format.")
                    except Exception as e:
                        self.show_error_message(f"An error occurred: {str(e)}")
                elif pd.notna(start_date):  # If start_date is a valid Timestamp (datetime)
                    try:
                        # Use start_date directly as it is already a valid datetime
                        df[df.columns[0]] = [start_date + pd.Timedelta(days=i) for i in range(len(df))]
                    except Exception as e:
                        self.show_error_message(f"An error occurred: {str(e)}")
                else:
                    pass  # If start_date is NaT or invalid, do nothing



                            
                df1['day'] = df[df.columns[0]].dt.day
                df1['month'] = df[df.columns[0]].dt.month
                df1['year'] = df[df.columns[0]].dt.year
                df1[df.columns[1]] = df[df.columns[1]]

                # Define the full path to save the .txt file
                output_file = os.path.join(output_folder, file.replace('.csv', '.txt'))
                # Save the DataFrame df1 as .txt
                df1.to_csv(output_file, sep=',', index=False, header=False)
                
        self.process_all_files_flow(output_folder, output_folder+'/Flow')
        # Move files from the 'Flow' folder to 'output_folder' and delete the folder if necessary
        self.move_and_replace_files(output_folder, 'Flow')
        
        self.show_success_message("Processing completed successfully")
        
#############################################################################################       
# CLIMATE      
        
    def format_column_climate(self, value, spaces, decimal_places):
        """Format a numerical value with specified spaces and a given number of decimal places."""
        try:
            float_value = float(value)
            formatted_value = f"{float_value:.{decimal_places}f}".lstrip()  # Remove leading spaces
            return ' ' * spaces + formatted_value.lstrip()  # Ensure no leading spaces after adding spaces
        except ValueError:
            return value  # Return the original value on failure

    def format_column_climates(self, columns):
        """Format the relevant columns from the provided list of columns."""
        col1 = self.format_column_climate(columns[0], 5 if len(columns[0]) == 1 else 4 if len(columns[0]) == 2 else 0, 0)
        col2 = self.format_column_climate(columns[1], 5 if len(columns[1]) == 1 else 4 if len(columns[1]) == 2 else 0, 0)
        col3 = ' ' * 2 + columns[2].lstrip()  # Ensure col3 has no leading spaces

        # Adjusting spaces based on the formatted value for columns 4 to 8
        col4 = self.format_column_climate(columns[3], 9 if float(columns[3]) < 10 else 8, 1)
        col5 = self.format_column_climate(columns[4], 7 if float(columns[4]) < 10 else 8, 1)
        col6 = self.format_column_climate(columns[5], 9 if float(columns[5]) < 10 else 10, 1)
        col7 = self.format_column_climate(columns[6], 9 if float(columns[6]) < 10 else 8, 1)
        col8 = self.format_column_climate(columns[7], 7 if float(columns[7]) < 1000 else 6, 1)
        
        return f"{col1}{col2}{col3}{col4}{col5}{col6}{col7}{col8}\n"
    
    
    def format_file_climate(self, input_file, output_file):
        formatted_lines = []  # List to store formatted lines
        warnings = []  # List to collect warnings

        with open(input_file, 'r', encoding='utf-8') as infile:
            lines = infile.readlines()  # Read all lines from the input file

            for index, line in enumerate(lines):  # Process all lines
                columns = line.strip().split(',')

                # Ignore the first line (header)
                #if index == 0:
                #    continue  

                if len(columns) < 8:
                    warnings.append(f"Skipping line {index + 1} due to insufficient columns.")
                    continue  # Skip lines with less than 8 columns

                # Remove leading zeros from columns 0 and 1
                columns[0] = self.remove_leading_zeros(columns[0])
                columns[1] = self.remove_leading_zeros(columns[1])

                # Format the columns and add to formatted_lines
                formatted_lines.append(self.format_column_climates(columns))

        # Adding header in the first line of the output file
        header = "   day month  year    Temp(°C)   RelHum(%) Wind10m(m/s) SunHours(h) AtmPres(mb)\n"
        
        # Writing header and formatted lines to the output file
        with open(output_file, 'w', encoding='utf-8') as outfile:
            outfile.write(header)  # Write header
            outfile.writelines(formatted_lines)  # Write all formatted lines
        
        # Print warnings if any
        if warnings:
            print("\n".join(warnings))

    def process_all_files_climate(self, input_folder, output_folder):
            # Create the output folder if it doesn't exist
            os.makedirs(output_folder, exist_ok=True)

            # Iterate through all the files in the input directory
            for filename in os.listdir(input_folder):
                input_file_path = os.path.join(input_folder, filename)
                
                # Check if it's a file and if it has the .txt extension
                if os.path.isfile(input_file_path) and filename.endswith('.txt'):
                    output_file_path = os.path.join(output_folder, filename)
                    self.format_file_climate(input_file_path, output_file_path)
            
            
    
    # Remove the 10.0 that becomes misformatted.
    def replace_in_txt_file_climate(self, file_path, old_value, new_value):
        # Check if the file is a .txt file.
        if file_path.endswith(".txt"):
            try:
                # Read the file
                with open(file_path, 'r', encoding='utf-8') as file:
                    file_content = file.read()

                # Replace the old value with the new one.
                if old_value in file_content:
                    new_content = file_content.replace(old_value, new_value)
                    
                    # Write the updated content back to the file.
                    with open(file_path, 'w', encoding='utf-8') as file:
                        file.write(new_content)
                else:
                    print(f"No occurrences of '{old_value}' were found in the file {file_path}")
            except Exception as e:
                print(f"An error occurred while processing the file: {e}")
        else:
            print(f"The file {file_path} is not a valid .txt file")
            
    def process_files_climate(self):
        """Method that performs the processing when OK is pressed"""
        input_folder = self.dlg.lineEdit_7.text()  # Gets the input path (as defined in your .ui)
        output_folder = self.dlg.lineEdit_8.text()  # Gets the output path (as defined in your .ui)
        
        # Check if the input folder is valid
        if not os.path.isdir(input_folder):
            self.show_error_message(f"Error: The input directory '{input_folder}' is not valid or does not exist.")
            return  # Stop further execution if input folder is invalid
        
        # Check if the output folder is valid
        if not os.path.isdir(output_folder):
            self.show_error_message(f"Error: The output directory '{output_folder}' is not valid or does not exist.")
            return  # Stop further execution if output folder is invalid
        
        # Iterates through the files in the input folder
        for file in os.listdir(input_folder):
            if file.endswith('.csv'):
                # Full path of the CSV file
                file_path = os.path.join(input_folder, file)

                # Read the CSV file
                df = pd.read_csv(file_path, sep=',')

                # Convert the first column to datetime
                df[df.columns[0]] = pd.to_datetime(df[df.columns[0]])

                # Create the DataFrame df1 with the day, month, and year columns
                df1 = pd.DataFrame()
                
                # Start date
                start_date = pd.Timestamp(self.dlg.lineEdit_9.text())
                
                if isinstance(start_date, str) and start_date.strip():  # Check if start_date is a string and not empty or only whitespace
                    try:
                        # Ensure start_date is a valid datetime
                        start_date = pd.to_datetime(start_date)
                        
                        # Change the 'date' column based on the start date
                        df[df.columns[0]] = [start_date + pd.Timedelta(days=i) for i in range(len(df))]
                    except ValueError:
                        self.show_error_message("Invalid start date format.")
                    except Exception as e:
                        self.show_error_message(f"An error occurred: {str(e)}")
                elif pd.notna(start_date):  # If start_date is a valid Timestamp (datetime)
                    try:
                        # Use start_date directly as it is already a valid datetime
                        df[df.columns[0]] = [start_date + pd.Timedelta(days=i) for i in range(len(df))]
                    except Exception as e:
                        self.show_error_message(f"An error occurred: {str(e)}")
                else:
                    pass  # If start_date is NaT or invalid, do nothing



                            
                df1['day'] = df[df.columns[0]].dt.day
                df1['month'] = df[df.columns[0]].dt.month
                df1['year'] = df[df.columns[0]].dt.year
                df1[df.columns[1]] = df[df.columns[1]]
                df1[df.columns[2]] = df[df.columns[2]]
                df1[df.columns[3]] = df[df.columns[3]]
                df1[df.columns[4]] = df[df.columns[4]]
                df1[df.columns[5]] = df[df.columns[5]]

                # Define the full path to save the .txt file
                output_file = os.path.join(output_folder, file.replace('.csv', '.txt'))
                # Save the DataFrame df1 as .txt
                df1.to_csv(output_file, sep=',', index=False, header=False)
                
        self.process_all_files_climate(output_folder, output_folder+'/Climate')
        # Move files from the 'Flow' folder to 'output_folder' and delete the folder if necessary
        self.move_and_replace_files(output_folder, 'Climate')
        
        old_value = "         10.0"  # The value you want to replace
        new_value = "        10.0"    # The new value that will replace the old one
        self.replace_in_txt_file_climate(output_folder, old_value, new_value)
        
        self.show_success_message("Processing completed successfully")    
                


#############################################################################################       

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = MGB_InputToolDialog()

        # show the dialog
        self.dlg.show()
        
        # Add the created functions
        
        self.dlg.toolButton.clicked.connect(self.OpenCSV_precipitation)
        self.dlg.toolButton_2.clicked.connect(self.OutputTXT_precipitation)
        
        self.dlg.toolButton_3.clicked.connect(self.OpenCSV_flow)
        self.dlg.toolButton_4.clicked.connect(self.OutputTXT_flow)
        
        self.dlg.toolButton_5.clicked.connect(self.OpenCSV_climate)
        self.dlg.toolButton_6.clicked.connect(self.OutputTXT_climate)
        
        
        # Connect the OK button to the processing method
        self.dlg.pushButton_3.clicked.connect(self.process_files_precipitation)
        self.dlg.pushButton_2.clicked.connect(self.process_files_flow)
        self.dlg.pushButton.clicked.connect(self.process_files_climate)
        
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            
            pass
