from pathlib import Path

from qgis.core import QgsReadWriteContext, QgsTextFormat
from qgis.PyQt.QtCore import QFile
from qgis.PyQt.QtXml import QDomDocument

from ..compat import OPEN_READ_ONLY, OPEN_TEXT


def saveTextFormat(textFormat: QgsTextFormat, xmlFile: Path):
    doc = QDomDocument()
    textStyle = textFormat.writeXml(doc, QgsReadWriteContext())
    doc.appendChild(textStyle)

    with open(xmlFile, "w") as f:
        f.write(doc.toString(2))


def loadTextFormat(xmlFile: Path) -> QgsTextFormat:
    textFormat = QgsTextFormat()
    if not xmlFile.is_file():
        return textFormat

    file = QFile(str(xmlFile))
    if not file.open(OPEN_READ_ONLY | OPEN_TEXT):
        file.close()
        return textFormat

    doc = QDomDocument()
    if not doc.setContent(file):
        file.close()
        return textFormat

    file.close()
    root = doc.documentElement()
    textFormat.readXml(root, QgsReadWriteContext())
    return textFormat
