import os

from qgis.core import QgsSettings
from qgis.PyQt.QtCore import QCoreApplication, QLocale, QTranslator

from .widgets import MeterToolButton


class Plugin:
    def __init__(self, iface):
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.loadTranslation()

    def initGui(self):
        self.meterTool = MeterToolButton(self.iface)
        self.toolbar = self.iface.addToolBar(self.tr("Meter Toolbar"))
        self.toolbar.setToolTip(self.tr("Meter Toolbar"))
        self.toolbar.addWidget(self.meterTool)

    def unload(self):
        self.meterTool.clear()
        self.meterTool.deleteLater()
        self.iface.mainWindow().removeToolBar(self.toolbar)
        self.toolbar.deleteLater()

    def tr(self, message: str) -> str:
        return QCoreApplication.translate("Plugin", message)

    def loadTranslation(self):
        locale = QgsSettings().value("locale/userLocale", QLocale.system().name())
        pluginDir = os.path.dirname(__file__)
        localePath = os.path.join(pluginDir, "i18n", f"meter_{locale[0:2]}.qm")
        if os.path.exists(localePath):
            self.translator = QTranslator()
            self.translator.load(localePath)
            QCoreApplication.installTranslator(self.translator)
