<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dc="http://purl.org/dc/elements/1.1/"
xmlns:dcterms="http://purl.org/dc/terms/"
xmlns:ows="http://www.opengis.net/ows"
xmlns:csw="http://www.opengis.net/cat/csw/2.0.2"
xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<!-- Stylesheet that translates a correct CSW  into a Dublin Core in RDF format  -->
	<!-- Author: jesusb  IAAA -->
	<!-- december 2007 -->
	<xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
	
	<xsl:variable name="valid-elements-URI" select="'xml\\fullElements.xml'"/>
  	<xsl:variable name="valid-elements" select="document($valid-elements-URI)"/>
  
	<xsl:template match="/">
		<xsl:apply-templates select="csw:Record"/>
		<xsl:apply-templates select="csw:BriefRecord"/>
		<xsl:apply-templates select="csw:SummaryRecord"/>
		<xsl:apply-templates select="csw:DCMIRecord"/>
	</xsl:template>
	
	<xsl:template match="csw:BriefRecord">
		<xsl:call-template name="allRecords"/>
	</xsl:template>
	<xsl:template match="csw:SummaryRecord">
		<xsl:call-template name="allRecords"/>
	</xsl:template>
	<xsl:template match="csw:DCMIRecord">
		<xsl:call-template name="allRecords"/>
	</xsl:template>
	<xsl:template match="csw:Record">
		<xsl:call-template name="allRecords"/>
	</xsl:template>
	
	<xsl:template name="allRecords">
		<!--xsl:element name="qualifieddc"-->
		<rdf:RDF>
			<rdf:Description>
				
				<!-- Set the File Identifier -->
				<xsl:if test="dc:identifier">
					<xsl:attribute name="rdf:about"><xsl:value-of select="normalize-space(dc:identifier)"/></xsl:attribute>
				</xsl:if>
				
				<!-- Set the RDF Type -->
				<rdf:type rdf:resource="http://iaaa.cps.unizar.es/thesaurus/IAAAResourceTypeThesaurus/102/DATASET"/>
				
				<!-- Copy the elements from the original CSW file -->
				<xsl:for-each select="*">
    	       			<xsl:variable name="tagname" select="name()"/>
		  			<xsl:if test="contains($valid-elements,$tagname)">
		          			<xsl:copy-of select="."/>
		 			</xsl:if>
    				</xsl:for-each>

				<!-- ows:BoundingBox -->
				<xsl:for-each select="ows:BoundingBox">
					<xsl:variable name="upperCorner" select="ows:UpperCorner"/>
					<xsl:variable name="lowerCorner" select="ows:LowerCorner"/>
					<xsl:element name="dcterms:spatial">
						<xsl:attribute name="xsi:type"><xsl:value-of select="local-name()"/></xsl:attribute>
						northlimit=<xsl:value-of select="substring-after(normalize-space($upperCorner), ' ')"/>;
						southlimit=<xsl:value-of select="substring-after(normalize-space($lowerCorner), ' ')"/>;
						westlimit=<xsl:value-of select="substring-before(normalize-space($lowerCorner), ' ')"/>;
						eastlimit=<xsl:value-of select="substring-before(normalize-space($upperCorner), ' ')"/>;
					</xsl:element>
				</xsl:for-each>
				
				<!-- ows:WGS84BoundingBox -->
				<xsl:for-each select="ows:WGS84BoundingBox">
					<xsl:variable name="upperCorner" select="ows:UpperCorner"/>
					<xsl:variable name="lowerCorner" select="ows:LowerCorner"/>
					<xsl:element name="dcterms:spatial">
						<xsl:attribute name="xsi:type"><xsl:value-of select="local-name()"/></xsl:attribute>
						northlimit=<xsl:value-of select="substring-after(normalize-space($upperCorner), ' ')"/>;
						southlimit=<xsl:value-of select="substring-after(normalize-space($lowerCorner), ' ')"/>;
						westlimit=<xsl:value-of select="substring-before(normalize-space($lowerCorner), ' ')"/>;
						eastlimit=<xsl:value-of select="substring-before(normalize-space($upperCorner), ' ')"/>;
					</xsl:element>
				</xsl:for-each>		
				
			</rdf:Description>			
		</rdf:RDF>		
	</xsl:template>
</xsl:stylesheet>
