# Universal Translation trigger for Qt python applications.
# Intended to be called during init of an app
# Test use case is a QGIS python plugin
#
# Author: Alex Mandel
#Copyright(C) 2009 University of California, Davis
#
# Adopted from:
#'Geoprocessing Plugin',Copyright(C) 2008 by Dr. Horst Duester, Stefan Ziegler
#-----------------------------------------------------------
# 
# licensed under the terms of GNU GPL 2
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
# 
#---------------------------------------------------------------------

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

def localeSwitch(parent,appPath,appName):
    '''Detects the system language setting an applies translation if available to the plugin'''
    # TODO: read QGIS language setting and use in place of system when set
    #plugin path detected and provided by init should make other methods below unnecessary
    currentPluginPath = appPath
    #This part is not application agnostic yet, and might not be needed
    userPluginPath = QFileInfo(QgsApplication.qgisUserDbFilePath()).path()+"/python/plugins/"+appName
    systemPluginPath = QgsApplication.prefixPath()+"/share/qgis/python/plugins/"+appName
    #Read the system locale, currently only looks at the 1st 2 characters
    settings = QSettings()
    if settings.value("locale/overrideFlag").toBool():
        myLocaleName = settings.value("locale/userLocale").toString()
    elif settings.value("locale/userLocale").toString() != QLocale.system().name():
        myLocaleName = settings.value("locale/userLocale").toString()
    else:    
        myLocaleName = QLocale.system().name()
    myLocale = myLocaleName[0:2]
    
    #If path to directory exists
    if QFileInfo(currentPluginPath).exists():
        pluginPath = currentPluginPath+"/i18n/"+appName+"_"+myLocale+".qm"
    elif QFileInfo(userPluginPath).exists():
      pluginPath = userPluginPath+"/i18n/"+appName+"_"+myLocale+".qm"
    elif QFileInfo(systemPluginPath).exists():
      pluginPath = systemPluginPath+"/i18n/"+appName+"_"+myLocale+".qm"
    
    if QFileInfo(pluginPath).exists():
        parent.localePath = pluginPath
        parent.translator = QTranslator()
        parent.translator.load(parent.localePath)
        if qVersion() > '4.3.3':        
            QCoreApplication.installTranslator(parent.translator)
    
if __name__ == '__main__':
    #What to do if the module is run directly
    print "Nothing"