#-----------------------------------------------------------
# 
# MetaEdit
# Copyright (C) 2009  University of California, Davis
# AUTHORS: Alex Mandel, Nate Roth, Stacey Ellis, Alex Koltunov
# EMAIL: ?
# WEB  : https://apps.sourceforge.net/trac/qgismetaedit
#
# XML Metadata editor for QGISS
#
#-----------------------------------------------------------
# 
# licensed under the terms of GNU GPL 2
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
# 
#---------------------------------------------------------------------
#  defMetadata.py
# this module  defines class MetaData 
#
from xml.dom import minidom
##from xml.dom.minidom import *
# temprary, for debugging


import sys

class XMLMetaData():
    #    TODO: place class' attributes here, when necessary
    def __init__(self):        
        self.document = None; # actually contains the xml atributes and values 
        self.__sourceFileName = None        
    def isempty(self):
        return  self.document is  None  or self.document.doctype is None
        
    def loadDocumentFromXML(self, filenameStr):
        ''' uses minidom.parser() to load an XML doc from a file and parse it into an object of class minidom.Document
        and assigns it to attribute "document". Returns True if parsing went successfully'''
        try:
            #print 'importing  document from file: ', filenameStr
            self.document = minidom.parse(filenameStr)
            self.__sourceFileName = filenameStr
            return True,""
            #print 'self.isempty() == ', self.isempty()
        except Exception, e: 
            #print 'Error parsing from file: ', filenameStr  
             return False, e
    
    def get_sourceFileName(self):
        '''What does this do?'''
        return self.__sourceFileName
    
    def getTopNodeText(self):
        '''Retrive text value of top level node'''
        node = self.document.documentElement
        return node.localName
    
    def getTopNode(self):
        '''Retrieve Top Level Node as object'''
        node = self.document.documentElement
        return node


# to be continued here, 




