<?xml version="1.0" encoding="ISO-8859-1"?>
  <!-- 
     Conversion from Dublin Core Application Profile for Geographical Data Mining into ISO19115
     [jnog 21/11/2005] creation 
     [jnog 28/11/2005] solve the problem with the spatial resolution and the aggregation information
     [jnog 30/11/2005] add the role in MD_Metadat.contact
   -->

<!-- xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"  
xmlns:cen="http://www.cen.org/dc-spatial/"  
xmlns:iaaaterms="http://purl.org/dc/IAAAterms/"  
xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"  
xmlns:iemsr="http://www.ukoln.ac.uk/projects/iemsr/terms/"  
xmlns:fgdc="http://www.fgdc.gov/metadata/FGDC-STD-001-1998/"  
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:dc="http://purl.org/dc/elements/1.1/"
                                    xmlns:dcterms="http://purl.org/dc/terms/"
                                    xmlns:iso="http://www.isotc211.org/19115/"  
                                    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
                                    exclude-result-prefixes="dc dcterms"
                                    >
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
<xsl:template match="spatialdc" >

    <xsl:variable name="xsltsl-str-lower" select="'a;b;c;d;e;f;g;h;i;j;k;l;m;n;o;p;q;r;s;t;u;v;w;x;y;z'"/>
    <xsl:variable name="xsltsl-str-upper" select="'A;B;C;D;E;F;G;H;I;J;K;L;M;N;O;P;Q;R;S;T;U;V;W;X;Y;Z'"/>

<xsl:element name="MD_Metadata" >

<!-- METADATA -->

<!-- file identifier -->
<xsl:if test="./@fileID">
  <xsl:element name="fileIdentifier">
	  <xsl:value-of select="./@fileID"/>
	</xsl:element>
</xsl:if>

<xsl:choose>
  <xsl:when test="iso:MD_Metadata.language" >
    <xsl:for-each select="iso:MD_Metadata.language[1]" >
      <xsl:element name="language" >
        <xsl:value-of select="." />
      </xsl:element>
    </xsl:for-each>
  </xsl:when>
	<xsl:when test="./@xml:lang">
		<xsl:element name="language">
			<xsl:value-of select="./@xml:lang"/>
		</xsl:element>
	</xsl:when>
  <xsl:otherwise>
  </xsl:otherwise>
</xsl:choose>

<xsl:for-each select="iso:MD_Metadata.characterSet[1]" >
<xsl:element name="characterSet" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dc:type" >
<xsl:element name="hierarchyLevel" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>


<xsl:choose>
  <xsl:when test="iso:MD_Metadata.contact" >
    <xsl:for-each select="iso:MD_Metadata.contact" >
      <xsl:element name="contact" >
        <xsl:element name="CI_ResponsibleParty" >
          <xsl:element name="organisationName" >
            <xsl:value-of select="." />
          </xsl:element>
              <xsl:element name="role">
                  <xsl:text>custodian</xsl:text>
              </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:for-each>
  </xsl:when>
  <xsl:otherwise>
    <xsl:element name="contact" >
      <xsl:element name="CI_ResponsibleParty" >
        <xsl:element name="organisationName" >
mandatory element without value
        </xsl:element>
              <xsl:element name="role">
                  <xsl:text>custodian</xsl:text>
              </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:otherwise>
</xsl:choose>

<xsl:choose>
  <xsl:when test="iso:MD_Metadata.dateStamp" >
    <xsl:for-each select="iso:MD_Metadata.dateStamp[1]" >
      <xsl:element name="dateStamp" >
        <xsl:value-of select="." />
      </xsl:element>
    </xsl:for-each>
  </xsl:when>
  <xsl:otherwise>
    <xsl:element name="dateStamp" >
mandatory element without value
    </xsl:element>
  </xsl:otherwise>
</xsl:choose>

<xsl:for-each select="dc:identifier[1]" >
<!--  <xsl:element name="dataSetURI" > -->
  <xsl:element name="dataSet" >
    <xsl:value-of select="." />
  </xsl:element>
</xsl:for-each>

<!-- REFERENCE SYSTEM INFO -->

<xsl:for-each select="iso:MD_Metadata.referenceSystemInfo.referenceSystemIdentifier" >
  <xsl:element name="referenceSystemInfo" >

<!-- DISTINGUISH WHEN TO ADD MD_CRS OR MD_REFERENCESYSTEM -->
    <xsl:choose>
      <xsl:when test="contains(translate(normalize-space(./@xsi:type),$xsltsl-str-upper, $xsltsl-str-lower),'epsg')" >
        <xsl:element name="MD_CRS" >
          <xsl:element name="referenceSystemIdentifier" >
            <xsl:element name="RS_Identifier" >
              <xsl:element name="code" >
                <xsl:value-of select="." />
              </xsl:element>
              <xsl:if test="./@xsi:type" >
                <xsl:element name="authority" >
                  <xsl:element name="CI_Citation" >
                    <xsl:element name="title" >
                      <xsl:value-of select="./@xsi:type" />
                    </xsl:element>
                    <xsl:element name="date" >
                      <xsl:element name="CI_Date" >
                        <xsl:element name="date" >
                          <xsl:text>0000-00-00</xsl:text>
                        </xsl:element>
                        <xsl:element name="dateType" >
                          <xsl:text>publication</xsl:text>
                        </xsl:element>
                      </xsl:element>
                    </xsl:element>
                  </xsl:element>
                </xsl:element>
              </xsl:if>
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="MD_ReferenceSystem" >
          <xsl:element name="referenceSystemIdentifier" >
            <xsl:element name="RS_Identifier" >
              <xsl:element name="code" >
                <xsl:value-of select="." />
              </xsl:element>
              <xsl:if test="./@xsi:type" >
                <xsl:element name="authority" >
                  <xsl:element name="CI_Citation" >
                    <xsl:element name="title" >
                      <xsl:value-of select="./@xsi:type" />
                    </xsl:element>
                    <xsl:element name="date" >
                      <xsl:element name="CI_Date" >
                        <xsl:element name="date" >
                          <xsl:text>0000-00-00</xsl:text>
                        </xsl:element>
                        <xsl:element name="dateType" >
                          <xsl:text>publication</xsl:text>
                        </xsl:element>
                      </xsl:element>
                    </xsl:element>
                  </xsl:element>
                </xsl:element>
              </xsl:if>
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:element>
</xsl:for-each>

<!-- IDENTIFICATION INFO -->

<xsl:element name="identificationInfo" >
<xsl:element name="MD_DataIdentification" >

<xsl:element name="citation" >
<xsl:element name="CI_Citation" >

<xsl:choose>
  <xsl:when test="dc:title" >
    <xsl:for-each select="dc:title[1]" >
      <xsl:element name="title" >
        <xsl:value-of select="." />
      </xsl:element>
    </xsl:for-each>
  </xsl:when>
  <xsl:otherwise>
    <xsl:element name="title" >
      mandatory element without value
    </xsl:element>
  </xsl:otherwise>
</xsl:choose>

<xsl:for-each select="dc:title">
  <xsl:choose>
    <xsl:when test="position()=1">
      <!-- The first dc:title go to citation.title -->
    </xsl:when>
    <xsl:otherwise>
      <xsl:element name="alternateTitle">
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:otherwise>
  </xsl:choose>
</xsl:for-each>

<xsl:for-each select="dc:date" >
<xsl:element name="date" >
<xsl:element name="CI_Date" >
<xsl:element name="date" >
<xsl:value-of select="." />
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>


<xsl:for-each select="dcterms:created" >
<xsl:element name="date" >
<xsl:element name="CI_Date" >
<xsl:element name="date" >
<xsl:value-of select="." />
</xsl:element>
                  <xsl:element name="dateType">
                      <xsl:text>creation</xsl:text>
                  </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:issued" >
<xsl:element name="date" >
<xsl:element name="CI_Date" >
<xsl:element name="date" >
<xsl:value-of select="." />
</xsl:element>
                  <xsl:element name="dateType">
                      <xsl:text>publication</xsl:text>
                  </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:modified" >
<xsl:element name="date" >
<xsl:element name="CI_Date" >
<xsl:element name="date" >
<xsl:value-of select="." />
</xsl:element>
                  <xsl:element name="dateType">
                      <xsl:text>revision</xsl:text>
                  </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<!-- date is mandatory -->
<xsl:choose>
  <xsl:when test="dc:date" >
  </xsl:when>
  <xsl:when test="dcterms:created" >
  </xsl:when>
  <xsl:when test="dcterms:issued" >
  </xsl:when>
  <xsl:when test="dcterms:modified" >
  </xsl:when>
  <xsl:otherwise>
    <xsl:element name="date" >
      <xsl:element name="CI_Date" >
        <xsl:element name="date" >
0000-00-00
        </xsl:element>
        <xsl:element name="dateType">
          <xsl:text>publication</xsl:text>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:otherwise>
</xsl:choose>

<xsl:for-each select="dcterms:bibliographicCitation" >
<xsl:element name="identifier" >
<xsl:element name="MD_Identifier" >
<xsl:element name="code" >
<xsl:value-of select="." />
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dc:creator" >
<xsl:element name="citedResponsibleParty" >
<xsl:element name="CI_ResponsibleParty" >

<xsl:element name="organisationName" >
<xsl:value-of select="." />
</xsl:element>
              <xsl:element name="role">
                  <xsl:text>originator</xsl:text>
              </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dc:publisher" >
<xsl:element name="citedResponsibleParty" >
<xsl:element name="CI_ResponsibleParty" >
<xsl:element name="organisationName" >
<xsl:value-of select="." />
</xsl:element>
              <xsl:element name="role">
                  <xsl:text>publisher</xsl:text>
              </xsl:element>              
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:rightsHolder" >
<xsl:element name="citedResponsibleParty" >
<xsl:element name="CI_ResponsibleParty" >
<xsl:element name="organisationName" >
<xsl:value-of select="." />
</xsl:element>
              <xsl:element name="role">
                  <xsl:text>owner</xsl:text>
              </xsl:element>              
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="iso:MD_Metadata.identificationInfo.citation.presentationForm" >
<xsl:element name="presentationForm" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:bibliographicCitation" >
<xsl:element name="isbn" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:bibliographicCitation" >
<xsl:element name="issn" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>


</xsl:element>
</xsl:element>

<xsl:choose>
<xsl:when test="dc:description" >
<!--
<xsl:for-each select="dc:description[1]" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
-->
<xsl:element name="abstract" >
              <xsl:variable name="abstractElement"/>
              <xsl:for-each select="./dc:description">
                <xsl:value-of select="concat($abstractElement, normalize-space(.))"/>
                <xsl:if test="position()!=last()">
                  <xsl:value-of select="concat($abstractElement, '&#xA;')"/>
                </xsl:if>
              </xsl:for-each>
              <xsl:value-of select="$abstractElement"/>
</xsl:element>
</xsl:when>
<xsl:otherwise>
<xsl:element name="abstract" >
mandatory element without value
</xsl:element>
</xsl:otherwise>
</xsl:choose>

<xsl:for-each select="dc:contributor" >
<xsl:element name="credit" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dc:creator" >
<xsl:element name="pointOfContact" >
<xsl:element name="CI_ResponsibleParty" >
<xsl:element name="organisationName" >
<xsl:value-of select="." />
</xsl:element>
            <xsl:element name="role">
                <xsl:text>originator</xsl:text>
            </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dc:publisher" >
<xsl:element name="pointOfContact" >
<xsl:element name="CI_ResponsibleParty" >
<xsl:element name="organisationName" >
<xsl:value-of select="." />
</xsl:element>
            <xsl:element name="role">
                <xsl:text>publisher</xsl:text>
            </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dc:format" >
<xsl:element name="resourceFormat" >
<xsl:element name="MD_Format" >
<xsl:element name="name" >
<xsl:value-of select="." />
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dc:subject" >
<xsl:choose>
  <xsl:when test="contains(translate(normalize-space(./@xsi:type),$xsltsl-str-upper, $xsltsl-str-lower),'md_topiccategorycode')" >

    <xsl:element name="topicCategory" >
      <xsl:value-of select="." />
    </xsl:element>
  </xsl:when>

  <xsl:otherwise>
    <xsl:element name="descriptiveKeywords" >
    <xsl:element name="MD_Keywords" >
    <xsl:element name="keyword" >
    <xsl:value-of select="." />
    </xsl:element>
                <xsl:element name="type">
                    <xsl:text>theme</xsl:text>
                </xsl:element>
  <xsl:if test="./@xsi:type" >
    <xsl:element name="thesaurusName" >
       <xsl:element name="CI_Citation" >
         <xsl:element name="title" >
            <xsl:value-of select="./@xsi:type" />
         </xsl:element>
         <xsl:element name="date" >
           <xsl:element name="CI_Date" >
             <xsl:element name="date" >
               <xsl:text>0000-00-00</xsl:text>
             </xsl:element>
             <xsl:element name="dateType" >
               <xsl:text>publication</xsl:text>
             </xsl:element>
           </xsl:element>
         </xsl:element>
       </xsl:element>
    </xsl:element>
  </xsl:if>


    </xsl:element>
    </xsl:element>
  </xsl:otherwise>
</xsl:choose>
</xsl:for-each>




<xsl:for-each select="dcterms:spatial" >
  <xsl:choose>
    <xsl:when test="contains(translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower), 'northlimit')">
    </xsl:when>
  <xsl:otherwise>

    <xsl:element name="descriptiveKeywords" >
      <xsl:element name="MD_Keywords">
        <xsl:element name="keyword">
          <xsl:value-of select="."/>
        </xsl:element>
        <xsl:element name="type">
          <xsl:text>place</xsl:text>
        </xsl:element>
  <xsl:if test="./@xsi:type" >
    <xsl:element name="thesaurusName" >
       <xsl:element name="CI_Citation" >
         <xsl:element name="title" >
            <xsl:value-of select="./@xsi:type" />
         </xsl:element>
         <xsl:element name="date" >
           <xsl:element name="CI_Date" >
             <xsl:element name="date" >
               <xsl:text>0000-00-00</xsl:text>
             </xsl:element>
             <xsl:element name="dateType" >
               <xsl:text>publication</xsl:text>
             </xsl:element>
           </xsl:element>
         </xsl:element>
       </xsl:element>
    </xsl:element>
  </xsl:if>
    </xsl:element>       			
  </xsl:element>

</xsl:otherwise>
</xsl:choose>
</xsl:for-each>


<xsl:for-each select="dcterms:temporal" >
  <xsl:choose>
    <xsl:when test="contains(translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower), 'begin')">
    </xsl:when>
  <xsl:otherwise>
<xsl:element name="descriptiveKeywords" >
<xsl:element name="MD_Keywords" >
<xsl:element name="keyword" >
<xsl:value-of select="." />
</xsl:element>
                <xsl:element name="type">
                    <xsl:text>temporal</xsl:text>
                </xsl:element>
  <xsl:if test="./@xsi:type" >
    <xsl:element name="thesaurusName" >
       <xsl:element name="CI_Citation" >
         <xsl:element name="title" >
            <xsl:value-of select="./@xsi:type" />
         </xsl:element>
         <xsl:element name="date" >
           <xsl:element name="CI_Date" >
             <xsl:element name="date" >
               <xsl:text>0000-00-00</xsl:text>
             </xsl:element>
             <xsl:element name="dateType" >
               <xsl:text>publication</xsl:text>
             </xsl:element>
           </xsl:element>
         </xsl:element>
       </xsl:element>
    </xsl:element>
  </xsl:if>
</xsl:element>
</xsl:element>
  </xsl:otherwise>
  </xsl:choose>
</xsl:for-each>

<xsl:element name="resourceConstraints" >
<xsl:element name="MD_LegalConstraints" >
<xsl:for-each select="dcterms:accessRights" >
<xsl:element name="accessConstraints" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:license" >
<xsl:element name="otherConstraints" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="iso:MD_Metadata.identificationInfo.resourceConstraints.useConstraints" >
<xsl:element name="useConstraints" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

</xsl:element>
</xsl:element>

<xsl:for-each select="dcterms:isFormatOf" >
<xsl:element name="aggregationInfo" >
<xsl:element name="MD_AggregateInformation" >
<xsl:element name="aggregateDataSetName" >
       <xsl:element name="CI_Citation" >
         <xsl:element name="title" >
<xsl:value-of select="." />
         </xsl:element>
         <xsl:element name="date" >
           <xsl:element name="CI_Date" >
             <xsl:element name="date" >
               <xsl:text>0000-00-00</xsl:text>
             </xsl:element>
             <xsl:element name="dateType" >
               <xsl:text>publication</xsl:text>
             </xsl:element>
           </xsl:element>
         </xsl:element>
       </xsl:element>
</xsl:element>
              <xsl:element name="associationType">
                   <xsl:text>source</xsl:text>
              </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:isPartOf" >
<xsl:element name="aggregationInfo" >
<xsl:element name="MD_AggregateInformation" >
<xsl:element name="aggregateDataSetName" >
       <xsl:element name="CI_Citation" >
         <xsl:element name="title" >
<xsl:value-of select="." />
         </xsl:element>
         <xsl:element name="date" >
           <xsl:element name="CI_Date" >
             <xsl:element name="date" >
               <xsl:text>0000-00-00</xsl:text>
             </xsl:element>
             <xsl:element name="dateType" >
               <xsl:text>publication</xsl:text>
             </xsl:element>
           </xsl:element>
         </xsl:element>
       </xsl:element>
</xsl:element>
              <xsl:element name="associationType">
                   <xsl:text>largerWorkCitation</xsl:text>
              </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:isVersionOf" >
<xsl:element name="aggregationInfo" >
<xsl:element name="MD_AggregateInformation" >
<xsl:element name="aggregateDataSetName" >
       <xsl:element name="CI_Citation" >
         <xsl:element name="title" >
<xsl:value-of select="." />
         </xsl:element>
         <xsl:element name="date" >
           <xsl:element name="CI_Date" >
             <xsl:element name="date" >
               <xsl:text>0000-00-00</xsl:text>
             </xsl:element>
             <xsl:element name="dateType" >
               <xsl:text>publication</xsl:text>
             </xsl:element>
           </xsl:element>
         </xsl:element>
       </xsl:element>
</xsl:element>
              <xsl:element name="associationType">
                   <xsl:text>source</xsl:text>
              </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:references" >
<xsl:element name="aggregationInfo" >
<xsl:element name="MD_AggregateInformation" >
<xsl:element name="aggregateDataSetName" >
       <xsl:element name="CI_Citation" >
         <xsl:element name="title" >
<xsl:value-of select="." />
         </xsl:element>
         <xsl:element name="date" >
           <xsl:element name="CI_Date" >
             <xsl:element name="date" >
               <xsl:text>0000-00-00</xsl:text>
             </xsl:element>
             <xsl:element name="dateType" >
               <xsl:text>publication</xsl:text>
             </xsl:element>
           </xsl:element>
         </xsl:element>
       </xsl:element>
</xsl:element>
              <xsl:element name="associationType">
                   <xsl:text>crossReference</xsl:text>
              </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="dcterms:replaces" >
<xsl:element name="aggregationInfo" >
<xsl:element name="MD_AggregateInformation" >
<xsl:element name="aggregateDataSetName" >
       <xsl:element name="CI_Citation" >
         <xsl:element name="title" >
<xsl:value-of select="." />
         </xsl:element>
         <xsl:element name="date" >
           <xsl:element name="CI_Date" >
             <xsl:element name="date" >
               <xsl:text>0000-00-00</xsl:text>
             </xsl:element>
             <xsl:element name="dateType" >
               <xsl:text>publication</xsl:text>
             </xsl:element>
           </xsl:element>
         </xsl:element>
       </xsl:element>
</xsl:element>
              <xsl:element name="associationType">
                   <xsl:text>source</xsl:text>
              </xsl:element>
</xsl:element>
</xsl:element>
</xsl:for-each>

<xsl:for-each select="iso:MD_Metadata.identificationInfo.spatialRepresentationType" >
<xsl:element name="spatialRepresentationType" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="iso:MD_Metadata.identificationInfo.spatialResolution.distance" >
  <xsl:element name="spatialResolution" >
    <xsl:element name="MD_Resolution" >
      <xsl:element name="distance" >
        <xsl:element name="value" >
          <xsl:value-of select="." />
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:element>
</xsl:for-each>

<xsl:for-each select="iso:MD_Metadata.identificationInfo.spatialResolution.equivalentScale.denominator" >
  <xsl:element name="spatialResolution" >
    <xsl:element name="MD_Resolution" >
      <xsl:element name="equivalentScale" >
        <xsl:element name="MD_RepresentativeFraction" >
          <xsl:element name="denominator" >
            <xsl:value-of select="." />
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:element>
</xsl:for-each>

<xsl:choose>
<xsl:when test="dc:language" >
<xsl:for-each select="dc:language" >
<xsl:element name="language" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:when>
<xsl:otherwise>
<xsl:element name="language" >
<!--mandatory element without value -->
en
</xsl:element>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="iso:MD_Metadata.identificationInfo.characterSet" >
<xsl:for-each select="iso:MD_Metadata.identificationInfo.characterSet" >
<xsl:element name="characterSet" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:when>
<xsl:otherwise>
<xsl:element name="characterSet" >
utf8
</xsl:element>
</xsl:otherwise>
</xsl:choose>

<xsl:for-each select="./dcterms:spatial">
  <xsl:choose>
		<xsl:when test="contains(translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower), 'northlimit')">
    <!-- creates multiple and separate GeographicBoundingBox -->
	    <xsl:element name="extent">
	      <xsl:element name="EX_Extent">
	        <xsl:element name="geographicElement">
					  <xsl:element name="EX_GeographicBoundingBox">
  			      <xsl:element name="westBoundLongitude">
	              <xsl:value-of select="substring-before(substring-after(., 'westlimit='), ';')"/>
	            </xsl:element>
	            <xsl:element name="eastBoundLongitude">
	             	<xsl:value-of select="substring-before(substring-after(., 'eastlimit='), ';')"/>
		          </xsl:element>
              <xsl:element name="southBoundLatitude">
               	<xsl:value-of select="substring-before(substring-after(., 'southlimit='), ';')"/>
              </xsl:element>
   	          <xsl:element name="northBoundLatitude">
               	<xsl:value-of select="substring-before(substring-after(., 'northlimit='), ';')"/>
              </xsl:element>					
					  </xsl:element>
	        </xsl:element>
	      </xsl:element>
	    </xsl:element>
		</xsl:when>

    <xsl:otherwise>
      <xsl:element name="extent" >
        <xsl:element name="EX_Extent" >
          <xsl:element name="EX_GeographicDescription" >
            <xsl:element name="geographicIdentifier" >
              <xsl:element name="MD_Identifier" >
                <xsl:element name="code" >
                  <xsl:value-of select="." />
                </xsl:element>
                <xsl:if test="./@xsi:type" >
                  <xsl:element name="authority" >
                    <xsl:element name="CI_Citation" >
                      <xsl:element name="title" >
                        <xsl:value-of select="./@xsi:type" />
                      </xsl:element>
                      <xsl:element name="date" >
                        <xsl:element name="CI_Date" >
                          <xsl:element name="date" >
                            <xsl:text>0000-00-00</xsl:text>
                          </xsl:element>
                          <xsl:element name="dateType" >
                            <xsl:text>publication</xsl:text>
                          </xsl:element>
                        </xsl:element>
                      </xsl:element>
                    </xsl:element>
                  </xsl:element>
                </xsl:if>
              </xsl:element>
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:otherwise>
  </xsl:choose>
</xsl:for-each>

<xsl:for-each select="dcterms:temporal" >
	<xsl:if test="contains(translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower), 'begin')">
    <xsl:element name="extent" >
      <xsl:element name="EX_Extent" >
        <xsl:element name="temporalElement" >
          <xsl:element name="EX_TemporalExtent" >
            <xsl:element name="extent" >
     					<xsl:element name="TimePeriod">
    					  <xsl:element name="begin">
    					    <xsl:element name="TimeInstant">
    					      <xsl:element name="timePosition">
      					      <xsl:value-of select="substring-before(substring-after(., 'begin='), ';')"/>
    						    </xsl:element>
   						    </xsl:element>
 						    </xsl:element>
     						<xsl:element name="end">
    					    <xsl:element name="TimeInstant">
    					      <xsl:element name="timePosition">
		                  <xsl:value-of select="substring-before(substring-after(., 'end='), ';')"/>
    						    </xsl:element>
   						    </xsl:element>
		            </xsl:element>
					    </xsl:element>
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:if>
</xsl:for-each>


</xsl:element>
</xsl:element>

<!-- DISTRIBUTION INFO -->

<xsl:element name="distributionInfo" >
  <xsl:element name="MD_Distribution" >

    <xsl:for-each select="dc:format" >
      <xsl:element name="distributionFormat" >
        <xsl:element name="MD_Format" >
          <xsl:element name="name" >
            <xsl:value-of select="." />
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:for-each>

    <xsl:for-each select="./dc:identifier">
       <xsl:variable name="identifierVar">
        <!-- it's translated to lower case -->
          <xsl:value-of select="translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower)"/>
        </xsl:variable>
        <xsl:if test="contains($identifierVar, 'file')
            or contains($identifierVar, 'http')
            or contains($identifierVar, 'ftp')
            or contains($identifierVar, 'www')">
          <xsl:element name="transferOptions">
            <xsl:element name="MD_DigitalTransferOptions">
              <xsl:element name="onLine">
                <xsl:element name="CI_OnlineResource">
                  <xsl:element name="linkage">
                    <xsl:value-of select="."/>
                  </xsl:element>
                </xsl:element>
              </xsl:element>
            </xsl:element> 
          </xsl:element>
        </xsl:if>
     </xsl:for-each>

<!-- it does not check the first occurrence with domain URI -->
</xsl:element>
</xsl:element>

<!-- DATA QUALITY INFO -->

<xsl:element name="dataQualityInfo" >
  <xsl:element name="DQ_DataQuality" >

    <xsl:element name="lineage" >
      <xsl:element name="LI_Lineage" >

        <xsl:for-each select="dcterms:provenance[1]" >
          <xsl:element name="statement" >
            <xsl:value-of select="." />
          </xsl:element>
        </xsl:for-each>

        <xsl:for-each select="dc:source" >
          <xsl:element name="source" >
            <xsl:element name="LI_Source" >
              <xsl:element name="description" >
                <xsl:value-of select="." />
              </xsl:element>
            </xsl:element>
          </xsl:element>
        </xsl:for-each>


      </xsl:element>
    </xsl:element>
  </xsl:element>

</xsl:element>



</xsl:element>

</xsl:template>
</xsl:stylesheet>
