<?xml version="1.0" encoding="UTF-8" ?>
<!-- 25/05/2007 jesusb
	- Se añade compatibilidad con espacios de nombres
	- Mejora de la estética de presentación de metadatos (por petición del IGN):
		1. Generación de un índice al principio de la página HTML. Para ello se han añadido
		dos parámetros nuevos: "g-create-index" y "g-level-index".
		2. Eliminación de los Tipos de Datos en la presentación: Para ello, en los 
		xml de traducción se utiliza la etiqueta especial ##ignore##
		3. Mejora de los css asociados.
	- Mejora de la representación del SchemaAscii de ISO19115
-->

<!-- 16/09/2005	criszs	
		 Modificada para que:
		  Lee las etiquetas y las escribe usando un template u otro dependiendo 
		   de si es un nodo con valor o no. 
		  Genera los siguientes tipos de elementos HTML:
		  	DIV - para etiquetas de nodos que tienen hijos
		  	LI - para etiquetas de nodos que no tienen hijos
		  	P - para los valores de los nodos
		  Se utiliza la siguiente nomenclatura:
		  	section nn : 	para etiquetas de nodos que tienen hijos
		  	section nn l : para etiquetas de nodos que no tienen hijos
		  	section nn v : para los valores de los nodos
		  	donde nn es el número de orden de las etiquetas según el grado de indentación.
		  Ejemplo: DIV.section1 - Sección correspondiente a nodos descendientes directos del raiz
		           LI.section2l - Muestra la etiqueta de un nodo sin hijos
		           P.section2v - Muestra el valor del nodo anterior
		  Utiliza los estilos de página del fichero CSS que se le pasa como
		   parámetro: g-css-style-URI y que debe contener formato para todos 
		   los elementos.
-->

<!-- 22/2/2005	jnog	
     Hoja de estilo XSL tomada de la página http://www.ngdc.noaa.gov/metadata/xslt/ 
     para generar presentaciones en texto flexibles.
     Utiliza un fichero XML adicional que traduce cada tag xml por su etiqueta legible.
     Indenta cada elemento segun su profundidad en el arbol XML
     Ha sido modificada para generar documentos HTML
     Hay que modificar el parametro g-tag-translation-URI para configurar la referencia
     al XML que contiene la correspondencia tag-etiqueta legible para un estandar e idioma concreto
-->

<!--
xml-to-text.xsl, version 1.0, 06/August/2002

This stylesheet transforms files from XML format to text format. It
was written with the idea of transforming FGDC metadata records, but
could be used for other types of XML files. The code could probably
stand to be cleaned up.
The stylesheet works as follows: The tags of the XML source document
are replaced by labels that are read from an external lookup table
(more about this below). Attributes associated with the tags are
ignored. If a tag appears in the source document and does not have a
translation, no tag label will be written. The element itself will
still be processed, however.
Handling of the content of the XML elements depends on type of<div>
element. A compound element, which contains other elements, will
display those elements indented at a level that corresponds to the
nesting level. An element that contains text will display formatted
text. The look of the text depends on a global parameter. The default
is to display text with the same line wrapping as the original XML
file, but with indentation altered to fit the current indentation
level. This option would make sense if the XML source already had line
breaks that should be preserved. The other option is to fold lines so
they are no longer than a maximum specified length. Lines at broken at
some specified character (typically a space). If it is not possible to
break a line so that its length is less than the maximum length, then
it will be broken at the first possible place after the maximum
length. This option would make sense for documents with elements that
contain long blocks of text without line breaks. XML elements
containing mixed content (other XML elements as well as text) are
treated as compound elements, and the text is ignored. XML elements
such as comments and CDATA elements are ignored.

As an example, the following input:
<foo>
<bar>
        Text.
</bar>
<baz>
<quux>
        Even more text.
        On two or
        three lines.
</quux>
</baz>
</foo>

will be translated to:
Foo:
  Bar: Text
  Baz:
    Quux: Even more text.
      On two or
      three lines.

if using the default settings and assuming tag translations of the
nature of foo -> Foo.
This stylesheet relies on an external XML document to provide a
translation from the XML tag names to the words or phrases that
explain the tags. That document is accessed via the document call in
the match=* template. The document URI is contained in a global
parameter. Change the global parameter as appropriate. In particular
if delivering this stylesheet to a browser to apply the transform, be
sure that the URI refers to a network accessible resource. The format
of the external document should be:
<names>
  <name tagname="idinfo">Identification Information</name>
  <name tagname="citation">Citation</name>
...
</names>

The <name> elements should have the XML tag as a tagname attribute and
the translation as the content of the element.

This stylesheet has been tested with Xalan 2.4.D1 and Saxon 6.5.2.
This stylesheet was developed by Joseph Shirley of
Systems Engineering and Security Incorporated
Suite 700
Greenbelt, Maryland 20770
on behalf of
The National Oceanographic Data Center
1315 East West Highway
Silver Spring, MD 20910
-->

<!-- Top level directives -->

<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:dyn="http://exslt.org/dynamic" 
 xmlns:gmd="http://www.isotc211.org/2005/gmd" 
 xmlns:gco="http://www.isotc211.org/2005/gco" 
 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
 xmlns:dc="http://purl.org/dc/elements/1.1/">
<!--method="text/html"-->  
<xsl:output encoding="UTF-8"/>


<!-- Global parameters -->

<!-- 
  g-tag-translation-URI 
    This parameter specifies the URI of the external document
    containing the lookup table for the tag name translation. The
    default is the name of a file in the same directory as the
    stylesheet. Make sure this is a network accessible URI if
    delivering to a browser for translation.
-->
<xsl:param name="g-tag-translation-URI" select="'ISO19139_elements_es.xml'"/>

<!-- 
  g-css-style-URI 
    This parameter specifies the URI of the external document
    containing the style or the HMTL page (file .css). The
    default is the name of a file in the same directory as the
    stylesheet. Make sure this is a network accessible URI if
    delivering to a browser for translation.
-->
<xsl:param name="g-css-style-URI" select="'HTML_IGN_style.css'"/>

<!-- 
  g-metadata-title
    This parameter specifies the title of the metadata. 
    It has no default value.
-->
<xsl:param name="g-metadata-title" select="''"/>

<!-- 
  g-metadata-title-path
    This parameter specifies the xml-path of the title of the metadata. 
    It has no default value.
-->
<xsl:param name="g-metadata-title-path" select="'MD_Metadata/identificationInfo/MD_DataIdentification/citation//title'"/>

<!--
	Parámetro que permite configurar si se debe construir el índice
-->
<xsl:param name="g-create-index" select="'true'"/>
<!--
	En qué nivel se encuentran los elementos para construir en índice
-->
<xsl:param name="g-level-index" select="1"/>

<!-- Global variables -->

<!--
	sección en la que se encuentran los elementos para construir en índice
-->
<xsl:variable name="sectionIndex" select="concat('section', $g-level-index)"/>


<!-- Templates -->

<xsl:template match="/">
	<HTML>
		<HEAD>
			<!-- Incluimos el CSS a utilizar para el estilo -->
			<link rel="stylesheet" href="{$g-css-style-URI}" type="text/css" />
			<!-- Incluimos una función JavaScript para decodeificar imágenes en Base64-->
			<script>
				<xsl:comment>
					<xsl:text>
						function writeBase64Image(base64str){
							var userAgent = navigator.userAgent;
							var version = parseFloat(navigator.appVersion);
							if ((userAgent.indexOf('MSIE') >= 0 &amp;&amp; version >= 7.0) || 
							  userAgent.indexOf('Firefox') >= 0 || 
							  userAgent.indexOf('Opera') >= 0){
								document.write('&lt;img src=&quot;data:image;base64,' + base64str + '&quot;&gt;');
							}
						}//</xsl:text>
				</xsl:comment>
			</script>
		</HEAD>
		
		<BODY>
			<!-- Escribimos el título de la página solo si el metadato tiene titulo -->
			<xsl:choose>
				<xsl:when test="string-length($g-metadata-title) &gt; 0">	
						<DIV class="pageTitle"><xsl:value-of select='$g-metadata-title'/></DIV>
						<BR/>
				</xsl:when>
				<xsl:when test="string-length($g-metadata-title-path) &gt; 0">
					<xsl:if test="string-length(dyn:evaluate($g-metadata-title-path)) &gt; 0">
						<DIV class="pageTitle"><xsl:value-of select='dyn:evaluate($g-metadata-title-path)'/></DIV>
						<BR/>
					</xsl:if>
				</xsl:when>
			</xsl:choose>

			<!-- Escribimos el índice -->
			<xsl:if test="translate($g-create-index, 'TRUE', 'true') = 'true'"> 
				<xsl:call-template name="index">
					<xsl:with-param name="content" select="*"/>
					<xsl:with-param name="section" select="0"/>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Escribimos el contenido del metadato -->
			<xsl:apply-templates select="*" mode="body"/>
		</BODY>
	</HTML>
</xsl:template>


<!--
	Este template crea un índice con las secciones del metadato
-->
<xsl:template name="index">
	 <xsl:param name="content"/> 
	 <xsl:param name="section"/>
	
	<xsl:choose>		
		<xsl:when test="$section &lt; $g-level-index">
		<!-- hacemos llamadas recursivas hasta encontrarnos en la seción del metadato que contiene los elementos del índice -->
			<xsl:call-template name="index">
				<xsl:with-param name="content" select="$content/*"/>
				<xsl:with-param name="section" select="number($section) + 1"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
		<!-- creamos el índice -->
			<xsl:variable name="index-translation" select="document($g-tag-translation-URI)/*/name[@tagname='index']"/> 
		     	<div class="indexTitle"><a name="index">
		     	<xsl:value-of select="$index-translation"/>
		     	</a></div>
			<ul>

			<!-- Llamamos a la plantilla que irá construyendo el índice -->
			<xsl:call-template name="discoverIndex">
				<xsl:with-param name="content" select="$content"/>				
			</xsl:call-template>
			
	      		</ul>
	      		<br/>
     		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!--
	Este template va recorriendo todos los nodos situados en el nivel actual, creando las correspondientes entradas
	en el índice para cada uno de ellos. Se llama recursivamente a sí misma para ir almacenando una lista de nodos
	ya tratados, de manera que si el nombre del nodo que se desea tratar no está en dicha lista, se tratarán todos 
	los nodos con dicho nombre. Si el nombre del nodo se encuentra en la lista, no se hará nada con el nodo porque
	ya habrá sido tratado anteriormente.
-->
<xsl:template name="discoverIndex">
	<xsl:param name="content"/>	<!-- contenido del XML sobre el que se aplicará la función -->
	<xsl:param name="listedTags" select="''"/>	<!-- lista de nombres de nodos tratados hasta el momento -->
	<xsl:param name="tagposition" select="1"/>	<!-- Posición del nodo que se quiere tratar en el XML -->
	<xsl:variable name="actualElement" select="$content[position() = $tagposition]"/> <!-- Nodo situado en la posicion indicada-->

	<!-- Si el nombre de los nodos que se van a tratar (todos ellos tienen el mismo nombre) está en la lista de nodos
		ya tratados, no se hace nada -->
	<xsl:if test="not(contains($listedTags, concat('#', name($actualElement), '#')))">
		<!-- listamos todos los nodos que se llaman igual que el que se quiere tratar -->
		<xsl:variable name="nodeList1" select="$content[name() = name($actualElement)]"/>
		<!-- nos quedamos unicamente con los nodos que tienen valor -->
		<xsl:variable name="nodeList" select="$nodeList1[string-length(normalize-space(.)) &gt; 0]"/>
			
		<xsl:if test="count($nodeList) &gt; 0"> <!-- si no hay ningun nodo a tratar, no hacemos nada -->
			<li class="index"><div>
			<xsl:for-each select="$nodeList">	<!-- tratamos cada nodo -->
				<xsl:variable name="tagname" select="name()"/>		<!-- Nombre del nodo -->

			 	<xsl:choose>
					<xsl:when test="count($nodeList) &gt; 1">
					<!-- Si hay mas de un nodo, se crea una entrada en el indice poniendo entre parentesis
						los enlaces a cada uno de los nodos -->
						<xsl:choose>
							<xsl:when test="position() = 1"> 
								<a href="#{generate-id()}">
								<xsl:call-template name="writeLabelTranslation">
		      							<xsl:with-param name="tagname" select="$tagname"/>
					            			<xsl:with-param name="ignore" select='false()'/>
								</xsl:call-template>
								<xsl:value-of select="concat(' (', position())"/>
								</a>
							</xsl:when>
							<xsl:when test="position() = count($nodeList)">
								<a href="#{generate-id()}">
									<xsl:value-of select="concat(', ', position(), ')')"/>
								</a>
							</xsl:when>
							<xsl:otherwise>
								<a href="#{generate-id()}">
									<xsl:value-of select="concat(', ', position())"/>
								</a>
							</xsl:otherwise>
						</xsl:choose>					
					</xsl:when>
					<xsl:otherwise>
					<!-- Si solo hay un nodo, se crea una entrada normal en el indice -->
						<a href="#{generate-id()}">
						<xsl:call-template name="writeLabelTranslation">
			       			<xsl:with-param name="tagname" select="$tagname"/>
					            	<xsl:with-param name="ignore" select='false()'/>
						</xsl:call-template>
						</a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			</div>
			</li>
		</xsl:if>
	</xsl:if>		
	<!-- Si todavía hay más nodos, hacemos una llamada recursiva a la misma función, indicando que tiene que
		tratar el nodo situado en la siguiente posición, y añadiendo el nombre del nodo actual a la lista de nodos
		ya tratados -->
	<xsl:if test='$tagposition &lt; count($content)'>
		<xsl:call-template name="discoverIndex">
			<xsl:with-param name="content" select="$content"/>
			<xsl:with-param name="tagposition" select="$tagposition + 1"/>
			<xsl:with-param name="listedTags" select="concat($listedTags, '#', name($actualElement), '#')"/>
		 </xsl:call-template>
	 </xsl:if>
</xsl:template>

<!--
  Apply to all elements. Determine whether it's a compound or text element
  and call the appropriate template.
-->
<xsl:template mode="body" match="*">
  <xsl:param name="sectionNumber" select="0"/> <!-- Numero de seccion: Se utiliza en el .css -->
  <xsl:param name="increment" select="1"/>
  <xsl:variable name="tagname" select="name()"/>  <!-- Etiqueta -->
  <xsl:variable name="t-original-string" select="normalize-space(.)"/> <!-- Contenido de la etiqueta -->
  <xsl:variable name="section" select="concat('section', $sectionNumber)"/>
 
  <xsl:if test="$sectionNumber >= $g-level-index">  <!-- Ignoramos las etiqueta de los nodos anteriores al índice -->
   <xsl:if test="string-length($t-original-string) &gt; 0">  <!-- Solo los mostramos si alguno de sus hijos tiene valores -->
	<xsl:choose>
		<xsl:when test="count(*)=0"> <!-- Si no tiene dentro mas hijos -->
			<xsl:variable name="translated-code" select="document($g-tag-translation-URI)/*/name[@tagname=$t-original-string]"/> <!-- TRADUCCION DEL CODIGO --> 
			<xsl:choose>
				<xsl:when test="string-length($translated-code) &gt; 0"> <!-- HE ENCONTRADO TRADUCCION DE CODIGO -->
				<!-- Llamamos a la platilla para escribir etiqueta mas valor (no tiene mas hijos) -->  
					<xsl:call-template name="writeLabelAndValue">
						<xsl:with-param name="section" select="$section"/>
						<xsl:with-param name="text-value" select="$translated-code"/>
						<xsl:with-param name="tagname" select="$tagname"/>
						<xsl:with-param name="search">'</xsl:with-param>
						<xsl:with-param name="replace">\'</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
				<!-- Llamamos a la platilla para escribir etiqueta mas valor (no tiene mas hijos) -->  
					<xsl:call-template name="writeLabelAndValue">
						<xsl:with-param name="section" select="$section"/>
						<xsl:with-param name="text-value" select="$t-original-string"/>
						<xsl:with-param name="tagname" select="$tagname"/>
						<xsl:with-param name="search">'</xsl:with-param>
						<xsl:with-param name="replace">\'</xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
	      	<!-- Llamamos a la platilla para escribir solo etiqueta (si que tiene hijos) -->  
			<xsl:call-template name="writeLabel">
				<xsl:with-param name="section" select="$section"/>
				<xsl:with-param name="tagname" select="$tagname"/>
				<xsl:with-param name="search">'</xsl:with-param>
				<xsl:with-param name="replace">\'</xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
   </xsl:if>  
  </xsl:if>   
 
  <!-- Recorremos el arbol -->
  <xsl:choose>
    <xsl:when test="*">
      <xsl:comment>This is a compound element (i.e. it has children)</xsl:comment> 
			<xsl:apply-templates select="*" mode="body">
			  <xsl:with-param name="sectionNumber" select="number($sectionNumber) + number($increment)"/>
			</xsl:apply-templates>
    </xsl:when>     
  </xsl:choose>  
  
  <!-- Imprimimos la separación entre secciones y el enlace al índice-->
  <xsl:if test="$sectionNumber  >= $g-level-index">  <!-- Ignoramos las etiqueta de los nodos anteriores al índice -->
  	<xsl:if test="string-length($t-original-string) &gt; 0">  <!-- Solo mostramos si alguno de sus hijos tiene valores -->
  		<xsl:if test="$section = $sectionIndex">
	  		
  			<xsl:if test="translate($g-create-index, 'TRUE', 'true') = 'true'"> 
				<xsl:variable name="home-translation" select="document($g-tag-translation-URI)/*/name[@tagname='home']"/> 
				<a href="#index" class="index"> <xsl:value-of select="$home-translation"/></a>				
			</xsl:if>
			<br/>
  		</xsl:if>  
  	</xsl:if>  
  </xsl:if>
</xsl:template>

<!--
	Este template muestra la etiqueta correspondiente a un nodo que tiene hijos
-->
<xsl:template name="writeLabel">
	<xsl:param name="section"/>
	<xsl:param name="tagname"/>
	
	<!-- Si el elemento pertenece a la sección 1, se le añade la referencia para el hipervínculo -->
	<xsl:if test="$section = $sectionIndex">
		<a name="{generate-id()}"/>
	</xsl:if>
	<!-- Escribimos la etiqueta -->		
	<xsl:call-template name="writeLabelTranslation">
       	<xsl:with-param name="tagname" select="$tagname"/>
            	<xsl:with-param name="section" select="$section"/>
	</xsl:call-template>  

</xsl:template>

<!--
	Este template muestra la etiqueta correspondiente a un nodo que no tiene hijos,
	con lo que mostrará la etiqueta y el valor (si lo tiene)
-->
<xsl:template name="writeLabelAndValue">
	<xsl:param name="section"/>
	<xsl:param name="text-value"/> <!-- Texto que esta entre las etiquetas -->
	<xsl:param name="tagname"/> <!-- Etiqueta original del nodo (sin traducir) -->
	
	<xsl:variable name="hidden" select="document($g-tag-translation-URI)/*/name[@tagname=$tagname]/@hidden"/>

	<xsl:if test="$section = $sectionIndex">
		<a name="{generate-id()}"/>
		<xsl:call-template name="writeLabelTranslation">
			<xsl:with-param name="tagname" select="$tagname"/>
	       	<xsl:with-param name="section" select="$section"/>
	       </xsl:call-template> 
	</xsl:if>
	<!-- Escribimos la etiqueta y el valor -->
	<div>
		<LI class="{concat($section, 'l')}">
			<xsl:if test="string-length(normalize-space($hidden)) = 0">
				<xsl:if test="$section != $sectionIndex">
					<xsl:call-template name="writeLabelTranslation">
						<xsl:with-param name="tagname" select="$tagname"/>
						<xsl:with-param name="appendChar" select="': '"/>
       				</xsl:call-template> 	
				</xsl:if>
			</xsl:if>
			<P class="{concat($section, 'v')}">
				<xsl:choose>
				<!-- Tratamiento especial para la codificación en Base 64 -->
					<xsl:when test="contains($text-value, '%%%%%%%%%%%%%%%%%PREVIEW BASE64%%%%%%%%%%%%%%%%%')">
						<br/>
						<script>
							<xsl:comment><xsl:text>&#10;</xsl:text>
								<xsl:value-of select="concat('writeBase64Image(&quot;',substring-after($text-value, '%%%%%%%%%%%%%%%%%PREVIEW BASE64%%%%%%%%%%%%%%%%%'), '&quot;);//')"/>
							</xsl:comment>
						</script>
					</xsl:when>
				<!-- Tratamiento especial para el elemento schemaAscii de ISO19115-->
					<xsl:when test="contains($tagname, 'schemaAscii')">
						<br/>
						<xsl:variable name="schemaAscii" select="substring-after($text-value, '?&gt;')"/>
							<xsl:call-template name="formatInnerXml">
								<xsl:with-param name="content" select="$schemaAscii"/>
								<xsl:with-param name="sectionNumber" select="substring-after($section, 'section') + 1"/>
							</xsl:call-template>
					</xsl:when>					
					<xsl:otherwise>
						<xsl:value-of select="$text-value"/>
					</xsl:otherwise>
				</xsl:choose>
			</P>
		</LI>
	</div>
</xsl:template>

<xsl:template name="formatInnerXml">
	<xsl:param name="content"/>  
	<xsl:param name="sectionNumber"/>
	
	<xsl:variable name="section" select="concat('section', $sectionNumber)"/>
	<xsl:variable name="lessThan" select="'&lt;'"/>
	<xsl:variable name="greaterThan" select="'&gt;'"/>
	<xsl:variable name="labelContent" select="substring-before(substring-after($content, $lessThan), $greaterThan)"/>
	<xsl:variable name="contentWithoutLabel" select="substring-after($content, $greaterThan)"/>
	
	<xsl:choose>		
		<xsl:when test="not(contains($labelContent, '/'))">					
			<xsl:variable name="elementContent" select="substring-before($contentWithoutLabel, concat($lessThan, '/' , $labelContent, $greaterThan))"/>
			<xsl:if test="string-length($elementContent) &gt; 0">
				<xsl:choose>
					<xsl:when test="not(contains($elementContent, $lessThan))">	
						<LI class="{concat($section, 'l')}">				
							<xsl:call-template name="writeLabelTranslation">
								<xsl:with-param name="tagname" select="$labelContent"/>
	       						<xsl:with-param name="appendChar" select="': '"/>
	      						 </xsl:call-template> 
	      						<P class="{concat($section, 'v')}">
								<xsl:value-of select="$elementContent"/>
							</P>
						</LI>
					</xsl:when>
					<xsl:otherwise>
						<LI class="{concat($section, 'l')}">
							<xsl:call-template name="writeLabelTranslation">
								<xsl:with-param name="tagname" select="$labelContent"/>
	       						<xsl:with-param name="appendChar" select="': '"/>
	      						 </xsl:call-template> 
							<xsl:call-template name="formatInnerXml">
								<xsl:with-param name="content" select='$elementContent'/>
								<xsl:with-param name="sectionNumber" select="$sectionNumber+1"/>
							</xsl:call-template>
						</LI>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>	
			
			<xsl:variable name="otherElements" select="substring-after($contentWithoutLabel, concat($lessThan, '/' , $labelContent, $greaterThan))"/>
			<xsl:if test="string-length($otherElements) &gt; 0">
				<xsl:call-template name="formatInnerXml">
					<xsl:with-param name="content" select='$otherElements'/>
					<xsl:with-param name="sectionNumber" select="$sectionNumber"/>
				</xsl:call-template>
			</xsl:if>	
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="string-length($contentWithoutLabel) &gt; 0">
				<xsl:call-template name="formatInnerXml">
					<xsl:with-param name="content" select='$contentWithoutLabel'/>
					<xsl:with-param name="sectionNumber" select="$sectionNumber"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!--
	Este template escribe la etiqueta traducida en el idioma apropiado. Primero busca en el fichero de traducciones la etiqueta junto al namespace (Ej: "dc:title"). Si no encuentra traducción, busca sólo la etiqueta (Ej: "title"), y si tampoco encuentra traducción, escribe en el fichero de salida la etiqueta tal cual.
	En caso de que la traducción sea "##ignore##", no escribirá nada en el fichero de salida. Este comportamiento se puede configuar mediante el parámetro "ignore".
-->
<xsl:template name="writeLabelTranslation">
	<xsl:param name="tagname"/>
	<xsl:param name="section"/>
	<xsl:param name="appendChar" select="''"/>
	<xsl:param name="ignore" select='true()'/>
		
	<xsl:variable name="tag-translation" select="document($g-tag-translation-URI)/*/name[@tagname=$tagname]"/> 	
	<xsl:variable name="tag-withouth-ns-translation" select="document($g-tag-translation-URI)/*/name[@tagname=substring-after($tagname,':')]"/>

	<!-- Imprimimos la traducción de la etiqueta-->
	<xsl:choose>
		<!-- Buscamos la traducción a la etiqueta junto al espacio de nombres (Ej: "dc:title") -->
     		<xsl:when test="string-length(normalize-space($tag-translation)) &gt; 0">
     			<xsl:choose>
				<xsl:when test="contains($tag-translation, '##ignore##')">
					<xsl:if test="$ignore = false()">
						<xsl:call-template name="writeLabelIntoDivSection">
       						<xsl:with-param name="text" select="$tagname"/>
            						<xsl:with-param name="section" select="$section"/>
            						<xsl:with-param name="appendChar" select="$appendChar"/>
						</xsl:call-template>  						
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
						<xsl:call-template name="writeLabelIntoDivSection">
       						<xsl:with-param name="text" select="$tag-translation"/>
            						<xsl:with-param name="section" select="$section"/>
            						<xsl:with-param name="appendChar" select="$appendChar"/>
						</xsl:call-template> 
				</xsl:otherwise>
			</xsl:choose>	
     		</xsl:when>
     		<!-- Buscamos la traducción a la etiqueta sin el espacio de nombres (Ej: "title") -->     		
     		<xsl:when test="string-length(normalize-space($tag-withouth-ns-translation)) &gt; 0">
     			<xsl:choose>
				<xsl:when test="contains($tag-withouth-ns-translation, '##ignore##')">
					<xsl:if test="$ignore = false()">
						<xsl:call-template name="writeLabelIntoDivSection">
       						<xsl:with-param name="text" select="$tagname"/>
            						<xsl:with-param name="section" select="$section"/>
            						<xsl:with-param name="appendChar" select="$appendChar"/>
						</xsl:call-template>						
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
						<xsl:call-template name="writeLabelIntoDivSection">
       						<xsl:with-param name="text" select="$tag-withouth-ns-translation"/>
            						<xsl:with-param name="section" select="$section"/>
            						<xsl:with-param name="appendChar" select="$appendChar"/>
						</xsl:call-template>							
				</xsl:otherwise>
			</xsl:choose>     		
     		</xsl:when>
     		<!-- Imprimos la etiqueta tal cual--> 
     		<xsl:otherwise>
			<xsl:call-template name="writeLabelIntoDivSection">
       			<xsl:with-param name="text" select="$tagname"/>
            			<xsl:with-param name="section" select="$section"/>
            			<xsl:with-param name="appendChar" select="$appendChar"/>
			</xsl:call-template>							
		</xsl:otherwise>
	</xsl:choose>	
</xsl:template>

<!--
	Este template escribe un texto dentro de una etiqueta <div> identificada con el nombre de la sección que se le ha pasado como parámetro. Si la sección se corresponde con el nivel de sección a partir del cual se genera el índice,  se añadirá una etiqueta <span> que se identificará como "sectionIndex". En caso de no pasar este parámetro, se escribirá únicamente el texto.
-->

<xsl:template name="writeLabelIntoDivSection">
	<xsl:param name="text"/>
	<xsl:param name="section"/>
	<xsl:param name="appendChar" select="''"/>
	<xsl:variable name="isSectionIndex" select="$section = $sectionIndex"/>

	<xsl:choose>
		<xsl:when test="string-length($section) &gt; 0">
			
			<xsl:choose>
				<xsl:when test="$isSectionIndex">
					<div class="sectionIndex">
						<xsl:value-of select="$text"/>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="{$section}">
						<xsl:value-of select="$text"/>
					</div>
				</xsl:otherwise>
			</xsl:choose>

		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$text"/>
			<xsl:value-of select="$appendChar"/>
		</xsl:otherwise>
	</xsl:choose>
	
</xsl:template>

</xsl:stylesheet>