<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
<xsl:template match="MD_Metadata" >
<xsl:element name="MD_Metadata" >
<xsl:element name="spatialRepresentationInfo" >
<xsl:element name="MD_VectorSpatialRepresentation" >
<xsl:for-each select="geometObjs" >
<xsl:element name="geometricObjects" >
<xsl:element name="MD_GeometricObjects" >
<xsl:for-each select="geoObjCnt" >
<xsl:element name="geometricObjectCount" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
<xsl:for-each select="geoObjTyp" >
<xsl:element name="geometricObjectType" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
</xsl:for-each>
</xsl:element>
<xsl:element name="MD_GridSpatialRepresentation" >
<xsl:element name="axisDimensionProperties" >
<xsl:for-each select="axDimProps" >
<xsl:element name="MD_Dimension" >
<xsl:for-each select="dimName" >
<xsl:element name="dimensionName" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
<xsl:for-each select="dimSize" >
<xsl:element name="dimensionSize" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:for-each>
</xsl:element>
<xsl:for-each select="numDims" >
<xsl:element name="numberOfDimensions" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
<xsl:element name="distributionInfo" >
<xsl:element name="MD_Distribution" >
<xsl:element name="distributionFormat" >
<xsl:element name="MD_Format" >
<xsl:for-each select="formatName" >
<xsl:element name="name" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
<xsl:for-each select="transferOptions" >
<xsl:element name="transferOptions" >
<xsl:element name="MD_DigitalTransferOptions" >
<xsl:element name="onLine" >
<xsl:element name="CI_OnlineResource" >
<xsl:for-each select="linkage" >
<xsl:element name="linkage" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
<xsl:for-each select="transferSize" >
<xsl:element name="transferSize" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
<xsl:element name="identificationInfo" >
<xsl:element name="MD_DataIdentification" >
<xsl:element name="graphicOverview" >
<xsl:element name="MD_BrowseGraphic" >
<xsl:for-each select="bgFileDesc" >
<xsl:element name="fileDescription" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
<xsl:for-each select="spatRpType" >
<xsl:element name="spatialRepresentationType" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
<xsl:element name="extent" >
<xsl:element name="EX_Extent" >
<xsl:element name="geographicElement" >
<xsl:element name="EX_GeographicBoundingBox" >
<xsl:for-each select="northBL" >
<xsl:element name="northBoundLatitude" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
<xsl:for-each select="southBL" >
<xsl:element name="southBoundLatitude" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
<xsl:for-each select="eastBL" >
<xsl:element name="eastBoundLongitude" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
<xsl:for-each select="westBL" >
<xsl:element name="westBoundLongitude" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:element>
<xsl:element name="spatialResolution" >
<xsl:element name="MD_Resolution" >
<xsl:element name="distance" >
<xsl:for-each select="scaleDist" >
<xsl:element name="value" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:element>

<xsl:element name="applicationSchemaInfo">
				<xsl:element name="MD_ApplicationSchemaInformation">
					<xsl:element name="schemaAscii">
						<xsl:text>&lt;?xml version = '1.0' encoding = 'ISO-8859-1'?>
						&lt;eainfo>
						</xsl:text>
						<xsl:for-each select="detailed">
						<xsl:text>&lt;detailed>
						</xsl:text>
							<xsl:text>&lt;enttyp>
							</xsl:text>
								<xsl:text>&lt;enttypl></xsl:text><xsl:value-of select="./catFetTyps"/>
							<xsl:text>&lt;/enttypl>
							</xsl:text>							
							<xsl:text>&lt;/enttyp>
							</xsl:text>
								<xsl:for-each select="./attr">
									<xsl:text>&lt;attr>
									</xsl:text>											
										<xsl:text>&lt;attrlabl></xsl:text><xsl:value-of select="./attrlabl"/>
										<xsl:text>&lt;/attrlabl>
										</xsl:text>												
										<xsl:text>&lt;attrdomv>
										</xsl:text>
											<xsl:text>&lt;udom></xsl:text><xsl:value-of select="./udom"/>
											<xsl:text>&lt;/udom>
											</xsl:text>
										<xsl:text>&lt;/attrdomv>
										</xsl:text>
										<xsl:text>&lt;/attr>
									</xsl:text>
								</xsl:for-each>
							<xsl:text>&lt;/detailed>
							</xsl:text>
						</xsl:for-each>
							<xsl:text>&lt;/eainfo>
							</xsl:text>
						</xsl:element>
					</xsl:element>
			</xsl:element>

<xsl:element name="contentInfo" >
<xsl:element name="MD_FeatureCatalogueDescription" >
<xsl:for-each select="detailed/catFetTyps" >
<xsl:element name="featureTypes" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:template>
</xsl:stylesheet>
