<?xml version='1.0' encoding='ISO-8859-1'?>
<!-- xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl" -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output encoding="ISO-8859-1"/>

<!-- An xsl template for displaying metadata in ArcInfo8 with the
     traditional FGDC look and feel created by mp
     Labels are displayed in Spanish
	
     History:   
     	Created 16/10/2001 IAAA, http://iaaa.cps.unizar.es
-->

<xsl:template match="/">
  <HTML>
  <BODY>

    <A name="Top"/>
    <H1><xsl:value-of select="metadata/idinfo/citation/citeinfo/title"/></H1>
    <H2>Metadatos:</H2>

    <UL>
      <xsl:for-each select="metadata/idinfo">
        <LI><A HREF="#Informacin_de_Identificacin">Informacin_de_Identificacin</A></LI>
      </xsl:for-each>
      <xsl:for-each select="metadata/dataqual">
        <LI><A HREF="#Informacin_de_Calidad_de_Datos">Informacin_de_Calidad_de_Datos</A></LI>
      </xsl:for-each>
      <xsl:for-each select="metadata/spdoinfo">
        <LI><A HREF="#Informacin_de_Organizacin_de_Datos_Espaciales">Informacin_de_Organizacin_de_Datos_Espaciales</A></LI>
      </xsl:for-each>
      <xsl:for-each select="metadata/spref">
        <LI><A HREF="#Informacin_de_Referencia_Espacial">Informacin_de_Referencia_Espacial</A></LI>
      </xsl:for-each>
      <xsl:for-each select="metadata/eainfo">
        <LI><A HREF="#Informacin_de_Entidad_y_Atributo">Informacin_de_Entidad_y_Atributo</A></LI>
      </xsl:for-each>

      <xsl:for-each select="metadata/distinfo">

      <xsl:choose>
        <xsl:when test="position()=1">

          <xsl:choose>
            <xsl:when test="position()=last()">
              <LI>
			<A HREF="#{generate-id()}">Informacin_de_Distribucin</A>
              </LI>
            </xsl:when>

            <xsl:otherwise>
              <LI>Informacin_de_Distribucin</LI>
              <LI STYLE="margin-left:0.3in">
		<A HREF="#{generate-id()}">Informacin_de_Distribucin</A>
              </LI>
            </xsl:otherwise>

          </xsl:choose>
        </xsl:when>

        <xsl:otherwise>
          <LI STYLE="margin-left:0.3in">
            <A HREF="#{generate-id()}">Informacin_de_Distribucin</A>
          </LI>
        </xsl:otherwise>
      </xsl:choose>

      </xsl:for-each>

      <xsl:for-each select="metadata/metainfo">
        <LI><A HREF="#Informacin_de_Referencia_de_Metadatos">Informacin_de_Referencia_de_Metadatos</A></LI>
      </xsl:for-each>
    </UL>

    <xsl:apply-templates select="metadata/idinfo"/>
    <xsl:apply-templates select="metadata/dataqual"/>
    <xsl:apply-templates select="metadata/spdoinfo"/>
    <xsl:apply-templates select="metadata/spref"/>
    <xsl:apply-templates select="metadata/eainfo"/>
    <xsl:apply-templates select="metadata/distinfo"/>
    <xsl:apply-templates select="metadata/metainfo"/>

  </BODY>
  </HTML>
</xsl:template>

<!-- Identification -->
<xsl:template match="idinfo">
  <A name="Informacin_de_Identificacin"><HR/></A>
  <DL>
    <DT><I>Informacin_de_Identificacin:</I></DT>
    <DD>
    <DL>
      <xsl:for-each select="citation">
        <DT><I>Cita:</I></DT>
        <DD>
        <DL>
          <xsl:apply-templates select="citeinfo"/>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="descript">
        <DT><I>Descripcin:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="abstract">
            <DT><I>Resumen:</I></DT>
            <DD><xsl:value-of select="."/></DD>      
          </xsl:for-each>

          <xsl:for-each select="purpose">
            <DT><I>Propsito:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>

          <xsl:for-each select="supplinf">
            <DT><I>Informacin_Suplementaria:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="timeperd">
        <DT><I>Perodo_Asociado_al_Contenido:</I></DT>
        <DD>
        <DL>
          <xsl:apply-templates select="timeinfo"/>
          <xsl:for-each select="current">
            <DT><I>Vigencia:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="status">
        <DT><I>Estatus:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="progress">
            <DT><I>Avance:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="update">
            <DT><I>Frecuencia_de_Mantenimiento_y_Actualizacin:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="spdom">
        <DT><I>Dominio_Espacial:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="bounding">
            <DT><I>Coordenadas_Lmites:</I></DT>
            <DD>
            <DL>
              <DT><I>Coordenada_Lmite_al_Oeste:</I> <xsl:value-of select="westbc"/></DT>
              <DT><I>Coordenada_Lmite_al_Este:</I> <xsl:value-of select="eastbc"/></DT>
              <DT><I>Coordenada_Lmite_al_Norte:</I> <xsl:value-of select="northbc"/></DT>
              <DT><I>Coordenada_Lmite_al_Sur:</I> <xsl:value-of select="southbc"/></DT>
            </DL>
            </DD>
          </xsl:for-each>
          <xsl:for-each select="dsgpoly">
            <DT><I>Polgono_Lmite_de_los_Datos:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="dsgpolyo">
                <DT><I>Polgono_Excludo_de_los_Datos:</I></DT>
                <DD>
                <DL>
                  <xsl:apply-templates select="grngpoin"/>
                  <xsl:apply-templates select="gring"/>
                </DL>
                </DD>
              </xsl:for-each>
              <xsl:for-each select="dsgpolyx">
                <DT><I>Polgono_Externo_de_los_Datos:</I></DT>
                <DD>
                <DL>
                  <xsl:apply-templates select="grngpoin"/>
                  <xsl:apply-templates select="gring"/>
                </DL>
                </DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="keywords">
        <DT><I>Palabras_Clave:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="theme">
            <DT><I>Tema:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="themekt">
                <DT><I>Tesauro_de_Palabras_Clave_de_Tema:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="themekey">
                <DT><I>Palabra_Clave_de_Tema:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="place">
            <DT><I>Lugar:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="placekt">
                <DT><I>Tesauro_de_Palabras_Clave_de_Lugar:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="placekey">
                <DT><I>Palabra_Clave_de_Lugar:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="stratum">
            <DT><I>Estrato:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="stratkt">
                <DT><I>Tesauro_de_Palabras_Clave_de_Estrato:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="stratkey">
                <DT><I>Palabra_Clave_de_Estrato:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
 
          <xsl:for-each select="temporal">
            <DT><I>Temporal:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="tempkt">
                <DT><I>Tesauro_de_Palabras_Clave_de_Tiempo:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="tempkey">
                <DT><I>Palabra_Clave_de_Tiempo:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="accconst">
        <DT><I>Restricciones_de_Acceso:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>
      <xsl:for-each select="useconst">
        <DT><I>Restricciones_de_Uso:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>

      <xsl:for-each select="ptcontac">
        <DT><I>Punto_de_Contacto:</I></DT>
        <DD>
        <DL>
          <xsl:apply-templates select="cntinfo"/>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="browse">
        <DT><I>Grficos_Para_Visualizar:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="browsen">
            <DT><I>Nombre_del_Archivo_de_Grficos_Para_Visualizar:</I> <A TARGET="viewer">
              <xsl:attribute name="HREF"><xsl:value-of select="."/></xsl:attribute>
              <xsl:value-of select="."/></A>
            </DT>
          </xsl:for-each>
          <xsl:for-each select="browsed">
            <DT><I>Descripcin_del_Archivo_de_Grficos_Para_Visualizar:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
          <xsl:for-each select="browset">
            <DT><I>Tipo_del_Archivo_de_Grficos_Para_Visualizar:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="datacred">
        <DT><I>Crdito_del_Conjunto_de_Datos:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>

      <xsl:for-each select="secinfo">
        <DT><I>Informacin_de_Seguridad:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="secsys">
            <DT><I>Sistema_de_Clasificacin_de_Seguridad:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="secclass">
            <DT><I>Clasificacin_de_Seguridad:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="sechandl">
            <DT><I>Descripcin_de_Manejo_de_Seguridad:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="native">
        <DT><I>Entorno_Original_de_los_Datos:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>

      <xsl:for-each select="crossref">
        <DT><I>Referencia_Cruzada:</I></DT>
        <DD>
        <DL>
          <xsl:apply-templates select="citeinfo"/>
        </DL>
        </DD>
      </xsl:for-each>

    </DL>
    </DD>
  </DL>
  <A HREF="#Top">Back to Top</A>
</xsl:template>

<!-- Data Quality -->
<xsl:template match="dataqual">
  <A name="Informacin_de_Calidad_de_Datos"><HR/></A>
  <DL>
    <DT><I>Informacin_de_Calidad_de_Datos:</I></DT>
    <DD>
    <DL>
      <xsl:for-each select="attracc">
        <DT><I>Precisin_de_Atributos:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="attraccr">
            <DT><I>Informe_Sobre_Precisin_de_Atributos:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
          <xsl:for-each select="qattracc">
            <DT><I>Determinacin_Cuantitativa_Sobre_Precisin_en_Atributos:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="attraccv">
                <DT><I>Valor_de_Precisin_de_Atributo:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="attracce">
                <DT><I>Descripcin_de_la_Precisin_del_Atributo:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="logic">
        <DT><I>Informe_Sobre_Consistencia_Lgica:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>
      <xsl:for-each select="complete">
        <DT><I>Informe_Sobre_Completitud:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>

      <xsl:for-each select="posacc">
        <DT><I>Precisin_de_la_Posicin:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="horizpa">
            <DT><I>Precisin_en_la_Horizontal:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="horizpar">
                <DT><I>Informe_Sobre_Precisin_en_la_Horizontal:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
              <xsl:for-each select="qhorizpa">
                <DT><I>Determinacin_Cuantitativa_Sobre_Precisin_en_la_Horizontal:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="horizpav">
                    <DT><I>Valor_de_Precisin_en_la_Horizontal:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                  <xsl:for-each select="horizpae">
                    <DT><I>Interpretacin_de_Precisin_Posicional_Horizontal:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
          <xsl:for-each select="vertacc">
            <DT><I>Precisin_en_la_Vertical:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="vertaccr">
                <DT><I>Informe_Sobre_Precisin_en_la_Vertical:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
              <xsl:for-each select="qvertpa">
                <DT><I>Determinacin_Cuantitativa_Sobre_Precisin_Posicional_en_la_Vertical:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="vertaccv">
                    <DT><I>Valor_de_Precisin_en_la_Vertical:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                  <xsl:for-each select="vertacce">
                    <DT><I>Interpretacin_de_Precisin_Posicional_Vertical:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="lineage">
        <DT><I>Historia:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="srcinfo">
            <DT><I>Informacin_de_la_Fuente:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="srccite">
                <DT><I>Cita_de_la_Fuente:</I></DT>
                <DD>
                <DL>
                  <xsl:apply-templates select="citeinfo"/>
                </DL>
                </DD>
              </xsl:for-each>
              <xsl:for-each select="srcscale">
                <DT><I>Denominador_de_Escala_de_la_Fuente:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="typesrc">
                <DT><I>Tipo_de_Medio_Fsico_de_la_Fuente:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>

              <xsl:for-each select="srctime">
                <DT><I>Perodo_Contenido_en_la_Fuente:</I></DT>
                <DD>
                <DL>
                  <xsl:apply-templates select="timeinfo"/>
                  <xsl:for-each select="srccurr">
                    <DT><I>Referencia_a_Vigencia_de_la_Fuente:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>

              <xsl:for-each select="srccitea">
                <DT><I>Abreviacin_de_Cita_de_la_Fuente:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
              <xsl:for-each select="srccontr">
                <DT><I>Contribucin_de_la_Fuente:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="procstep">
            <DT><I>Paso_del_Proceso:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="procdesc">
                <DT><I>Descripcin_del_Proceso:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
              <xsl:for-each select="srcused">
                <DT><I>Abreviatura_de_Cita_de_la_Fuente_Usada:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
              <xsl:for-each select="procdate">
                <DT><I>Fecha_del_Proceso:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="proctime">
                <DT><I>Hora_del_Proceso:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="srcprod">
                <DT><I>Abreviatura_de_Cita_de_la_Fuente_Producida:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
              <xsl:for-each select="proccont">
                <DT><I>Contacto_Por_el_Proceso:</I></DT>
                <DD>
                <DL>
                  <xsl:apply-templates select="cntinfo"/>
                </DL>
                </DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>
      <xsl:for-each select="cloud">
        <DT><I>Cubrimiento_por_Nubes:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>
    </DL>
    </DD>
  </DL>
  <A HREF="#Top">Back to Top</A>
</xsl:template>

<!-- Spatial Data Organization -->
<xsl:template match="spdoinfo">
  <A name="Informacin_de_Organizacin_de_Datos_Espaciales"><HR/></A>
  <DL>
    <DT><I>Informacin_de_Organizacin_de_Datos_Espaciales:</I></DT>
    <DD>
    <DL>
      <xsl:for-each select="indspref">
        <DT><I>Indirect_Spatial_Reference_Method:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>

      <xsl:for-each select="direct">
        <DT><I>Mtodo_de_Referencia_Espacial_Directa:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>

      <xsl:for-each select="ptvctinf">
        <DT><I>Informacin_de_Objetos_Punto_y_Vector:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="sdtsterm">
            <DT><I>Descripcin_de_Trminos_SDTS:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="sdtstype">
                <DT><I>Tipo_de_Objetos_Punto_y_Vector_SDTS:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="ptvctcnt">
                <DT><I>Cantidad_de_Objetos_Punto_y_Vector:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="vpfterm">
            <DT><I>Descripcin_de_Trminos_VPF:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="vpflevel">
                <DT><I>Nivel_de_Topologa_VPF:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="vpfinfo">
                <DT><I>VPF_Informacin_de_Objetos_Punto_y_Vector:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="vpftype">
                    <DT><I>Tipo_de_Objetos_Punto_y_Vector_VPF:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                  <xsl:for-each select="ptvctcnt">
                    <DT><I>Cantidad_de_Objetos_Punto_y_Vector:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="rastinfo">
        <DT><I>Informacin_Sobre_Objetos_Raster:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="rasttype">
            <DT><I>Tipo_de_Objetos_Raster:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="rowcount">
            <DT><I>Nmero_de_Objetos_Raster_en_Eje_Y:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="colcount">
            <DT><I>Nmero_de_Objetos_Raster_en_Eje_X:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="vrtcount">
            <DT><I>Nmero_de_Objetos_Raster_en_Eje_Z:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>
    </DL>
    </DD>
  </DL>
  <A HREF="#Top">Back to Top</A>
</xsl:template>

<!-- Spatial Reference -->
<xsl:template match="spref">
  <A name="Informacin_de_Referencia_Espacial"><HR/></A>
  <DL>
    <DT><I>Informacin_de_Referencia_Espacial:</I></DT>
    <DD>
    <DL>
      <xsl:for-each select="horizsys">
        <DT><I>Definicin_del_Sistema_de_Coordenadas_Horizontales:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="geograph">
            <DT><I>Geogrfico:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="latres">
                <DT><I>Resolucin_en_Latitud:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="longres">
                <DT><I>Resolucin_en_Longitud:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="geogunit">
                <DT><I>Unidades_de_las_Coordenadas_Geogrficas:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="planar">
            <DT><I>Plano:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="mapproj">
                <DT><I>Proyeccin_Cartogrfica:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="mapprojn">
                    <DT><I>Nombre_de_la_Proyeccin_Cartogrfica:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>

                  <xsl:for-each select="albers">
                    <DT><I>Iso_rea_Azimutal_de_Albers:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="azimequi">
                    <DT><I>Equidistante_Azimutal:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="equicon">
                    <DT><I>Cnica_Equidistante:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="equirect">
                    <DT><I>Equirrectangular:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="gvnsp">
                    <DT><I>Perspectiva_de_Costado_General_Vertical:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="gnomonic">
                    <DT><I>Nomnica:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="lamberta">
                    <DT><I>Iso_rea_Azimutal_de_Lambert:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="lambertc">
                    <DT><I>Cnica_Conforme_de_Lambert:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="mercator">
                    <DT><I>Mercator:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="modsak">
                    <DT><I>Estereogrfica_Modificada_Para_Alaska:</I></DT>
                    <DD>
                    <DL>
                      <xsl:apply-templates select="feast"/>
                      <xsl:apply-templates select="fnorth"/>
                    </DL>
                    </DD>
                  </xsl:for-each>
                  <xsl:for-each select="miller">
                    <DT><I>Cilndrica_de_Miller:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="obqmerc">
                    <DT><I>Mercator_Oblicuo:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="orthogr">
                    <DT><I>Ortogrfico:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="polarst">
                    <DT><I>Estereogrfico_Polar:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="polycon">
                    <DT><I>Policnico:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="robinson">
                    <DT><I>Robinson:</I></DT>
                    <DD>
                    <DL>
                      <xsl:apply-templates select="longpc"/>
                      <xsl:apply-templates select="feast"/>
                      <xsl:apply-templates select="fnorth"/>
                    </DL>
                    </DD>
                  </xsl:for-each>
                  <xsl:for-each select="sinusoid">
                    <DT><I>Sinusoidal:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="spaceobq">
                    <DT><I>Space_Mercator_Oblicuo_(Landsat):</I></DT>
                    <DD>
                    <DL>
                      <xsl:apply-templates select="landsat"/>
                      <xsl:apply-templates select="pathnum"/>
                      <xsl:apply-templates select="feast"/>
                      <xsl:apply-templates select="fnorth"/>
                    </DL>
                    </DD>
                  </xsl:for-each>
                  <xsl:for-each select="stereo">
                    <DT><I>Estereogrfica:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="transmer">
                    <DT><I>Mercator_Transverso:</I></DT>
                  </xsl:for-each>
                  <xsl:for-each select="vdgrin">
                    <DT><I>van_der_Grinten:</I></DT>
                  </xsl:for-each>

                  <xsl:apply-templates select="*"/>
                </DL>
                </DD>
              </xsl:for-each>

              <xsl:for-each select="gridsys">
                <DT><I>Sistema_de_Coordenadas_de_Cuadricula:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="gridsysn">
                    <DT><I>Nombre_de_Sistema_de_Coordenadas_de_Cuadricula:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>

                  <xsl:for-each select="utm">
                    <DT><I>Universal_Mercator_Transverso:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="utmzone">
                        <DT><I>Nmero_de_Zona_UTM:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="transmer">
                        <DT><I>Mercator_Transverso:</I></DT>
                      </xsl:for-each>
                      <xsl:apply-templates select="transmer"/>
                    </DL>
                    </DD>
                  </xsl:for-each>

                  <xsl:for-each select="ups">
                    <DT><I>Universal_Estereogrfico_Polar:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="upszone">
                        <DT><I>Identificador_de_Zona_UPS:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="polarst">
                        <DT><I>Estereogrfico_Polar:</I></DT>
                      </xsl:for-each>
                      <xsl:apply-templates select="polarst"/>
                    </DL>
                    </DD>
                  </xsl:for-each>

                  <xsl:for-each select="spcs">
                    <DT><I>Sistema_Estatal_de_Coordenadas_Planas:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="spcszone">
                        <DT><I>Identificador_de_Zona_SPCS:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="lambertc">
                        <DT><I>Cnica_Conforme_de_Lambert:</I></DT>
                      </xsl:for-each>
                      <xsl:apply-templates select="lambertc"/>
                      <xsl:for-each select="transmer">
                        <DT><I>Mercator_Transverso:</I></DT>
                      </xsl:for-each>
                      <xsl:apply-templates select="transmer"/>
                      <xsl:for-each select="obqmerc">
                        <DT><I>Mercator_Oblicuo:</I></DT>
                      </xsl:for-each>
                      <xsl:apply-templates select="obqmerc"/>
                      <xsl:for-each select="polycon">
                        <DT><I>Policnico:</I></DT>
                      </xsl:for-each>
                      <xsl:apply-templates select="polycon"/>
                    </DL>
                    </DD>
                  </xsl:for-each>

                  <xsl:for-each select="arcsys">
                    <DT><I>Sistema_ARC_de_Coordenadas:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="arczone">
                        <DT><I>Identificador_de_Zona_del_Sistema_ARC:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="equirect">
                        <DT><I>Equirrectangular:</I></DT>
                      </xsl:for-each>
                      <xsl:apply-templates select="equirect"/>
                      <xsl:for-each select="azimequi">
                        <DT><I>Equidistante_Azimutal:</I></DT>
                      </xsl:for-each>
                      <xsl:apply-templates select="azimequi"/>
                    </DL>
                    </DD>
                  </xsl:for-each>

                  <xsl:for-each select="othergrd">
                    <DT><I>Definicin_de_Otro_Sistema_de_Cuadricula:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>

              <xsl:for-each select="localp">
                <DT><I>Local_Plano:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="localpd">
                    <DT><I>Descripcin_de_la_Plana_Local:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                  <xsl:for-each select="localpgi">
                    <DT><I>Informacin_de_la_Georeferencia_de_la_Plana_Local:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>

              <xsl:for-each select="planci">
                <DT><I>Informacin_de_Coordenadas_Plana:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="plance">
                    <DT><I>Mtodo_Codificado_de_Coordenadas_Plana:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                  <xsl:for-each select="coordrep">
                    <DT><I>Representacin_de_Coordenadas:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="absres">
                        <DT><I>Resolucin_de_Abscisa:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="ordres">
                        <DT><I>Resolucin_de_Ordenadas:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                    </DL>
                    </DD>
                  </xsl:for-each>
                  <xsl:for-each select="distbrep">
                    <DT><I>Representacin_de_Distancia_y_Rumbo:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="distres">
                        <DT><I>Resolucin_de_Distancia:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="bearres">
                        <DT><I>Resolucin_de_Rumbo:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="bearunit">
                        <DT><I>Unidades_de_Rumbo:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="bearrefd">
                        <DT><I>Direccin_del_Rumbo_de_Referencia:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="bearrefm">
                        <DT><I>Meridiano_del_Rumbo_de_Referencia:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                    </DL>
                    </DD>
                  </xsl:for-each>
                  <xsl:for-each select="plandu">
                    <DT><I>Unidades_de_Distancias_Planas:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="local">
            <DT><I>Local:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="localdes">
                <DT><I>Descripcin_Local:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="localgeo">
                <DT><I>Informacin_de_Georreferenciacin_Local:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="geodetic">
            <DT><I>Modelo_Geodsico:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="horizdn">
                <DT><I>Nombre_del_Datum_Horizontal:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="ellips">
                <DT><I>Nombre_del_Elipsoide:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="semiaxis">
                <DT><I>Semi-eje_Mayor:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="denflat">
                <DT><I>Denominador_de_la_Razn_de_Aplastamiento:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="vertdef">
        <DT><I>Definicin_del_Sistema_de_Coordenadas_Verticales:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="altsys">
            <DT><I>Definicin_del_Sistema_de_Altitud:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="altdatum">
                <DT><I>Nombre_del_Datum_de_Altitud:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="altres">
                <DT><I>Resolucin_en_Altitud:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="altunits">
                <DT><I>Unidades_de_Distancia_en_Altitud:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="altenc">
                <DT><I>Mtodo_de_Codificacin_de_Altitud:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="depthsys">
            <DT><I>Definicin_del_Sistema_de_Profundidad:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="depthdn">
                <DT><I>Nombre_del_Datum_de_Profundidad:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="depthres">
                <DT><I>Resolucin_en_Profundidad:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="depthdu">
                <DT><I>Unidades_de_Distancia_en_Profundidad:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="depthem">
                <DT><I>Mtodo_de_Codificacin_de_Profundidad:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>
    </DL>
    </DD>
  </DL>
  <A HREF="#Top">Back to Top</A>
</xsl:template>

<!-- Entity and Atributos -->
<xsl:template match="eainfo">
  <A name="Informacin_de_Entidad_y_Atributo"><HR/></A>
  <DL>
    <DT><I>Informacin_de_Entidad_y_Atributo:</I></DT>
    <DD>
    <DL>
      <xsl:for-each select="detailed">
        <DT><I>Descripcin_Detallada:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="enttyp">
            <DT><I>Tipo_de_Entidad:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="enttypl">
                <DT><I>Etiqueta_de_Tipo_de_Entidad:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="enttypd">
                <DT><I>Definicin_de_Tipo_de_Entidad:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
              <xsl:for-each select="enttypds">
                <DT><I>Fuente_de_Definicin_de_Tipo_de_Entidad:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="attr">
            <DT><I>Atributos:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="attrlabl">
                <DT><I>Etiqueta_del_Atributo:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="attrdef">
                <DT><I>Definicin_del_Atributo:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
              <xsl:for-each select="attrdefs">
                <DT><I>Fuente_de_Definicin_de_Atributos:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>

              <xsl:for-each select="attrdomv">
                <DT><I>Rango_de_Valores_de_Atributos:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="edom">
                    <DT><I>Dominio_Enumerado:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="edomv">
                        <DT><I>Valores_del_Dominio_Enumerado:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="edomvd">
                        <DT><I>Definicin_del_Dominio_Enumerado:</I></DT>
                        <DD><xsl:value-of select="."/></DD>
                      </xsl:for-each>
                      <xsl:for-each select="edomvds">
                        <DT><I>Fuente_Para_la_Definicin_del_Dominio_Enumerado:</I></DT>
                        <DD><xsl:value-of select="."/></DD>
                      </xsl:for-each>
                      <xsl:for-each select="attr">
                        <DT><I>Atributos:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                    </DL>
                    </DD>
                  </xsl:for-each>

                  <xsl:for-each select="rdom">
                    <DT><I>Dominio_del_Rango:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="rdommin">
                        <DT><I>Mnimo_del_Dominio_del_Rango:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="rdommax">
                        <DT><I>Mximo_del_Dominio_del_Rango:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="attrunit">
                        <DT><I>Unidades_de_Medidas_del_Atributo:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="attrmres">
                        <DT><I>Resolucin_de_Medidas_del_Atributo:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="attr">
                        <DT><I>Atributos:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                    </DL>
                    </DD>
                  </xsl:for-each>

                  <xsl:for-each select="codesetd">
                    <DT><I>Dominio_del_Codeset:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="codesetn">
                        <DT><I>Nombre_del_Codeset:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="codesets">
                        <DT><I>Fuente_del_Codeset:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                    </DL>
                    </DD>
                  </xsl:for-each>

                  <xsl:for-each select="udom">
                    <DT><I>Dominio_No_Representable:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>

              <xsl:for-each select="begdatea">
                <DT><I>Fecha_Inicial_de_Valores_del_Atributo:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>
              <xsl:for-each select="enddatea">
                <DT><I>Fecha_Final_de_Valores_del_Atributo:</I> <xsl:value-of select="."/></DT>
              </xsl:for-each>

              <xsl:for-each select="attrvai">
                <DT><I>Informacin_de_Precisin_de_Valores_del_Atributo:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="attrva">
                    <DT><I>Precisin_de_Valores_del_Atributo:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                   <xsl:for-each select="attrvae">
                    <DT><I>Explicacin_de_Precisin_de_Valores_del_Atributo:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                 </DL>
                </DD>
              </xsl:for-each>
              <xsl:for-each select="attrmfrq">
                <DT><I>Frecuencia_de_Medidas_del_Atributo:</I></DT>
                <DD><xsl:value-of select="."/></DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="overview">
        <DT><I>Descripcin_Resumida:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="eaover">
            <DT><I>Resumen_Somero_de_Entidad_y_Atributo:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
          <xsl:for-each select="eadetcit">
            <DT><I>Cita_Detallada_de_Entidad_y_Atributo:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>
    </DL>
    </DD>
  </DL>
  <A HREF="#Top">Back to Top</A>
</xsl:template>

<!-- Distribution -->
<xsl:template match="distinfo">
  <A name="{generate-id()}"><HR/></A>
  <DL>
    <DT><I>Informacin_de_Distribucin:</I> </DT>
    <DD>
    <DL>
      <xsl:for-each select="distrib">
        <DT><I>Distribuidor:</I></DT>
        <DD>
        <DL>
          <xsl:apply-templates select="cntinfo"/>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="resdesc">
        <DT><I>Descripcin_del_Recurso:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>
      <xsl:for-each select="distliab">
        <DT><I>Responsabilidades_del_Distribuidor:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>

      <xsl:for-each select="stdorder">
        <DT><I>Procesamiento_Estndar_de_Pedidos:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="nondig">
            <DT><I>Formato_No_Digital:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
          <xsl:for-each select="digform">
            <DT><I>Formato_Digital:</I></DT>
            <DD>
            <DL>
              <xsl:for-each select="digtinfo">
                <DT><I>Informacin_Sobre_Transferencia_Digital:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="formname">
                    <DT><I>Nombre_del_Formato:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                  <xsl:for-each select="formvern">
                    <DT><I>Nmero_de_Versin_del_Formato:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                  <xsl:for-each select="formverd">
                    <DT><I>Fecha_de_Versin_del_Formato:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                  <xsl:for-each select="formspec">
                    <DT><I>Especificacin_del_Formato:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                  <xsl:for-each select="formcont">
                   <DT><I>Informacin_del_Contenido_del_Formato:</I></DT>
                    <DD><xsl:value-of select="."/></DD>
                  </xsl:for-each>
                  <xsl:for-each select="filedec">
                    <DT><I>Tcnica_de_Descompresin_de_Archivos:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                  <xsl:for-each select="transize">
                    <DT><I>Tamao_de_Transferencia:</I> <xsl:value-of select="."/></DT>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>

              <xsl:for-each select="digtopt">
                <DT><I>Opcin_Sobre_Transferencia_Digital:</I></DT>
                <DD>
                <DL>
                  <xsl:for-each select="onlinopt">
                    <DT><I>Opcin_en_Lnea:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="computer">
                        <DT><I>Informacin_Para_Contacto_con_Computador:</I></DT>
                        <DD>
                        <DL>
                          <xsl:for-each select="networka">
                            <DT><I>Direccin_de_la_Red:</I></DT>
                            <DD>
                            <DL>
                              <xsl:for-each select="networkr">
                                <DT><I>Nombre_del_Recurso_de_Red:</I> <A TARGET="viewer">
                                  <xsl:attribute name="HREF"><xsl:value-of select="."/></xsl:attribute>
                                  <xsl:value-of select="."/></A>
                                </DT>
                              </xsl:for-each>
                            </DL>
                            </DD>
                          </xsl:for-each>

                          <xsl:for-each select="dialinst">
                            <DT><I>Instrucciones_Para_Discado_Automtico:</I></DT>
                            <DD>
                            <DL>
                              <xsl:for-each select="lowbps">
                                <DT><I>Mnima_BPS:</I> <xsl:value-of select="."/></DT>
                              </xsl:for-each>
                              <xsl:for-each select="highbps">
                                <DT><I>Mxima_BPS:</I> <xsl:value-of select="."/></DT>
                              </xsl:for-each>
                              <xsl:for-each select="numdata">
                                <DT><I>Nmero_de_Bits_de_Datos:</I> <xsl:value-of select="."/></DT>
                              </xsl:for-each>
                              <xsl:for-each select="numstop">
                                <DT><I>Nmero_de_Bits_de_Parada:</I> <xsl:value-of select="."/></DT>
                              </xsl:for-each>
                              <xsl:for-each select="parity">
                                <DT><I>Paridad:</I> <xsl:value-of select="."/></DT>
                              </xsl:for-each>
                              <xsl:for-each select="compress">
                                <DT><I>Protocolos_de_Compresin_Soportados:</I> <xsl:value-of select="."/></DT>
                              </xsl:for-each>
                              <xsl:for-each select="dialtel">
                                <DT><I>Nmero_Telefnico_Para_Discado_Automtico:</I> <xsl:value-of select="."/></DT>
                              </xsl:for-each>
                              <xsl:for-each select="dialfile">
                                <DT><I>Nombre_de_Archivo_de_Discado_Automtico:</I> <xsl:value-of select="."/></DT>
                              </xsl:for-each>
                            </DL>
                            </DD>
                          </xsl:for-each>
                        </DL>
                        </DD>
                      </xsl:for-each>
                      <xsl:for-each select="accinstr">
                        <DT><I>Instrucciones_de_Acceso:</I></DT>
                        <DD><xsl:value-of select="."/></DD>
                      </xsl:for-each>
                      <xsl:for-each select="oncomp">
                        <DT><I>Computadora_y_Sistema_Operativo_en_Lnea:</I></DT>
                        <DD><xsl:value-of select="."/></DD>
                      </xsl:for-each>
                    </DL>
                    </DD>
                  </xsl:for-each>

                  <xsl:for-each select="offoptn">
                    <DT><I>Opcin_Fuera_de_Lnea:</I></DT>
                    <DD>
                    <DL>
                      <xsl:for-each select="offmedia">
                        <DT><I>Medio_Fsico_Fuera_de_Lnea:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="reccap">
                        <DT><I>Capacidad_de_Grabacin:</I></DT>
                        <DD>
                        <DL>
                          <xsl:for-each select="recden">
                            <DT><I>Densidad_de_Grabacin:</I> <xsl:value-of select="."/></DT>
                          </xsl:for-each>
                          <xsl:for-each select="recdenu">
                            <DT><I>Unidades_de_Densidad_de_Grabacin:</I> <xsl:value-of select="."/></DT>
                          </xsl:for-each>
                        </DL>
                        </DD>
                      </xsl:for-each>
                      <xsl:for-each select="recfmt">
                        <DT><I>Formato_de_Grabacin:</I> <xsl:value-of select="."/></DT>
                      </xsl:for-each>
                      <xsl:for-each select="compat">
                        <DT><I>Informacin_de_Compatibilidad:</I></DT>
                        <DD><xsl:value-of select="."/></DD>
                      </xsl:for-each>
                    </DL>
                    </DD>
                  </xsl:for-each>
                </DL>
                </DD>
              </xsl:for-each>
            </DL>
            </DD>
          </xsl:for-each>

          <xsl:for-each select="fees">
            <DT><I>Tarifas:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="ordering">
            <DT><I>Instrucciones_Para_el_Pedido:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
          <xsl:for-each select="turnarnd">
            <DT><I>Tiempo_de_Entrega:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="custom">
        <DT><I>Procesamiento_Personalizado_de_Pedidos:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>
      <xsl:for-each select="techpreq">
        <DT><I>Prerequisitos_Tcnicos:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>
      <xsl:for-each select="availabl">
        <DT><I>Perodo_con_Datos_Disponibles:</I></DT>
        <DD>
        <DL>
          <xsl:apply-templates select="timeinfo"/>
        </DL>
        </DD>
      </xsl:for-each>
    </DL>
    </DD>
  </DL>
  <A HREF="#Top">Back to Top</A>
</xsl:template>

<!-- Metadatos -->
<xsl:template match="metainfo">
  <A name="Informacin_de_Referencia_de_Metadatos"><HR/></A>
  <DL>
    <DT><I>Informacin_de_Referencia_de_Metadatos:</I></DT>
    <DD>
    <DL>
      <xsl:for-each select="metd">
        <DT><I>Fecha_de_Metadatos:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>
      <xsl:for-each select="metrd">
        <DT><I>Fecha_de_ltima_Revisin_de_Metadatos:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>
      <xsl:for-each select="metfrd">
        <DT><I>Fecha_de_Futura_Revisin_de_Metadatos:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>

      <xsl:for-each select="metc">
        <DT><I>Contacto_Por_Metadatos:</I></DT>
        <DD>
        <DL>
          <xsl:apply-templates select="cntinfo"/>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="metstdn">
        <DT><I>Nombre_del_Estndar_de_Metadatos:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>
      <xsl:for-each select="metstdv">
        <DT><I>Versin_del_Estndar_de_Metadatos:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>
      <xsl:for-each select="mettc">
        <DT><I>Convencin_de_Fechas_en_Metadatos:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>

      <xsl:for-each select="metac">
        <DT><I>Restricciones_al_Acceso_a_los_Metadatos:</I> <xsl:value-of select="."/></DT>
      </xsl:for-each>
      <xsl:for-each select="metuc">
        <DT><I>Restricciones_al_Uso_de_Metadatos:</I></DT>
        <DD><xsl:value-of select="."/></DD>
      </xsl:for-each>

      <xsl:for-each select="metsi">
        <DT><I>Informacin_de_Seguridad_de_Metadatos:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="metscs">
            <DT><I>Sistema_de_Clasificacin_de_Seguridad_de_Metadatos:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="metsc">
            <DT><I>Clasificacin_de_Seguridad_de_Metadatos:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
          <xsl:for-each select="metshd">
            <DT><I>Descripcin_de_Precauciones_de_Manejo_de_Metadatos:</I></DT>
            <DD><xsl:value-of select="."/></DD>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>

      <xsl:for-each select="metextns">
        <DT><I>Extensiones_al_Estndar_de_Metadatos:</I></DT>
        <DD>
        <DL>
          <xsl:for-each select="onlink">
            <DT><I>Acceso_en_Lnea:</I> <A TARGET="viewer">
              <xsl:attribute name="HREF"><xsl:value-of select="."/></xsl:attribute>
              <xsl:value-of select="."/></A>
            </DT>
          </xsl:for-each>
          <xsl:for-each select="metprof">
            <DT><I>Nombre_del_Perfil:</I> <xsl:value-of select="."/></DT>
          </xsl:for-each>
        </DL>
        </DD>
      </xsl:for-each>
    </DL>
    </DD>
  </DL>
  <A HREF="#Top">Back to Top</A>
</xsl:template>

<!-- Cita -->
<xsl:template match="citeinfo">
  <DT><I>Informacin_Para_Cita:</I></DT>
  <DD>
  <DL>
    <xsl:for-each select="origin">
      <DT><I>Productor:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>

    <xsl:for-each select="pubdate">
      <DT><I>Fecha_de_Publicacin:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="pubtime">
      <DT><I>Hora_de_Publicacin:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>

    <xsl:for-each select="title">
      <DT><I>Ttulo:</I></DT>
      <DD><xsl:value-of select="."/></DD>
    </xsl:for-each>
    <xsl:for-each select="edition">
      <DT><I>Edicin:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>

    <xsl:for-each select="geoform">
      <DT><I>Forma_de_Presentacin_Geoespacial:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>

    <xsl:for-each select="serinfo">
      <DT><I>Informacin_de_la_Serie:</I></DT>
      <DD>
      <DL>
        <xsl:for-each select="sername">
          <DT><I>Nombre_de_la_Serie:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="issue">
          <DT><I>Identificacin_del_Nmero:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
      </DL>
      </DD>
    </xsl:for-each>

    <xsl:for-each select="pubinfo">
      <DT><I>Informacin_de_la_Publicacin:</I></DT>
      <DD>
      <DL>
        <xsl:for-each select="pubplace">
          <DT><I>Lugar_de_la_Publicacin:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="publish">
          <DT><I>Editor:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
      </DL>
      </DD>
    </xsl:for-each>

    <xsl:for-each select="othercit">
      <DT><I>Otros_Detalles_de_la_Cita:</I></DT>
      <DD><xsl:value-of select="."/></DD>
    </xsl:for-each>

    <xsl:for-each select="onlink">
      <DT><I>Acceso_en_Lnea:</I> <A TARGET="viewer">
        <xsl:attribute name="HREF"><xsl:value-of select="."/></xsl:attribute>
        <xsl:value-of select="."/></A>
      </DT>
    </xsl:for-each>

    <xsl:for-each select="lworkcit">
      <DT><I>Cita_a_Trabajo_Mayor:</I></DT>
      <DD>
      <DL>
        <xsl:apply-templates select="citeinfo"/>
      </DL>
      </DD>
    </xsl:for-each>
  </DL>
  </DD>
</xsl:template>

<!-- Contact -->
<xsl:template match="cntinfo">
  <DT><I>Informacin_de_Contacto:</I></DT>
  <DD>
  <DL>
    <xsl:for-each select="cntperp">
      <DT><I>Contacto_Preferentemente_con_Persona:</I></DT>
      <DD>
      <DL>
        <xsl:for-each select="cntper">
          <DT><I>Persona_Para_Contacto:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="cntorg">
          <DT><I>Organizacin_Para_Contacto:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
      </DL>
      </DD>
    </xsl:for-each>
    <xsl:for-each select="cntorgp">
      <DT><I>Contacto_Preferentemente_con_Organizacin:</I></DT>
      <DD>
      <DL>
        <xsl:for-each select="cntorg">
          <DT><I>Organizacin_Para_Contacto:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="cntper">
          <DT><I>Persona_Para_Contacto:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
      </DL>
      </DD>
    </xsl:for-each>
    <xsl:for-each select="cntpos">
      <DT><I>Cargo_del_Contacto:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>

    <xsl:for-each select="cntaddr">
      <DT><I>Direccin_del_Contacto:</I></DT>
      <DD>
      <DL>
        <xsl:for-each select="addrtype">
          <DT><I>Tipo_de_Direccin:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="address">
          <DT><I>Direccin:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="city">
          <DT><I>Ciudad:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="state">
          <DT><I>Estado_o_Provincia:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="postal">
          <DT><I>Cdigo_Postal:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="country">
          <DT><I>Pas:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
      </DL>
      </DD>
    </xsl:for-each>

    <xsl:for-each select="cntvoice">
      <DT><I>Telfono_de_Contacto:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="cnttdd">
      <DT><I>TDD_o_Telfono_TTY:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="cntfax">
      <DT><I>Facsmil_de_Contacto:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="cntemail">
      <DT><I>Correo_Electrnico_de_Contacto:</I> <TT><xsl:value-of select="."/></TT></DT>
    </xsl:for-each>

    <xsl:for-each select="hours">
      <DT><I>Horario_de_Atencin:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="cntinst">
      <DT><I>Contact Instructions:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
  </DL>
  </DD>
</xsl:template>

<!-- Time Period Info -->
<xsl:template match="timeinfo">
  <DT><I>Informacin_de_Perodo_de_Tiempo:</I></DT>
  <DD>
  <DL>
    <xsl:apply-templates select="sngdate"/>
    <xsl:apply-templates select="mdattim"/>
    <xsl:apply-templates select="rngdates"/>
  </DL>
  </DD>
</xsl:template>

<!-- Single Date/Time -->
<xsl:template match="sngdate">
  <DT><I>nica_Fecha_u_Hora:</I></DT>
  <DD>
  <DL>
    <xsl:for-each select="caldate">
      <DT><I>Fecha_Calendario:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="time">
      <DT><I>Time of Day:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
  </DL>
  </DD>
</xsl:template>

<!-- Multiple Date/Time -->
<xsl:template match="mdattim">
  <DT><I>Mltiples_Fecha_y_Hora:</I></DT>
  <DD>
  <DL>
    <xsl:apply-templates select="sngdate"/>
  </DL>
  </DD>
</xsl:template>

<!-- Range of Dates/Times -->
<xsl:template match="rngdates">
  <DT><I>Rango_de_Fecha_y_Hora:</I></DT>
  <DD>
  <DL>
    <xsl:for-each select="begdate">
      <DT><I>Fecha_de_Comienzo:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="begtime">
      <DT><I>Hora_de_Comienzo:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="enddate">
      <DT><I>Fecha_de_Finalizacin:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="endtime">
      <DT><I>Hora_de_Finalizacin:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
  </DL>
  </DD>
</xsl:template>

<!-- Poligonal_Geogrfica -->
<xsl:template match="grngpoin">
  <DT><I>Longitud_de_Poligonal:</I></DT>
  <DD>
  <DL>
    <xsl:for-each select="gringlat">
      <DT><I>Punto_de_Poligonal_Geogrfica:</I> <xsl:value-of select="."/></DT>
        </xsl:for-each>
        <xsl:for-each select="gringlon">
      <DT><I>Latitud_de_Poligonal:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
  </DL>
  </DD>
</xsl:template>
<xsl:template match="gring">
  <DT><I>Poligonal_Geogrfica:</I></DT>
  <DD><xsl:value-of select="."/></DD>
</xsl:template>


<!-- Map Projections -->
<xsl:template match="albers | equicon | lambertc">
  <DD>
  <DL>
    <xsl:apply-templates select="stdparll"/>
    <xsl:apply-templates select="longcm"/>
    <xsl:apply-templates select="latprjo"/>
    <xsl:apply-templates select="feast"/>
    <xsl:apply-templates select="fnorth"/>
  </DL>
  </DD>
</xsl:template>

<xsl:template match="gnomonic | lamberta | orthogr | stereo | gvnsp">
  <DD>
  <DL>
    <xsl:for-each select="../gvnsp">
      <xsl:apply-templates select="heightpt"/>
    </xsl:for-each>
    <xsl:apply-templates select="longpc"/>
    <xsl:apply-templates select="latprjc"/>
    <xsl:apply-templates select="feast"/>
    <xsl:apply-templates select="fnorth"/>
  </DL>
  </DD>
</xsl:template>

<xsl:template match="miller | sinusoid | vdgrin | equirect | mercator">
  <DD>
  <DL>
    <xsl:for-each select="../equirect">
      <xsl:apply-templates select="stdparll"/>
    </xsl:for-each>
    <xsl:for-each select="../mercator">
      <xsl:apply-templates select="stdparll"/>
      <xsl:apply-templates select="sfequat"/>
    </xsl:for-each>
    <xsl:apply-templates select="longcm"/>
    <xsl:apply-templates select="feast"/>
    <xsl:apply-templates select="fnorth"/>
  </DL>
  </DD>
</xsl:template>

<xsl:template match="azimequi | polycon | transmer">
  <DD>
  <DL>
    <xsl:for-each select="../transmer">
      <xsl:apply-templates select="sfctrmer"/>
    </xsl:for-each>
    <xsl:apply-templates select="longcm"/>
    <xsl:apply-templates select="latprjo"/>
    <xsl:apply-templates select="feast"/>
    <xsl:apply-templates select="fnorth"/>
  </DL>
  </DD>
</xsl:template>

<xsl:template match="polarst">
  <DD>
  <DL>
    <xsl:apply-templates select="svlong"/>
    <xsl:apply-templates select="stdparll"/>
    <xsl:apply-templates select="sfprjorg"/>
    <xsl:apply-templates select="feast"/>
    <xsl:apply-templates select="fnorth"/>
  </DL>
  </DD>
</xsl:template>

<xsl:template match="obqmerc">
  <DD>
  <DL>
    <xsl:apply-templates select="sfctrlin"/>
    <xsl:apply-templates select="obqlazim"/>
    <xsl:apply-templates select="obqlpt"/>
    <xsl:apply-templates select="latprjo"/>
    <xsl:apply-templates select="feast"/>
    <xsl:apply-templates select="fnorth"/>
  </DL>
  </DD>
</xsl:template>
 

<!-- Map Projection Parameters -->
<xsl:template match="stdparll">
  <DT><I>Paralelo_Estndar:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="longcm">
  <DT><I>Longitud_del_Meridiano_Central:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="latprjo">
  <DT><I>Latitud_del_Origen_de_la_Proyeccin:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="feast">
  <DT><I>Falso_Este:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="fnorth">
  <DT><I>Falso_Norte:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="sfequat">
  <DT><I>Factor_de_Escala_en_el_Ecuador:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="heightpt">
  <DT><I>Altura_del_Punto_de_Perspectiva_Sobre_la_Superficie:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="longpc">
  <DT><I>Longitud_del_Centro_de_la_Proyeccin:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="latprjc">
  <DT><I>Latitud_del_Centro_de_la_Proyeccin:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="sfctrlin">
  <DT><I>Factor_de_Escala_en_la_Lnea_Central:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="obqlazim">
  <DT><I>Azimuth_de_Lnea_Oblicua:</I> <xsl:value-of select="."/></DT>
  <DD>
  <DL>
    <xsl:for-each select="azimangl">
      <DT><I>Angulo_Azimutal:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="azimptl">
      <DT><I>Azimuthal_Measure_Point_Longitude:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
  </DL>
  </DD>
</xsl:template>

<xsl:template match="obqlpt">
  <DT><I>Punto_de_Lnea_Oblicua:</I> <xsl:value-of select="."/></DT>
  <DD>
  <DL>
    <xsl:for-each select="obqllat">
      <DT><I>Latitud_de_Lnea_Oblicua:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
    <xsl:for-each select="obqllong">
       <DT><I>Longitud_de_Lnea_Oblicua:</I> <xsl:value-of select="."/></DT>
    </xsl:for-each>
  </DL>
  </DD>
</xsl:template>

<xsl:template match="svlong">
  <DT><I>Straight_Vertical_Longitude_from_Pole:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="sfprjorg">
  <DT><I>Factor_de_Escala_en_el_Origen_de_la_Proyeccin:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="landsat">
  <DT><I>Nmero_Landsat:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="pathnum">
  <DT><I>Nmero_de_Camino:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="sfctrmer">
  <DT><I>Factor_de_Escala_en_el_Meridiano_Central:</I> <xsl:value-of select="."/></DT>
</xsl:template>

<xsl:template match="otherprj">
  <DT><I>Definicin_de_Otra_Proyeccin:</I></DT>
  <DD><xsl:value-of select="."/></DD>
</xsl:template>

</xsl:stylesheet>
