/* ***********************************************************
fgdc_plus.js

Includes Javascript functions from "FGDC Plus.xsl" metadata stylesheet.
These functions hide and show HTML elements and introduce line
breaks and URL hypertext links in selected HTML elements having ID 
attribute values initially set to "fixvalue". The init() function
starts this conversion process and is called by the window.onload 
function in both fgdc_classic_onload.js and fgdc_faq_onload.js files.

History:

1.  Created July, 2006 by Howie Sternberg
************************************************************** */

// Onload function assigns event handler functions to DIV elements according to className
function init() {
	var elem = document.getElementById("results");
	// Remove white space text nodes in Netscape 7 and Mozilla Firefox in order to 
	// use same set of javascript functions that work in IE to navigate through HTML.
	removewhitespace(elem);
	// Assign event handler functions to children of md-title element
	elem = document.getElementById("md-title");
	setuptitle(elem);
	// Assign event handler functions to md-clickdef element
	elem = document.getElementById("md-clickdef");
	setupclickdef(elem);
	// Assign event handler functions to children of md-menu element
	elem = document.getElementById("md-menu");
	setupmenu(elem);
	// Assign event handler functions md-mastertitle, md-detailtitle, md-item, md-itemlist, and md-bgraphic elements
	elem = document.getElementById("md-description");
	setupmaster(elem);
	elem = document.getElementById("md-graphic");
	setupmaster(elem);
	elem = document.getElementById("md-spatial");
	setupmaster(elem);
	elem = document.getElementById("md-structure");
	setupmaster(elem);
	elem = document.getElementById("md-quality");
	setupmaster(elem);
	elem = document.getElementById("md-source");
	setupmaster(elem);			
	elem = document.getElementById("md-distribution");
	setupmaster(elem);
	elem = document.getElementById("md-metadata");
	setupmaster(elem);
	elem = document.getElementById("tax");
	setuptaxonomy(elem);
	/* Parse Text - Find each <pre> element with an Id="fixvalue" and
	call fixvalue() function to parse text to respect line breaks,
	replace <pre> element with <div> elememt, and convert URL address
	strings in text to <a href> element. */
	elem = document.getElementById("fixvalue");
	while (Boolean(elem != null)) {
		fixvalue(elem);
		elem = document.getElementById("fixvalue");
	}
	window.focus()
}

// Remove white space text nodes in Netscape 7 and Mozilla Firefox in order to 
// use same set of javascript functions that work in IE to navigate through HTML. 
// Although not necessary, this function is called by onload function even for IE.
function removewhitespace(elem) {
	for (var i = 0; i < elem.childNodes.length; i++) {
		var c = elem.childNodes[i]
		if (c.nodeType == 1) {
			removewhitespace(c);
		}
		// Use regular expression to test for white space text nodes and remove
		if (((/^\s+$/.test(c.nodeValue))) && (c.nodeType == 3)) {
			elem.removeChild(elem.childNodes[i--]);
		}
	}
}

// Assign event handler functions to md-title element
function setuptitle(elem) {
	if (Boolean(elem != null)) {
		if (elem.className == "md-title") {
			elem.onclick = clicktitle;
			elem.onmouseover = overtitle;
			elem.onmouseout = overtitle;
		}
	}
}

// Assign event handler functions to md-clickdef element
function setupclickdef(elem) {
	if (Boolean(elem != null)) {
		if (elem.className == "md-menuitem") {
			elem.onclick = clickdef;
			elem.onmouseover = overmenuitem;
			elem.onmouseout = overmenuitem;
		}
	}
}

// Assign event handler functions to md-menuitem elements
function setupmenu(elem) {
	if (Boolean(elem != null)) {
		for (var i = 0; i < elem.childNodes.length; i++) {
			c = elem.childNodes[i];			
			if (c.className == "md-menuitem") {
				c.onclick = clickmenuitem;
				c.onmouseover = overmenuitem;
				c.onmouseout = overmenuitem;
			}
		}
	}
}

// Assign event handler functions to md-mastertitle, md-detailtitle, md-item, md-itemlist, and md-bgraphic elements
function setupmaster(elem) {
	if (Boolean(elem != null)) {
			var c // child
			var gc 	// grandchild
			var ggc // great grandchild
			var gggc // great great grandchild
			var ggggc // great great great grandchild
			var gggggc // great great great great grandchild
		for (var i = 0; i < elem.childNodes.length; i++) {
			c = elem.childNodes[i];			
			for (var j = 0; j < c.childNodes.length; j++) {
				gc = c.childNodes[j];
				if (gc.className == "md-mastertitle") {
					gc.onclick = clickmaster;
					gc.onmouseover = overmaster;
					gc.onmouseout = overmaster;
				} 
				for (var k = 0; k < gc.childNodes.length; k++) {
					ggc = gc.childNodes[k];
					if (ggc.className == "md-detailtitle") {
						ggc.onclick = clickdetail;
						ggc.onmouseover = overdetail;
						ggc.onmouseout = overdetail;
					}
					if (ggc.className == "md-item") {
						ggc.onclick = clickitem;
						ggc.onmouseover = overitem;
						ggc.onmouseout = overitem;
					}
					if (ggc.className == "md-itemlist") {
						ggc.onclick = clickitemlist;
						ggc.onmouseover = overitemlist;
						ggc.onmouseout = overitemlist;
					}
					for (var l = 0; l < ggc.childNodes.length; l++) {
						gggc = ggc.childNodes[l];
						if (gggc.className == "md") {
							for (var m = 0; m < gggc.childNodes.length; m++) {
								ggggc = gggc.childNodes[m];						
								if (ggggc.className == "md-bgraphic") {
									ggggc.onclick = clickbgraphic;
									ggggc.onmouseover = overbgraphic;
									ggggc.onmouseout = overbgraphic;
								}
							}
						}
						if (gggc.className == "md-item") {
							gggc.onclick = clickitem;
							gggc.onmouseover = overitem;
							gggc.onmouseout = overitem;
						}
						if (gggc.className == "md-itemlist") {
							gggc.onclick = clickitemlist;
							gggc.onmouseover = overitemlist;
							gggc.onmouseout = overitemlist;
						}
						for (var n = 0; n < gggc.childNodes.length; n++) {
							ggggc = gggc.childNodes[n];
							if (ggggc.className == "md-item") {
								ggggc.onclick = clickitem;
								ggggc.onmouseover = overitem;
								ggggc.onmouseout = overitem;
							}
							if (ggggc.className == "md-itemlist") {
								ggggc.onclick = clickitemlist;
								ggggc.onmouseover = overitemlist;
								ggggc.onmouseout = overitemlist;
							}
							for (var o = 0; o < ggggc.childNodes.length; o++) {
								gggggc = ggggc.childNodes[o];
								if (gggggc.className == "md-item") {
									gggggc.onclick = clickitem;
									gggggc.onmouseover = overitem;
									gggggc.onmouseout = overitem;
								}
								if (gggggc.className == "md-itemlist") {
									gggggc.onclick = clickitemlist;
									gggggc.onmouseover = overitemlist;
									gggggc.onmouseout = overitemlist;
								}
							}					
						}
					}
				}
			}
		}
	}
}

// Assign event handler functions to taxonomy classification elements
function setuptaxonomy(elem) {
	while (Boolean(elem != null)) {
		elem.onclick = clickitem;
		elem.onmouseover = overitem;
		elem.onmouseout = overitem;
		elem.id="";
		elem = document.getElementById("tax");
	}
}

// "md-title" onmouseover and onmouseout function
function overtitle(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			if (elem.className == "md-title") {
				elem.className = "md-titleover";
			} else if (elem.className == "md-titleover") {
				elem.className = "md-title";
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-menuitem" onmouseover and onmouseout function
function overmenuitem(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			if (elem.className == "md-menuitem") {
				elem.className = "md-menuitemover";
			} else if (elem.className == "md-menuitemover") {
				elem.className = "md-menuitem";
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-mastertitle" onmouseover and onmouseout function
function overmaster(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			if (elem.className == "md-mastertitle") {
				elem.className = "md-mastertitleover";
			} else if (elem.className == "md-mastertitleover") {
				elem.className = "md-mastertitle";
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-detailtitle" onmouseover and onmouseout function
function overdetail(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			if (elem.className == "md-detailtitle") {
				elem.className = "md-detailtitleover";
			} else if (elem.className == "md-detailtitleover") {
				elem.className = "md-detailtitle";
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-itemlist" onmouseover and onmouseout function
function overitemlist(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			if (elem.className == "md-itemlist") {
				elem.className = "md-itemlistover";
			} else if (elem.className == "md-itemlistover") {
				elem.className = "md-itemlist";
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-item" onmouseover and onmouseout function
function overitem(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			if (elem.className == "md-item") {
				elem.className = "md-itemover";
			} else if (elem.className == "md-itemover") {
				elem.className = "md-item";
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-bgraphic" onmouseover and onmouseout function
function overbgraphic(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			if (elem.className == "md-bgraphic") {
				elem.className = "md-bgraphicover";
			} else if (elem.className == "md-bgraphicover") {
				elem.className = "md-bgraphic";
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-menuitem" onclick function. Tabs to different metadata sections.
function clickmenuitem(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element. Show selected metadata section.
			document.getElementById("md-"+elem.id).style.display = "block";
			// Hide all other metadata sections
			listNodes = ["md-description","md-graphic","md-spatial","md-structure","md-quality","md-source","md-distribution","md-metadata"]; 
			for (var i = 0; i < listNodes.length; i++) {
				if (listNodes[i] != "md-"+elem.id) {
					findNode = document.getElementById(listNodes[i]);
					if (Boolean(findNode != null)) {
						findNode.style.display = "none";
					}
				}
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-clickdef" onclick function. Opens and closes metadata definitions, which "md-def" class div elements
function clickdef (evt) {
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			var e
			var aElem
			var text 
			var elemDefinition
			var styleDisplay
			elemDefinition = document.getElementById("md-clickdef");
			text = "Show Definitions";
			styleDisplay = "none";
			if (elemDefinition.innerHTML == "Show Definitions") {
				text = "Hide Definitions";
				styleDisplay = "block";
			}
			// hide or show metadata definition elements
			aElem = document.getElementsByName("md-def")
			for (var i = 0; i < aElem.length; i++) {
				e = aElem[i]				
				e.style.display = styleDisplay;
			}
			elem.innerHTML = text;
		}
	}
}

/* "md-title" onclick function. Always opens md-detailshow and either opens or closes md-detailhide,
and md-itemhide elements, depending on value of title elements toggledisplay value. Toggledisplay
value is either "block" to "none" and toggles everytime this function runs. */
function clicktitle(evt) {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			var p = elem.parentNode; // parent
			var c 	// parent's child
			var gc 	// parent's grandchild
			var ggc // parent's great grandchild
			var gggc // parent's great great grandchild
			var ggggc // parent's great great great grandchild
			var gggggc // parent's great great great great grandchild
			var ggggggc // parent's great great great great great grandchild
			// Create toggledisplay attribute when title element is first clicked and set value to "block"
			// in order to open content.
			if (!elem.getAttributeNode("toggledisplay")) {
			 	elem.setAttribute("toggledisplay","block");
			}
			// Loop through child nodes, find those that open and close (md-detail and md-itemhide) 
			// and set their style.display to that of elem.getAttributeNode("toggledisplay").value
			for (var i = 0; i < p.childNodes.length; i++) {
				// Show (open) all metadata sections
				c = p.childNodes[i];
				c.style.display = "block";
				for (var j = 0; j < c.childNodes.length; j++) {
					gc = c.childNodes[j];
					for (var k = 0; k < gc.childNodes.length; k++) {
						ggc = gc.childNodes[k];
						if (ggc.className == "md-detailhide") {
							// hide or show md-detailhide element
							ggc.style.display = elem.getAttributeNode("toggledisplay").value;
						} else if (ggc.className == "md-detailshow") {
							// make sure md-detailshow is always shown because user could have previously closed it
							ggc.style.display = "block"
						} else if (ggc.className == "md-detailhelp") {
							// make sure md-detailhelp is always not shown
							ggc.style.display = "none"
						}
						for (var l = 0; l < ggc.childNodes.length; l++) {
							gggc = ggc.childNodes[l];
							if (gggc.className == "md-itemhide") {
								// hide or show md-itemhide element
								gggc.style.display = elem.getAttributeNode("toggledisplay").value;
							} else if (gggc.className == "md-itemshow") {
								// show md-itemshow element
								gggc.style.display = "block"
							}					
							for (var m = 0; m < gggc.childNodes.length; m++) {
								ggggc = gggc.childNodes[m];
								if (ggggc.className == "md-itemhide") {
									// hide or show md-itemhide element
									ggggc.style.display = elem.getAttributeNode("toggledisplay").value;
								} else if (ggggc.className == "md-itemshow") {
									// show md-itemshow element
									ggggc.style.display = "block"
								}								
								for (var n = 0; n < ggggc.childNodes.length; n++) {
									gggggc = ggggc.childNodes[n];
									if (gggggc.className == "md-itemhide") {
										// hide or show md-itemhide element
										gggggc.style.display = elem.getAttributeNode("toggledisplay").value;
									} else if (gggggc.className == "md-itemshow") {
										// show md-itemshow element
										gggggc.style.display = "block"
									}			
									for (var o = 0; o < gggggc.childNodes.length; o++) {
										ggggggc = gggggc.childNodes[o];
										if (ggggggc.className == "md-itemhide") {
											// hide or show md-itemhide element
											ggggggc.style.display = elem.getAttributeNode("toggledisplay").value;
										} else if (ggggggc.className == "md-itemshow") {
											// show md-itemshow element
											ggggggc.style.display = "block"
										}			
									}												
								}													
							}							
						}				
					}
				}
			}
			if (elem.getAttributeNode("toggledisplay").value == "block") {
				elem.setAttribute("toggledisplay","none");
			} else {
				elem.setAttribute("toggledisplay","block");
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

/* "md-mastertitle" onclick function. Always opens md-detailshow and either opens or closes md-detailhide,
and md-itemhide elements, depending on whether they are currently all opened or closed. */
function clickmaster(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			var p = elem.parentNode.nextSibling;
			var c 	// parent's child
			var gc 	// parent's grandchild
			var ggc // parent's great grandchild
			var gggc // parent's great great grandchild
			var ggggc // parent's great great great grandchild
			// Are all md-detail children (md-detailhide and md-detailshow) currently open or closed?
			// Do this test by i
			var allClosed = Boolean("true");
			var allOpened = Boolean("true");
			allOpened = allchildrenopenedexcept(p,"md-detail")
			allClosed = allchildrenclosedexcept(p,"md-detail")
			allOpened = allchildrenopenedexcept(p,"md-detailhelp")
			allClosed = allchildrenclosedexcept(p,"md-detailhelp")
			// Are all grand children (md-itemhide) opened?
			if (allOpened) {
				allOpened = allgrandchildrenopened(p)
			}
			// window.alert(allOpened)
			// window.alert(allClosed)
			// Set new display variable. If one or more element but 
			// not all are open, open all elements. Otherwise, close
			// all elements if all of them are open.
			var newdisplay = "block";
			if ((allOpened) & (!allClosed)) {
				newdisplay = "none";
			}
			// Loop through child nodes, find md-detailhide and md-itemhide elements
			// and set their style.display to value of newdisplay variable. The newdisplay
			// variable has a value of either "block" or "none". This value is based on the
			// current display condition of all md-detailhide and md-detailshow elements. If they
			// are currently all opened, then newdisplay is set to "none" so that they will all close.
			// If they are all closed, then the newdisplay value is "block" so that they all will
			// open. If some are opened and closed, the assumption is the user wants to open
			// all elements so the newdisplay value is "block". Once all opened, if user intended to
			// close them, they will close when the user natually clicks element again.			
			for (var i = 0; i < p.childNodes.length; i++) {
				c = p.childNodes[i];
				if (c.className == "md-detailhide") {
					// hide or show md-detailhide element
					c.style.display = newdisplay;
				} else if (c.className == "md-detailshow") {
					// make sure md-detailshow is always shown because user could have previously closed it
					c.style.display = "block";
				} else if (c.className == "md-detailhelp") {
					// make sure md-detailhelp is always not shown
					c.style.display = "none";
				}
				for (var j = 0; j < c.childNodes.length; j++) {
					gc = c.childNodes[j];
					if (gc.className == "md-itemhide") {
						// hide or show md-itemhide element
						gc.style.display = newdisplay;
					} else if (gc.className == "md-itemshow") {
						// show md-itemshow element
						gc.style.display = "block"	
					}				
					for (var k = 0; k < gc.childNodes.length; k++) {
						ggc = gc.childNodes[k];
			 			if (ggc.className == "md-itemhide") {
							// hide or show md-itemhide element
			 				ggc.style.display = newdisplay;
						} else if (ggc.className == "md-itemshow") {
							// show md-itemshow element
							ggc.style.display = "block"	
						}							
						for (var l = 0; l < ggc.childNodes.length; l++) {
							gggc = ggc.childNodes[l];
							if (gggc.className == "md-itemhide") {
								// hide or show md-itemhide element
								gggc.style.display = newdisplay;
							} else if (gggc.className == "md-itemshow") {
								// show md-itemshow element
								gggc.style.display = "block"	
							}				
							for (var m = 0; m < gggc.childNodes.length; m++) {
								ggggc = gggc.childNodes[m];
								if (ggggc.className == "md-itemhide") {
									// hide or show md-itemhide element
									ggggc.style.display = newdisplay;
								} else if (ggggc.className == "md-itemshow") {
									// show md-itemshow element
									ggggc.style.display = "block"	
								}				
							}												
						}													
					}							
				}				
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-detailtitle" onclick function. Opens and closes md-detailhide and md-detailshow elements.
function clickdetail(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			var p = elem.parentNode.nextSibling; // parent's next sibling element
			if (getcomputeddisplay(p) == "none") {
				p.style.display = "block";
			} else {
				p.style.display = "none";
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-detailitemlist" onclick function. Opens and closes all children and all grand children md-itemhide and md-itemshow elements.
function clickitemlist(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			var elemNext = elem.nextSibling; // next sibling element
			// Next sibling is normally md-itemshow class, but if md-itemhide
			// class then hide or show it.
			if (elemNext.className == "md-itemhide") {
				if (getcomputeddisplay(elemNext) == "none") {
					elemNext.style.display = "block";
				} else {
					elemNext.style.display = "none";
				}
			}
			// Are all grand children open or are all children closed?
			var allClosed = Boolean("true");
			var allOpened = Boolean("true");
			allOpened = allchildrenopenedexcept(elemNext,"md-item")
			allClosed = allchildrenclosedexcept(elemNext,"md-item")
			var newdisplay = "block";
			if ((allOpened) & (!allClosed)) {
				newdisplay = "none";
			}
			// if they're all opened, close them. Otherwise, open all of them.
			for (var i = 0; i < elemNext.childNodes.length; i++) {
				c = elemNext.childNodes[i];
				if (c.className == "md-itemhide") {
					// hide or show md-itemhide
					c.style.display = newdisplay;
				} else if (c.className == "md-itemshow") {
					// make sure md-itemshow is always shown
					c.style.display = "block";
				}
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-detailitem" onclick function. Opens and closes nextsibling md-itemhide or md-itemshow element.
function clickitem(evt)  {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			var elemNext = elem.nextSibling; // next sibling element
			if ((elemNext.className == "md-itemhide") || ( elemNext.className == "md-itemshow")) {
				if (getcomputeddisplay(elemNext) == "none") {
					elemNext.style.display = "block";
				} else {
					elemNext.style.display = "none";
				}
			}
		}
		// Prevent event from bubbling past this event handler.
		evt.cancelBubble = true;
	}
}

// "md-bgraphic" onclick function. Opens and closes browsegraphic images (jpg, jpeg, gif, png, bmp).
function clickbgraphic(evt) {
	// Get reference to W3C or IE event object
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt) {
		// Get reference to element from which event object was created. W3C calls this element target. IE calls it srcElement.
		var elem = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (elem.nodeType == 3) {
			// If W3C and element is text node (nodeType = 3), then get reference to container (parent) to equalize with IE event model.
			elem = elem.parentNode;
		}
		if (elem) {
			// Work with element.
			var p = elem.parentNode.nextSibling;  // parent's next sibling element
			if (getcomputeddisplay(p) == "none") {
				var elemImage = p.childNodes[0];
				var srcImage = elem.getAttributeNode("browsen").value;
				p.style.display = "block";
				elemImage.setAttribute("src",srcImage);
				elemImage.setAttribute("alt","Image - " + srcImage);
			} else {
				p.style.display = "none";
			}
		}
	}
}

// Returns boolean indicating whether all child elements other than a particular class are opened
function allchildrenopenedexcept(elem,cname) {
	var opened = Boolean("true");
	for (var i = 0; i < elem.childNodes.length; i++) {
		c = elem.childNodes[i];
		if (c.className != cname) {
			if (getcomputeddisplay(c) == "none") {
				opened = false;
				break;
			}
		}
	}
	return opened;
}

// Returns boolean indicating whether all child elements other than a particular class are closed
function allchildrenclosedexcept(elem,cname) {
	var closed = Boolean("true");
	for (var i = 0; i < elem.childNodes.length; i++) {
		c = elem.childNodes[i];
		if (c.className != cname) {
			if (getcomputeddisplay(c) == "block") {
				closed = false;
				break;
			}
		}
	}
	return closed;
}

// Returns boolean indicating whether all grand child 
// and grand child's next sibling child elements are opened
function allgrandchildrenopened(elem) {
	var opened = Boolean("true");
	for (var i = 0; i < elem.childNodes.length; i++) {
		c = elem.childNodes[i];
		for (var j = 0; j < c.childNodes.length; j++) {
			gc = c.childNodes[j];
			if (gc.className == "md-itemhide") {
				if (getcomputeddisplay(gc) == "none") {
					opened = false;
					break;
				}
			} else if (gc.className == "md-itemlist") {
				gcns = gc.nextSibling
				for (var k = 0; k < gcns.childNodes.length; k++) {
					gcnsc = gcns.childNodes[k];
					if (gcnsc.className == "md-itemhide") {
						if (getcomputeddisplay(gcnsc) == "none") {
							opened = false;
							break;
						}
					}
				}
			}
		}
		if (!opened) {
			break;
		}
	}
	return opened;
}

// Returns element style.display property as a text string. Returns "none" or "block".
function getcomputeddisplay(elem) {
	var dis
	if (window.getComputedStyle) {
		// W3C		
		dis = window.getComputedStyle(elem, null).display;
	} else if (elem.currentStyle) {
		// IE
		dis = elem.currentStyle.display;
	}
	return dis;
}