/* ***********************************************************
args.js
Javascript function for extracting arguments from URL.
--------------------------------------------------------------
History - This function is an example from the following book. 
"Javascript: The Definitive Guide" 4nd Edition, by David Flanagan, 
published by O'Reilly & Associates, Inc. (http://www.oreilly.com)
ISBN 0-596-00048-0.
**************************************************************
This function parses comma-separated name=value argument pairs from
the query string of the URL. It stores the name=value pairs in 
properties of the object and returns that object.
*/

function getArgs() {
	var args = new Object();
	var query = location.search.substring(1);
	var pairs = query.split(",");
	for (var i = 0; i < pairs.length; i++) {
		var pos = pairs[i].indexOf('=');
		if (pos == -1) continue;
		var argname = pairs[i].substring(0,pos);
		var value = pairs[i].substring(pos+1);
		args[argname] = unescape(value);
	}
	return args;
}