#-----------------------------------------------------------
# 
# MetaEdit
# Copyright (C) 2009  University of California, Davis
# AUTHORS: Alex Mandel, Nate Roth, Stacey Ellis, Alex Koltunov
# EMAIL: ?
# WEB  : https://apps.sourceforge.net/trac/qgismetaedit
#
# XML Metadata editor for QGISS
#
#-----------------------------------------------------------
# 
# licensed under the terms of GNU GPL 2
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
# 
#---------------------------------------------------------------------

'''GUI base file'''

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from metaeditUi import Ui_Dialog
#from xml.dom import minidom
from os import path
import os
from importTemplateTool import ImpTemplateDialog
import webbrowser
from shutil import copy as filecopy
from simpledommodel import DomItem,DomModel
from PyQt4 import QtXml
currentPath = path.dirname(__file__)

class Dialog(QDialog,Ui_Dialog):
    '''Main Control Point of Plugin'''
    def __init__(self,iface,use_qgis=False, parent=None):
        #Toggle next line to use winpdb debugger
        #import rpdb2; rpdb2.start_embedded_debugger("testing")
        
        QDialog.__init__(self,parent)
        self.iface = iface
        self.setupUi(self)
        
        self.DEBUGME = False  
        
        # fields related to functionality
        self.openedFileInfo = QFileInfo() # file selected from File -load dialog
        self.savedFileInfo = QFileInfo() # file selected from File -save dialog
        self.saveFileNameLabel = QLabel()
        self.openXMLfileNameLabel = QLabel()  # XML file name to parse
        self.saveXMLfileNameLabel = QLabel()
        self.CurrentXmlFileName = QString()  # ALWAYS stores the CURRRENT xml-file name, or EMPTY, if WE are editing something from scratch
        
        # TODO: make completely dynamic
        self.defaultDir = QDir( QDir.fromNativeSeparators(QDir.homePath()) + "/.qgis/python/plugins/metaedit" )  # hardcoded for now
        self.lastAttemptedOpenDir = self.defaultDir               
        self.lastAttemptedSaveDir = QDir( )        
        self.lastAttemptedOpenTemplateDir = QDir( self.defaultDir.path() + "/Templates/xml")   # hardcoded for now        
        self.errMessage = QErrorMessage(self)
        self.undoStack = QUndoStack(self)
        self.impDlg = ImpTemplateDialog(self)
                
        self.model = DomModel(QtXml.QDomDocument(), self) #Temp holder?
        self.index = None;

        #Fill the about page
        testpath = str(self.defaultDir.filePath("about.html"))
        aboutfile = open(testpath,"r")
        self.aboutfile = aboutfile.read()
        aboutfile.close()
        self.textBrowser_2.setHtml(self.aboutfile)
        
        #SIGNALS
        QObject.connect(self.pushButtonBrowse, SIGNAL("clicked()"), self.on_click_button_Browse)
        QObject.connect(self.buttonBox.button(QDialogButtonBox.Save), SIGNAL("clicked()"), self.on_click_button_Save)
        QObject.connect(self.buttonBox.button(QDialogButtonBox.Apply),SIGNAL("clicked()"), self.on_click_button_Apply)
        QObject.connect(self.treeView,SIGNAL("clicked(QModelIndex)"),self.item_select)
        QObject.connect(self.ButtonUndo,SIGNAL("clicked()"),self.textEdit,SLOT("undo()"))
        QObject.connect(self.ButtonRedo,SIGNAL("clicked()"),self.textEdit,SLOT("redo()"))
        QObject.connect(self.comboBoxFileLayer,SIGNAL("currentIndexChanged(int)"),self.layer_selected)
        QObject.connect(self.ButtonRefresh,SIGNAL("clicked()"),self.loadLayers)
        QObject.connect(self.pushOpenTemplate, SIGNAL("clicked()"), self.on_click_button_OpenTemplate)
        QObject.connect(self.xmlView,SIGNAL("clicked()"),self.openXmlViewer)
        QObject.connect(self.model,SIGNAL("dataChanged()"),self.treeView,SLOT("update()"))
        #TODO: not working, also need to prevent activation if nothing selected or no file loaded
        #QObject.connect(self.textEdit,SIGNAL("textChanged()"),self.buttonBox.button(QDialogButtonBox.Apply),SLOT("setEnabled()"))
        QObject.connect(self.model,SIGNAL("datachanged()"),self.buttonBox.button(QDialogButtonBox.Apply),SLOT("setEnabled()"))
        
        # initially disable some buttons
        self.buttonBox.button(QDialogButtonBox.Apply).setDisabled(True)
        self.buttonBox.button(QDialogButtonBox.Save).setDisabled(True)

        # populate dropdown
        self.mapCanvas = self.iface.mapCanvas()
        self.loadLayers()
        
    def loadLayers(self):
        '''Load the layer selection list'''
        self.comboBoxFileLayer.clear()
        self.comboBoxFileLayer.addItem("Select Available File/Layer")
        for i in range(self.mapCanvas.layerCount()):
            layer = self.mapCanvas.layer(i)
            self.comboBoxFileLayer.addItem(layer.name())
                
    def loadDoc(self):
        '''Load XML Document from file to TreeView'''
        try:
            #self.openedFileInfo.absoluteFilePath = '/home/madadh/.qgis/python/plugins/metaedit/test/OSHPD_Licensed_Healthcare_Facilities.xml'
            self.file = QFile(self.CurrentXmlFileName)
            self.metaXML = QtXml.QDomDocument()
            self.metaXML.setContent(self.file)
                
            self.model = DomModel(self.metaXML, self)
            self.treeView.setModel(self.model)
            self.treeView.show()
            
            return True, ""

        except Exception,e:
            self.errMessage.showMessage("loadDoc:: Failed to load: " + self.CurrentXmlFileName + "   " + str(e))
            return False, e

        
    def on_click_button_Browse(self):
        ''' reaction on Browse button'''
        try:
            fileName = QFileDialog.getOpenFileName(self, 
                            self.tr("Open Spatial File's Xml"),
                            self.lastAttemptedOpenDir.path(),
                            self.tr("Spatial files (*.shp *.xml *.tif *.tiff *.jpg);;All Files(*.*)"))    
            if self.setOpenFileName(fileName):
                self.comboBoxFileLayer.addItem(self.CurrentXmlFileName)
                self.comboBoxFileLayer.setCurrentIndex(self.comboBoxFileLayer.count()-1)
                
        except Exception,e:
            #self.errMessage.showMessage("Could not parse XML doc from: %s,%s" % (self.openXMLfileNameLabel.text(),e))  
            pass
    def on_click_button_OpenTemplate(self):
        '''Action when OpenTemplate button is used'''
        openedFileInfo, xmlfnStr, OK =  self.importTemplate()
        if OK: 
            self.setFilenameFields(openedFileInfo, xmlfnStr)       
            catcher  = self.loadDoc() # AK: exceptions are caught inside loadDoc()
            if catcher[0]:
                self.comboBoxFileLayer.addItem(xmlfnStr)
                self.comboBoxFileLayer.setCurrentIndex(self.comboBoxFileLayer.count()-1)
    
    def layer_selected(self,index):
        '''layer choosen from combobox'''
        # TODO : this function is very redundant with the one above, find way to consolidate
        try:
            if self.comboBoxFileLayer.currentIndex() > 0:
                fn =  self.comboBoxFileLayer.currentText()
                if QFileInfo(fn).isAbsolute(): # AK: relies on that for external files we add the entire path+file name into the combobox                  
                    self.setOpenFileName(fn)
                else:
                    self.index = index
                    layer = self.mapCanvas.layer(self.index-1).dataProvider()
                    dataUri = layer.dataSourceUri()
                    fileName = dataUri.split("|")
                    # TODO: good spot to check what type of layer it is
                    # TODO: better error handling for non path based layers like Postgis, GRASS
                    if path.isfile(fileName[0]):
                        '''QGIS Layer was choosen from list'''
                        self.setOpenFileName(fileName[0])                     
                    else:
                        self.errMessage.showMessage(str(self.index-1) +  "failed attempt")
        
        except Exception,e:
            self.errMessage.showMessage("Error: %s" % e)
       
    def on_click_button_Save(self):
        ''' reaction on Save button'''
        try:
            #Get the filename for saving
            self.setSaveFileName()
            #Save 
            #QFile set output file
            #file = QFile(self.saveFileNameLabel.text())
            filename = str(self.saveFileNameLabel.text())
            #if file.open(QIODevice.WriteOnly)== False:
            #    return -1;
            #file.write(self.model.domDocument().toString())
            #QTextStream create text stream to use
            #ts = QTextStream(file)
            #Write string to text stream
            #ts = self.model.rootItem.domNode.toString()
            #Close File
            #file.close()
            
            #A simpler
            fopen = open(filename,'w+')
            fopen.write(self.model.rootItem.domNode.toString())
            fopen.close()
            #QMessageBox.information(self,"rootItem",self.model.rootItem.domNode.toString())
            
            #Disable the Save button until next datachange()
            self.buttonBox.button(QDialogButtonBox.Save).setDisabled(True)
            if self.DEBUGME:
                QMessageBox.information(self, "Save-File selected", self.saveFileNameLabel.text()) 
        except Exception,e:
            QMessageBox.warning(self, "Metaedit Error", "Failed to save file"+str(self.saveFileNameLabel.text())+str(e))
            
    def on_click_button_Apply(self):
        ''' reaction on Apply button'''
        try:
            #TODO: write it back to the model on apply, save model to file with save
            #QMessageBox.information(self, "Apply Button Pressed", "Proof the button triggers")
            #self.tindex = self.treeView.selectedIndexes()
            self.model.flags(self.mindex)
            #self.model.flags(self.tindex[0])
            text = QVariant(self.textEdit.document().toPlainText())
            #QMessageBox.information(self, "Test", str(text.toString().toLatin1()))
            catcher = self.model.setData(self.mindex,text.toString().toLatin1(),3)
            #catcher = self.model.setData(self.tindex,QVariant(self.textEdit.document()),3)
            #self.model.show()
            #QMessageBox.information(self, "Apply Button Pressed", "But doesn't seem to work "+str(catcher.nodeValue())+str(self.textEdit.document().toPlainText()))
            self.buttonBox.button(QDialogButtonBox.Apply).setDisabled(True)
            self.buttonBox.button(QDialogButtonBox.Save).setDisabled(False)
        
            if self.DEBUGME:
                QMessageBox.information(self, "Apply Button Pressed", "The slot is to be implemented")
        except Exception,e:
            QMessageBox.information(self, "Apply Button Pressed", "Proof the button triggers "+str(e)+str(self.mindex))
            
    def setOpenFileName(self,fileName): 
        '''Checks for XML-file and loads it if available, refers users to create if not available
        also calls 'Import Template' dialog '''  
        try:
            if fileName.isEmpty():  return False        
            #self.openFileNameLabel.setText(fileName)
            openedFileInfo = QFileInfo(fileName)
            self.lastAttemptedOpenDir = QDir(openedFileInfo.canonicalPath())        
            if openedFileInfo.canonicalFilePath().right(4) != ".xml":
                # look for xml-file in the same directory
                xmlfnStr = openedFileInfo.canonicalFilePath() + ".xml"                
                if not QFileInfo(xmlfnStr).exists():
                    xmlfnStr = openedFileInfo.completeBaseName() + ".xml"
                    if not QFileInfo(xmlfnStr).exists(): 
                        openedFileInfo, xmlfnStr, OK =  self.importTemplate()
                        if not OK: return False
                self.setFilenameFields(openedFileInfo, xmlfnStr)
            elif  openedFileInfo.canonicalFilePath().right(4) == ".xml":
                self.setFilenameFields(openedFileInfo, fileName)
            else:
                self.errMessage.showMessage("Wrong file type: " + self.openFileNameLabel.text() + "  ")  
                return False
            if self.DEBUGME:  QMessageBox.information(self, "Found XML file to parse", "Ready to parse from:  " + self.openXMLfileNameLabel.text() + "  ")                      
            catcher = self.loadDoc() 
             #One of these to lines is causing a problem  
            #self.buttonBox.button(QDialogButtonBox.Apply).setEnabled()
            #self.buttonBox.button(QDialogButtonBox.Save).setEnabled()
            return catcher[0]
        
        except Exception,e:
            self.errMessage.showMessage(("Error occured while reading xml file, %s" % e))
            
    def setFilenameFields(self, openedFileInfo, xmlfnStr):
        '''Sets the current in use filename based on the results of opening a file'''
        self.openedFileInfo = openedFileInfo;     
        self.openXMLfileNameLabel.setText(xmlfnStr)
        self.CurrentXmlFileName = xmlfnStr 


    def importTemplate(self):
        '''Load a Template xml metadata file to use as the base for a new metadata record.'''
        if self.impDlg.exec_() ==1 and not self.impDlg.openedFileInfo.canonicalFilePath().isEmpty():
            openedFileInfo = self.impDlg.openedFileInfo
            xmlfnStr = openedFileInfo.canonicalFilePath()
            return self.impDlg.openedFileInfo, openedFileInfo.canonicalFilePath(), True
        else:    return None, None, False;


    def setSaveFileName(self):    
        '''Set file name of xml for saving'''
        fileName = QFileDialog.getSaveFileName(self,
                                     self.tr("Save XML file"),
                                     self.lastAttemptedSaveDir.path(),
                                     self.tr("XML files (*.xml)"))
        if not fileName.isEmpty():
            self.saveFileNameLabel.setText(fileName)

    def item_select(self,mindex):
        '''Item selected in TreeView will be displayed in edit box.'''
        self.text = QVariant()
        self.mindex = mindex
        self.text = self.model.data(self.mindex,0)
        self.textEdit.clear()
        #TODO: use the type detection to turn on things like date picker self.text.Type()
        self.textEdit.insertPlainText(str(self.text.toString().toAscii()))
        self.buttonBox.button(QDialogButtonBox.Apply).setDisabled(False)
        
    def openWeb(self):
        '''Launches Browser to the plugin development homepage'''
        webbrowser.open("http://apps.sourceforge.net/trac/qgismetaedit/")
    
    def openXmlViewer(self):
        '''Launches web browser to render xml for easy reading
        Uses ESRI public domain style sheets and js, would like to swich to geonetwork or catmdedit'''
        try:
            if len(self.CurrentXmlFileName) > 0:
                # Todo: allow user to choose style sheet
                viewPath = currentPath.replace('//','/')
                xsl = "xsl/FGDC_Plus_body.xsl"
                xml = "tmp/view.xml"
                tmpXml = path.join(viewPath,path.join("viewer/",xml))
                # Only solution that seems to work for now is to copy the file into the same path
                if path.exists(tmpXml) == True:
                    #remove existing file
                    os.remove(tmpXml)
                #copy current selection to the temp file
                filecopy(str(self.CurrentXmlFileName),tmpXml)
                xsl = "xsl/FGDC_Plus_body.xsl"
                xml = "tmp/view.xml"
                launch =("file://%s/viewer/metadata.htm?xmlfile=%s,xslfile=%s" % (viewPath,xml,xsl))
                webbrowser.open(launch)
                self.viewUrl.setText(launch)
            else:
                self.errMessage.showMessage("Error reading xml file, check that you've loaded a file")
                
        except Exception,e:
            self.errMessage.showMessage(("Error occured while reading xml file, %s" % e))

if __name__ == '__main__':
    #What to do if the module is run directly
    print "Nothing"
