#-----------------------------------------------------------
#  class implementing the import XML template dialog
#-----------------------------------------------------------

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from importtemplateUi import Ui_Dialog

class ImpTemplateDialog(QDialog,Ui_Dialog):
    '''implements the import xml-template dialog'''
    def __init__(self, parentDlg):
        
        self.DEBUGME = True  
        QDialog.__init__(self, parentDlg)
        self.setupUi(self)
        
        # fields related to functionality
        self.openedFileInfo = QFileInfo() # file selected from File -load dialog
        self.lastAttemptedOpenDir = parentDlg.lastAttemptedOpenTemplateDir
        self.errMessage = QErrorMessage(self) 

        #SIGNALS
        QObject.connect(self.ButtonBrowse, SIGNAL("clicked()"), self.on_click_button_Browse)
        QObject.connect(self.comboBoxTemplateList, SIGNAL("currentIndexChanged(int)"), self.on_curr_Ind_Changed)               
              
        self.initializeComboBox()
        
    def on_curr_Ind_Changed(self):
        if self.comboBoxTemplateList.currentIndex() > 0:
            fn =  self.comboBoxTemplateList.currentText()
            if QFileInfo(fn).isRelative(): # AK: relies on that for external files we add the entire path+file name into the combobox
                fn = self.lastAttemptedOpenDir.path() + "/" + fn
            self.setOpenFileName(fn)
        else: 
            self.openedFileInfo = QFileInfo() 
 
        
         
        
    def initializeComboBox(self):        
         
        filenameList = self.lastAttemptedOpenDir.entryList(QStringList("*.xml")) #"XML-files (*.xml ; All Files(*.*)") 
        if filenameList.isEmpty():
            self.comboBoxTemplateList.addItem("No XML files found in the default template directory")
        else:
            if self.DEBUGME:
                pass
            self.comboBoxTemplateList.addItem("Select a file") 
            self.comboBoxTemplateList.addItems(filenameList)

    
    def on_click_button_Browse(self):
        ''' reaction on Browse button'''
        fileName = QFileDialog.getOpenFileName(self, 
                            self.tr("Open XML TEMPLATE File"),
                            self.lastAttemptedOpenDir.path() ,
                            self.tr("XML-files (*.xml);;All Files(*.*)"))    
        OK =  not fileName.isEmpty() and  self.setOpenFileName(fileName)
        if OK:
            self.comboBoxTemplateList.addItem(fileName)
            self.comboBoxTemplateList.setCurrentIndex(self.comboBoxTemplateList.count()-1)
        return OK
 
        
 
       
               

    def setOpenFileName(self, fileName): 
        ''' interactively chooses a data-file or an XML-file and checks the file name'''  
        openedFileInfo = QFileInfo(fileName)
        self.lastAttemptedOpenDir = QDir(openedFileInfo.path())        
        if openedFileInfo.canonicalFilePath().right(4) != ".xml":           
            self.errMessage.showMessage("Wrong file type: " + fileName + "  ")  
            return False
        self.openedFileInfo = openedFileInfo;
        return True
            

 