<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dc="http://purl.org/dc/elements/1.1/"
xmlns:dcterms="http://purl.org/dc/terms/"
xmlns:ows="http://www.opengis.net/ows"
xmlns:csw="http://www.opengis.net/cat/csw/2.0.2"
xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<!-- Stylesheet that translates a Dublin Core in RDF format into  a correct CSW  -->
	<!-- Author: jesusb  IAAA -->
	<!-- december 2007 -->

  <xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
  
  <xsl:variable name="valid-elements-URI" select="'xml\\fullElements.xml'"/>
  <xsl:variable name="valid-elements" select="document($valid-elements-URI)"/>

  <xsl:template match="/">
    <xsl:apply-templates select="rdf:RDF"/>
  </xsl:template>

  <xsl:template match="rdf:RDF">

	<!--xsl:element name="Record"-->
	<csw:Record>
	<xsl:if test="rdf:Description">
	<xsl:for-each select="*">

		 <xsl:if test="@rdf:about">
		 <!-- dc:identifier -->
	  		<xsl:element name="dc:identifier">
			    <xsl:value-of select="@rdf:about"/>
	  		</xsl:element>
		</xsl:if>
		
	        <!-- Copy the elements from the original RDF file only if they are valid -->
    	       <xsl:for-each select="*">
    	       <xsl:variable name="tagname" select="name()"/>
		  	<xsl:if test="contains($valid-elements,$tagname)">
			  	<xsl:variable name="coords" select="."/>
				<xsl:if test="not(contains($coords,'northlimit'))">
					<xsl:element name="{$tagname}">
		          			 <xsl:value-of select="normalize-space(.)"/>
		          		</xsl:element>	        		
		          	</xsl:if>
		 	</xsl:if>
    		</xsl:for-each>
    		
    		<xsl:for-each select="dcterms:spatial">
			<xsl:variable name="coordinates" select="normalize-space(.)"/>
			<xsl:if test="contains($coordinates,'northlimit')">			
				<xsl:choose>
					<!-- Check if the last character in the coordinates difinition is ';' -->
					 <xsl:when  test="substring($coordinates,string-length($coordinates)) = ';'">
					<xsl:call-template name="processBoundingBox">
						<xsl:with-param name="coords" select="$coordinates"/>
					</xsl:call-template>
		 	 		</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="processBoundingBox">
							<xsl:with-param name="coords" select="concat($coordinates, ';')"/>
						</xsl:call-template>
			 	 	</xsl:otherwise>
			 	 </xsl:choose>
		 	 </xsl:if>
   	  	</xsl:for-each>
    	</xsl:for-each>

	</xsl:if>
    </csw:Record>

  </xsl:template>
  
  <xsl:template name="processBoundingBox">
  	<xsl:param name="coords" select="''"/>
	  	<xsl:element name="ows:BoundingBox">
			<xsl:element name="ows:LowerCorner">
				<xsl:value-of select="substring-before(substring-after(normalize-space($coords), 'westlimit='),';')"/>
				<xsl:value-of select="' '"/>
				<xsl:value-of select="substring-before(substring-after(normalize-space($coords), 'southlimit='),';')"/>
			</xsl:element>
			<xsl:element name="ows:UpperCorner">
				<xsl:value-of select="substring-before(substring-after(normalize-space($coords), 'eastlimit='),';')"/>
				<xsl:value-of select="' '"/>
				<xsl:value-of select="substring-before(substring-after(normalize-space($coords), 'northlimit='),';')"/>
			</xsl:element>
		</xsl:element>
  </xsl:template>

  
</xsl:stylesheet>