<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dc="http://purl.org/dc/elements/1.1/"
xmlns:dcterms="http://purl.org/dc/terms/"
xmlns:ows="http://www.opengis.net/ows"
xmlns:csw="http://www.opengis.net/cat/csw/2.0.2"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<!-- Stylesheet that translates a correct CSW  into a correct qualifieddc  -->
	<!-- Author: carlos  IAAA -->
	<!-- february 2006: -->
	<xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
	
	<xsl:template match="/">
		<xsl:apply-templates select="csw:Record"/>
		<xsl:apply-templates select="csw:BriefRecord"/>
		<xsl:apply-templates select="csw:SummaryRecord"/>
		<xsl:apply-templates select="csw:DCMIRecord"/>
	</xsl:template>
	
	<xsl:template match="csw:BriefRecord">
		<xsl:call-template name="allRecords"/>
	</xsl:template>
	<xsl:template match="csw:SummaryRecord">
		<xsl:call-template name="allRecords"/>
	</xsl:template>
	<xsl:template match="csw:DCMIRecord">
		<xsl:call-template name="allRecords"/>
	</xsl:template>
	<xsl:template match="csw:Record">
		<xsl:call-template name="allRecords"/>
	</xsl:template>
	
	<xsl:template name="allRecords">
		<!--xsl:element name="qualifieddc"-->
		<qualifieddc>
		
			<!-- Extraer el atributo xml:lang -->
			<xsl:if test="dc:language">
				<!-- xml:lang -->
				<xsl:attribute name="xml:lang"><xsl:value-of select="normalize-space(dc:language)"/></xsl:attribute>
			</xsl:if>
			
			<!-- Extraer el atributo fileID -->
			<xsl:if test="dc:identifier">
				<!-- xml:fileID -->
				<xsl:attribute name="fileID"><xsl:value-of select="normalize-space(dc:identifier)"/></xsl:attribute>
			</xsl:if>
			
			<!-- Resto de elementos vlidos -->
			<!-- dc:creator -->
			<xsl:for-each select="dc:creator">
				<xsl:element name="dc:creator">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:description -->
			<xsl:for-each select="dc:description">
				<xsl:element name="dc:description">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:publisher -->
			<xsl:for-each select="dc:publisher">
				<xsl:element name="dc:publisher">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:contributor -->
			<xsl:for-each select="dc:contributor">
				<xsl:element name="dc:contributor">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:date -->
			<xsl:for-each select="dc:date">
				<xsl:element name="dc:date">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:identifier -->
			<xsl:for-each select="dc:identifier">
				<xsl:element name="dc:identifier">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:source -->
			<xsl:for-each select="dc:source">
				<xsl:element name="dc:source">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:language -->
			<xsl:for-each select="dc:language">
				<xsl:element name="dc:language">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:coverage -->
			<xsl:for-each select="dc:coverage">
				<xsl:element name="dc:coverage">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:rights -->
			<xsl:for-each select="dc:rights">
				<xsl:element name="dc:rights">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:rights -->
			<xsl:for-each select="dc:rights">
				<xsl:element name="dc:rights">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:title -->
			<xsl:for-each select="dc:title">
				<xsl:element name="dc:title">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:subject -->
			<xsl:for-each select="dc:subject">
				<xsl:element name="dc:subject">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:type -->
			<xsl:for-each select="dc:type">
				<xsl:element name="dc:type">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:format -->
			<xsl:for-each select="dc:format">
				<xsl:element name="dc:format">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dc:relation -->
			<xsl:for-each select="dc:relation">
				<xsl:element name="dc:relation">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			
			<!-- dcterms:abstract -->
			<xsl:for-each select="dcterms:abstract">
				<xsl:element name="dcterms:abstract">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:accessRights -->
			<xsl:for-each select="dcterms:accessRights">
				<xsl:element name="dcterms:accessRights">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:alternative -->
			<xsl:for-each select="dcterms:alternative">
				<xsl:element name="dcterms:alternative">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:audience -->
			<xsl:for-each select="dcterms:audience">
				<xsl:element name="dcterms:audience">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:available -->
			<xsl:for-each select="dcterms:available">
				<xsl:element name="dcterms:available">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:bibliographicCitation -->
			<xsl:for-each select="dcterms:bibliographicCitation">
				<xsl:element name="dcterms:bibliographicCitation">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:conformsTo -->
			<xsl:for-each select="dcterms:conformsTo">
				<xsl:element name="dcterms:conformsTo">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:created -->
			<xsl:for-each select="dcterms:created">
				<xsl:element name="dcterms:created">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:dateAccepted -->
			<xsl:for-each select="dcterms:dateAccepted">
				<xsl:element name="dcterms:dateAccepted">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:dateCopyrighted -->
			<xsl:for-each select="dcterms:dateCopyrighted">
				<xsl:element name="dcterms:dateCopyrighted">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:dateSubmitted -->
			<xsl:for-each select="dcterms:dateSubmitted">
				<xsl:element name="dcterms:dateSubmitted">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:educationLevel -->
			<xsl:for-each select="dcterms:educationLevel">
				<xsl:element name="dcterms:educationLevel">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:extent -->
			<xsl:for-each select="dcterms:extent">
				<xsl:element name="dcterms:extent">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:hasFormat -->
			<xsl:for-each select="dcterms:hasFormat">
				<xsl:element name="dcterms:hasFormat">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:hasPart -->
			<xsl:for-each select="dcterms:hasPart">
				<xsl:element name="dcterms:hasPart">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:hasVersion -->
			<xsl:for-each select="dcterms:hasVersion">
				<xsl:element name="dcterms:hasVersion">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:isFormatOf -->
			<xsl:for-each select="dcterms:isFormatOf">
				<xsl:element name="dcterms:isFormatOf">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:isPartOf -->
			<xsl:for-each select="dcterms:isPartOf">
				<xsl:element name="dcterms:isPartOf">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:isReferencedBy -->
			<xsl:for-each select="dcterms:isReferencedBy">
				<xsl:element name="dcterms:isReferencedBy">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:isReplacedBy -->
			<xsl:for-each select="dcterms:isReplacedBy">
				<xsl:element name="dcterms:isReplacedBy">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:isRequiredBy -->
			<xsl:for-each select="dcterms:isRequiredBy">
				<xsl:element name="dcterms:isRequiredBy">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:issued -->
			<xsl:for-each select="dcterms:issued">
				<xsl:element name="dcterms:issued">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:isVersionOf -->
			<xsl:for-each select="dcterms:isVersionOf">
				<xsl:element name="dcterms:isVersionOf">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:license -->
			<xsl:for-each select="dcterms:license">
				<xsl:element name="dcterms:license">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:mediator -->
			<xsl:for-each select="dcterms:mediator">
				<xsl:element name="dcterms:mediator">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:medium -->
			<xsl:for-each select="dcterms:medium">
				<xsl:element name="dcterms:medium">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:modified -->
			<xsl:for-each select="dcterms:modified">
				<xsl:element name="dcterms:modified">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:provenance -->
			<xsl:for-each select="dcterms:provenance">
				<xsl:element name="dcterms:provenance">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:references -->
			<xsl:for-each select="dcterms:references">
				<xsl:element name="dcterms:references">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:replaces -->
			<xsl:for-each select="dcterms:replaces">
				<xsl:element name="dcterms:replaces">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:requires -->
			<xsl:for-each select="dcterms:requires">
				<xsl:element name="dcterms:requires">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:rightsHolder -->
			<xsl:for-each select="dcterms:rightsHolder">
				<xsl:element name="dcterms:rightsHolder">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:spatial -->
			<xsl:for-each select="dcterms:spatial">
				<xsl:element name="dcterms:spatial">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:tableOfContents -->
			<xsl:for-each select="dcterms:tableOfContents">
				<xsl:element name="dcterms:tableOfContents">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			<!-- dcterms:temporal -->
			<xsl:for-each select="dcterms:temporal">
				<xsl:element name="dcterms:temporal">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:element>
			</xsl:for-each>
			
			<!-- ows:BoundingBox -->
			<xsl:for-each select="ows:BoundingBox">
				<xsl:variable name="upperCorner" select="ows:UpperCorner"/>
				<xsl:variable name="lowerCorner" select="ows:LowerCorner"/>
				<xsl:element name="dcterms:spatial">
					<xsl:attribute name="xsi:type"><xsl:value-of select="local-name()"/></xsl:attribute>
					northlimit=<xsl:value-of select="substring-after(normalize-space($upperCorner), ' ')"/>;
					southlimit=<xsl:value-of select="substring-after(normalize-space($lowerCorner), ' ')"/>;
					westlimit=<xsl:value-of select="substring-before(normalize-space($lowerCorner), ' ')"/>;
					eastlimit=<xsl:value-of select="substring-before(normalize-space($upperCorner), ' ')"/>;
				</xsl:element>
			</xsl:for-each>
			
			<!-- ows:WGS84BoundingBox -->
			<xsl:for-each select="ows:WGS84BoundingBox">
				<xsl:variable name="upperCorner" select="ows:UpperCorner"/>
				<xsl:variable name="lowerCorner" select="ows:LowerCorner"/>
				<xsl:element name="dcterms:spatial">
					<xsl:attribute name="xsi:type"><xsl:value-of select="local-name()"/></xsl:attribute>
					northlimit=<xsl:value-of select="substring-after(normalize-space($upperCorner), ' ')"/>;
					southlimit=<xsl:value-of select="substring-after(normalize-space($lowerCorner), ' ')"/>;
					westlimit=<xsl:value-of select="substring-before(normalize-space($lowerCorner), ' ')"/>;
					eastlimit=<xsl:value-of select="substring-before(normalize-space($upperCorner), ' ')"/>;
				</xsl:element>
			</xsl:for-each>			
			
		</qualifieddc>
		
	</xsl:template>
</xsl:stylesheet>
