#-----------------------------------------------------------
# 
# MetaEdit
# Copyright (C) 2009  University of California, Davis
# AUTHORS: Alex Mandel, Nate Roth, Stacey Ellis, Alex Koltunov
# EMAIL: ?
# WEB  : https://apps.sourceforge.net/trac/qgismetaedit
#
# XML Metadata editor for QGIS
#
#-----------------------------------------------------------
# 
# licensed under the terms of GNU GPL 2
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
# 
#---------------------------------------------------------------------

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
import resources_rc
import os.path, sys

import metaeditTool
currentPath = os.path.dirname(__file__)
from translate import localeSwitch

class MetaEditPlugin:
    def __init__(self,iface):
        #Only turn on to use winpdb debugger
        #import rpdb2; rpdb2.start_embedded_debugger("testing")
        self.iface = iface
        try:
            self.QgisVersion = unicode( QGis.QGIS_VERSION_INT )
            # Apply translation if appropirate
            localeSwitch(self,currentPath,"metaedit")
        except:
            #This exception had an error
            self.QgisVersion = unicode( QGis.QGIS_VERSION )[ 0 ]

    def initGui(self):
        '''Initialize Interface'''
        #Translation Strings
        #self.Title = QCoreApplication.translate("Metadata Editor")
        self.Title = "Metadata Editor"
        #self.Description = QCoreApplication.translate("Edits XML Metadata file attributes")
        self.Description = "Edits XML Metadata file attributes"
        #Apply Properties to GUI
        self.action = QAction(QIcon(":/plugins/metaedit/metaedit.png"), self.Title, self.iface.mainWindow())
        self.action.setWhatsThis(self.Description)
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)
        #add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Metadata", self.action)
    
    def unload(self):
        '''Unload interface'''
        # remove the plugin menu item and icon
        self.iface.removePluginMenu("&Metadata",self.action)
        self.iface.removeToolBarIcon(self.action)
        # TODO: remove temp files? see /viewer/tmp
        
    def run(self):
        '''Launch the interface'''
        # TODO: Actually make it launch the qui
        # create and show a configuration dialog or something similar
        #dialoga = metaeditTool.Dialog(self.iface)
        #dialoga.exec_()
        self.dlg = metaeditTool.Dialog(self.iface,True)
        
        #How to get a minimize button even though it's a dialog type
        #TODO : Should it be a MainWindow instead of a dialog?
        #self.dlg.setWindowFlags(Qt.CustomizeWindowHint) 
        #self.dlg.setWindowFlags(Qt.WindowMinMaxButtonsHint | Qt.WindowSystemMenuHint)
        self.dlg.setWindowFlags(Qt.WindowSystemMenuHint)
        #Method is Modaless so it doesn't block main application
        self.dlg.setModal(False)
        if not self.dlg.show():
            return
        
        #Method below is Modal, blocks background app
        #if not self.dlg.exec_():
        #    return
        return

if __name__ == '__main__':
    #What to do if the module is run directly
    print "Nothing"
