/* ***********************************************************
xmlxslt.js
Javascript functions for using XSLT to transform XML into HTML.
Combines the XSLT and XML documents from the server. There are
two different ways to do this, depending on the browser. IE uses
transformNode(), whereas Mozilla uses the XSLTProcessor object.
--------------------------------------------------------------
History - These functions were examples from the following book.
"Ajax in Action", by Dave Crane, Eric Pascarello with Darren James,
published by Manning Publications Co., ISBN 932394-61-3.
(http://www.manning.com/crane)
**************************************************************
*/

var urlXML;
var urlXSL;
var docXML;
var docXSL;
var objOutput;

function LoadXMLXSLTDoc(urlXML,urlXSL,elementID){
	docXML=null;
	docXSL=null;
	objOutput = document.getElementById(elementID);
	new net.ContentLoader(urlXML,onXMLLoad);
	new net.ContentLoader(urlXSL,onXSLLoad);
}

function onXMLLoad(){
	docXML=this.req.responseXML;
	doXSLT();
}

function onXSLLoad(){
	docXSL=this.req.responseXML;
	doXSLT();
}

function doXSLT(){
	if (docXML==null || docXSL==null){ return false; }
	if (window.ActiveXObject){
		objOutput.innerHTML = "";
		objOutput.innerHTML=docXML.transformNode(docXSL);
	} else {
 		var xsltProcessor = new XSLTProcessor();
 		xsltProcessor.importStylesheet(docXSL);
 		var fragment =xsltProcessor.transformToFragment(docXML,document);
 		objOutput.innerHTML = "";
 		objOutput.appendChild(fragment);        
	}

}