/* ***********************************************************
metadata.js

Includes the Window onload function for Metadata.htm.

Includes functions common to "FGDC Classic for Web.xsl", "FGDC FAQ for
Web.xsl" and "FGDC Plus.xsl" metadata stylesheets. These functions
introduce line breaks and URL hypertext links in selected HTML 
elements having ID attribute values initially set to "fixvalue". 
The init() function starts this process and is called by the 
window.onload function. The init() function is in the fgdc_plus.js
file.

History:

1.  Created July, 2006 by Howie Sternberg
************************************************************** */

window.onload = function() {
	// Set URL to XML - Get name of XML metadata file from name=value argument pairs in query string of URL.
	var args = getArgs();
	if (args.xmlfile) { 
		urlXML = args.xmlfile;
		if (urlXML.length == 0) {
			window.alert("URL missing query string xmlfile argument");
			return false;
		}
	} else {
		window.alert("URL missing query string xmlfile argument");
		return false;
	}
	if (args.xslfile) { 
		urlXSL = args.xslfile;
		if (urlXSL.length == 0) {
			window.alert("URL missing query string xslfile argument");
			return false;
		}
	} else {
		window.alert("URL missing query string xslfile argument");
		return false;
	}	
	// load XML and XSL files and use XSLT to transform XML into HTML. Place resulting HTML in <DIV id="results"></di> element.
	LoadXMLXSLTDoc(urlXML,urlXSL,"results");
	// Add line breaks and hypertext links in HTML
	setTimeout("init()",300);
}

function useStylesheet (urlXSL) {
	// If URL to XSL file is "None" open XML file instead. Otherwise load XSL file and use it to transform XML
	if (urlXSL == "None") {
		window.location = urlXML;
		return null;
	} else {
		// load XML and XSL files and use XSLT to transform XML into HTML. Place resulting HTML in <DIV id="results"></di> element.
		LoadXMLXSLTDoc(urlXML,urlXSL,"results");
		// Add line breaks and hypertext links in HTML
		setTimeout("init()",300);
	}
}

/* Parse Text - Find each <pre> element with an Id="fixvalue" and
call fixvalue() function to parse text to respect line breaks,
replace <pre> element with <div> elememt, and convert URL address
strings in text to <a href> element. 

function init() {
	elem = document.getElementById("fixvalue");
	while (Boolean(elem != null)) {
		fixvalue(elem);
		elem = document.getElementById("fixvalue");
	}
	window.focus()
}
*/

/* Fix value - Parse text in <pre> element to respect line breaks introduced in ArcCatalog
by the metadata author who intentionally introduced single line breaks to start new lines
or even more than one consecutive line break to further separate text to form paragraphs.
Note, fixvalue() calls the addtext() function, which adds text to DIV elements, which are
sequentially added to a parent DIV element to form separate lines and paragraphs of text. */

function fixvalue(elem) {
	elem.id = "";
	var n
	var val = String("");
	var pos = Number(0);
	// Make a newline character to use for basis for splitting string into 
	// an array of strings that are processed and turned into separate div
	// elements with either new line or paragraphic-like style.
	var newline = String.fromCharCode(10);
	var par = elem.parentNode;
	if (elem.innerText) {
		// Position of first newline character in IE
		n = elem;
		val = n.innerText;
		pos = val.indexOf(newline);
	} else {
		// Position of first newline character in NS, Firefox
		n = elem.childNodes[0];
		val = n.nodeValue;
		pos = val.indexOf(newline);
	}
	if (pos > 0) {
		// Text string contains at least one white space character
		var sValue = new String ("");
		// Split entire text string value on newline character
		// in order to create an array of string values to process	
		var aValues = val.split(newline);
		var padBottom = Number(0);
		var add = Boolean("false");
		// Loop thru each potential new line or paragraph and append <DIV>
		// element and set its className accordingly.				
		for (var i = 0; i <= aValues.length - 1; i++) {
			var div = document.createElement("DIV");
			sValue = aValues[i];
			add = false;
			for (var j = 0; j < sValue.length; j++) {
				if (sValue.charCodeAt(j) > 32) {
					add = true;
					// window.alert("CHARACTER AT " + sValue.charAt(j) + " CHARCODE " + sValue.charCodeAt(j))
					break;
				}
			}
			if (add) {
				if (i == 0) {
					// Must clone and append label property (e.g. <b>Abstract</b>) to first <DIV>
					// element, and then remove it from parent if at first element in aValues array.
					prev = elem.previousSibling;
					if (Boolean(prev != null)) {
						var label = prev.cloneNode(true)
						div.appendChild(label);
						par.removeChild(prev);
					}
				}
				// Now test to see whether to set style.paddingBottom to 0 or 4 for newline or 
				// paragraph, respectively.  Look ahead and if all characters in the next element 
				// in the aValues array (the next DIV element to make) are not white space then set
				// style.paddingBottom = 0. Otherwise, set style.paddingBottom = 4 to separate the 
				// the current <DIV> from the next <DIV> element. 			
				padBottom = Number(0);
				if (i < aValues.length - 1) {
					// Assume paragraph-like separation between DIV elements
					padBottom = Number(4);
					// Look for non-white space characters in content for next DIV
					var nextValue = aValues[i+1];
					for (var k = 0; k < nextValue.length; k++) {
						if (nextValue.charCodeAt(k) > 32) {
							// Found a non-white space character
							padBottom = Number(0);
							// window.alert("CHARACTER AT " + nextval.charAt(k) + " CHARCODE " + nextval.charCodeAt(k))
							break;
						}
					}
				}
				// Pad element
				div.style.paddingLeft = 0;
				div.style.paddingRight = 0;
				div.style.paddingTop = 0;
				div.style.paddingBottom = padBottom;
				// Scan text for URL strings before adding text to div element
				addtext(div,sValue);
				// Add new div element to parent div element
				par.appendChild(div);
			}
		}
		par.removeChild(elem);
	} else {
		// No white space charaters in text string so can be added directly to parent DIV element.
		par.removeChild(elem);
		// Scan text for URL strings before adding text to div element
		addtext(par,val);
	}		
}

/* Add text - This function adds text to (inside) DIV element, but before doing so 
searches for strings in the text that resemble URLs and converts them to hypertext
elements and adds them to the div element as well. Searches for strings that begin 
with "://" or "www." and converts them to <a href> elements. Add text function is 
called by fixvalue function */ 
 
function addtext(elem,txt) {
	// Scan entire text value and test for presense of URL strings, 
	// convert URL strings to Hypertext Elements, convert text strings
	// between URL strings to Text Nodes and append all Hypertext
	// Elements and Text Nodes to DIV element.
	var start = new Number (0);
	var end = new Number (0);
	var url = new String("");
	var urlpattern = /(\w+):\/\/([\w.]+)((\S)*)|www\.([\w.]+)((\S)*)/g;
	var punctuation = /[\.\,\;\:\?\!\[\]\(\)\{\}\'\"]/;
	var result
	var elemText
	while((result = urlpattern.exec(txt)) != null) {
		var fullurl = result[0];
		var protocol = result[1];
		url = fullurl;
		end = result.index;
		if (start < end){
			// Append Text Node to parent
			elemText = document.createTextNode(txt.substring(start, end));
			elem.appendChild(elemText);
		}
		var lastchar = fullurl.charAt(fullurl.length - 1);
		// Remove last character from url if character is punctuation mark, bracket or parenthesis;
		if (lastchar.match(punctuation) != null) {
			// Remove next-to-last character from url if character is punctuation mark, bracket or parenthesis. For example the ")" in "),"
			var nexttolastchar = fullurl.charAt(fullurl.length - 2);
			if (nexttolastchar.match(punctuation) != null) {
				url = fullurl.substring(0,fullurl.length - 2);		
			} else {		
				url = fullurl.substring(0,fullurl.length - 1);
			}		
		}
		start = (result.index + url.length)
		// Test to concatinate 'http://' to url if not already begininng with 'http://', 'https://' or 'ftp://'"
		if (protocol == "") {
			url = "http://" + url;
		}
		// Append Hypertext (anchor) Element to parent
		elemText = document.createTextNode(url);
		var elemAnchor = document.createElement("A");
		elemAnchor.setAttribute("href", url);
		elemAnchor.setAttribute("target", "viewer");
		elemAnchor.appendChild(elemText);
		elem.appendChild(elemAnchor);				
	}
	end = txt.length;
	if (start < end) {
		// Append Text Node that follows last Hypertext Element
		elemText = document.createTextNode(txt.substring(start, end));
		elem.appendChild(elemText);
	}
}