<?xml version="1.0" encoding="UTF-8"?>
  <!-- 
     Conversion from ISO19115 into Dublin Core Application Profile for Geographical Data Mining
     [jnog 21/11/2005] creation 
     [jnog 28/11/2005] solve the problem with the spatial resolution and the aggregation information
   -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:dc="http://purl.org/dc/elements/1.1/"
                                    xmlns:dcterms="http://purl.org/dc/terms/"
                                    xmlns:iso="http://www.isotc211.org/19115/"  
                                    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
                                    >

<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
<xsl:template match="MD_Metadata" >

    <xsl:variable name="xsltsl-str-lower" select="'a;b;c;d;e;f;g;h;i;j;k;l;m;n;o;p;q;r;s;t;u;v;w;x;y;z'"/>
    <xsl:variable name="xsltsl-str-upper" select="'A;B;C;D;E;F;G;H;I;J;K;L;M;N;O;P;Q;R;S;T;U;V;W;X;Y;Z'"/>


<xsl:element name="spatialdc" >

<!-- ATTRIBUTES -->

<xsl:if test="./fileIdentifier">
	<xsl:attribute name="fileID">    	
		<xsl:value-of select="./fileIdentifier"/>
 	</xsl:attribute>
</xsl:if>

<xsl:if test="./language">
	<xsl:attribute name="xml:lang">    	
		<xsl:value-of select="./language"/>
 	</xsl:attribute>
</xsl:if>

<!-- METADATA -->

<xsl:for-each select="characterSet" >
<xsl:element name="iso:MD_Metadata.characterSet" >
    <xsl:attribute name="xsi:type">
      <xsl:text>http://www.isotc211.org/19115/MD_CharacterSetCode</xsl:text>
    </xsl:attribute>
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="contact/CI_ResponsibleParty" >
  <xsl:element name="iso:MD_Metadata.contact" >
    <xsl:choose>
      <xsl:when test="./organisationName">
        <xsl:value-of select="./organisationName"/>
      </xsl:when>
      <xsl:when test="./individualName">
        <xsl:value-of select="./individualName"/>
      </xsl:when>
      <xsl:when test="./positionName">
        <xsl:value-of select="./positionName"/>
      </xsl:when>
      <xsl:otherwise>
        <!-- Nothing.  This should be never happen. -->
      </xsl:otherwise>
    </xsl:choose>
  </xsl:element>
</xsl:for-each>

<xsl:for-each select="dateStamp" >
  <xsl:element name="iso:MD_Metadata.dateStamp" >
    <xsl:attribute name="xsi:type">
      <xsl:text>http://purl.org/dc/terms/W3CDTF</xsl:text>
    </xsl:attribute>
    <xsl:value-of select="." />
  </xsl:element>
</xsl:for-each>

<xsl:for-each select="language" >
<xsl:element name="iso:MD_Metadata.language" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 1. TITLE -->

<xsl:for-each select="identificationInfo/MD_DataIdentification/citation/CI_Citation/title" >
<xsl:element name="dc:title" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 2. CREATOR -->

    <!-- creator element conversion:                                         -->
    <!-- It's assumed that at least, one of organisationName, individualName -->
    <!-- or positionName exists.  No comprobations are made.                 -->
      <xsl:for-each select="./identificationInfo/*/citation/*/citedResponsibleParty/CI_ResponsibleParty">
        <xsl:if test="translate(normalize-space(./role),$xsltsl-str-upper, $xsltsl-str-lower)='originator'">
          <xsl:element name="dc:creator">
            <xsl:choose>
              <xsl:when test="./organisationName">
                <xsl:value-of select="./organisationName"/>
              </xsl:when>
              <xsl:when test="./individualName">
                <xsl:value-of select="./individualName"/>
              </xsl:when>
              <xsl:when test="./positionName">
                <xsl:value-of select="./positionName"/>
              </xsl:when>
              <xsl:otherwise>
                <!-- Nothing.  This should never happen. -->
              </xsl:otherwise>
            </xsl:choose>
          </xsl:element>
        </xsl:if>
      </xsl:for-each>

      <!-- ISO CORE -->
      <xsl:for-each select="./identificationInfo/*/pointOfContact/CI_ResponsibleParty">
        <xsl:if test="translate(normalize-space(./role),$xsltsl-str-upper, $xsltsl-str-lower)='originator'">
          <xsl:element name="dc:creator">
            <xsl:choose>
              <xsl:when test="./organisationName">
                <xsl:value-of select="./organisationName"/>
              </xsl:when>
              <xsl:when test="./individualName">
                <xsl:value-of select="./individualName"/>
              </xsl:when>
              <xsl:when test="./positionName">
                <xsl:value-of select="./positionName"/>
              </xsl:when>
              <xsl:otherwise>
                <!-- Nothing.  This should be never happen. -->
              </xsl:otherwise>
            </xsl:choose>
          </xsl:element>
        </xsl:if>
      </xsl:for-each>

<!-- 3. SUBJECT -->
<xsl:for-each select="identificationInfo/MD_DataIdentification/descriptiveKeywords/MD_Keywords" >
  <xsl:if test="translate(normalize-space(./type),$xsltsl-str-upper, $xsltsl-str-lower)='theme'">
    <xsl:element name="dc:subject" >
      <xsl:if test="./thesaurusName/CI_Citation/title">
        <xsl:attribute name="xsi:type">
          <xsl:value-of select="./thesaurusName/CI_Citation/title" />
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="./keyword" />
    </xsl:element>
  </xsl:if>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/topicCategory" >
  <xsl:element name="dc:subject" >
    <xsl:attribute name="xsi:type">
      <xsl:text>http://www.isotc211.org/19115/MD_TopicCategoryCode</xsl:text>
    </xsl:attribute>
    <xsl:value-of select="." />
  </xsl:element>
</xsl:for-each>

<!-- 4. DESCRIPTION -->
<xsl:for-each select="identificationInfo/MD_DataIdentification/abstract" >
<xsl:element name="dc:description" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 5. PUBLISHER -->

    <!-- publisher element conversion:                                       -->
    <!-- It's assumed that at least, one of organisationName, individualName -->
    <!-- or positionName exists.  No comprobations are made.                 -->

      <xsl:for-each select="./identificationInfo/*/citation/*/citedResponsibleParty/CI_ResponsibleParty">
        <xsl:if test="translate(normalize-space(./role),$xsltsl-str-upper, $xsltsl-str-lower)='publisher'">
          <xsl:element name="dc:publisher">
            <xsl:choose>
              <xsl:when test="./organisationName">
                <xsl:value-of select="./organisationName"/>
              </xsl:when>
              <xsl:when test="./individualName">
                <xsl:value-of select="./individualName"/>
              </xsl:when>
              <xsl:when test="./positionName">
                <xsl:value-of select="./positionName"/>
              </xsl:when>
              <xsl:otherwise>
                <!-- Nothing.  This should be never happen. -->
              </xsl:otherwise>
            </xsl:choose>
          </xsl:element>
	</xsl:if>
      </xsl:for-each>

      <xsl:for-each select="./identificationInfo/*/pointOfContact/CI_ResponsibleParty">
        <xsl:if test="translate(normalize-space(./role),$xsltsl-str-upper, $xsltsl-str-lower)='publisher'">
          <xsl:element name="dc:publisher">
            <xsl:choose>
              <xsl:when test="./organisationName">
                <xsl:value-of select="./organisationName"/>
              </xsl:when>
              <xsl:when test="./individualName">
                <xsl:value-of select="./individualName"/>
              </xsl:when>
              <xsl:when test="./positionName">
                <xsl:value-of select="./positionName"/>
              </xsl:when>
              <xsl:otherwise>
                <!-- Nothing.  This should be never happen. -->
              </xsl:otherwise>
            </xsl:choose>
          </xsl:element>
	</xsl:if>
      </xsl:for-each>

<!-- 6. CONTRIBUTOR -->

<xsl:for-each select="identificationInfo/MD_DataIdentification/credit" >
<xsl:element name="dc:contributor" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>


<!-- 7. DATE -->

<!-- only refinements are created using the dataTypes of the dates -->
<!--
<xsl:for-each select="identificationInfo/MD_DataIdentification/citation/CI_Citation/date/CI_Date/date" >
<xsl:element name="dc:date" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
-->

<xsl:for-each select="identificationInfo/MD_DataIdentification/citation/CI_Citation/date/CI_Date" >
  <xsl:choose>
    <xsl:when test="contains(translate(normalize-space(./dateType),$xsltsl-str-upper, $xsltsl-str-lower),'crea')">
      <xsl:element name="dcterms:created" >
        <xsl:attribute name="xsi:type">
          <xsl:text>http://purl.org/dc/terms/W3CDTF</xsl:text>
        </xsl:attribute>
        <xsl:value-of select="./date" />
      </xsl:element>
    </xsl:when>
    <xsl:when test="contains(translate(normalize-space(./dateType),$xsltsl-str-upper, $xsltsl-str-lower),'publica')">
      <xsl:element name="dcterms:issued" >
        <xsl:attribute name="xsi:type">
          <xsl:text>http://purl.org/dc/terms/W3CDTF</xsl:text>
        </xsl:attribute>
        <xsl:value-of select="./date" />
      </xsl:element>
    </xsl:when>
    <xsl:when test="contains(translate(normalize-space(./dateType),$xsltsl-str-upper, $xsltsl-str-lower),'revi')">
      <xsl:element name="dcterms:modified" >
        <xsl:attribute name="xsi:type">
          <xsl:text>http://purl.org/dc/terms/W3CDTF</xsl:text>
        </xsl:attribute>
        <xsl:value-of select="./date" />
      </xsl:element>
    </xsl:when>
  </xsl:choose>
</xsl:for-each>

<!-- 8. TYPE -->

<xsl:for-each select="hierarchyLevel" >
  <xsl:element name="dc:type" >
    <xsl:attribute name="xsi:type">
      <xsl:text>http://www.isotc211.org/19115/MD_ScopeCode</xsl:text>
    </xsl:attribute>
    <xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/citation/CI_Citation/presentationForm" >
<xsl:element name="iso:MD_Metadata.identificationInfo.citation.presentationForm" >
    <xsl:attribute name="xsi:type">
      <xsl:text>http://www.isotc211.org/19115/CI_PresentationFormCode</xsl:text>
    </xsl:attribute>
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/spatialRepresentationType" >
<xsl:element name="iso:MD_Metadata.identificationInfo.spatialRepresentationType" >
    <xsl:attribute name="xsi:type">
      <xsl:text>http://www.isotc211.org/19115/CI_PresentationFormCode</xsl:text>
    </xsl:attribute>
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>


<!-- 9. FORMAT -->
<xsl:for-each select="distributionInfo/MD_Distribution/distributionFormat/MD_Format/name" >
<xsl:element name="dc:format" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/resourceFormat/MD_Format/name" >
<xsl:element name="dc:format" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/characterSet" >
<xsl:element name="iso:MD_Metadata.identificationInfo.characterSet" >
    <xsl:attribute name="xsi:type">
      <xsl:text>http://www.isotc211.org/19115/MD_CharacterSetCode</xsl:text>
    </xsl:attribute>
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 10. IDENTIFIER -->

<!--<xsl:for-each select="dataSetURI" >-->
<xsl:for-each select="dataSet" >
<xsl:element name="dc:identifier" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- this mapping was not present in the profile document. By mistake?? -->
      <xsl:for-each select="./distributionInfo/MD_Distribution/transferOptions/MD_DigitalTransferOptions/onLine/CI_OnlineResource">
        <xsl:element name="dc:identifier">
          <xsl:if test="./linkage">
            <xsl:value-of select="./linkage"/>
          </xsl:if>
        </xsl:element>
      </xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/citation/CI_Citation/identifier/MD_Identifier/code" >
<xsl:element name="dcterms:bibliographicCitation" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/citation/CI_Citation/isbn" >
<xsl:element name="dcterms:bibliographicCitation" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/citation/CI_Citation/issn" >
<xsl:element name="dcterms:bibliographicCitation" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 11. SOURCE -->

<xsl:for-each select="dataQualityInfo/DQ_DataQuality/lineage/LI_Lineage/source/LI_Source/description" >
<xsl:element name="dc:source" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 12. LANGUAGE -->

<xsl:for-each select="identificationInfo/MD_DataIdentification/language" >
<xsl:element name="dc:language" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 13. RELATION refinements -->
<!--
<xsl:for-each select="identificationInfo/MD_DataIdentification/aggregationInfo/MD_AggregateInformation/aggregateDataSetName" >
<xsl:element name="dcterms:isFormatOf" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
<xsl:for-each select="identificationInfo/MD_DataIdentification/aggregationInfo/MD_AggregateInformation/aggregateDataSetName" >
<xsl:element name="dcterms:replaces" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>
-->

<xsl:for-each select="identificationInfo/MD_DataIdentification/aggregationInfo/MD_AggregateInformation" >
  <xsl:choose>
    <xsl:when test="translate(normalize-space(./associationType),$xsltsl-str-upper, $xsltsl-str-lower)='largerWorkCitation'">
      <xsl:element name="dcterms:isPartOf" >
        <xsl:value-of select="./aggregateDataSetName/CI_Citation/title" />
      </xsl:element>
    </xsl:when>
    <xsl:when test="translate(normalize-space(./associationType),$xsltsl-str-upper, $xsltsl-str-lower)='source'">
      <xsl:element name="dcterms:isVersionOf" >
        <xsl:value-of select="./aggregateDataSetName/CI_Citation/title" />
      </xsl:element>
    </xsl:when>
    <xsl:when test="translate(normalize-space(./associationType),$xsltsl-str-upper, $xsltsl-str-lower)='crossReference'">
      <xsl:element name="dcterms:references" >
        <xsl:value-of select="./aggregateDataSetName/CI_Citation/title" />
      </xsl:element>
    </xsl:when>
  </xsl:choose>
</xsl:for-each>

<!-- 14.COVERAGE -->
<!-- SPATIAL -->

<xsl:for-each select="identificationInfo/MD_DataIdentification/descriptiveKeywords/MD_Keywords" >
  <xsl:if test="translate(normalize-space(./type),$xsltsl-str-upper, $xsltsl-str-lower)='place'">
    <xsl:element name="dcterms:spatial" >
      <xsl:if test="./thesaurusName/CI_Citation/title">
        <xsl:attribute name="xsi:type">
          <xsl:value-of select="./thesaurusName/CI_Citation/title" />
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="./keyword" />
    </xsl:element>
  </xsl:if>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/extent/EX_Extent/geographicElement/EX_GeographicBoundingBox" >
  <xsl:if test="./northBoundLatitude">	
    <xsl:element name="dcterms:spatial" >
      <xsl:attribute name="xsi:type">http://purl.org/dc/terms/Box</xsl:attribute>
      <xsl:text>northlimit=</xsl:text>
      <xsl:value-of select="./northBoundLatitude"/>
      <xsl:text>; </xsl:text>
     	<xsl:text>southlimit=</xsl:text>
 	    <xsl:value-of select="./southBoundLatitude"/>
 	    <xsl:text>; </xsl:text>
      <xsl:text>westlimit=</xsl:text>
 	    <xsl:value-of select="./westBoundLongitude"/>
 	    <xsl:text>; </xsl:text>
     	<xsl:text>eastlimit=</xsl:text>
 	    <xsl:value-of select="./eastBoundLongitude"/>
 	    <xsl:text>; </xsl:text>
    </xsl:element>
  </xsl:if>	
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/extent/EX_Extent/geographicElement/EX_GeographicDescription/geographicIdentifier/code" >
  <xsl:element name="dcterms:spatial" >
    <xsl:if test="../authority/CI_Citation/title">
      <xsl:attribute name="xsi:type">
        <xsl:value-of select="../authority/CI_Citation/title" />
      </xsl:attribute>
    </xsl:if>
    <xsl:value-of select="." />
  </xsl:element>
</xsl:for-each>

<!-- TEMPORAL -->

<xsl:for-each select="identificationInfo/MD_DataIdentification/descriptiveKeywords/MD_Keywords" >
  <xsl:if test="translate(normalize-space(./type),$xsltsl-str-upper, $xsltsl-str-lower)='temporal'">
    <xsl:element name="dcterms:temporal" >
      <xsl:if test="./thesaurusName/CI_Citation/title">
        <xsl:attribute name="xsi:type">
          <xsl:value-of select="./thesaurusName/CI_Citation/title" />
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select="./keyword" />
    </xsl:element>
  </xsl:if>
</xsl:for-each>


<xsl:for-each select="identificationInfo/MD_DataIdentification/extent/EX_Extent/temporalElement/EX_TemporalExtent/extent" >
   <xsl:if test="./*/begin">	
     <xsl:element name="dcterms:temporal" >
      	<xsl:attribute name="xsi:type">http://purl.org/dc/terms/Period</xsl:attribute>
        <xsl:text>begin=</xsl:text>
   	    <xsl:value-of select="./*/begin/*/timePosition"/>
       	<xsl:text>; </xsl:text>
     	  <xsl:text>end=</xsl:text>
 	      <xsl:value-of select="./*/end/*/timePosition"/>
 	      <xsl:text>;</xsl:text>
     </xsl:element>
	 </xsl:if>
</xsl:for-each>

<!-- 15. RIGHTS -->
<xsl:for-each select="identificationInfo/MD_DataIdentification/resourceConstraints/MD_LegalConstraints/accessConstraints" >
  <xsl:element name="dcterms:accessRights" >
    <xsl:value-of select="." />
  </xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/resourceConstraints/MD_LegalConstraints/otherConstraints" >
<xsl:element name="dcterms:license" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/resourceConstraints/MD_LegalConstraints/useConstraints" >
<xsl:element name="iso:MD_Metadata.identificationInfo.resourceConstraints.useConstraints" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 16. PROVENANCE -->

<xsl:for-each select="dataQualityInfo/DQ_DataQuality/lineage/LI_Lineage/statement" >
<xsl:element name="dcterms:provenance" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 17. RIGHTSHOLDER -->

<xsl:for-each select="./identificationInfo/*/citation/*/citedResponsibleParty/CI_ResponsibleParty">
  <xsl:if test="translate(normalize-space(./role),$xsltsl-str-upper, $xsltsl-str-lower)='owner'">
    <xsl:element name="dcterms:rightsHolder" >
      <xsl:choose>
        <xsl:when test="./organisationName">
          <xsl:value-of select="./organisationName"/>
        </xsl:when>
        <xsl:when test="./individualName">
          <xsl:value-of select="./individualName"/>
        </xsl:when>
        <xsl:when test="./positionName">
          <xsl:value-of select="./positionName"/>
        </xsl:when>
        <xsl:otherwise>
          <!-- Nothing.  This should never happen. -->
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:if>
</xsl:for-each>

<!-- 18. RESOLUTION -->

<xsl:for-each select="identificationInfo/MD_DataIdentification/spatialResolution/MD_Resolution/distance/value" >
<xsl:element name="iso:MD_Metadata.identificationInfo.spatialResolution.distance" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<xsl:for-each select="identificationInfo/MD_DataIdentification/spatialResolution/MD_Resolution/equivalentScale/MD_RepresentativeFraction/denominator" >
<xsl:element name="iso:MD_Metadata.identificationInfo.spatialResolution.equivalentScale.denominator" >
<xsl:value-of select="." />
</xsl:element>
</xsl:for-each>

<!-- 19. REFERENCE SYSTEM IDENTIFIER -->

<xsl:for-each select="referenceSystemInfo/*/referenceSystemIdentifier/RS_Identifier/code" >
  <xsl:element name="iso:MD_Metadata.referenceSystemInfo.referenceSystemIdentifier" >
    <xsl:if test="../authority/CI_Citation/title">
      <xsl:attribute name="xsi:type">
        <xsl:value-of select="../authority/CI_Citation/title" />
      </xsl:attribute>
    </xsl:if>
    <xsl:value-of select="." />
  </xsl:element>
</xsl:for-each>

</xsl:element>

</xsl:template>
</xsl:stylesheet>
