<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:dyn="http://exslt.org/dynamic">
<!--method="text/html"-->  
<xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
<xsl:template match="/">
	<xsl:apply-templates select="*" mode="body"/>
</xsl:template>


<xsl:template mode="body" match="*">
  <xsl:variable name="tagname" select="name()"/>  <!-- Etiqueta -->
  <xsl:variable name="t-original-string" select="normalize-space(.)"/> <!-- Contenido de la etiqueta -->
 
   <xsl:if test="string-length($t-original-string) &gt; 0">  <!-- Solo los mostramos si alguno de sus hijos tiene valores -->
	<xsl:choose>
		<xsl:when test="count(*)=0"> <!-- Si no tiene dentro mas hijos -->
		<xsl:element name="{$tagname}">
      			<xsl:value-of select="$t-original-string"/>
   		 </xsl:element>
		</xsl:when> 
		<xsl:otherwise>
	      	<!-- Escribir solo etiqueta (si que tiene hijos) y hacer una llamada recursiva al tratarse de un elemento compuesto-->
		<xsl:element name="{$tagname}">
      			<xsl:apply-templates select="*" mode="body"/>
   		 </xsl:element>
		</xsl:otherwise>
	</xsl:choose>
   </xsl:if>  
</xsl:template>

</xsl:stylesheet>